/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.GlobalState;
import java.io.Serializable;
import java.util.HashMap;

public class CullState
extends GlobalState
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = -603030653997520956L;
    private static HashMap<Integer, FrontMode> ms_pkFrontModeMap = new HashMap();
    private static HashMap<Integer, CullMode> ms_pkCullModeMap = new HashMap();
    private static FrontMode ms_eFrontModeStatic;
    private static CullMode ms_eCullModeStatic;
    public boolean Enabled = true;
    public FrontMode FrontFace = FrontMode.FT_CCW;
    public CullMode CullFace = CullMode.CT_BACK;

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_BOOLEAN + Stream.SIZEOF_INT + Stream.SIZEOF_INT;
    }

    @Override
    public final GlobalState.StateType GetStateType() {
        return GlobalState.StateType.CULL;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.Enabled = rkStream.ReadBoolean();
        int iFrontFace = rkStream.ReadInt();
        this.FrontFace = ms_pkFrontModeMap.get(iFrontFace);
        int iCullFace = rkStream.ReadInt();
        this.CullFace = ms_pkCullModeMap.get(iCullFace);
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.Enabled);
        rkStream.Write(this.FrontFace.Value());
        rkStream.Write(this.CullFace.Value());
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("CullState", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("enabled =", this.Enabled));
        pkTree.Append(StringTree.Format("front face = ", this.FrontFace.Name()));
        pkTree.Append(StringTree.Format("cull face = ", this.CullFace.Name()));
        return pkTree;
    }

    static {
        if (!DefaultInitialized[GlobalState.StateType.CULL.Value()]) {
            CullState.DefaultInitialized[GlobalState.StateType.CULL.Value()] = true;
            CullState.Default[GlobalState.StateType.CULL.Value()] = new CullState();
        }
        ms_eFrontModeStatic = FrontMode.FT_QUANTITY;
        ms_eCullModeStatic = CullMode.CT_QUANTITY;
    }

    public static enum FrontMode {
        FT_CCW("FT_CCW"),
        FT_CW("FT_CW"),
        FT_QUANTITY("FT_QUANTITY");

        private int m_iValue;
        private String m_kName;
        private static int m_iInitValue;

        private FrontMode(String kName) {
            this.m_kName = kName;
            this.m_iValue = this.Init();
            ms_pkFrontModeMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }

    public static enum CullMode {
        CT_FRONT("CT_FRONT"),
        CT_BACK("CT_BACK"),
        CT_QUANTITY("CT_QUANTITY");

        private int m_iValue;
        private String m_kName;
        private static int m_iInitValue;

        private CullMode(String kName) {
            this.m_kName = kName;
            this.m_iValue = this.Init();
            ms_pkCullModeMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }
}

