/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibGraphics.Rendering.Renderer;
import WildMagic.LibGraphics.Rendering.Texture;
import java.io.Serializable;

public abstract class FrameBuffer
implements Serializable {
    private static final long serialVersionUID = 2032964846540861997L;
    protected FormatType m_eFormat;
    protected DepthType m_eDepth;
    protected StencilType m_eStencil;
    protected BufferingType m_eBuffering;
    protected MultisamplingType m_eMultisampling;
    protected Renderer m_pkRenderer;
    protected Texture[] m_apkTarget;

    public FrameBuffer(FormatType eFormat, DepthType eDepth, StencilType eStencil, BufferingType eBuffering, MultisamplingType eMultisampling, Renderer pkRenderer, Texture[] apkTarget) {
        this.m_eFormat = eFormat;
        this.m_eDepth = eDepth;
        this.m_eStencil = eStencil;
        this.m_eBuffering = eBuffering;
        this.m_eMultisampling = eMultisampling;
        this.m_pkRenderer = pkRenderer;
        this.m_apkTarget = apkTarget;
    }

    public abstract void Disable();

    public void dispose() {
        this.m_pkRenderer = null;
        this.m_apkTarget = null;
    }

    public abstract void DrawBuffers(int[] var1);

    public abstract void Enable();

    public final BufferingType GetBufferingType() {
        return this.m_eBuffering;
    }

    public final DepthType GetDepthType() {
        return this.m_eDepth;
    }

    public final FormatType GetFormatType() {
        return this.m_eFormat;
    }

    public final MultisamplingType GetMultisamplingType() {
        return this.m_eMultisampling;
    }

    public final Renderer GetRenderer() {
        return this.m_pkRenderer;
    }

    public final StencilType GetStencilType() {
        return this.m_eStencil;
    }

    public final Texture GetTarget(int i) {
        return this.m_apkTarget[i];
    }

    public void SetTarget(int i, Texture kTarget) {
        this.m_apkTarget[i] = kTarget;
    }

    public static enum StencilType {
        ST_STENCIL_NONE,
        ST_STENCIL_8;

    }

    public static enum MultisamplingType {
        MT_SAMPLING_NONE,
        MT_SAMPLING_2,
        MT_SAMPLING_4;

    }

    public static enum FormatType {
        FT_FORMAT_NONE,
        FT_FORMAT_RGB,
        FT_FORMAT_RGBA,
        FT_FORMAT_DEPTH;

    }

    public static enum DepthType {
        DT_DEPTH_NONE,
        DT_DEPTH_16,
        DT_DEPTH_24,
        DT_DEPTH_32;

    }

    public static enum BufferingType {
        BT_BUFFERED_SINGLE,
        BT_BUFFERED_DOUBLE,
        BT_QUAD_STEREO;

    }
}

