/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibFoundation.Mathematics.BitHacks;
import WildMagic.LibFoundation.Mathematics.ColorRGBA;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.ImageVersion;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Shaders.ImageCatalog;
import com.jogamp.common.nio.Buffers;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class GraphicsImage
extends GraphicsObject
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 7001455043449630292L;
    private static HashMap<Integer, FormatMode> ms_pkFormatModeMap = new HashMap();
    private static HashMap<Integer, Type> ms_pkTypeMap = new HashMap();
    private static FormatMode m_eFormatModeStatic = FormatMode.IT_QUANTITY;
    private static Type m_eTypeStatic = Type.IT_QUANTITY;
    private static final float fInv255 = 0.003921569f;
    protected FormatMode m_eFormat;
    protected Type m_eType = Type.IT_QUANTITY;
    protected int m_iDimension;
    protected int[] m_aiBound = new int[3];
    protected int m_iQuantity;
    protected byte[] m_aucData = null;
    protected float[] m_afData = null;
    protected Buffer m_kBuffer = null;
    protected boolean m_bUpdateBuffer = true;

    public GraphicsImage() {
        this.m_eFormat = FormatMode.IT_QUANTITY;
        this.m_iDimension = 0;
        this.m_aiBound[0] = 0;
        this.m_aiBound[1] = 0;
        this.m_aiBound[2] = 0;
        this.m_iQuantity = 0;
        this.m_aucData = null;
    }

    public GraphicsImage(FormatMode eFormat, int iBound0, byte[] aucData, String acImageName) {
        assert (BitHacks.IsPowerOfTwo(iBound0));
        assert (acImageName != null);
        this.m_eFormat = eFormat;
        this.m_eType = Type.IT_BYTE;
        this.m_iDimension = 1;
        this.m_aiBound[0] = iBound0;
        this.m_aiBound[1] = 1;
        this.m_aiBound[2] = 1;
        this.m_iQuantity = iBound0;
        this.m_aucData = aucData;
        this.SetName(acImageName);
        if (acImageName == ImageCatalog.ms_kDefaultString) {
            return;
        }
        ImageCatalog.GetActive().Insert(this);
    }

    public GraphicsImage(FormatMode eFormat, int iBound0, float[] afData, String acImageName) {
        assert (BitHacks.IsPowerOfTwo(iBound0));
        assert (acImageName != null);
        this.m_eFormat = eFormat;
        this.m_eType = Type.IT_FLOAT;
        this.m_iDimension = 1;
        this.m_aiBound[0] = iBound0;
        this.m_aiBound[1] = 1;
        this.m_aiBound[2] = 1;
        this.m_iQuantity = iBound0;
        this.m_afData = afData;
        this.SetName(acImageName);
        if (acImageName == ImageCatalog.ms_kDefaultString) {
            return;
        }
        ImageCatalog.GetActive().Insert(this);
    }

    public GraphicsImage(FormatMode eFormat, int iBound0, int iBound1, byte[] aucData, String acImageName) {
        assert (BitHacks.IsPowerOfTwo(iBound0) && BitHacks.IsPowerOfTwo(iBound1));
        assert (acImageName != null);
        this.m_eFormat = eFormat;
        this.m_eType = Type.IT_BYTE;
        this.m_iDimension = 2;
        this.m_aiBound[0] = iBound0;
        this.m_aiBound[1] = iBound1;
        this.m_aiBound[2] = 1;
        this.m_iQuantity = iBound0 * iBound1;
        this.m_aucData = aucData;
        this.SetName(acImageName);
        ImageCatalog.GetActive().Insert(this);
    }

    public GraphicsImage(FormatMode eFormat, int iBound0, int iBound1, float[] afData, String acImageName) {
        assert (BitHacks.IsPowerOfTwo(iBound0) && BitHacks.IsPowerOfTwo(iBound1));
        assert (acImageName != null);
        this.m_eFormat = eFormat;
        this.m_eType = Type.IT_FLOAT;
        this.m_iDimension = 2;
        this.m_aiBound[0] = iBound0;
        this.m_aiBound[1] = iBound1;
        this.m_aiBound[2] = 1;
        this.m_iQuantity = iBound0 * iBound1;
        this.m_afData = afData;
        this.SetName(acImageName);
        ImageCatalog.GetActive().Insert(this);
    }

    public GraphicsImage(FormatMode eFormat, int iBound0, int iBound1, int iBound2, byte[] aucData, String acImageName) {
        assert (BitHacks.IsPowerOfTwo(iBound0) && BitHacks.IsPowerOfTwo(iBound1) && BitHacks.IsPowerOfTwo(iBound2));
        assert (acImageName != null);
        this.m_eFormat = eFormat;
        this.m_eType = Type.IT_BYTE;
        this.m_iDimension = 3;
        this.m_aiBound[0] = iBound0;
        this.m_aiBound[1] = iBound1;
        this.m_aiBound[2] = iBound2;
        this.m_iQuantity = iBound0 * iBound1 * iBound2;
        this.m_aucData = aucData;
        this.SetName(acImageName);
        ImageCatalog.GetActive().Insert(this);
    }

    public GraphicsImage(FormatMode eFormat, int iBound0, int iBound1, int iBound2, float[] afData, String acImageName) {
        assert (BitHacks.IsPowerOfTwo(iBound0) && BitHacks.IsPowerOfTwo(iBound1) && BitHacks.IsPowerOfTwo(iBound2));
        assert (acImageName != null);
        this.m_eFormat = eFormat;
        this.m_eType = Type.IT_FLOAT;
        this.m_iDimension = 3;
        this.m_aiBound[0] = iBound0;
        this.m_aiBound[1] = iBound1;
        this.m_aiBound[2] = iBound2;
        this.m_iQuantity = iBound0 * iBound1 * iBound2;
        this.m_afData = afData;
        this.SetName(acImageName);
        ImageCatalog.GetActive().Insert(this);
    }

    public static final int GetBytesPerPixel(FormatMode eFormat) {
        return eFormat.BytesPerPixel();
    }

    public static String GetFormatName(FormatMode eFormat) {
        return eFormat.FormatName();
    }

    public static GraphicsImage Load(String acImageName, String rkDirectory) {
        int i;
        if (acImageName == null) {
            return null;
        }
        boolean bUseWildMagic = true;
        String kExtension = null;
        int iIndex = acImageName.lastIndexOf(".");
        if (iIndex >= 0 && !(kExtension = acImageName.substring(iIndex + 1)).equals("wimf")) {
            bUseWildMagic = false;
        }
        if (!bUseWildMagic) {
            return GraphicsImage.LoadImage(acImageName, rkDirectory, kExtension);
        }
        String kFilename = new String("WildMagic" + File.separator + "Shaders" + File.separator + "Images" + File.separator + acImageName + ".wmif");
        ByteArrayInputStream acBuffer = GraphicsImage.LoadFile(kFilename);
        if (acBuffer == null) {
            return null;
        }
        int iSize = acBuffer.available();
        if (iSize < ImageVersion.LENGTH) {
            acBuffer = null;
            return null;
        }
        byte[] abHeader = new byte[ImageVersion.LENGTH];
        acBuffer.read(abHeader, 0, ImageVersion.LENGTH);
        String kHeader = new String(abHeader);
        ImageVersion kVersion = new ImageVersion(kHeader);
        if (!kVersion.IsValid()) {
            acBuffer = null;
            return null;
        }
        acBuffer.read(abHeader, 0, 1);
        byte[] abCurrent = new byte[4];
        acBuffer.read(abCurrent, 0, 4);
        int iFormat = 0;
        for (int i2 = 3; i2 >= 0; --i2) {
            iFormat = iFormat << 8 | abCurrent[i2] & 0xFF;
        }
        int iDimension = 0;
        if (kVersion.GreaterEqual(new ImageVersion(3, 1))) {
            acBuffer.read(abCurrent, 0, 4);
            for (int i3 = 3; i3 >= 0; --i3) {
                iDimension = iDimension << 8 | abCurrent[i3] & 0xFF;
            }
        } else {
            iDimension = 2;
        }
        int[] aiBound = new int[]{0, 0, 0};
        acBuffer.read(abCurrent, 0, 4);
        for (i = 3; i >= 0; --i) {
            aiBound[0] = aiBound[0] << 8 | abCurrent[i] & 0xFF;
        }
        acBuffer.read(abCurrent, 0, 4);
        for (i = 3; i >= 0; --i) {
            aiBound[1] = aiBound[1] << 8 | abCurrent[i] & 0xFF;
        }
        if (kVersion.GreaterEqual(new ImageVersion(3, 1))) {
            acBuffer.read(abCurrent, 0, 4);
            for (i = 3; i >= 0; --i) {
                aiBound[2] = aiBound[2] << 8 | abCurrent[i] & 0xFF;
            }
        } else {
            aiBound[2] = 1;
        }
        FormatMode eFormat = ms_pkFormatModeMap.get(iFormat);
        int iQuantity = aiBound[0] * aiBound[1] * aiBound[2];
        int iDataSize = eFormat.BytesPerPixel() * iQuantity;
        byte[] aucData = new byte[iDataSize];
        acBuffer.read(aucData, 0, iDataSize);
        GraphicsImage pkImage = null;
        switch (iDimension) {
            case 1: {
                pkImage = new GraphicsImage(eFormat, aiBound[0], aucData, acImageName);
                break;
            }
            case 2: {
                pkImage = new GraphicsImage(eFormat, aiBound[0], aiBound[1], aucData, acImageName);
                break;
            }
            case 3: {
                pkImage = new GraphicsImage(eFormat, aiBound[0], aiBound[1], aiBound[2], aucData, acImageName);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        acBuffer = null;
        return pkImage;
    }

    private static ByteArrayInputStream LoadFile(String acFilename) {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource(acFilename);
        if (fileURL != null) {
            try {
                InputStream kStream = fileURL.openStream();
                int iLength = kStream.available();
                BufferedInputStream kFileReader = new BufferedInputStream(kStream);
                byte[] racBuffer = new byte[iLength];
                kFileReader.read(racBuffer, 0, iLength);
                kFileReader.close();
                ByteArrayInputStream kByteStream = new ByteArrayInputStream(racBuffer);
                return kByteStream;
            }
            catch (FileNotFoundException kFNF) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static GraphicsImage LoadImage(String acImageName, String rkDirectory, String kExtension) {
        assert (acImageName != null);
        String kFilename = new String(File.separator + "Shaders" + File.separator + "Images" + File.separator + acImageName);
        BufferedImage kBImage = null;
        try {
            kBImage = ImageIO.read(new File(rkDirectory + File.separator + kFilename));
        }
        catch (IOException e) {
            return null;
        }
        if (kBImage == null) {
            System.err.println("unsuppoted file type " + kExtension);
            return null;
        }
        int iWidth = kBImage.getWidth();
        int iHeight = kBImage.getHeight();
        byte[] aucData = new byte[iWidth * iHeight * 4];
        for (int y = 0; y < iHeight; ++y) {
            for (int x = 0; x < iWidth; ++x) {
                int iARGB = kBImage.getRGB(x, y);
                aucData[(y * iWidth + x) * 4 + 3] = (byte)((iARGB & 0xFF000000) >> 32);
                aucData[(y * iWidth + x) * 4 + 0] = (byte)((iARGB & 0xFF0000) >> 16);
                aucData[(y * iWidth + x) * 4 + 1] = (byte)((iARGB & 0xFF00) >> 8);
                aucData[(y * iWidth + x) * 4 + 2] = (byte)(iARGB & 0xFF);
            }
        }
        return new GraphicsImage(FormatMode.IT_RGBA8888, iWidth, iHeight, aucData, acImageName);
    }

    public void CopyRGBA(ColorRGBA[] akCImage) {
        block4: {
            block5: {
                block3: {
                    if (this.m_eFormat != FormatMode.IT_RGB888) break block3;
                    for (int i = 0; i < this.m_iQuantity; ++i) {
                        akCImage[i].R = 0.003921569f * (float)this.m_aucData[i * 3 + 0];
                        akCImage[i].G = 0.003921569f * (float)this.m_aucData[i * 3 + 1];
                        akCImage[i].B = 0.003921569f * (float)this.m_aucData[i * 3 + 2];
                        akCImage[i].A = 1.0f;
                    }
                    break block4;
                }
                if (this.m_eFormat != FormatMode.IT_RGBA8888) break block5;
                for (int i = 0; i < this.m_iQuantity; ++i) {
                    akCImage[i].R = 0.003921569f * (float)this.m_aucData[i * 4 + 0];
                    akCImage[i].G = 0.003921569f * (float)this.m_aucData[i * 4 + 1];
                    akCImage[i].B = 0.003921569f * (float)this.m_aucData[i * 4 + 2];
                    akCImage[i].A = 0.003921569f * (float)this.m_aucData[i * 4 + 3];
                }
                break block4;
            }
            if (!this.IsDepthImage()) break block4;
            for (int i = 0; i < this.m_iQuantity; ++i) {
                float fValue;
                akCImage[i].R = fValue = (float)this.m_aucData[i];
                akCImage[i].G = fValue;
                akCImage[i].B = fValue;
                akCImage[i].A = 1.0f;
            }
        }
    }

    public ColorRGBA[] CreateRGBA() {
        if (!this.IsCubeImage()) {
            ColorRGBA[] akCImage = new ColorRGBA[this.m_iQuantity];
            this.CopyRGBA(akCImage);
            return akCImage;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.m_aiBound = null;
        this.m_aucData = null;
        this.m_afData = null;
        if (this.m_kBuffer != null) {
            this.m_kBuffer.clear();
            this.m_kBuffer = null;
        }
        ImageCatalog.GetActive().Remove(this);
        super.dispose();
    }

    public int GetBound(int i) {
        assert (0 <= i && i < 3);
        return this.m_aiBound[i];
    }

    public final int GetBytesPerPixel() {
        return this.m_eFormat.BytesPerPixel();
    }

    public final byte[] GetData() {
        this.m_bUpdateBuffer = true;
        return this.m_aucData;
    }

    public Buffer GetDataBuffer() {
        if (this.m_kBuffer != null && !this.m_bUpdateBuffer) {
            return this.m_kBuffer;
        }
        this.m_bUpdateBuffer = false;
        if (this.m_kBuffer != null) {
            this.m_kBuffer.clear();
            this.m_kBuffer = null;
        }
        if (this.m_aucData != null) {
            this.m_kBuffer = Buffers.newDirectByteBuffer((byte[])this.m_aucData);
            this.m_kBuffer.rewind();
        } else if (this.m_afData != null) {
            this.m_kBuffer = Buffers.newDirectFloatBuffer((float[])this.m_afData);
            this.m_kBuffer.rewind();
        }
        if (this.m_kBuffer == null) {
            // empty if block
        }
        return this.m_kBuffer;
    }

    public final int GetDimension() {
        return this.m_iDimension;
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        int iSize = super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT;
        if (rkVersion.GreaterEqual(new StreamVersion(3, 2))) {
            iSize += Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_INT;
            int iBytes = this.m_eFormat.BytesPerPixel() * this.m_iQuantity;
            iSize += iBytes * Stream.SIZEOF_BYTE;
        } else {
            iSize += Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_INT;
            ++iSize;
            if (this.m_aucData != null) {
                int iBytes = this.m_eFormat.BytesPerPixel() * this.m_aiBound[0] * this.m_aiBound[1];
                iSize += iBytes * Stream.SIZEOF_BYTE;
            }
        }
        return iSize;
    }

    public float[] GetFloatData() {
        this.m_bUpdateBuffer = true;
        return this.m_afData;
    }

    public final FormatMode GetFormat() {
        return this.m_eFormat;
    }

    public final String GetFormatName() {
        return this.m_eFormat.FormatName();
    }

    public final int GetQuantity() {
        return this.m_iQuantity;
    }

    public final Type GetType() {
        return this.m_eType;
    }

    public void InitDataBuffer() {
        if (this.m_aucData == null && this.m_afData == null) {
            switch (this.m_eFormat) {
                case IT_RGB888: {
                    this.m_aucData = new byte[this.m_aiBound[0] * this.m_aiBound[1] * this.m_aiBound[2] * 3];
                    break;
                }
                case IT_RGBA8888: {
                    this.m_aucData = new byte[this.m_aiBound[0] * this.m_aiBound[1] * this.m_aiBound[2] * 4];
                    break;
                }
                case IT_RGB32: {
                    this.m_afData = new float[this.m_aiBound[0] * this.m_aiBound[1] * this.m_aiBound[2] * 3];
                    break;
                }
                case IT_RGBA32: {
                    this.m_afData = new float[this.m_aiBound[0] * this.m_aiBound[1] * this.m_aiBound[2] * 4];
                    break;
                }
                case IT_L8: {
                    this.m_aucData = new byte[this.m_aiBound[0] * this.m_aiBound[1] * this.m_aiBound[2]];
                    break;
                }
                case IT_L32F: {
                    this.m_afData = new float[this.m_aiBound[0] * this.m_aiBound[1] * this.m_aiBound[2]];
                }
            }
        }
    }

    public final boolean IsCubeImage() {
        return this.m_eFormat == FormatMode.IT_CUBE_RGB888 || this.m_eFormat == FormatMode.IT_CUBE_RGBA8888;
    }

    public final boolean IsDepthImage() {
        return this.m_eFormat == FormatMode.IT_DEPTH16 || this.m_eFormat == FormatMode.IT_DEPTH24 || this.m_eFormat == FormatMode.IT_DEPTH32;
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        int iFormat = rkStream.ReadInt();
        this.m_eFormat = ms_pkFormatModeMap.get(iFormat);
        this.m_iDimension = rkStream.ReadInt();
        this.m_aiBound[0] = rkStream.ReadInt();
        this.m_aiBound[1] = rkStream.ReadInt();
        this.m_aiBound[2] = rkStream.ReadInt();
        this.m_iQuantity = rkStream.ReadInt();
        int iBytes = this.m_eFormat.BytesPerPixel() * this.m_iQuantity;
        this.m_aucData = new byte[iBytes];
        rkStream.Read(iBytes, this.m_aucData);
        ImageCatalog.GetActive().Insert(this);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_eFormat.Value());
        rkStream.Write(this.m_iDimension);
        rkStream.Write(this.m_aiBound[0]);
        rkStream.Write(this.m_aiBound[1]);
        rkStream.Write(this.m_aiBound[2]);
        rkStream.Write(this.m_iQuantity);
        int iBytes = this.m_eFormat.BytesPerPixel() * this.m_iQuantity;
        rkStream.Write(iBytes, this.m_aucData);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("GraphicsImage", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("format =", this.m_eFormat.FormatName()));
        pkTree.Append(StringTree.Format("dimension = ", this.m_iDimension));
        for (int i = 0; i < this.m_iDimension; ++i) {
            String prefix = new String("bound[" + i + "] =");
            pkTree.Append(StringTree.Format(prefix, this.m_aiBound[i]));
        }
        return pkTree;
    }

    public void SetData(Buffer kBuffer, int iZ) {
        float[] afData = null;
        if (kBuffer instanceof FloatBuffer) {
            afData = ((FloatBuffer)kBuffer).array();
        }
        if (this.m_afData != null) {
            for (int i = 0; i < this.m_aiBound[0]; ++i) {
                for (int j = 0; j < this.m_aiBound[1]; ++j) {
                    if (this.m_eFormat == FormatMode.IT_RGBA8888) {
                        for (int k = 0; k < 4; ++k) {
                            this.m_afData[4 * (iZ * this.m_aiBound[0] * this.m_aiBound[1] + i * this.m_aiBound[1] + j) + k] = afData[4 * (i * this.m_aiBound[1] + j) + k];
                        }
                    }
                    if (this.m_eFormat != FormatMode.IT_L32F) continue;
                    this.m_afData[iZ * this.m_aiBound[0] * this.m_aiBound[1] + i * this.m_aiBound[1] + j] = afData[i * this.m_aiBound[1] * 4 + j * 4];
                }
            }
        }
    }

    public void SetData(byte[] aucData, int iSize) {
        if (this.m_aucData != null) {
            this.m_aucData = null;
        }
        this.m_aucData = aucData;
        this.m_aiBound[0] = iSize;
        this.m_bUpdateBuffer = true;
    }

    public void SetData(byte[] aucData, int iXSize, int iYSize) {
        if (this.m_aucData != null) {
            this.m_aucData = null;
        }
        this.m_aucData = aucData;
        this.m_aiBound[0] = iXSize;
        this.m_aiBound[1] = iYSize;
        this.m_bUpdateBuffer = true;
    }

    public void SetData(byte[] aucData, int iXSize, int iYSize, int iZSize) {
        if (this.m_aucData != null) {
            this.m_aucData = null;
        }
        this.m_aucData = aucData;
        this.m_aiBound[0] = iXSize;
        this.m_aiBound[1] = iYSize;
        this.m_aiBound[2] = iZSize;
        this.m_iQuantity = iXSize * iYSize * iZSize;
        this.m_eType = Type.IT_BYTE;
        this.m_iDimension = 3;
        this.m_bUpdateBuffer = true;
    }

    public void SetData(ByteBuffer kBuffer, int iZ) {
        byte[] afData = kBuffer.array();
        if (this.m_aucData != null) {
            for (int i = 0; i < this.m_aiBound[0]; ++i) {
                for (int j = 0; j < this.m_aiBound[1]; ++j) {
                    if (this.m_eFormat == FormatMode.IT_RGBA8888) {
                        for (int k = 0; k < 4; ++k) {
                            this.m_aucData[4 * (iZ * this.m_aiBound[0] * this.m_aiBound[1] + i * this.m_aiBound[1] + j) + k] = afData[4 * (i * this.m_aiBound[1] + j) + k];
                        }
                    }
                    if (this.m_eFormat != FormatMode.IT_L8) continue;
                    this.m_aucData[iZ * this.m_aiBound[0] * this.m_aiBound[1] + i * this.m_aiBound[1] + j] = afData[i * this.m_aiBound[1] * 4 + j * 4];
                }
            }
        }
    }

    public void SetData(float[] afData, int iXSize, int iYSize) {
        if (this.m_afData != null) {
            this.m_afData = null;
        }
        this.m_afData = afData;
        this.m_aiBound[0] = iXSize;
        this.m_aiBound[1] = iYSize;
        this.m_bUpdateBuffer = true;
    }

    public void SetFloatData(float[] afData, int iSize) {
        if (this.m_afData != null) {
            this.m_afData = null;
        }
        this.m_afData = afData;
        this.m_aiBound[0] = iSize;
        this.m_bUpdateBuffer = true;
    }

    public void SetFloatData(float[] afData, int iXSize, int iYSize) {
        if (this.m_afData != null) {
            this.m_afData = null;
        }
        this.m_afData = afData;
        this.m_aiBound[0] = iXSize;
        this.m_aiBound[1] = iYSize;
        this.m_bUpdateBuffer = true;
    }

    public void SetFloatData(float[] afData, int iXSize, int iYSize, int iZSize) {
        if (this.m_afData != null) {
            this.m_afData = null;
        }
        this.m_afData = afData;
        this.m_aiBound[0] = iXSize;
        this.m_aiBound[1] = iYSize;
        this.m_aiBound[2] = iZSize;
        this.m_bUpdateBuffer = true;
    }

    public static enum Type {
        IT_BYTE(1, "IT_BYTE"),
        IT_UBYTE(1, "IT_UBYTE"),
        IT_SHORT(2, "IT_SHORT"),
        IT_USHORT(2, "IT_USHORT"),
        IT_INT(4, "IT_INT"),
        IT_UINT(4, "IT_UINT"),
        IT_LONG(8, "IT_LONG"),
        IT_FLOAT(4, "IT_FLOAT"),
        IT_DOUBLE(8, "IT_DOUBLE"),
        IT_QUANTITY(0, "");

        private static int m_iInitValue;
        private final int ms_aiBytesPerPixel;
        private final String ms_kName;
        private int m_iValue;

        private Type(int iBytesPerPixel, String kFormatName) {
            this.ms_aiBytesPerPixel = iBytesPerPixel;
            this.ms_kName = kFormatName;
            this.m_iValue = this.Init();
            ms_pkTypeMap.put(this.m_iValue, this);
        }

        public int BytesPerPixel() {
            return this.ms_aiBytesPerPixel;
        }

        public String Name() {
            return this.ms_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }

    public static enum FormatMode {
        IT_RGB888(3, "IT_RGB888"),
        IT_RGBA8888(4, "IT_RGBA8888"),
        IT_DEPTH16(2, "IT_DEPTH16"),
        IT_DEPTH24(3, "IT_DEPTH24"),
        IT_DEPTH32(4, "IT_DEPTH32"),
        IT_CUBE_RGB888(3, "IT_CUBE_RGB888"),
        IT_CUBE_RGBA8888(4, "IT_CUBE_RGBA8888"),
        IT_RGB32(12, "IT_RGB32"),
        IT_RGBA32(16, "IT_RGBA32"),
        IT_L8(1, "IT_L8"),
        IT_L32F(4, "IT_L32F"),
        IT_RGB16(6, "IT_RGB16"),
        IT_RGBA16(8, "IT_RGBA32"),
        IT_R32(4, "IT_R32"),
        IT_QUANTITY(0, "");

        private static int m_iInitValue;
        private final int ms_aiBytesPerPixel;
        private final String ms_akFormatName;
        private int m_iValue;

        private FormatMode(int iBytesPerPixel, String kFormatName) {
            this.ms_aiBytesPerPixel = iBytesPerPixel;
            this.ms_akFormatName = kFormatName;
            this.m_iValue = this.Init();
            ms_pkFormatModeMap.put(this.m_iValue, this);
        }

        public int BytesPerPixel() {
            return this.ms_aiBytesPerPixel;
        }

        public String FormatName() {
            return this.ms_akFormatName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }
}

