/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibFoundation.Mathematics.ColorRGB;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import java.io.Serializable;

public class Light
extends GraphicsObject
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 5615211303260002460L;
    public LightType Type = LightType.LT_AMBIENT;
    public boolean On = true;
    public ColorRGB Ambient = new ColorRGB(0.0f, 0.0f, 0.0f);
    public ColorRGB Diffuse = new ColorRGB(0.0f, 0.0f, 0.0f);
    public ColorRGB Specular = new ColorRGB(0.0f, 0.0f, 0.0f);
    public float Constant = 1.0f;
    public float Linear = 0.0f;
    public float Quadratic = 0.0f;
    public float Intensity = 1.0f;
    public float Angle = (float)Math.PI;
    public float CosAngle = -1.0f;
    public float SinAngle = 0.0f;
    public float Exponent = 1.0f;
    public Vector3f Position = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f DVector = new Vector3f(0.0f, 0.0f, -1.0f);
    public Vector3f UVector = new Vector3f(0.0f, 1.0f, 0.0f);
    public Vector3f RVector = new Vector3f(1.0f, 0.0f, 0.0f);

    public Light() {
    }

    public Light(LightType eType) {
        this.Type = eType;
    }

    public Light(Light kLight) {
        this.Type = kLight.Type;
        this.On = kLight.On;
        this.Ambient = new ColorRGB(kLight.Ambient);
        this.Diffuse = new ColorRGB(kLight.Diffuse);
        this.Specular = new ColorRGB(kLight.Specular);
        this.Constant = kLight.Constant;
        this.Linear = kLight.Linear;
        this.Quadratic = kLight.Quadratic;
        this.Intensity = kLight.Intensity;
        this.Angle = kLight.Angle;
        this.CosAngle = kLight.CosAngle;
        this.SinAngle = kLight.SinAngle;
        this.Exponent = kLight.Exponent;
        this.Position = new Vector3f(kLight.Position);
        this.DVector = new Vector3f(kLight.DVector);
        this.UVector = new Vector3f(kLight.UVector);
        this.RVector = new Vector3f(kLight.RVector);
    }

    @Override
    public void dispose() {
        this.Ambient = null;
        this.Diffuse = null;
        this.Specular = null;
        this.Position = null;
        this.DVector = null;
        this.UVector = null;
        this.RVector = null;
        super.dispose();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + 3 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT;
    }

    public boolean IsValidFrame() {
        float fTest = this.DVector.Dot(this.UVector);
        if (Math.abs(fTest) > 1.0E-6f) {
            return false;
        }
        fTest = this.DVector.Dot(this.RVector);
        if (Math.abs(fTest) > 1.0E-6f) {
            return false;
        }
        fTest = this.UVector.Dot(this.RVector);
        if (Math.abs(fTest) > 1.0E-6f) {
            return false;
        }
        Vector3f kCross = new Vector3f();
        kCross.Cross(this.UVector, this.RVector);
        fTest = this.DVector.Dot(kCross);
        kCross = null;
        return Math.abs(1.0f - fTest) <= 1.0E-6f;
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        rkStream.Read(this.Position);
        rkStream.Read(this.DVector);
        rkStream.Read(this.UVector);
        rkStream.Read(this.RVector);
        rkStream.Read(this.Ambient);
        rkStream.Read(this.Diffuse);
        rkStream.Read(this.Specular);
        this.Intensity = rkStream.ReadFloat();
        this.Constant = rkStream.ReadFloat();
        this.Linear = rkStream.ReadFloat();
        this.Quadratic = rkStream.ReadFloat();
        this.Angle = rkStream.ReadFloat();
        this.CosAngle = rkStream.ReadFloat();
        this.SinAngle = rkStream.ReadFloat();
        this.Exponent = rkStream.ReadFloat();
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.Position);
        rkStream.Write(this.DVector);
        rkStream.Write(this.UVector);
        rkStream.Write(this.RVector);
        rkStream.Write(this.Ambient);
        rkStream.Write(this.Diffuse);
        rkStream.Write(this.Specular);
        rkStream.Write(this.Intensity);
        rkStream.Write(this.Constant);
        rkStream.Write(this.Linear);
        rkStream.Write(this.Quadratic);
        rkStream.Write(this.Angle);
        rkStream.Write(this.CosAngle);
        rkStream.Write(this.SinAngle);
        rkStream.Write(this.Exponent);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("Light", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("position =", this.Position));
        pkTree.Append(StringTree.Format("d vector =", this.DVector));
        pkTree.Append(StringTree.Format("u vector =", this.UVector));
        pkTree.Append(StringTree.Format("r vector =", this.RVector));
        pkTree.Append(StringTree.Format("ambient =", this.Ambient));
        pkTree.Append(StringTree.Format("diffuse =", this.Diffuse));
        pkTree.Append(StringTree.Format("specular =", this.Specular));
        pkTree.Append(StringTree.Format("intensity =", this.Intensity));
        pkTree.Append(StringTree.Format("attn constant =", this.Constant));
        pkTree.Append(StringTree.Format("attn linear =", this.Linear));
        pkTree.Append(StringTree.Format("attn quadratic =", this.Quadratic));
        pkTree.Append(StringTree.Format("angle =", this.Angle));
        pkTree.Append(StringTree.Format("exponent =", this.Exponent));
        return pkTree;
    }

    public void SetAngle(float fAngle) {
        assert (0.0f < fAngle && (double)fAngle <= Math.PI);
        this.Angle = fAngle;
        this.CosAngle = (float)Math.cos(fAngle);
        this.SinAngle = (float)Math.sin(fAngle);
    }

    public void SetDirection(Vector3f rkDirection) {
        this.DVector = new Vector3f(rkDirection);
        Vector3f.GenerateOrthonormalBasis(this.UVector, this.RVector, this.DVector);
    }

    public static enum LightType {
        LT_AMBIENT("Ambient"),
        LT_DIRECTIONAL("Directional"),
        LT_POINT("Point"),
        LT_SPOT("Spot"),
        LT_QUANTITY("Quantity");

        private String m_kName;
        private int m_iValue;
        private static int m_iInitValue;

        private LightType(String kName) {
            this.m_kName = kName;
            this.m_iValue = this.Init();
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }
}

