/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.GlobalState;
import java.io.Serializable;

public class PolygonOffsetState
extends GlobalState
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = -8324297394310813373L;
    public boolean FillEnabled = false;
    public boolean LineEnabled = false;
    public boolean PointEnabled = false;
    public float Scale = 0.0f;
    public float Bias = 0.0f;

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_BOOLEAN + Stream.SIZEOF_BOOLEAN + Stream.SIZEOF_BOOLEAN + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT;
    }

    @Override
    public final GlobalState.StateType GetStateType() {
        return GlobalState.StateType.POLYGONOFFSET;
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.FillEnabled = rkStream.ReadBoolean();
        this.LineEnabled = rkStream.ReadBoolean();
        this.PointEnabled = rkStream.ReadBoolean();
        this.Scale = rkStream.ReadFloat();
        this.Bias = rkStream.ReadFloat();
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.FillEnabled);
        rkStream.Write(this.LineEnabled);
        rkStream.Write(this.PointEnabled);
        rkStream.Write(this.Scale);
        rkStream.Write(this.Bias);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("PolygonOffsetState", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("fill enabled =", this.FillEnabled));
        pkTree.Append(StringTree.Format("line enabled =", this.LineEnabled));
        pkTree.Append(StringTree.Format("point enabled =", this.PointEnabled));
        pkTree.Append(StringTree.Format("scale =", this.Scale));
        pkTree.Append(StringTree.Format("bias =", this.Bias));
        return pkTree;
    }

    static {
        if (!DefaultInitialized[GlobalState.StateType.POLYGONOFFSET.Value()]) {
            PolygonOffsetState.DefaultInitialized[GlobalState.StateType.POLYGONOFFSET.Value()] = true;
            PolygonOffsetState.Default[GlobalState.StateType.POLYGONOFFSET.Value()] = new PolygonOffsetState();
        }
    }
}

