/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.GlobalState;
import java.io.Serializable;
import java.util.HashMap;

public class WireframeState
extends GlobalState
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 111654826665033500L;
    private static HashMap<Integer, FillMode> ms_pkFillModeMap = new HashMap();
    private static FillMode ms_eFillModeStatic;
    public boolean Enabled = false;
    public FillMode Fill = FillMode.FM_FILL;

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_BOOLEAN;
    }

    @Override
    public final GlobalState.StateType GetStateType() {
        return GlobalState.StateType.WIREFRAME;
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.Enabled = rkStream.ReadBoolean();
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.Enabled);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("WireframeState", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("enabled =", this.Enabled));
        return pkTree;
    }

    static {
        if (!DefaultInitialized[GlobalState.StateType.WIREFRAME.Value()]) {
            WireframeState.DefaultInitialized[GlobalState.StateType.WIREFRAME.Value()] = true;
            WireframeState.Default[GlobalState.StateType.WIREFRAME.Value()] = new WireframeState();
        }
        ms_eFillModeStatic = FillMode.FM_QUANTITY;
    }

    public static enum FillMode {
        FM_FILL("FM_FILL"),
        FM_LINE("FM_LINE"),
        FM_POINT("FM_POINT"),
        FM_QUANTITY("FM_QUANTITY");

        private int m_iValue = this.Init();
        private String m_kName;
        private static int m_iInitValue;

        private FillMode(String kName) {
            this.m_kName = kName;
            ms_pkFillModeMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }
}

