/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibFoundation.Containment.ContBox3f;
import WildMagic.LibFoundation.Intersection.IntrBox3Box3f;
import WildMagic.LibFoundation.Intersection.IntrLine3Box3f;
import WildMagic.LibFoundation.Intersection.IntrRay3Box3f;
import WildMagic.LibFoundation.Intersection.IntrSegment3Box3f;
import WildMagic.LibFoundation.Mathematics.Box3f;
import WildMagic.LibFoundation.Mathematics.Line3f;
import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Ray3f;
import WildMagic.LibFoundation.Mathematics.Segment3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.SceneGraph.BoundingVolume;
import WildMagic.LibGraphics.SceneGraph.Transformation;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import java.io.Serializable;

public class BoxBV
extends BoundingVolume
implements Serializable {
    private static final long serialVersionUID = -3399833532407528036L;
    protected Box3f m_kBox;

    public BoxBV() {
        this.m_kBox = new Box3f(Vector3f.ZERO, Vector3f.UNIT_X, Vector3f.UNIT_Y, Vector3f.UNIT_Z, 1.0f, 1.0f, 1.0f);
    }

    public BoxBV(Box3f rkBox) {
        this.m_kBox = rkBox;
    }

    @Override
    public void ComputeFromData(Vector3f[] pkVertices) {
        if (pkVertices != null) {
            int iVQuantity = pkVertices.length;
            this.m_kBox = ContBox3f.ContAlignedBox(iVQuantity, pkVertices);
        }
    }

    @Override
    public void ComputeFromData(VertexBuffer pkVBuffer) {
        if (pkVBuffer != null) {
            int iVQuantity = pkVBuffer.GetVertexQuantity();
            Vector3f[] pkVertices = new Vector3f[iVQuantity];
            for (int i = 0; i < iVQuantity; ++i) {
                pkVertices[i] = pkVBuffer.GetPosition3(i);
            }
            this.m_kBox = ContBox3f.ContAlignedBox(iVQuantity, pkVertices);
        }
    }

    @Override
    public boolean Contains(Vector3f rkPoint) {
        return ContBox3f.InBox(rkPoint, this.m_kBox);
    }

    @Override
    public void CopyFrom(BoundingVolume pkInput) {
        this.m_kBox = ((BoxBV)pkInput).m_kBox;
    }

    @Override
    public void dispose() {
        this.m_kBox = null;
    }

    public Box3f GetBox() {
        return this.m_kBox;
    }

    @Override
    public BoundingVolume.BVType GetBVType() {
        return BoundingVolume.BVType.BV_BOX;
    }

    @Override
    public Vector3f GetCenter() {
        return this.m_kBox.Center;
    }

    @Override
    public float GetRadius() {
        float fRadius = this.m_kBox.Extent[0];
        if (fRadius < this.m_kBox.Extent[1]) {
            fRadius = this.m_kBox.Extent[1];
        }
        if (fRadius < this.m_kBox.Extent[2]) {
            fRadius = this.m_kBox.Extent[2];
        }
        return fRadius;
    }

    @Override
    public void GrowToContain(BoundingVolume pkInput) {
        this.m_kBox = ContBox3f.MergeBoxes(this.m_kBox, ((BoxBV)pkInput).m_kBox);
    }

    public void SetBox(Box3f kBox) {
        this.m_kBox = kBox;
    }

    @Override
    public void SetCenter(Vector3f rkCenter) {
        this.m_kBox.Center = new Vector3f(rkCenter);
    }

    @Override
    public void SetRadius(float fRadius) {
        this.m_kBox.Extent[0] = fRadius;
        this.m_kBox.Extent[1] = fRadius;
        this.m_kBox.Extent[2] = fRadius;
    }

    @Override
    public boolean TestIntersection(BoundingVolume pkInput) {
        IntrBox3Box3f kTestBB = new IntrBox3Box3f(this.m_kBox, ((BoxBV)pkInput).m_kBox);
        return kTestBB.Test();
    }

    @Override
    public boolean TestIntersection(Vector3f rkOrigin, Vector3f rkDirection, float fTMin, float fTMax) {
        if (fTMin == -3.4028235E38f) {
            Line3f kLine = new Line3f(rkOrigin, rkDirection);
            IntrLine3Box3f kTestLB = new IntrLine3Box3f(kLine, this.m_kBox);
            return kTestLB.Test();
        }
        assert (fTMin == 0.0f);
        if (fTMax == Float.MAX_VALUE) {
            Ray3f kRay = new Ray3f(rkOrigin, rkDirection);
            IntrRay3Box3f kTestRB = new IntrRay3Box3f(kRay, this.m_kBox);
            return kTestRB.Test();
        }
        assert (fTMax > 0.0f);
        Segment3f kSegment = new Segment3f();
        kSegment.Extent = 0.5f * fTMax;
        kSegment.Center.Scale(kSegment.Extent, rkDirection);
        kSegment.Center.Add(rkOrigin);
        kSegment.Direction = rkDirection;
        IntrSegment3Box3f kTestSB = new IntrSegment3Box3f(kSegment, this.m_kBox, true);
        return kTestSB.Test();
    }

    @Override
    public void TransformBy(Transformation rkTransform, BoundingVolume pkResult) {
        Box3f rkTarget = ((BoxBV)pkResult).m_kBox;
        rkTarget.Center = rkTransform.ApplyForward(this.m_kBox.Center);
        for (int i = 0; i < 3; ++i) {
            rkTransform.GetRotate().Mult(this.m_kBox.Axis[i], rkTarget.Axis[i]);
            rkTarget.Extent[i] = rkTransform.GetNorm() * this.m_kBox.Extent[i];
        }
    }

    @Override
    public int WhichSide(Plane3f rkPlane) {
        float fAbs2;
        float fAbs1;
        float fAbs0;
        float fProjRadius;
        float fProjCenter = rkPlane.Normal.Dot(this.m_kBox.Center) - rkPlane.Constant;
        if (fProjCenter - (fProjRadius = this.m_kBox.Extent[0] * (fAbs0 = Math.abs(rkPlane.Normal.Dot(this.m_kBox.Axis[0]))) + this.m_kBox.Extent[1] * (fAbs1 = Math.abs(rkPlane.Normal.Dot(this.m_kBox.Axis[1]))) + this.m_kBox.Extent[2] * (fAbs2 = Math.abs(rkPlane.Normal.Dot(this.m_kBox.Axis[2])))) >= 0.0f) {
            return 1;
        }
        if (fProjCenter + fProjRadius <= 0.0f) {
            return -1;
        }
        return 0;
    }
}

