/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.Effects.Effect;
import WildMagic.LibGraphics.Rendering.Camera;
import WildMagic.LibGraphics.SceneGraph.BoundingVolume;
import WildMagic.LibGraphics.SceneGraph.Spatial;
import WildMagic.LibGraphics.SceneGraph.VisibleSet;
import java.io.Serializable;

public class Culler
implements Serializable {
    private static final long serialVersionUID = -3973101760307267483L;
    public static final int VS_MAX_PLANE_QUANTITY = 32;
    protected Camera m_pkCamera;
    protected float[] m_afFrustum = new float[Camera.ViewFrustum.VF_QUANTITY.Value()];
    protected int m_iPlaneQuantity;
    protected Plane3f[] m_akPlane = new Plane3f[32];
    protected int m_uiPlaneState;
    protected VisibleSet m_kVisible;

    public Culler(int iMaxQuantity, int iGrowBy, Camera pkCamera) {
        this.m_kVisible = new VisibleSet(iMaxQuantity, iGrowBy);
        this.m_pkCamera = pkCamera;
        this.m_iPlaneQuantity = 6;
        for (int i = 0; i < 32; ++i) {
            this.m_akPlane[i] = new Plane3f();
        }
    }

    public void ComputeVisibleSet(Spatial pkScene) {
        assert (this.m_pkCamera != null && pkScene != null);
        if (this.m_pkCamera != null && pkScene != null) {
            this.SetFrustum(this.m_pkCamera.GetFrustum());
            this.m_kVisible.Clear();
            pkScene.OnGetVisibleSet(this, false);
        }
    }

    public void dispose() {
        this.m_pkCamera = null;
        this.m_afFrustum = null;
        for (int i = 0; i < 32; ++i) {
            this.m_akPlane[i].dispose();
            this.m_akPlane[i] = null;
        }
        this.m_akPlane = null;
        if (this.m_kVisible != null) {
            this.m_kVisible.dispose();
            this.m_kVisible = null;
        }
    }

    public final Camera GetCamera() {
        return this.m_pkCamera;
    }

    public final float[] GetFrustum() {
        return this.m_afFrustum;
    }

    public final int GetPlaneQuantity() {
        return this.m_iPlaneQuantity;
    }

    public final Plane3f[] GetPlanes() {
        return this.m_akPlane;
    }

    public final int GetPlaneState() {
        return this.m_uiPlaneState;
    }

    public final VisibleSet GetVisibleSet() {
        return this.m_kVisible;
    }

    public void Insert(Spatial pkObject, Effect pkGlobalEffect) {
        this.m_kVisible.Insert(pkObject, pkGlobalEffect);
    }

    public boolean IsVisible(BoundingVolume pkBound) {
        int iP = this.m_iPlaneQuantity - 1;
        int uiMask = 1 << iP;
        int i = 0;
        while (i < this.m_iPlaneQuantity) {
            if ((this.m_uiPlaneState & uiMask) != 0) {
                int iSide = pkBound.WhichSide(this.m_akPlane[iP]);
                if (iSide < 0) {
                    return false;
                }
                if (iSide > 0) {
                    this.m_uiPlaneState &= ~uiMask;
                }
            }
            ++i;
            --iP;
            uiMask >>= 1;
        }
        return true;
    }

    public boolean IsVisible(int iVertexQuantity, Vector3f[] akVertex, boolean bIgnoreNearPlane) {
        int iP = this.m_iPlaneQuantity - 1;
        int i = 0;
        while (i < this.m_iPlaneQuantity) {
            Plane3f rkPlane = this.m_akPlane[iP];
            if (!bIgnoreNearPlane || iP != Camera.ViewFrustum.VF_DMIN.Value()) {
                int iSide;
                int iV;
                for (iV = 0; iV < iVertexQuantity && (iSide = rkPlane.WhichSide(akVertex[iV])) < 0; ++iV) {
                }
                if (iV == iVertexQuantity) {
                    return false;
                }
            }
            ++i;
            --iP;
        }
        return true;
    }

    public void PopPlane() {
        if (this.m_iPlaneQuantity > Camera.ViewFrustum.VF_QUANTITY.Value()) {
            --this.m_iPlaneQuantity;
        }
    }

    public void PushPlane(Plane3f rkPlane) {
        if (this.m_iPlaneQuantity < 32) {
            this.m_akPlane[this.m_iPlaneQuantity++] = rkPlane;
        }
    }

    public final void SetCamera(Camera pkCamera) {
        this.m_pkCamera = pkCamera;
    }

    public void SetFrustum(float[] afFrustum) {
        assert (this.m_pkCamera != null);
        if (this.m_pkCamera == null) {
            return;
        }
        for (int i = 0; i < Camera.ViewFrustum.VF_QUANTITY.Value(); ++i) {
            this.m_afFrustum[i] = afFrustum[i];
        }
        float fDMin2 = this.m_afFrustum[Camera.ViewFrustum.VF_DMIN.Value()] * this.m_afFrustum[Camera.ViewFrustum.VF_DMIN.Value()];
        float fRMin2 = this.m_afFrustum[Camera.ViewFrustum.VF_RMIN.Value()] * this.m_afFrustum[Camera.ViewFrustum.VF_RMIN.Value()];
        float fRMax2 = this.m_afFrustum[Camera.ViewFrustum.VF_RMAX.Value()] * this.m_afFrustum[Camera.ViewFrustum.VF_RMAX.Value()];
        float fUMin2 = this.m_afFrustum[Camera.ViewFrustum.VF_UMIN.Value()] * this.m_afFrustum[Camera.ViewFrustum.VF_UMIN.Value()];
        float fUMax2 = this.m_afFrustum[Camera.ViewFrustum.VF_UMAX.Value()] * this.m_afFrustum[Camera.ViewFrustum.VF_UMAX.Value()];
        Vector3f kLoc = this.m_pkCamera.GetLocation();
        Vector3f kDVec = this.m_pkCamera.GetDVector();
        Vector3f kUVec = this.m_pkCamera.GetUVector();
        Vector3f kRVec = this.m_pkCamera.GetRVector();
        float fDdE = kDVec.Dot(kLoc);
        this.m_akPlane[Camera.ViewFrustum.VF_DMIN.Value()].Normal.Copy(kDVec);
        this.m_akPlane[Camera.ViewFrustum.VF_DMIN.Value()].Constant = fDdE + this.m_afFrustum[Camera.ViewFrustum.VF_DMIN.Value()];
        this.m_akPlane[Camera.ViewFrustum.VF_DMAX.Value()].Normal.Copy(kDVec);
        this.m_akPlane[Camera.ViewFrustum.VF_DMAX.Value()].Normal.Neg();
        this.m_akPlane[Camera.ViewFrustum.VF_DMAX.Value()].Constant = -(fDdE + this.m_afFrustum[Camera.ViewFrustum.VF_DMAX.Value()]);
        float fInvLength = (float)(1.0 / Math.sqrt(fDMin2 + fUMin2));
        float fC0 = -this.m_afFrustum[Camera.ViewFrustum.VF_UMIN.Value()] * fInvLength;
        float fC1 = this.m_afFrustum[Camera.ViewFrustum.VF_DMIN.Value()] * fInvLength;
        Vector3f kTemp1 = new Vector3f(kUVec);
        kTemp1.Scale(fC1);
        Vector3f kTemp2 = new Vector3f(kDVec);
        kTemp2.Scale(fC0);
        kTemp1.Add(kTemp2);
        this.m_akPlane[Camera.ViewFrustum.VF_UMIN.Value()].Normal.Copy(kTemp1);
        this.m_akPlane[Camera.ViewFrustum.VF_UMIN.Value()].Constant = kLoc.Dot(this.m_akPlane[Camera.ViewFrustum.VF_UMIN.Value()].Normal);
        fInvLength = (float)(1.0 / Math.sqrt(fDMin2 + fUMax2));
        fC0 = this.m_afFrustum[Camera.ViewFrustum.VF_UMAX.Value()] * fInvLength;
        fC1 = -this.m_afFrustum[Camera.ViewFrustum.VF_DMIN.Value()] * fInvLength;
        kTemp1.Copy(kUVec);
        kTemp1.Scale(fC1);
        kTemp2.Copy(kDVec);
        kTemp2.Scale(fC0);
        kTemp1.Add(kTemp2);
        this.m_akPlane[Camera.ViewFrustum.VF_UMAX.Value()].Normal.Copy(kTemp1);
        this.m_akPlane[Camera.ViewFrustum.VF_UMAX.Value()].Constant = kLoc.Dot(this.m_akPlane[Camera.ViewFrustum.VF_UMAX.Value()].Normal);
        fInvLength = (float)(1.0 / Math.sqrt(fDMin2 + fRMin2));
        fC0 = -this.m_afFrustum[Camera.ViewFrustum.VF_RMIN.Value()] * fInvLength;
        fC1 = this.m_afFrustum[Camera.ViewFrustum.VF_DMIN.Value()] * fInvLength;
        kTemp1.Copy(kRVec);
        kTemp1.Scale(fC1);
        kTemp2.Copy(kDVec);
        kTemp2.Scale(fC0);
        kTemp1.Add(kTemp2);
        this.m_akPlane[Camera.ViewFrustum.VF_RMIN.Value()].Normal.Copy(kTemp1);
        this.m_akPlane[Camera.ViewFrustum.VF_RMIN.Value()].Constant = kLoc.Dot(this.m_akPlane[Camera.ViewFrustum.VF_RMIN.Value()].Normal);
        fInvLength = (float)(1.0 / Math.sqrt(fDMin2 + fRMax2));
        fC0 = this.m_afFrustum[Camera.ViewFrustum.VF_RMAX.Value()] * fInvLength;
        fC1 = -this.m_afFrustum[Camera.ViewFrustum.VF_DMIN.Value()] * fInvLength;
        this.m_akPlane[Camera.ViewFrustum.VF_RMAX.Value()].Normal.Copy(kTemp1);
        this.m_akPlane[Camera.ViewFrustum.VF_RMAX.Value()].Constant = kLoc.Dot(this.m_akPlane[Camera.ViewFrustum.VF_RMAX.Value()].Normal);
        this.m_uiPlaneState = -1;
    }

    public final void SetPlaneState(int uiPlaneState) {
        this.m_uiPlaneState = uiPlaneState;
    }

    public int WhichSide(Plane3f rkPlane) {
        float fNdEmC = rkPlane.DistanceTo(this.m_pkCamera.GetLocation());
        float fNdD = rkPlane.Normal.Dot(this.m_pkCamera.GetDVector());
        float fNdU = rkPlane.Normal.Dot(this.m_pkCamera.GetUVector());
        float fNdR = rkPlane.Normal.Dot(this.m_pkCamera.GetRVector());
        float fFdN = this.m_afFrustum[Camera.ViewFrustum.VF_DMAX.Value()] / this.m_afFrustum[Camera.ViewFrustum.VF_DMIN.Value()];
        int iPositive = 0;
        int iNegative = 0;
        float fPDMin = this.m_afFrustum[Camera.ViewFrustum.VF_DMIN.Value()] * fNdD;
        float fNUMin = this.m_afFrustum[Camera.ViewFrustum.VF_UMIN.Value()] * fNdU;
        float fNUMax = this.m_afFrustum[Camera.ViewFrustum.VF_UMAX.Value()] * fNdU;
        float fNRMin = this.m_afFrustum[Camera.ViewFrustum.VF_RMIN.Value()] * fNdR;
        float fNRMax = this.m_afFrustum[Camera.ViewFrustum.VF_RMAX.Value()] * fNdR;
        float fSgnDist = fNdEmC + fPDMin + fNUMin + fNRMin;
        if (fSgnDist > 0.0f) {
            ++iPositive;
        } else if (fSgnDist < 0.0f) {
            ++iNegative;
        }
        fSgnDist = fNdEmC + fPDMin + fNUMin + fNRMax;
        if (fSgnDist > 0.0f) {
            ++iPositive;
        } else if (fSgnDist < 0.0f) {
            ++iNegative;
        }
        fSgnDist = fNdEmC + fPDMin + fNUMax + fNRMin;
        if (fSgnDist > 0.0f) {
            ++iPositive;
        } else if (fSgnDist < 0.0f) {
            ++iNegative;
        }
        fSgnDist = fNdEmC + fPDMin + fNUMax + fNRMax;
        if (fSgnDist > 0.0f) {
            ++iPositive;
        } else if (fSgnDist < 0.0f) {
            ++iNegative;
        }
        float fPDMax = this.m_afFrustum[Camera.ViewFrustum.VF_DMAX.Value()] * fNdD;
        float fFUMin = fFdN * fNUMin;
        float fFUMax = fFdN * fNUMax;
        float fFRMin = fFdN * fNRMin;
        float fFRMax = fFdN * fNRMax;
        fSgnDist = fNdEmC + fPDMax + fFUMin + fFRMin;
        if (fSgnDist > 0.0f) {
            ++iPositive;
        } else if (fSgnDist < 0.0f) {
            ++iNegative;
        }
        fSgnDist = fNdEmC + fPDMax + fFUMin + fFRMax;
        if (fSgnDist > 0.0f) {
            ++iPositive;
        } else if (fSgnDist < 0.0f) {
            ++iNegative;
        }
        fSgnDist = fNdEmC + fPDMax + fFUMax + fFRMin;
        if (fSgnDist > 0.0f) {
            ++iPositive;
        } else if (fSgnDist < 0.0f) {
            ++iNegative;
        }
        fSgnDist = fNdEmC + fPDMax + fFUMax + fFRMax;
        if (fSgnDist > 0.0f) {
            ++iPositive;
        } else if (fSgnDist < 0.0f) {
            ++iNegative;
        }
        if (iPositive > 0) {
            if (iNegative > 0) {
                return 0;
            }
            return 1;
        }
        return -1;
    }
}

