/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibGraphics.Effects.Effect;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.NameIdInterface;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.GlobalState;
import WildMagic.LibGraphics.Rendering.Light;
import WildMagic.LibGraphics.SceneGraph.Culler;
import WildMagic.LibGraphics.SceneGraph.Spatial;
import java.io.Serializable;
import java.util.Vector;

public class Node
extends Spatial
implements NameIdInterface,
StreamInterface,
Serializable {
    private static final long serialVersionUID = -2061571134950534647L;
    protected Vector<Spatial> m_kChild = new Vector();

    public int AttachChild(Spatial pkChild) {
        if (pkChild == null) {
            return this.m_kChild.size();
        }
        assert (pkChild != null && pkChild.GetParent() == null);
        pkChild.SetParent(this);
        int iQuantity = this.m_kChild.size();
        this.m_kChild.add(pkChild);
        return iQuantity;
    }

    public void DetachAllChildren() {
        for (int i = 0; i < this.m_kChild.size(); ++i) {
            Spatial spkChild = this.m_kChild.get(i);
            if (spkChild == null) continue;
            spkChild.SetParent(null);
        }
        this.m_kChild.clear();
    }

    public int DetachChild(Spatial pkChild) {
        if (pkChild != null) {
            for (int i = 0; i < this.m_kChild.size(); ++i) {
                if (this.m_kChild.get(i) != pkChild) continue;
                pkChild.SetParent(null);
                this.m_kChild.remove(i);
                return i;
            }
        }
        return -1;
    }

    public Spatial DetachChildAt(int i) {
        if (0 <= i && i < this.m_kChild.size()) {
            Spatial spkChild = this.m_kChild.get(i);
            if (spkChild != null) {
                spkChild.SetParent(null);
                this.m_kChild.remove(i);
            }
            return spkChild;
        }
        return null;
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.m_kChild.size(); ++i) {
            Spatial spkChild = this.DetachChildAt(i);
            if (spkChild == null) continue;
            spkChild.dispose();
            Object var2_2 = null;
        }
        super.dispose();
    }

    @Override
    public void GetAllObjectsByName(String rkName, Vector<GraphicsObject> rkObjects) {
        super.GetAllObjectsByName(rkName, rkObjects);
        for (int i = 0; i < this.m_kChild.size(); ++i) {
            Spatial pkChild = this.m_kChild.get(i);
            if (pkChild == null) continue;
            pkChild.GetAllObjectsByName(rkName, rkObjects);
        }
    }

    public Spatial GetChild(int i) {
        if (0 <= i && i < this.m_kChild.size()) {
            return this.m_kChild.get(i);
        }
        return null;
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT + this.m_kChild.size() * Stream.SIZEOF_INT;
    }

    @Override
    public GraphicsObject GetObjectByID(int uiID) {
        GraphicsObject pkFound = super.GetObjectByID(uiID);
        if (pkFound != null) {
            return pkFound;
        }
        for (int i = 0; i < this.m_kChild.size(); ++i) {
            Spatial pkChild = this.m_kChild.get(i);
            if (pkChild == null || (pkFound = pkChild.GetObjectByID(uiID)) == null) continue;
            return pkFound;
        }
        return null;
    }

    @Override
    public GraphicsObject GetObjectByName(String rkName) {
        GraphicsObject pkFound = super.GetObjectByName(rkName);
        if (pkFound != null) {
            return pkFound;
        }
        for (int i = 0; i < this.m_kChild.size(); ++i) {
            Spatial pkChild = this.m_kChild.get(i);
            if (pkChild == null || (pkFound = pkChild.GetObjectByName(rkName)) == null) continue;
            return pkFound;
        }
        return null;
    }

    public final int GetQuantity() {
        return this.m_kChild.size();
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
        for (int i = 0; i < this.m_kChild.size(); ++i) {
            int iLinkID = pkLink.GetLinkID();
            Spatial pkChild = (Spatial)rkStream.GetFromMap(iLinkID);
            if (pkChild == null) continue;
            this.SetChild(i, pkChild);
        }
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        int iQuantity = rkStream.ReadInt();
        this.m_kChild.setSize(iQuantity);
        for (int i = 0; i < iQuantity; ++i) {
            int iLinkID = rkStream.ReadInt();
            pkLink.Add(iLinkID);
        }
    }

    @Override
    public boolean Register(Stream rkStream) {
        if (!super.Register(rkStream)) {
            return false;
        }
        for (int i = 0; i < this.m_kChild.size(); ++i) {
            if (this.m_kChild.get(i) == null) continue;
            this.m_kChild.get(i).Register(rkStream);
        }
        return true;
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_kChild.size());
        for (int i = 0; i < this.m_kChild.size(); ++i) {
            rkStream.Write(this.m_kChild.get(i).GetID());
        }
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("Node", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("child quantity =", this.m_kChild.size()));
        for (int i = 0; i < this.m_kChild.size(); ++i) {
            Spatial pkChild = this.m_kChild.get(i);
            if (pkChild != null) {
                pkTree.Append(pkChild.SaveStrings(null));
                continue;
            }
            StringTree pkEmpty = new StringTree();
            pkEmpty.Append(StringTree.Format("unused slot"));
            pkTree.Append(pkEmpty);
        }
        return pkTree;
    }

    public Spatial SetChild(int i, Spatial pkChild) {
        if (pkChild != null) assert (pkChild.GetParent() == null);
        if (0 <= i && i < this.m_kChild.size()) {
            Spatial spkPreviousChild = this.m_kChild.get(i);
            if (spkPreviousChild != null) {
                spkPreviousChild.SetParent(null);
            }
            if (pkChild != null) {
                pkChild.SetParent(this);
            }
            this.m_kChild.set(i, pkChild);
            return spkPreviousChild;
        }
        pkChild.SetParent(this);
        this.m_kChild.add(pkChild);
        return null;
    }

    @Override
    protected void GetVisibleSet(Culler rkCuller, boolean bNoCull) {
        int i;
        for (i = 0; i < this.m_kEffects.size(); ++i) {
            rkCuller.Insert(this, (Effect)this.m_kEffects.get(i));
        }
        for (i = 0; i < this.m_kChild.size(); ++i) {
            Spatial pkChild = this.m_kChild.get(i);
            if (pkChild == null) continue;
            pkChild.OnGetVisibleSet(rkCuller, bNoCull);
        }
        for (i = 0; i < this.m_kEffects.size(); ++i) {
            rkCuller.Insert(null, null);
        }
    }

    @Override
    protected void UpdateState(Vector<Vector<GlobalState>> akGStack, Vector<Light> pkLStack) {
        for (int i = 0; i < this.m_kChild.size(); ++i) {
            Spatial pkChild = this.m_kChild.get(i);
            if (pkChild == null) continue;
            pkChild.UpdateRS(akGStack, pkLStack);
        }
    }

    @Override
    protected void UpdateWorldBound() {
        if (!this.WorldBoundIsCurrent) {
            boolean bFoundFirstBound = false;
            for (int i = 0; i < this.m_kChild.size(); ++i) {
                Spatial pkChild = this.m_kChild.get(i);
                if (pkChild == null) continue;
                if (bFoundFirstBound) {
                    this.WorldBound.GrowToContain(pkChild.WorldBound);
                    continue;
                }
                bFoundFirstBound = true;
                this.WorldBound.CopyFrom(pkChild.WorldBound);
            }
        }
    }

    @Override
    protected void UpdateWorldData(double dAppTime) {
        super.UpdateWorldData(dAppTime);
        for (int i = 0; i < this.m_kChild.size(); ++i) {
            Spatial pkChild = this.m_kChild.get(i);
            if (pkChild == null) continue;
            pkChild.UpdateGS(dAppTime, false);
        }
    }
}

