/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.SceneGraph.Geometry;
import WildMagic.LibGraphics.SceneGraph.IndexBuffer;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import java.io.Serializable;

public class Polyline
extends Geometry
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = -9043076796687490801L;
    protected int m_iActiveQuantity;
    protected boolean m_bClosed;
    protected boolean m_bContiguous;

    public Polyline(VertexBuffer pkVBuffer, boolean bClosed, boolean bContiguous) {
        super(pkVBuffer, null);
        int iVQuantity = this.VBuffer.GetVertexQuantity();
        assert (iVQuantity >= 2);
        this.m_iActiveQuantity = iVQuantity;
        this.m_bClosed = bClosed;
        this.m_bContiguous = bContiguous;
        this.IBuffer = new IndexBuffer(iVQuantity + 1);
        int[] aiIndex = this.IBuffer.GetData();
        for (int i = 0; i < iVQuantity; ++i) {
            aiIndex[i] = i;
        }
        aiIndex[iVQuantity] = 0;
        if (!this.m_bContiguous || !this.m_bClosed) {
            this.IBuffer.SetIndexQuantity(iVQuantity);
        }
        this.SetGeometryType(true);
    }

    public Polyline() {
        this.m_iActiveQuantity = 0;
        this.m_bClosed = false;
        this.m_bContiguous = false;
        this.SetGeometryType(true);
    }

    public void Copy(Polyline kSource) {
        super.Copy(kSource);
        int iVQuantity = this.VBuffer.GetVertexQuantity();
        assert (iVQuantity >= 2);
        this.m_iActiveQuantity = iVQuantity;
        this.m_bClosed = kSource.m_bClosed;
        this.m_bContiguous = kSource.m_bContiguous;
        this.IBuffer = new IndexBuffer(iVQuantity + 1);
        int[] aiIndex = this.IBuffer.GetData();
        for (int i = 0; i < iVQuantity; ++i) {
            aiIndex[i] = i;
        }
        aiIndex[iVQuantity] = 0;
        if (!this.m_bContiguous || !this.m_bClosed) {
            this.IBuffer.SetIndexQuantity(iVQuantity);
        }
        this.SetGeometryType(true);
    }

    public final int GetActiveQuantity() {
        return this.m_iActiveQuantity;
    }

    public final boolean GetClosed() {
        return this.m_bClosed;
    }

    public final boolean GetContiguous() {
        return this.m_bContiguous;
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT + Stream.SIZEOF_BOOLEAN + Stream.SIZEOF_BOOLEAN;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.m_iActiveQuantity = rkStream.ReadInt();
        this.m_bClosed = rkStream.ReadBoolean();
        this.m_bContiguous = rkStream.ReadBoolean();
        this.SetGeometryType(false);
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_iActiveQuantity);
        rkStream.Write(this.m_bClosed);
        rkStream.Write(this.m_bContiguous);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("Polyline", this.GetName()));
        pkTree.Append(StringTree.Format("active quantity =", this.m_iActiveQuantity));
        pkTree.Append(StringTree.Format("closed =", this.m_bClosed));
        pkTree.Append(StringTree.Format("contiguous =", this.m_bContiguous));
        pkTree.Append(super.SaveStrings(acTitle));
        return pkTree;
    }

    public void SetActiveQuantity(int iActiveQuantity) {
        int iVQuantity = this.VBuffer.GetVertexQuantity();
        this.m_iActiveQuantity = 0 <= iActiveQuantity && iActiveQuantity <= iVQuantity ? iActiveQuantity : iVQuantity;
        this.IBuffer.SetIndexQuantity(this.m_iActiveQuantity);
    }

    public void SetClosed(boolean bClosed) {
        this.m_bClosed = bClosed;
        this.SetGeometryType(false);
    }

    public void SetContiguous(boolean bContiguous) {
        this.m_bContiguous = bContiguous;
        this.SetGeometryType(false);
    }

    protected void SetGeometryType(boolean bInit) {
        if (this.m_bContiguous) {
            if (this.m_bClosed) {
                if (this.Type != Geometry.GeometryType.GT_POLYLINE_CLOSED && !bInit) {
                    this.IBuffer.SetIndexQuantity(this.IBuffer.GetIndexQuantity() + 1);
                    this.IBuffer.Release();
                }
                this.Type = Geometry.GeometryType.GT_POLYLINE_CLOSED;
            } else {
                if (this.Type == Geometry.GeometryType.GT_POLYLINE_CLOSED && !bInit) {
                    this.IBuffer.SetIndexQuantity(this.IBuffer.GetIndexQuantity() - 1);
                    this.IBuffer.Release();
                }
                this.Type = Geometry.GeometryType.GT_POLYLINE_OPEN;
            }
        } else {
            if (this.Type == Geometry.GeometryType.GT_POLYLINE_CLOSED && !bInit) {
                this.IBuffer.SetIndexQuantity(this.IBuffer.GetIndexQuantity() - 1);
                this.IBuffer.Release();
            }
            this.Type = Geometry.GeometryType.GT_POLYLINE_SEGMENTS;
        }
    }
}

