/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Shaders;

import WildMagic.LibGraphics.Shaders.Program;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CompiledProgramCatalog {
    private HashMap<String, Program> m_kEntry = new HashMap();
    private static final String ms_kNullString = new String("-1 -1");
    private static CompiledProgramCatalog ms_pkActive;

    public static final CompiledProgramCatalog GetActive() {
        return ms_pkActive;
    }

    public static void SetActive(CompiledProgramCatalog pkActive) {
        ms_pkActive = pkActive;
    }

    public void dispose() {
        this.m_kEntry.clear();
        this.m_kEntry = null;
    }

    public Program Find(int iVertexShaderID, int iPixelShaderID) {
        String kProgramName = new String(iVertexShaderID + " " + iPixelShaderID);
        if (kProgramName == ms_kNullString) {
            return null;
        }
        Program kLocalProgram = this.m_kEntry.get(kProgramName);
        if (kLocalProgram != null) {
            return kLocalProgram;
        }
        return null;
    }

    public boolean Insert(Program pkProgram, int iVertexShaderID, int iPixelShaderID) {
        if (pkProgram == null) {
            assert (false);
            return false;
        }
        String kProgramName = new String(iVertexShaderID + " " + iPixelShaderID);
        Program kLocalProgram = this.m_kEntry.get(kProgramName);
        if (kLocalProgram != null) {
            return true;
        }
        this.m_kEntry.put(kProgramName, pkProgram);
        return true;
    }

    public void PrintEntries() {
        System.err.println("");
        System.err.println("Compiled Program Catalog");
        Iterator<Map.Entry<String, Program>> kEIter = this.m_kEntry.entrySet().iterator();
        Map.Entry<String, Program> kEntry = null;
        while (kEIter.hasNext()) {
            kEntry = kEIter.next();
            System.err.println(kEntry.getKey());
        }
    }
}

