/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Shaders;

import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.Rendering.Renderer;
import WildMagic.LibGraphics.Shaders.Program;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PixelProgramCatalog {
    private String m_kName;
    private String m_kDefaultDir;
    private HashMap<String, Program> m_kEntry = new HashMap();
    private GraphicsObject m_spkDefaultPProgram;
    private char m_cCommentChar;
    private static final String ms_kNullString = new String("");
    private static final String ms_kDefaultString = new String("Default");
    private static PixelProgramCatalog ms_pkActive;

    public PixelProgramCatalog(String rkName, String rkDefaultDir) {
        this.m_kName = new String(rkName);
        this.m_kDefaultDir = new String(rkDefaultDir);
        this.m_cCommentChar = '\u0000';
    }

    public static final PixelProgramCatalog GetActive() {
        return ms_pkActive;
    }

    public static void SetActive(PixelProgramCatalog pkActive) {
        ms_pkActive = pkActive;
    }

    public void dispose() {
        this.m_kName = null;
        this.m_kDefaultDir = null;
        this.m_kEntry.clear();
        this.m_kEntry = null;
        if (this.m_spkDefaultPProgram != null) {
            this.m_spkDefaultPProgram.dispose();
            this.m_spkDefaultPProgram = null;
        }
    }

    public Program Find(Renderer kRenderer, String rkProgramName, String rkDirectory) {
        if (rkProgramName == ms_kNullString || rkProgramName == ms_kDefaultString) {
            return (Program)this.m_spkDefaultPProgram;
        }
        Program kLocalProgram = this.m_kEntry.get(rkProgramName);
        if (kLocalProgram != null) {
            return kLocalProgram;
        }
        assert (this.m_cCommentChar != '\u0000');
        Program pkProgram = kRenderer.ReadProgram(rkProgramName, rkDirectory, Program.PIXEL);
        if (pkProgram != null) {
            return pkProgram;
        }
        return (Program)this.m_spkDefaultPProgram;
    }

    public final String GetDefaultDir() {
        return this.m_kDefaultDir;
    }

    public final String GetName() {
        return this.m_kName;
    }

    public boolean Insert(Program pkProgram) {
        if (pkProgram == null) {
            assert (false);
            return false;
        }
        String kProgramName = new String(pkProgram.GetName());
        if (kProgramName == ms_kNullString || kProgramName == ms_kDefaultString || pkProgram == this.m_spkDefaultPProgram) {
            return false;
        }
        Program kLocalProgram = this.m_kEntry.get(kProgramName);
        if (kLocalProgram != null) {
            return true;
        }
        this.m_kEntry.put(kProgramName, pkProgram);
        return true;
    }

    public void PrintEntries() {
        System.err.println("");
        System.err.println("Pixel Program Catalog");
        Iterator<Map.Entry<String, Program>> kEIter = this.m_kEntry.entrySet().iterator();
        Map.Entry<String, Program> kEntry = null;
        while (kEIter.hasNext()) {
            kEntry = kEIter.next();
            System.err.println(kEntry.getKey());
        }
    }

    public boolean Remove(Program pkProgram) {
        if (pkProgram == null) {
            assert (false);
            return false;
        }
        String kProgramName = new String(pkProgram.GetName());
        if (kProgramName == ms_kNullString || kProgramName == ms_kDefaultString || pkProgram == this.m_spkDefaultPProgram) {
            return false;
        }
        Iterator<String> kIterator = this.m_kEntry.keySet().iterator();
        while (kIterator.hasNext()) {
            Program kLocalProgram;
            String kKey = kIterator.next();
            if (!kKey.equals(kProgramName) || (kLocalProgram = this.m_kEntry.get(kKey)) != pkProgram) continue;
            kIterator.remove();
            return true;
        }
        return false;
    }

    public void SetInformation(Renderer kRenderer, String rkRendererType, char cCommentChar) {
        this.m_cCommentChar = cCommentChar;
        if (this.m_cCommentChar != '\u0000') {
            this.m_spkDefaultPProgram = kRenderer.ReadProgram(ms_kDefaultString, this.m_kDefaultDir, Program.PIXEL);
            assert (this.m_spkDefaultPProgram != null);
        } else {
            this.m_spkDefaultPProgram = null;
        }
    }
}

