/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Shaders;

import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Bindable;
import WildMagic.LibGraphics.SceneGraph.Attributes;
import WildMagic.LibGraphics.Shaders.PixelProgramCatalog;
import WildMagic.LibGraphics.Shaders.RendererConstant;
import WildMagic.LibGraphics.Shaders.SamplerInformation;
import WildMagic.LibGraphics.Shaders.UserConstant;
import WildMagic.LibGraphics.Shaders.VertexProgramCatalog;
import java.io.Serializable;
import java.util.Vector;

public class Program
extends Bindable
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 1989809153635245232L;
    public static int VERTEX = 0;
    public static int PIXEL = 1;
    private String m_kProgramType = new String();
    private String m_kProgramText = new String();
    private boolean m_bCompiled = false;
    private boolean m_bParsed = false;
    private int m_iShaderID;
    private int m_iProgramID = -1;
    private Attributes m_kInputAttributes = new Attributes();
    private Attributes m_kOutputAttributes = new Attributes();
    private Vector<RendererConstant> m_kRendererConstants = new Vector();
    private Vector<UserConstant> m_kUserConstants = new Vector();
    private Vector<SamplerInformation> m_kSamplerInformation = new Vector();
    protected static final String ms_kSampler1DStr = new String("sampler1D");
    protected static final String ms_kSampler2DStr = new String("sampler2D");
    protected static final String ms_kSampler3DStr = new String("sampler3D");
    protected static final String ms_kSamplerCubeStr = new String("samplerCUBE");
    protected static final String ms_kSamplerProjStr = new String("sampler2DSHADOW");
    protected static final String ms_kPositionStr = new String("POSITION");
    protected static final String ms_kNormalStr = new String("NORMAL");
    protected static final String ms_kColorStr = new String("COLOR");
    protected static final String ms_kColor0Str = new String("COLOR0");
    protected static final String ms_kColor1Str = new String("COLOR1");
    protected static final String ms_kTexCoordStr = new String("TEXCOORD");
    protected static final String ms_kInStr = new String("in");
    protected static final String ms_kEOL = new String("\n");
    protected static final String ms_kTexUnitString = new String("texunit");
    protected static final String ms_kUserString = new String("c");

    public void AddRendererConstant(RendererConstant kRC) {
        this.m_kRendererConstants.add(kRC);
    }

    public void AddSamplerInformation(SamplerInformation kSI) {
        this.m_kSamplerInformation.add(kSI);
    }

    public void AddUserConstant(UserConstant kUC) {
        this.m_kUserConstants.add(kUC);
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion);
    }

    public final Attributes GetInputAttributes() {
        return this.m_kInputAttributes;
    }

    public final Attributes GetOutputAttributes() {
        return this.m_kOutputAttributes;
    }

    public int GetProgramID() {
        return this.m_iProgramID;
    }

    public final String GetProgramText() {
        return this.m_kProgramText;
    }

    public final String GetProgramType() {
        return this.m_kProgramType;
    }

    public RendererConstant GetRC(int i) {
        if (0 <= i && i < this.m_kRendererConstants.size()) {
            return this.m_kRendererConstants.get(i);
        }
        assert (false);
        return null;
    }

    public RendererConstant GetRC(RendererConstant.Type eType) {
        for (int i = 0; i < this.m_kRendererConstants.size(); ++i) {
            if (eType != this.m_kRendererConstants.get(i).GetType()) continue;
            return this.m_kRendererConstants.get(i);
        }
        assert (false);
        return null;
    }

    public final int GetRCQuantity() {
        return this.m_kRendererConstants.size();
    }

    public int GetShaderID() {
        return this.m_iShaderID;
    }

    public SamplerInformation GetSI(int i) {
        if (0 <= i && i < this.m_kSamplerInformation.size()) {
            return this.m_kSamplerInformation.get(i);
        }
        assert (false);
        return null;
    }

    public SamplerInformation GetSI(String rkName) {
        for (int i = 0; i < this.m_kSamplerInformation.size(); ++i) {
            if (!rkName.equals(this.m_kSamplerInformation.get(i).GetName())) continue;
            return this.m_kSamplerInformation.get(i);
        }
        assert (false);
        return null;
    }

    public final int GetSIQuantity() {
        return this.m_kSamplerInformation.size();
    }

    public UserConstant GetUC(int i) {
        if (0 <= i && i < this.m_kUserConstants.size()) {
            return this.m_kUserConstants.get(i);
        }
        assert (false);
        return null;
    }

    public UserConstant GetUC(String rkName) {
        for (int i = 0; i < this.m_kUserConstants.size(); ++i) {
            if (!rkName.equals(this.m_kUserConstants.get(i).GetName())) continue;
            return this.m_kUserConstants.get(i);
        }
        assert (false);
        return null;
    }

    public final int GetUCQuantity() {
        return this.m_kUserConstants.size();
    }

    public boolean IsCompiled() {
        return this.m_bCompiled;
    }

    public boolean IsParsed() {
        return this.m_bParsed;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Remove() {
        PixelProgramCatalog.GetActive().Remove(this);
        VertexProgramCatalog.GetActive().Remove(this);
        if (this.m_kInputAttributes != null) {
            this.m_kInputAttributes.dispose();
        }
        if (this.m_kOutputAttributes != null) {
            this.m_kOutputAttributes.dispose();
        }
        this.m_kRendererConstants.clear();
        this.m_kUserConstants.clear();
        this.m_kSamplerInformation.clear();
        super.Remove();
    }

    public void Reset() {
        this.m_kInputAttributes = new Attributes();
        this.m_kInputAttributes = new Attributes();
        this.m_kRendererConstants.clear();
        this.m_kUserConstants.clear();
        this.m_kSamplerInformation.clear();
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("Program", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        return pkTree;
    }

    public void SetCompiled(boolean bFlag) {
        this.m_bCompiled = bFlag;
    }

    public final void SetInputAttributes(Attributes kAttributes) {
        this.m_kInputAttributes = kAttributes;
    }

    public final void SetOutputAttributes(Attributes kAttributes) {
        this.m_kOutputAttributes = kAttributes;
    }

    public void SetParsed() {
        this.m_bParsed = true;
    }

    public void SetProgramID(int iID) {
        this.m_iProgramID = iID;
    }

    public final void SetProgramText(String kText) {
        if (!this.m_kProgramText.equals(kText)) {
            this.m_kProgramText = null;
            this.m_kProgramText = new String(kText);
            this.m_bParsed = false;
            this.m_bCompiled = false;
            this.m_iProgramID = -1;
            this.Reset();
        }
    }

    public final void SetProgramType(String kType) {
        this.m_kProgramType = null;
        this.m_kProgramType = new String(kType);
    }

    public void SetShaderID(int iID) {
        this.m_iShaderID = iID;
    }
}

