/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Shaders;

import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.GraphicsImage;
import WildMagic.LibGraphics.Rendering.Texture;
import WildMagic.LibGraphics.Shaders.ImageCatalog;
import WildMagic.LibGraphics.Shaders.Program;
import WildMagic.LibGraphics.Shaders.SamplerInformation;
import WildMagic.LibGraphics.Shaders.UserConstant;
import java.io.Serializable;
import java.util.Vector;

public abstract class Shader
extends GraphicsObject
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 209584071346253225L;
    protected String m_kShaderName;
    protected boolean m_bUnique = false;
    protected Program m_spkProgram;
    protected Vector<Float> m_kUserData = new Vector();
    protected Vector<String> m_kImageNames = new Vector();
    protected Vector<Texture> m_kTextures = new Vector();

    public Shader() {
    }

    protected Shader(String rkShaderName) {
        this.m_kShaderName = new String(rkShaderName);
    }

    protected Shader(String rkShaderName, boolean bUnique) {
        this.m_kShaderName = new String(rkShaderName);
        this.m_bUnique = bUnique;
    }

    protected Shader(String rkShaderName, String rkProgramText, boolean bUnique) {
        this.m_kShaderName = new String(rkShaderName);
        this.m_spkProgram = new Program();
        this.m_spkProgram.SetName(rkShaderName);
        this.m_spkProgram.SetProgramType("glsl");
        this.m_spkProgram.SetProgramText(rkProgramText);
        this.m_bUnique = bUnique;
    }

    @Override
    public void dispose() {
        this.m_kShaderName = null;
        if (this.m_spkProgram != null) {
            this.m_spkProgram.dispose();
            this.m_spkProgram = null;
        }
        this.m_kUserData.clear();
        this.m_kUserData = null;
        this.m_kImageNames.clear();
        this.m_kImageNames = null;
        this.m_kTextures.clear();
        this.m_kTextures = null;
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        int iSize = super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT + this.m_kShaderName.length();
        int iQuantity = this.m_kImageNames.size();
        iSize += Stream.SIZEOF_INT;
        for (int i = 0; i < iQuantity; ++i) {
            iSize += Stream.SIZEOF_INT + this.m_kImageNames.get(i).length();
        }
        iQuantity = this.m_kTextures.size();
        return iSize += Stream.SIZEOF_INT + iQuantity * Stream.SIZEOF_INT;
    }

    public SamplerInformation GetGetSamplerInformation(int i) {
        int iSIQuantity = this.m_spkProgram.GetSIQuantity();
        if (0 <= i && i < iSIQuantity) {
            return this.m_spkProgram.GetSI(i);
        }
        return null;
    }

    public String GetImageName(int i) {
        assert (0 <= i && i < this.m_kImageNames.size());
        return this.m_kImageNames.get(i);
    }

    public final String GetShaderName() {
        return this.m_kShaderName;
    }

    public Texture GetTexture(int i) {
        if (0 <= i && i < this.m_kTextures.size()) {
            return this.m_kTextures.get(i);
        }
        return null;
    }

    public int GetTextureQuantity() {
        return this.m_kTextures.size();
    }

    public final boolean GetUnique() {
        return this.m_bUnique;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
        for (int i = 0; i < this.m_kTextures.size(); ++i) {
            int iLinkID = pkLink.GetLinkID();
            this.m_kTextures.set(i, (Texture)rkStream.GetFromMap(iLinkID));
        }
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        int i;
        super.Load(rkStream, pkLink);
        this.m_kShaderName = rkStream.ReadString();
        int iQuantity = rkStream.ReadInt();
        this.m_kImageNames.setSize(iQuantity);
        for (i = 0; i < iQuantity; ++i) {
            this.m_kImageNames.set(i, rkStream.ReadString());
        }
        iQuantity = rkStream.ReadInt();
        this.m_kTextures.setSize(iQuantity);
        for (i = 0; i < iQuantity; ++i) {
            int iLinkID = rkStream.ReadInt();
            pkLink.Add(iLinkID);
        }
    }

    public void OnLoadProgram(Program pkProgram) {
        UserConstant pkUC;
        int i;
        assert (this.m_spkProgram == null && pkProgram != null);
        this.m_spkProgram = pkProgram;
        int iUCQuantity = this.m_spkProgram.GetUCQuantity();
        int iChannels = 0;
        for (i = 0; i < iUCQuantity; ++i) {
            pkUC = this.m_spkProgram.GetUC(i);
            assert (pkUC != null);
            iChannels += 4 * pkUC.GetRegisterQuantity();
        }
        this.m_kUserData.setSize(iChannels);
        iChannels = 0;
        for (i = 0; i < iUCQuantity; ++i) {
            pkUC = this.m_spkProgram.GetUC(i);
            assert (pkUC != null);
            int iSize = 4 * pkUC.GetRegisterQuantity();
            float[] afData = new float[iSize];
            pkUC.SetDataSource(afData);
            iChannels += 4 * pkUC.GetRegisterQuantity();
        }
        int iSIQuantity = this.m_spkProgram.GetSIQuantity();
        this.m_kImageNames.setSize(iSIQuantity);
        this.m_kTextures.setSize(iSIQuantity);
        for (i = 0; i < iSIQuantity; ++i) {
            GraphicsImage pkImage = ImageCatalog.GetActive().Find(this.m_kImageNames.get(i));
            assert (pkImage != null);
            if (this.m_kTextures.get(i) == null) {
                this.m_kTextures.set(i, new Texture());
            }
            this.m_kTextures.get(i).SetImage(pkImage);
        }
    }

    public void OnReleaseProgram() {
        if (this.m_spkProgram != null) {
            this.m_spkProgram.Remove();
            this.m_spkProgram.dispose();
            this.m_spkProgram = null;
        }
    }

    @Override
    public boolean Register(Stream rkStream) {
        if (!super.Register(rkStream)) {
            return false;
        }
        for (int i = 0; i < this.m_kTextures.size(); ++i) {
            if (this.m_kTextures.get(i) == null) continue;
            this.m_kTextures.get(i).Register(rkStream);
        }
        return true;
    }

    @Override
    public void Save(Stream rkStream) {
        int i;
        super.Save(rkStream);
        rkStream.Write(this.m_kShaderName);
        int iQuantity = this.m_kImageNames.size();
        rkStream.Write(iQuantity);
        for (i = 0; i < iQuantity; ++i) {
            rkStream.Write(this.m_kImageNames.get(i));
        }
        iQuantity = this.m_kTextures.size();
        rkStream.Write(iQuantity);
        for (i = 0; i < iQuantity; ++i) {
            rkStream.Write(this.m_kTextures.get(i).GetID());
        }
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        int i;
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("Shader", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("shader name =", this.m_kShaderName));
        for (i = 0; i < this.m_kImageNames.size(); ++i) {
            String kPrefix = new String("image[" + i + "] =");
            pkTree.Append(StringTree.Format(kPrefix, this.m_kImageNames.get(i)));
        }
        for (i = 0; i < this.m_kTextures.size(); ++i) {
            pkTree.Append(this.m_kTextures.get(i).SaveStrings(null));
        }
        return pkTree;
    }

    public void SetImageName(int i, String rkName) {
        int iQuantity = this.m_kImageNames.size();
        if (i >= iQuantity) {
            this.m_kImageNames.setSize(i + 1);
        }
        this.m_kImageNames.set(i, rkName);
    }

    public void SetTexture(int i, Texture kTexture) {
        if (0 <= i && i < this.m_kTextures.size()) {
            this.m_kTextures.set(i, kTexture);
            this.m_kImageNames.set(i, kTexture.GetName());
        }
    }

    public void SetTextureQuantity(int iQuantity) {
        this.m_kTextures.clear();
        this.m_kTextures.setSize(iQuantity);
        for (int i = 0; i < iQuantity; ++i) {
            this.m_kTextures.set(i, new Texture());
        }
        this.m_kImageNames.clear();
        this.m_kImageNames.setSize(iQuantity);
    }
}

