/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Sorting;

import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.Effects.Effect;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Camera;
import WildMagic.LibGraphics.SceneGraph.Culler;
import WildMagic.LibGraphics.SceneGraph.Node;
import WildMagic.LibGraphics.SceneGraph.Spatial;
import java.io.Serializable;

public class BspNode
extends Node
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 5607034369137944946L;
    protected Plane3f m_kModelPlane;
    protected Plane3f m_kWorldPlane;

    public BspNode() {
        this.m_kModelPlane = new Plane3f(Vector3f.ZERO, 0.0f);
        this.m_kChild.add(null);
        this.m_kChild.add(null);
        this.m_kChild.add(null);
    }

    public BspNode(Plane3f rkModelPlane) {
        this.m_kModelPlane = new Plane3f(rkModelPlane);
        this.m_kChild.add(null);
        this.m_kChild.add(null);
        this.m_kChild.add(null);
    }

    public Spatial AttachCoplanarChild(Spatial pkChild) {
        return this.SetChild(1, pkChild);
    }

    public Spatial AttachNegativeChild(Spatial pkChild) {
        return this.SetChild(2, pkChild);
    }

    public Spatial AttachPositiveChild(Spatial pkChild) {
        return this.SetChild(0, pkChild);
    }

    public Spatial DetachCoplanarChild() {
        return this.DetachChildAt(1);
    }

    public Spatial DetachNegativeChild() {
        return this.DetachChildAt(2);
    }

    public Spatial DetachPositiveChild() {
        return this.DetachChildAt(0);
    }

    @Override
    public void dispose() {
        if (this.m_kModelPlane != null) {
            this.m_kModelPlane.dispose();
            this.m_kModelPlane = null;
        }
        if (this.m_kWorldPlane != null) {
            this.m_kWorldPlane.dispose();
            this.m_kWorldPlane = null;
        }
        super.dispose();
    }

    public Spatial GetContainingNode(Vector3f rkPoint) {
        Spatial spkPChild = this.GetPositiveChild();
        Spatial spkNChild = this.GetNegativeChild();
        if (spkPChild != null || spkNChild != null) {
            if (this.m_kWorldPlane.WhichSide(rkPoint) < 0) {
                BspNode pkBspChild = (BspNode)spkNChild;
                if (pkBspChild != null) {
                    return pkBspChild.GetContainingNode(rkPoint);
                }
                return spkNChild;
            }
            BspNode pkBspChild = (BspNode)spkPChild;
            if (pkBspChild != null) {
                return pkBspChild.GetContainingNode(rkPoint);
            }
            return spkPChild;
        }
        return this;
    }

    public Spatial GetCoplanarChild() {
        return this.GetChild(1);
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + 3 * Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT;
    }

    public Plane3f GetModelPlane() {
        return this.m_kModelPlane;
    }

    public Spatial GetNegativeChild() {
        return this.GetChild(2);
    }

    public Spatial GetPositiveChild() {
        return this.GetChild(0);
    }

    public Plane3f GetWorldPlane() {
        return this.m_kWorldPlane;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        rkStream.Read(this.m_kModelPlane);
    }

    public Plane3f ModelPlane() {
        return this.m_kModelPlane;
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_kModelPlane);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("BspNode", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("model plane =", this.m_kModelPlane));
        return pkTree;
    }

    @Override
    protected void GetVisibleSet(Culler rkCuller, boolean bNoCull) {
        int i;
        for (i = 0; i < this.m_kEffects.size(); ++i) {
            rkCuller.Insert(this, (Effect)this.m_kEffects.get(i));
        }
        Spatial spkPChild = this.GetPositiveChild();
        Spatial spkCChild = this.GetCoplanarChild();
        Spatial spkNChild = this.GetNegativeChild();
        Camera pkCamera = rkCuller.GetCamera();
        int iLocSide = this.m_kWorldPlane.WhichSide(pkCamera.GetLocation());
        int iFruSide = rkCuller.WhichSide(this.m_kWorldPlane);
        if (iLocSide > 0) {
            if (iFruSide <= 0 && spkNChild != null) {
                spkNChild.OnGetVisibleSet(rkCuller, bNoCull);
            }
            if (iFruSide == 0 && spkCChild != null) {
                spkCChild.OnGetVisibleSet(rkCuller, bNoCull);
            }
            if (iFruSide >= 0 && spkPChild != null) {
                spkPChild.OnGetVisibleSet(rkCuller, bNoCull);
            }
        } else if (iLocSide < 0) {
            if (iFruSide >= 0 && spkPChild != null) {
                spkPChild.OnGetVisibleSet(rkCuller, bNoCull);
            }
            if (iFruSide == 0 && spkCChild != null) {
                spkCChild.OnGetVisibleSet(rkCuller, bNoCull);
            }
            if (iFruSide <= 0 && spkNChild != null) {
                spkNChild.OnGetVisibleSet(rkCuller, bNoCull);
            }
        } else {
            float fNdD = this.m_kWorldPlane.Normal.Dot(pkCamera.GetDVector());
            if (fNdD >= 0.0f) {
                if (spkPChild != null) {
                    spkPChild.OnGetVisibleSet(rkCuller, bNoCull);
                }
                if (spkCChild != null) {
                    spkCChild.OnGetVisibleSet(rkCuller, bNoCull);
                }
                if (spkNChild != null) {
                    spkNChild.OnGetVisibleSet(rkCuller, bNoCull);
                }
            } else {
                if (spkNChild != null) {
                    spkNChild.OnGetVisibleSet(rkCuller, bNoCull);
                }
                if (spkCChild != null) {
                    spkCChild.OnGetVisibleSet(rkCuller, bNoCull);
                }
                if (spkPChild != null) {
                    spkPChild.OnGetVisibleSet(rkCuller, bNoCull);
                }
            }
        }
        for (i = 0; i < this.m_kEffects.size(); ++i) {
            rkCuller.Insert(null, null);
        }
    }

    @Override
    protected void UpdateWorldData(double dAppTime) {
        super.UpdateWorldData(dAppTime);
        this.m_kWorldPlane = this.World.ApplyForward(this.m_kModelPlane);
    }
}

