/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Surfaces;

import WildMagic.LibFoundation.Curves.Curve3f;
import WildMagic.LibFoundation.Mathematics.Vector2f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.SceneGraph.Attributes;
import WildMagic.LibGraphics.SceneGraph.IndexBuffer;
import WildMagic.LibGraphics.SceneGraph.TriMesh;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import java.io.Serializable;

public class TubeSurface
extends TriMesh
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = -8071335593382396531L;
    Curve3f m_pkMedial;
    float m_oRadial;
    int m_iMedialSamples;
    int m_iSliceSamples;
    Vector3f m_kUpVector;
    float[] m_afSin;
    float[] m_afCos;
    boolean m_bClosed;
    boolean m_bSampleByArcLength;

    public TubeSurface() {
        this.m_pkMedial = null;
        this.m_oRadial = 0.0f;
        this.m_afSin = null;
        this.m_afCos = null;
    }

    public TubeSurface(Curve3f pkMedial, float oRadial, boolean bClosed, Vector3f rkUpVector, int iMedialSamples, int iSliceSamples, Attributes rkAttr, boolean bSampleByArcLength, boolean bInsideView, Vector2f pkUVMin, Vector2f pkUVMax) {
        this.m_pkMedial = pkMedial;
        this.m_oRadial = oRadial;
        this.m_kUpVector = rkUpVector;
        this.m_iMedialSamples = iMedialSamples;
        this.m_iSliceSamples = iSliceSamples;
        this.m_bClosed = bClosed;
        this.m_bSampleByArcLength = bSampleByArcLength;
        int iVQuantity = this.m_bClosed ? (this.m_iSliceSamples + 1) * (this.m_iMedialSamples + 1) : (this.m_iSliceSamples + 1) * this.m_iMedialSamples;
        this.VBuffer = new VertexBuffer(rkAttr, iVQuantity);
        this.ComputeSinCos();
        this.ComputeVertices();
        if (rkAttr.HasNormal()) {
            this.ComputeNormals();
        }
        if (pkUVMin != null && pkUVMax != null) {
            assert (rkAttr.GetMaxTCoords() > 0);
            this.ComputeUVs(pkUVMin, pkUVMax);
        }
        this.ComputeIndices(bInsideView);
        this.UpdateModelBound();
    }

    Curve3f GetMedial() {
        return this.m_pkMedial;
    }

    float GetRadial() {
        return this.m_oRadial;
    }

    int GetSliceSamples() {
        return this.m_iSliceSamples;
    }

    Vector3f GetUpVector() {
        return this.m_kUpVector;
    }

    int Index(int iS, int iM) {
        return iS + (this.m_iSliceSamples + 1) * iM;
    }

    Curve3f setMedial(Curve3f medial) {
        this.m_pkMedial = medial;
        return this.m_pkMedial;
    }

    float setRadial(float radial) {
        this.m_oRadial = radial;
        return this.m_oRadial;
    }

    Vector3f UpVector() {
        return this.m_kUpVector;
    }

    public void GetTMaxSlice(Vector3f[] akSlice) {
        int j = this.VBuffer.GetVertexQuantity() - this.m_iSliceSamples - 1;
        int i = 0;
        while (i <= this.m_iSliceSamples) {
            akSlice[i] = this.VBuffer.GetPosition3(j);
            ++i;
            ++j;
        }
    }

    public void GetTMinSlice(Vector3f[] akSlice) {
        for (int i = 0; i <= this.m_iSliceSamples; ++i) {
            akSlice[i] = this.VBuffer.GetPosition3(i);
        }
    }

    public void UpdateSurface() {
        this.ComputeVertices();
        this.UpdateModelBound();
        if (this.VBuffer.GetAttributes().HasNormal()) {
            this.ComputeNormals();
        }
    }

    private void ComputeIndices(boolean bInsideView) {
        int i;
        int i3;
        int i2;
        int i1;
        int i0;
        int iTQuantity = this.m_bClosed ? 2 * this.m_iSliceSamples * this.m_iMedialSamples : 2 * this.m_iSliceSamples * (this.m_iMedialSamples - 1);
        this.IBuffer = new IndexBuffer(3 * iTQuantity);
        int[] aiLocalIndex = this.IBuffer.GetData();
        int iIndex = 0;
        int iMStart = 0;
        for (int iM = 0; iM < this.m_iMedialSamples - 1; ++iM) {
            i0 = iMStart;
            i1 = i0 + 1;
            i2 = iMStart += this.m_iSliceSamples + 1;
            i3 = i2 + 1;
            for (i = 0; i < this.m_iSliceSamples; ++i) {
                if (bInsideView) {
                    aiLocalIndex[iIndex++] = i0++;
                    aiLocalIndex[iIndex++] = i2;
                    aiLocalIndex[iIndex++] = i1;
                    aiLocalIndex[iIndex++] = i1++;
                    aiLocalIndex[iIndex++] = i2++;
                    aiLocalIndex[iIndex++] = i3++;
                    continue;
                }
                aiLocalIndex[iIndex++] = i0++;
                aiLocalIndex[iIndex++] = i1;
                aiLocalIndex[iIndex++] = i2;
                aiLocalIndex[iIndex++] = i1++;
                aiLocalIndex[iIndex++] = i3++;
                aiLocalIndex[iIndex++] = i2++;
            }
        }
        if (this.m_bClosed) {
            i0 = iMStart;
            i1 = i0 + 1;
            i2 = 0;
            i3 = i2 + 1;
            for (i = 0; i < this.m_iSliceSamples; ++i) {
                if (bInsideView) {
                    aiLocalIndex[iIndex++] = i0++;
                    aiLocalIndex[iIndex++] = i2;
                    aiLocalIndex[iIndex++] = i1;
                    aiLocalIndex[iIndex++] = i1++;
                    aiLocalIndex[iIndex++] = i2++;
                    aiLocalIndex[iIndex++] = i3++;
                    continue;
                }
                aiLocalIndex[iIndex++] = i0++;
                aiLocalIndex[iIndex++] = i1;
                aiLocalIndex[iIndex++] = i2;
                aiLocalIndex[iIndex++] = i1++;
                aiLocalIndex[iIndex++] = i3++;
                aiLocalIndex[iIndex++] = i2++;
            }
        }
    }

    private void ComputeNormals() {
        Vector3f kNormal;
        Vector3f kResult;
        int iSp;
        int iSm;
        int iS;
        Vector3f kDir0 = new Vector3f();
        Vector3f kDir1 = new Vector3f();
        for (int iM = 1; iM <= this.m_iMedialSamples - 2; ++iM) {
            for (iS = 0; iS < this.m_iSliceSamples; ++iS) {
                iSm = iS > 0 ? iS - 1 : this.m_iSliceSamples - 1;
                iSp = iS + 1;
                int iMm = iM - 1;
                int iMp = iM + 1;
                kDir0.Sub(this.VBuffer.GetPosition3(this.Index(iSm, iM)), this.VBuffer.GetPosition3(this.Index(iSp, iM)));
                kDir1.Sub(this.VBuffer.GetPosition3(this.Index(iS, iMm)), this.VBuffer.GetPosition3(this.Index(iS, iMp)));
                kResult = new Vector3f();
                kResult.UnitCross(kDir0, kDir1);
                this.VBuffer.SetNormal3(this.Index(iS, iM), kResult);
            }
            kNormal = new Vector3f();
            this.VBuffer.GetNormal3(this.Index(0, iM), kNormal);
            this.VBuffer.SetNormal3(this.Index(this.m_iSliceSamples, iM), kNormal);
        }
        if (this.m_bClosed) {
            for (iS = 0; iS < this.m_iSliceSamples; ++iS) {
                iSm = iS > 0 ? iS - 1 : this.m_iSliceSamples - 1;
                iSp = iS + 1;
                kDir0.Sub(this.VBuffer.GetPosition3(this.Index(iSm, 0)), this.VBuffer.GetPosition3(this.Index(iSp, 0)));
                kDir1.Sub(this.VBuffer.GetPosition3(this.Index(iS, this.m_iMedialSamples - 1)), this.VBuffer.GetPosition3(this.Index(iS, 1)));
                kResult = new Vector3f();
                kResult.UnitCross(kDir0, kDir1);
                this.VBuffer.SetNormal3(iS, kResult);
                kNormal = new Vector3f();
                this.VBuffer.GetNormal3(this.Index(iS, 0), kNormal);
                this.VBuffer.SetNormal3(this.Index(iS, this.m_iMedialSamples), kNormal);
            }
            kNormal = new Vector3f();
            this.VBuffer.GetNormal3(this.Index(0, 0), kNormal);
            this.VBuffer.SetNormal3(this.Index(this.m_iSliceSamples, 0), kNormal);
            kNormal = new Vector3f();
            this.VBuffer.GetNormal3(this.Index(0, this.m_iMedialSamples), kNormal);
            this.VBuffer.SetNormal3(this.Index(this.m_iSliceSamples, this.m_iMedialSamples), kNormal);
        } else {
            for (iS = 0; iS < this.m_iSliceSamples; ++iS) {
                iSm = iS > 0 ? iS - 1 : this.m_iSliceSamples - 1;
                iSp = iS + 1;
                kDir0.Sub(this.VBuffer.GetPosition3(this.Index(iSm, 0)), this.VBuffer.GetPosition3(this.Index(iSp, 0)));
                kDir1.Sub(this.VBuffer.GetPosition3(this.Index(iS, 0)), this.VBuffer.GetPosition3(this.Index(iS, 1)));
                kResult = new Vector3f();
                kResult.UnitCross(kDir0, kDir1);
                this.VBuffer.SetNormal3(this.Index(iS, 0), kResult);
            }
            kNormal = new Vector3f();
            this.VBuffer.GetNormal3(this.Index(0, 0), kNormal);
            this.VBuffer.SetNormal3(this.Index(this.m_iSliceSamples, 0), kNormal);
            for (iS = 0; iS < this.m_iSliceSamples; ++iS) {
                iSm = iS > 0 ? iS - 1 : this.m_iSliceSamples - 1;
                iSp = iS + 1;
                kDir0.Sub(this.VBuffer.GetPosition3(this.Index(iSm, this.m_iMedialSamples - 1)), this.VBuffer.GetPosition3(this.Index(iSp, this.m_iMedialSamples - 1)));
                kDir1.Sub(this.VBuffer.GetPosition3(this.Index(iS, this.m_iMedialSamples - 2)), this.VBuffer.GetPosition3(this.Index(iS, this.m_iMedialSamples - 1)));
                kResult = new Vector3f();
                kResult.UnitCross(kDir0, kDir1);
                this.VBuffer.SetNormal3(iS, kResult);
            }
            kNormal = new Vector3f();
            this.VBuffer.GetNormal3(this.Index(0, this.m_iMedialSamples - 1), kNormal);
            this.VBuffer.SetNormal3(this.Index(this.m_iSliceSamples, this.m_iMedialSamples - 1), kNormal);
        }
    }

    private void ComputeSinCos() {
        this.m_afSin = new float[this.m_iSliceSamples + 1];
        this.m_afCos = new float[this.m_iSliceSamples + 1];
        float fInvSliceSamples = 1.0f / (float)this.m_iSliceSamples;
        for (int i = 0; i < this.m_iSliceSamples; ++i) {
            float fAngle = (float)Math.PI * 2 * fInvSliceSamples * (float)i;
            this.m_afCos[i] = (float)Math.cos(fAngle);
            this.m_afSin[i] = (float)Math.sin(fAngle);
        }
        this.m_afSin[this.m_iSliceSamples] = this.m_afSin[0];
        this.m_afCos[this.m_iSliceSamples] = this.m_afCos[0];
    }

    private void ComputeUVs(Vector2f rkUVMin, Vector2f rkUVMax) {
        Attributes rkAttr = this.VBuffer.GetAttributes();
        Vector2f kUVRange = new Vector2f();
        kUVRange.Sub(rkUVMax, rkUVMin);
        int iMMax = this.m_bClosed ? this.m_iMedialSamples : this.m_iMedialSamples - 1;
        int iV = 0;
        for (int iM = 0; iM <= iMMax; ++iM) {
            float fMRatio = (float)iM / (float)iMMax;
            float fMValue = rkUVMin.Y + fMRatio * kUVRange.Y;
            for (int iS = 0; iS <= this.m_iSliceSamples; ++iS) {
                float fSRatio = (float)iS / (float)this.m_iSliceSamples;
                float fSValue = rkUVMin.X + fSRatio * kUVRange.X;
                Vector2f kTCoord = new Vector2f(fSValue, fMValue);
                for (int iUnit = 0; iUnit < rkAttr.GetMaxTCoords(); ++iUnit) {
                    if (!rkAttr.HasTCoord(iUnit)) continue;
                    this.VBuffer.SetTCoord2(iUnit, iV, kTCoord);
                }
                ++iV;
            }
        }
    }

    private void ComputeVertices() {
        float fTMin = this.m_pkMedial.GetMinTime();
        float fTRange = this.m_pkMedial.GetMaxTime() - fTMin;
        Vector3f kResult = new Vector3f();
        float fTotalLength = this.m_bSampleByArcLength ? this.m_pkMedial.GetTotalLength() : 0.0f;
        float fDenom = this.m_bClosed ? 1.0f / (float)this.m_iMedialSamples : 1.0f / (float)(this.m_iMedialSamples - 1);
        int iV = 0;
        for (int iM = 0; iM < this.m_iMedialSamples; ++iM) {
            float fT = this.m_bSampleByArcLength ? this.m_pkMedial.GetTime((float)iM * fTotalLength * fDenom) : fTMin + (float)iM * fTRange * fDenom;
            float fRadius = 0.003f;
            Vector3f kP = new Vector3f();
            Vector3f kT = new Vector3f();
            Vector3f kN = new Vector3f();
            Vector3f kB = new Vector3f();
            if (this.m_kUpVector != Vector3f.ZERO) {
                kP = this.m_pkMedial.GetPosition(fT);
                kT = this.m_pkMedial.GetTangent(fT);
                kB.UnitCross(kT, this.m_kUpVector);
                kN.UnitCross(kB, kT);
            } else {
                this.m_pkMedial.GetFrame(fT, kP, kT, kN, kB);
            }
            int iSave = iV;
            Vector3f kNScale = new Vector3f();
            Vector3f kBScale = new Vector3f();
            for (int i = 0; i < this.m_iSliceSamples; ++i) {
                kNScale.Scale(this.m_afCos[i], kN);
                kBScale.Scale(this.m_afSin[i], kB);
                kResult.Add(kNScale, kBScale);
                kResult.Scale(fRadius);
                kResult.Add(kP);
                this.VBuffer.SetPosition3(iV, kResult);
                ++iV;
            }
            this.VBuffer.SetPosition3(iV, this.VBuffer.GetPosition3(iSave));
            ++iV;
        }
        if (this.m_bClosed) {
            for (int i = 0; i <= this.m_iSliceSamples; ++i) {
                int i1 = this.Index(i, this.m_iMedialSamples);
                int i0 = this.Index(i, 0);
                this.VBuffer.SetPosition3(i1, this.VBuffer.GetPosition3(i0));
            }
        }
    }
}

