/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibImagics.Extraction;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibFoundation.Meshes.TriangleKey;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class ExtractSurfaceCubes
implements Serializable {
    private static final long serialVersionUID = 6355647321256224321L;
    protected static final int EI_XMIN_YMIN = 0;
    protected static final int EI_XMIN_YMAX = 1;
    protected static final int EI_XMAX_YMIN = 2;
    protected static final int EI_XMAX_YMAX = 3;
    protected static final int EI_XMIN_ZMIN = 4;
    protected static final int EI_XMIN_ZMAX = 5;
    protected static final int EI_XMAX_ZMIN = 6;
    protected static final int EI_XMAX_ZMAX = 7;
    protected static final int EI_YMIN_ZMIN = 8;
    protected static final int EI_YMIN_ZMAX = 9;
    protected static final int EI_YMAX_ZMIN = 10;
    protected static final int EI_YMAX_ZMAX = 11;
    protected static final int FI_XMIN = 12;
    protected static final int FI_XMAX = 13;
    protected static final int FI_YMIN = 14;
    protected static final int FI_YMAX = 15;
    protected static final int FI_ZMIN = 16;
    protected static final int FI_ZMAX = 17;
    protected static final int EB_XMIN_YMIN = 1;
    protected static final int EB_XMIN_YMAX = 2;
    protected static final int EB_XMAX_YMIN = 4;
    protected static final int EB_XMAX_YMAX = 8;
    protected static final int EB_XMIN_ZMIN = 16;
    protected static final int EB_XMIN_ZMAX = 32;
    protected static final int EB_XMAX_ZMIN = 64;
    protected static final int EB_XMAX_ZMAX = 128;
    protected static final int EB_YMIN_ZMIN = 256;
    protected static final int EB_YMIN_ZMAX = 512;
    protected static final int EB_YMAX_ZMIN = 1024;
    protected static final int EB_YMAX_ZMAX = 2048;
    protected int[] m_aiData;
    protected float m_fXDelta;
    protected float m_fYDelta;
    protected float m_fZDelta;
    protected int m_iXBound;
    protected int m_iYBound;
    protected int m_iZBound;
    protected int m_iXYBound;
    protected Vector3f m_kCentroid = new Vector3f();
    protected Vector3f m_kE0 = new Vector3f();
    protected Vector3f m_kE1 = new Vector3f();
    protected Vector3f m_kGradient = new Vector3f(0.0f, 0.0f, 0.0f);
    protected Vector3f m_kN = new Vector3f();

    protected static int addVertex(Vector3f kV, HashMap<Vector3f, Integer> kVMap) {
        if (kVMap.containsKey(kV)) {
            Integer kInt = kVMap.get(kV);
            return kInt;
        }
        int iIndex = kVMap.size();
        kVMap.put(new Vector3f(kV), new Integer(iIndex));
        return iIndex;
    }

    public ExtractSurfaceCubes(int iXBound, int iYBound, int iZBound, int[] aiData) {
        this.m_iXBound = iXBound;
        this.m_iYBound = iYBound;
        this.m_iZBound = iZBound;
        this.m_iXYBound = iXBound * iYBound;
        this.m_aiData = aiData;
    }

    public void ExtractContour(float level, Vector<int[]> kTriTable, Vector<Vector3f> vertices, Vector<TriangleKey> triangles) {
        vertices.clear();
        triangles.clear();
        int iSize = kTriTable.size();
        for (int i = 0; i < iSize; ++i) {
            VETable table;
            int type;
            int[] iCube = kTriTable.get(i);
            int x = iCube[0];
            int y = iCube[1];
            int z = iCube[2];
            if (x >= this.m_iXBound - 1 || y >= this.m_iYBound - 1 || z >= this.m_iZBound - 1 || (type = this.GetVertices(level, x, y, z, table = new VETable())) == 0) continue;
            this.GetXMinEdges(x, y, z, type, table);
            this.GetXMaxEdges(x, y, z, type, table);
            this.GetYMinEdges(x, y, z, type, table);
            this.GetYMaxEdges(x, y, z, type, table);
            this.GetZMinEdges(x, y, z, type, table);
            this.GetZMaxEdges(x, y, z, type, table);
            table.removeTriangles(vertices, triangles);
        }
    }

    public void ExtractContour(float level, Vector<Vector3f> vertices, Vector<TriangleKey> triangles) {
        vertices.clear();
        triangles.clear();
        for (int z = 0; z < this.m_iZBound - 1; ++z) {
            for (int y = 0; y < this.m_iYBound - 1; ++y) {
                for (int x = 0; x < this.m_iXBound - 1; ++x) {
                    VETable table = new VETable();
                    int type = this.GetVertices(level, x, y, z, table);
                    if (type == 0) continue;
                    this.GetXMinEdges(x, y, z, type, table);
                    this.GetXMaxEdges(x, y, z, type, table);
                    this.GetYMinEdges(x, y, z, type, table);
                    this.GetYMaxEdges(x, y, z, type, table);
                    this.GetZMinEdges(x, y, z, type, table);
                    this.GetZMaxEdges(x, y, z, type, table);
                    table.removeTriangles(vertices, triangles);
                }
            }
        }
    }

    public Vector3f getGradient(Vector3f kP) {
        int iX = (int)kP.X;
        if (iX < 0 || iX >= this.m_iXBound - 1) {
            this.m_kGradient.X = 0.0f;
            this.m_kGradient.Y = 0.0f;
            this.m_kGradient.Z = 0.0f;
            return this.m_kGradient;
        }
        int iY = (int)kP.Y;
        if (iY < 0 || iY >= this.m_iYBound - 1) {
            this.m_kGradient.X = 0.0f;
            this.m_kGradient.Y = 0.0f;
            this.m_kGradient.Z = 0.0f;
            return this.m_kGradient;
        }
        int iZ = (int)kP.Z;
        if (iZ < 0 || iZ >= this.m_iZBound - 1) {
            this.m_kGradient.X = 0.0f;
            this.m_kGradient.Y = 0.0f;
            this.m_kGradient.Z = 0.0f;
            return this.m_kGradient;
        }
        int i000 = iX + this.m_iXBound * (iY + this.m_iYBound * iZ);
        int i100 = i000 + 1;
        int i010 = i000 + this.m_iXBound;
        int i110 = i010 + 1;
        int i001 = i000 + this.m_iXYBound;
        int i101 = i001 + 1;
        int i011 = i001 + this.m_iXBound;
        int i111 = i011 + 1;
        float fF000 = this.m_aiData[i000];
        float fF100 = this.m_aiData[i100];
        float fF010 = this.m_aiData[i010];
        float fF110 = this.m_aiData[i110];
        float fF001 = this.m_aiData[i001];
        float fF101 = this.m_aiData[i101];
        float fF011 = this.m_aiData[i011];
        float fF111 = this.m_aiData[i111];
        float fDX = kP.X - (float)iX;
        float fDY = kP.Y - (float)iY;
        float fDZ = kP.Z - (float)iZ;
        float fOmX = 1.0f - fDX;
        float fOmY = 1.0f - fDY;
        float fOmZ = 1.0f - fDZ;
        float fTmp0 = fOmY * (fF100 - fF000) + fDY * (fF110 - fF010);
        float fTmp1 = fOmY * (fF101 - fF001) + fDY * (fF111 - fF011);
        this.m_kGradient.X = fOmZ * fTmp0 + fDZ * fTmp1;
        fTmp0 = fOmX * (fF010 - fF000) + fDX * (fF110 - fF100);
        fTmp1 = fOmX * (fF011 - fF001) + fDX * (fF111 - fF101);
        this.m_kGradient.Y = fOmZ * fTmp0 + fDZ * fTmp1;
        fTmp0 = fOmX * (fF001 - fF000) + fDX * (fF101 - fF100);
        fTmp1 = fOmX * (fF011 - fF010) + fDX * (fF111 - fF110);
        this.m_kGradient.Z = fOmY * fTmp0 + fDY * fTmp1;
        return this.m_kGradient;
    }

    public void MakeUnique(Vector<Vector3f> vertices, Vector<TriangleKey> triangles, Vector<Vector3f> newVertices, Vector<TriangleKey> newTriangles) {
        int numVertices = vertices.size();
        int numTriangles = triangles.size();
        if (numVertices == 0 || numTriangles == 0) {
            return;
        }
        HashMap<Vector3f, Integer> vertexMap = new HashMap<Vector3f, Integer>();
        int nextVertex = 0;
        for (int v = 0; v < numVertices; ++v) {
            if (vertexMap.containsKey(vertices.elementAt(v))) continue;
            vertexMap.put(vertices.elementAt(v), nextVertex);
            newVertices.add(new Vector3f(vertices.elementAt(v)));
            ++nextVertex;
        }
        System.err.println(numVertices + " ==> " + nextVertex);
        HashMap<TriangleKey, Integer> triangleMap = new HashMap<TriangleKey, Integer>();
        int nextTriangle = 0;
        for (int t = 0; t < numTriangles; ++t) {
            TriangleKey tri = triangles.elementAt(t);
            TriangleKey newTri = new TriangleKey();
            newTri.V[0] = (Integer)vertexMap.get(vertices.elementAt(tri.V[0]));
            newTri.V[1] = (Integer)vertexMap.get(vertices.elementAt(tri.V[1]));
            newTri.V[2] = (Integer)vertexMap.get(vertices.elementAt(tri.V[2]));
            if (triangleMap.containsKey(newTri)) continue;
            triangleMap.put(newTri, nextTriangle);
            ++nextTriangle;
        }
        System.err.println(numTriangles + " ==> " + nextTriangle);
        Set keySetT = triangleMap.keySet();
        Iterator itrT = keySetT.iterator();
        while (itrT.hasNext()) {
            newTriangles.add(new TriangleKey((TriangleKey)itrT.next()));
        }
    }

    public void OrientTriangles(Vector<Vector3f> vertices, Vector<TriangleKey> triangles, boolean sameDir) {
        int numTriangles = triangles.size();
        for (int i = 0; i < numTriangles; ++i) {
            int save;
            TriangleKey tri = triangles.elementAt(i);
            Vector3f v0 = vertices.elementAt(tri.V[0]);
            Vector3f v1 = vertices.elementAt(tri.V[1]);
            Vector3f v2 = vertices.elementAt(tri.V[2]);
            Vector3f edge1 = new Vector3f();
            edge1.Sub(v1, v0);
            Vector3f edge2 = new Vector3f();
            edge2.Sub(v2, v0);
            Vector3f normal = new Vector3f();
            normal.Cross(edge1, edge2);
            Vector3f gradAvr = new Vector3f();
            gradAvr.Add(v0, v1);
            gradAvr.Add(v2);
            gradAvr.Scale(0.33333334f);
            Vector3f gradient = this.getGradient(gradAvr);
            float dot = gradient.Dot(normal);
            if (sameDir) {
                if (!(dot < 0.0f)) continue;
                save = tri.V[1];
                tri.V[1] = tri.V[2];
                tri.V[2] = save;
                continue;
            }
            if (!(dot > 0.0f)) continue;
            save = tri.V[1];
            tri.V[1] = tri.V[2];
            tri.V[2] = save;
        }
    }

    private int GetVertices(float level, int x, int y, int z, VETable table) {
        int type = 0;
        int i000 = x + this.m_iXBound * (y + this.m_iYBound * z);
        int i100 = i000 + 1;
        int i010 = i000 + this.m_iXBound;
        int i110 = i010 + 1;
        int i001 = i000 + this.m_iXYBound;
        int i101 = i001 + 1;
        int i011 = i001 + this.m_iXBound;
        int i111 = i011 + 1;
        float f000 = this.m_aiData[i000];
        float f100 = this.m_aiData[i100];
        float f010 = this.m_aiData[i010];
        float f110 = this.m_aiData[i110];
        float f001 = this.m_aiData[i001];
        float f101 = this.m_aiData[i101];
        float f011 = this.m_aiData[i011];
        float f111 = this.m_aiData[i111];
        float x0 = x;
        float y0 = y;
        float z0 = z;
        float x1 = x0 + 1.0f;
        float y1 = y0 + 1.0f;
        float z1 = z0 + 1.0f;
        float diff0 = level - f000;
        float diff1 = level - f001;
        if (diff0 * diff1 < 0.0f) {
            type |= 1;
            table.Insert(0, new Vector3f(x0, y0, z0 + diff0 / (f001 - f000)));
        }
        if ((diff0 = level - f010) * (diff1 = level - f011) < 0.0f) {
            type |= 2;
            table.Insert(1, new Vector3f(x0, y1, z0 + diff0 / (f011 - f010)));
        }
        if ((diff0 = level - f100) * (diff1 = level - f101) < 0.0f) {
            type |= 4;
            table.Insert(2, new Vector3f(x1, y0, z0 + diff0 / (f101 - f100)));
        }
        if ((diff0 = level - f110) * (diff1 = level - f111) < 0.0f) {
            type |= 8;
            table.Insert(3, new Vector3f(x1, y1, z0 + diff0 / (f111 - f110)));
        }
        if ((diff0 = level - f000) * (diff1 = level - f010) < 0.0f) {
            type |= 0x10;
            table.Insert(4, new Vector3f(x0, y0 + diff0 / (f010 - f000), z0));
        }
        if ((diff0 = level - f001) * (diff1 = level - f011) < 0.0f) {
            type |= 0x20;
            table.Insert(5, new Vector3f(x0, y0 + diff0 / (f011 - f001), z1));
        }
        if ((diff0 = level - f100) * (diff1 = level - f110) < 0.0f) {
            type |= 0x40;
            table.Insert(6, new Vector3f(x1, y0 + diff0 / (f110 - f100), z0));
        }
        if ((diff0 = level - f101) * (diff1 = level - f111) < 0.0f) {
            type |= 0x80;
            table.Insert(7, new Vector3f(x1, y0 + diff0 / (f111 - f101), z1));
        }
        if ((diff0 = level - f000) * (diff1 = level - f100) < 0.0f) {
            type |= 0x100;
            table.Insert(8, new Vector3f(x0 + diff0 / (f100 - f000), y0, z0));
        }
        if ((diff0 = level - f001) * (diff1 = level - f101) < 0.0f) {
            type |= 0x200;
            table.Insert(9, new Vector3f(x0 + diff0 / (f101 - f001), y0, z1));
        }
        if ((diff0 = level - f010) * (diff1 = level - f110) < 0.0f) {
            type |= 0x400;
            table.Insert(10, new Vector3f(x0 + diff0 / (f110 - f010), y1, z0));
        }
        if ((diff0 = level - f011) * (diff1 = level - f111) < 0.0f) {
            type |= 0x800;
            table.Insert(11, new Vector3f(x0 + diff0 / (f111 - f011), y1, z1));
        }
        return type;
    }

    private void GetXMaxEdges(int x, int y, int z, int type, VETable table) {
        int faceType = 0;
        if ((type & 4) != 0) {
            faceType |= 1;
        }
        if ((type & 8) != 0) {
            faceType |= 2;
        }
        if ((type & 0x40) != 0) {
            faceType |= 4;
        }
        if ((type & 0x80) != 0) {
            faceType |= 8;
        }
        switch (faceType) {
            case 0: {
                return;
            }
            case 3: {
                table.Insert(2, 3);
                break;
            }
            case 5: {
                table.Insert(2, 6);
                break;
            }
            case 6: {
                table.Insert(3, 6);
                break;
            }
            case 9: {
                table.Insert(2, 7);
                break;
            }
            case 10: {
                table.Insert(3, 7);
                break;
            }
            case 12: {
                table.Insert(6, 7);
                break;
            }
            case 15: {
                int i = x + 1 + this.m_iXBound * (y + this.m_iYBound * z);
                int f00 = this.m_aiData[i];
                int f10 = this.m_aiData[i += this.m_iXBound];
                int f11 = this.m_aiData[i += this.m_iXYBound];
                int f01 = this.m_aiData[i -= this.m_iXBound];
                int det = f00 * f11 - f01 * f10;
                if (det > 0) {
                    table.Insert(2, 6);
                    table.Insert(3, 7);
                    break;
                }
                if (det < 0) {
                    table.Insert(2, 7);
                    table.Insert(3, 6);
                    break;
                }
                table.Insert(13, new Vector3f(table.getX(6), table.getY(6), table.getZ(2)));
                table.Insert(2, 13);
                table.Insert(3, 13);
                table.Insert(6, 13);
                table.Insert(7, 13);
                break;
            }
            default: {
                System.err.println("Unexpected condition");
            }
        }
    }

    private void GetXMinEdges(int x, int y, int z, int type, VETable table) {
        int faceType = 0;
        if ((type & 1) != 0) {
            faceType |= 1;
        }
        if ((type & 2) != 0) {
            faceType |= 2;
        }
        if ((type & 0x10) != 0) {
            faceType |= 4;
        }
        if ((type & 0x20) != 0) {
            faceType |= 8;
        }
        switch (faceType) {
            case 0: {
                return;
            }
            case 3: {
                table.Insert(0, 1);
                break;
            }
            case 5: {
                table.Insert(0, 4);
                break;
            }
            case 6: {
                table.Insert(1, 4);
                break;
            }
            case 9: {
                table.Insert(0, 5);
                break;
            }
            case 10: {
                table.Insert(1, 5);
                break;
            }
            case 12: {
                table.Insert(4, 5);
                break;
            }
            case 15: {
                int i = x + this.m_iXBound * (y + this.m_iYBound * z);
                int f00 = this.m_aiData[i];
                int f10 = this.m_aiData[i += this.m_iXBound];
                int f11 = this.m_aiData[i += this.m_iXYBound];
                int f01 = this.m_aiData[i -= this.m_iXBound];
                int det = f00 * f11 - f01 * f10;
                if (det > 0) {
                    table.Insert(0, 4);
                    table.Insert(1, 5);
                    break;
                }
                if (det < 0) {
                    table.Insert(0, 5);
                    table.Insert(1, 4);
                    break;
                }
                table.Insert(12, new Vector3f(table.getX(4), table.getY(4), table.getZ(0)));
                table.Insert(0, 12);
                table.Insert(1, 12);
                table.Insert(4, 12);
                table.Insert(5, 12);
                break;
            }
            default: {
                System.err.println("Unexpected condition");
            }
        }
    }

    private void GetYMaxEdges(int x, int y, int z, int type, VETable table) {
        int faceType = 0;
        if ((type & 2) != 0) {
            faceType |= 1;
        }
        if ((type & 8) != 0) {
            faceType |= 2;
        }
        if ((type & 0x400) != 0) {
            faceType |= 4;
        }
        if ((type & 0x800) != 0) {
            faceType |= 8;
        }
        switch (faceType) {
            case 0: {
                return;
            }
            case 3: {
                table.Insert(1, 3);
                break;
            }
            case 5: {
                table.Insert(1, 10);
                break;
            }
            case 6: {
                table.Insert(3, 10);
                break;
            }
            case 9: {
                table.Insert(1, 11);
                break;
            }
            case 10: {
                table.Insert(3, 11);
                break;
            }
            case 12: {
                table.Insert(10, 11);
                break;
            }
            case 15: {
                int i = x + this.m_iXBound * (y + 1 + this.m_iYBound * z);
                int f00 = this.m_aiData[i];
                int f10 = this.m_aiData[++i];
                int f11 = this.m_aiData[i += this.m_iXYBound];
                int f01 = this.m_aiData[--i];
                int det = f00 * f11 - f01 * f10;
                if (det > 0) {
                    table.Insert(1, 10);
                    table.Insert(3, 11);
                    break;
                }
                if (det < 0) {
                    table.Insert(1, 11);
                    table.Insert(3, 10);
                    break;
                }
                table.Insert(15, new Vector3f(table.getX(10), table.getY(1), table.getZ(1)));
                table.Insert(1, 15);
                table.Insert(3, 15);
                table.Insert(10, 15);
                table.Insert(11, 15);
                break;
            }
            default: {
                System.err.println("Unexpected condition");
            }
        }
    }

    private void GetYMinEdges(int x, int y, int z, int type, VETable table) {
        int faceType = 0;
        if ((type & 1) != 0) {
            faceType |= 1;
        }
        if ((type & 4) != 0) {
            faceType |= 2;
        }
        if ((type & 0x100) != 0) {
            faceType |= 4;
        }
        if ((type & 0x200) != 0) {
            faceType |= 8;
        }
        switch (faceType) {
            case 0: {
                return;
            }
            case 3: {
                table.Insert(0, 2);
                break;
            }
            case 5: {
                table.Insert(0, 8);
                break;
            }
            case 6: {
                table.Insert(2, 8);
                break;
            }
            case 9: {
                table.Insert(0, 9);
                break;
            }
            case 10: {
                table.Insert(2, 9);
                break;
            }
            case 12: {
                table.Insert(8, 9);
                break;
            }
            case 15: {
                int i = x + this.m_iXBound * (y + this.m_iYBound * z);
                int f00 = this.m_aiData[i];
                int f10 = this.m_aiData[++i];
                int f11 = this.m_aiData[i += this.m_iXYBound];
                int f01 = this.m_aiData[--i];
                int det = f00 * f11 - f01 * f10;
                if (det > 0) {
                    table.Insert(0, 8);
                    table.Insert(2, 9);
                    break;
                }
                if (det < 0) {
                    table.Insert(0, 9);
                    table.Insert(2, 8);
                    break;
                }
                table.Insert(14, new Vector3f(table.getX(8), table.getY(0), table.getZ(0)));
                table.Insert(0, 14);
                table.Insert(2, 14);
                table.Insert(8, 14);
                table.Insert(9, 14);
                break;
            }
            default: {
                System.err.println("Unexpected condition");
            }
        }
    }

    private void GetZMaxEdges(int x, int y, int z, int type, VETable table) {
        int faceType = 0;
        if ((type & 0x20) != 0) {
            faceType |= 1;
        }
        if ((type & 0x80) != 0) {
            faceType |= 2;
        }
        if ((type & 0x200) != 0) {
            faceType |= 4;
        }
        if ((type & 0x800) != 0) {
            faceType |= 8;
        }
        switch (faceType) {
            case 0: {
                return;
            }
            case 3: {
                table.Insert(5, 7);
                break;
            }
            case 5: {
                table.Insert(5, 9);
                break;
            }
            case 6: {
                table.Insert(7, 9);
                break;
            }
            case 9: {
                table.Insert(5, 11);
                break;
            }
            case 10: {
                table.Insert(7, 11);
                break;
            }
            case 12: {
                table.Insert(9, 11);
                break;
            }
            case 15: {
                int i = x + this.m_iXBound * (y + this.m_iYBound * (z + 1));
                int f00 = this.m_aiData[i];
                int f10 = this.m_aiData[++i];
                int f11 = this.m_aiData[i += this.m_iXBound];
                int f01 = this.m_aiData[--i];
                int det = f00 * f11 - f01 * f10;
                if (det > 0) {
                    table.Insert(5, 9);
                    table.Insert(7, 11);
                    break;
                }
                if (det < 0) {
                    table.Insert(5, 11);
                    table.Insert(7, 9);
                    break;
                }
                table.Insert(17, new Vector3f(table.getX(9), table.getY(5), table.getZ(5)));
                table.Insert(5, 17);
                table.Insert(7, 17);
                table.Insert(9, 17);
                table.Insert(11, 17);
                break;
            }
            default: {
                System.err.println("Unexpected condition");
            }
        }
    }

    private void GetZMinEdges(int x, int y, int z, int type, VETable table) {
        int faceType = 0;
        if ((type & 0x10) != 0) {
            faceType |= 1;
        }
        if ((type & 0x40) != 0) {
            faceType |= 2;
        }
        if ((type & 0x100) != 0) {
            faceType |= 4;
        }
        if ((type & 0x400) != 0) {
            faceType |= 8;
        }
        switch (faceType) {
            case 0: {
                return;
            }
            case 3: {
                table.Insert(4, 6);
                break;
            }
            case 5: {
                table.Insert(4, 8);
                break;
            }
            case 6: {
                table.Insert(6, 8);
                break;
            }
            case 9: {
                table.Insert(4, 10);
                break;
            }
            case 10: {
                table.Insert(6, 10);
                break;
            }
            case 12: {
                table.Insert(8, 10);
                break;
            }
            case 15: {
                int i = x + this.m_iXBound * (y + this.m_iYBound * z);
                int f00 = this.m_aiData[i];
                int f10 = this.m_aiData[++i];
                int f11 = this.m_aiData[i += this.m_iXBound];
                int f01 = this.m_aiData[--i];
                int det = f00 * f11 - f01 * f10;
                if (det > 0) {
                    table.Insert(4, 8);
                    table.Insert(6, 10);
                    break;
                }
                if (det < 0) {
                    table.Insert(4, 10);
                    table.Insert(6, 8);
                    break;
                }
                table.Insert(16, new Vector3f(table.getX(8), table.getY(4), table.getZ(4)));
                table.Insert(4, 16);
                table.Insert(6, 16);
                table.Insert(8, 16);
                table.Insert(10, 16);
                break;
            }
            default: {
                System.err.println("Unexpected condition");
            }
        }
    }

    protected class VETable {
        protected Vertex[] m_akVertex = new Vertex[18];

        public VETable() {
            for (int i = 0; i < this.m_akVertex.length; ++i) {
                this.m_akVertex[i] = new Vertex();
            }
        }

        public Vector3f get(int i) {
            return this.m_akVertex[i].p;
        }

        public Triangle getNextTriangle() {
            int i;
            for (i = 0; i < this.m_akVertex.length; ++i) {
                Vertex rkV = this.m_akVertex[i];
                if (!rkV.valid || rkV.adjQuantity != 2) continue;
                Triangle rkTri = new Triangle(i, rkV.adj[0], rkV.adj[1]);
                this.removeVertex(i);
                return rkTri;
            }
            for (i = 0; i < this.m_akVertex.length; ++i) {
                this.m_akVertex[i].reset();
            }
            return null;
        }

        public float getX(int i) {
            return this.m_akVertex[i].p.X;
        }

        public float getY(int i) {
            return this.m_akVertex[i].p.Y;
        }

        public float getZ(int i) {
            return this.m_akVertex[i].p.Z;
        }

        public void insert(int i, float x, float y, float z) {
            Vertex rkV = this.m_akVertex[i];
            rkV.p.Set(x, y, z);
            rkV.valid = true;
        }

        public void insert(int i0, int i1) {
            Vertex rkV0 = this.m_akVertex[i0];
            Vertex rkV1 = this.m_akVertex[i1];
            rkV0.adj[rkV0.adjQuantity++] = i1;
            rkV1.adj[rkV1.adjQuantity++] = i0;
        }

        public void Insert(int i0, int i1) {
            if (0 > i0 || i0 >= 18 || 0 > i1 || i1 >= 18) {
                System.err.println("Invalid index");
            }
            Vertex vertex0 = this.m_akVertex[i0];
            Vertex vertex1 = this.m_akVertex[i1];
            if (vertex0.adjQuantity >= 4 || vertex1.adjQuantity >= 4) {
                System.err.println("Invalid adjacent quantity");
            }
            vertex0.adj[vertex0.adjQuantity++] = i1;
            vertex1.adj[vertex1.adjQuantity++] = i0;
        }

        public void Insert(int i, Vector3f P) {
            Vertex vertex = this.m_akVertex[i];
            vertex.p = P;
            vertex.valid = true;
        }

        public void removeTriangles(Vector<Vector3f> vertices, Vector<TriangleKey> triangles) {
            TriangleKey tri = new TriangleKey();
            Vector3f edge1 = new Vector3f();
            Vector3f edge2 = new Vector3f();
            Vector3f normal = new Vector3f();
            Vector3f centroid = new Vector3f();
            while (this.remove(tri)) {
                int v0 = vertices.size();
                int v1 = v0 + 1;
                int v2 = v1 + 1;
                Vector3f kV0 = new Vector3f(this.m_akVertex[tri.V[0]].p);
                Vector3f kV1 = new Vector3f(this.m_akVertex[tri.V[1]].p);
                Vector3f kV2 = new Vector3f(this.m_akVertex[tri.V[2]].p);
                vertices.add(kV0);
                vertices.add(kV1);
                vertices.add(kV2);
                edge1.Sub(kV1, kV0);
                edge2.Sub(kV2, kV0);
                normal.Cross(edge1, edge2);
                centroid.Add(kV0, kV1);
                centroid.Add(kV2);
                centroid.Scale(0.33333334f);
                Vector3f kGradient = ExtractSurfaceCubes.this.getGradient(centroid);
                if (kGradient.Dot(normal) <= 0.0f) {
                    triangles.add(new TriangleKey(v0, v1, v2));
                    continue;
                }
                triangles.add(new TriangleKey(v0, v2, v1));
            }
        }

        protected void removeVertex(int i) {
            int j;
            Vertex rkV0 = this.m_akVertex[i];
            int iA0 = rkV0.adj[0];
            int iA1 = rkV0.adj[1];
            Vertex rkVA0 = this.m_akVertex[iA0];
            Vertex rkVA1 = this.m_akVertex[iA1];
            for (j = 0; j < rkVA0.adjQuantity; ++j) {
                if (rkVA0.adj[j] != i) continue;
                rkVA0.adj[j] = iA1;
                break;
            }
            for (j = 0; j < rkVA1.adjQuantity; ++j) {
                if (rkVA1.adj[j] != i) continue;
                rkVA1.adj[j] = iA0;
                break;
            }
            rkV0.valid = false;
            if (rkVA0.adjQuantity == 2 && rkVA0.adj[0] == rkVA0.adj[1]) {
                rkVA0.valid = false;
            }
            if (rkVA1.adjQuantity == 2 && rkVA1.adj[0] == rkVA1.adj[1]) {
                rkVA1.valid = false;
            }
        }

        private boolean remove(TriangleKey tri) {
            for (int i = 0; i < 18; ++i) {
                Vertex vertex = this.m_akVertex[i];
                if (!vertex.valid || vertex.adjQuantity != 2) continue;
                tri.V[0] = i;
                tri.V[1] = vertex.adj[0];
                tri.V[2] = vertex.adj[1];
                this.removeVertex(i);
                return true;
            }
            return false;
        }

        protected class Vertex {
            public int[] adj = new int[]{0, 0, 0, 0};
            public int adjQuantity;
            public Vector3f p = new Vector3f();
            public boolean valid;

            public Vertex() {
                this.reset();
            }

            public void reset() {
                this.valid = false;
                this.adjQuantity = 0;
            }
        }
    }

    protected class Triangle {
        public int m_iV0;
        public int m_iV1;
        public int m_iV2;

        public Triangle(int iV0, int iV1, int iV2) {
            if (iV0 < iV1) {
                if (iV0 < iV2) {
                    this.m_iV0 = iV0;
                    this.m_iV1 = iV1;
                    this.m_iV2 = iV2;
                } else {
                    this.m_iV0 = iV2;
                    this.m_iV1 = iV0;
                    this.m_iV2 = iV1;
                }
            } else if (iV1 < iV2) {
                this.m_iV0 = iV1;
                this.m_iV1 = iV2;
                this.m_iV2 = iV0;
            } else {
                this.m_iV0 = iV2;
                this.m_iV1 = iV0;
                this.m_iV2 = iV1;
            }
        }

        public boolean equals(Object kObject) {
            Triangle kT = (Triangle)kObject;
            return this.m_iV0 == kT.m_iV0 && (this.m_iV1 == kT.m_iV1 && this.m_iV2 == kT.m_iV2 || this.m_iV1 == kT.m_iV2 && this.m_iV2 == kT.m_iV1);
        }

        public int hashCode() {
            int iCmp = this.m_iV1 < this.m_iV2 ? this.m_iV2 << 8 ^ (this.m_iV0 << 16 | this.m_iV1) : this.m_iV1 << 8 ^ (this.m_iV0 << 16 | this.m_iV2);
            return iCmp;
        }
    }
}

