/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibImagics.Extraction;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class ExtractSurfaceTetra
implements Serializable {
    private static final long serialVersionUID = 4826433337198470692L;
    protected int[] m_aiData;
    protected int m_iNextIndex;
    protected int m_iXBound;
    protected int m_iYBound;
    protected int m_iZBound;
    protected int m_iXYProduct;
    protected int m_iXYZProduct;
    protected Vector3f m_kE0;
    protected Vector3f m_kE1;
    protected Vector3f m_kN;
    protected Vector3f m_kGradient;
    protected HashSet<Triangle> m_kTSet;
    protected Vector3f m_kV0;
    protected Vector3f m_kV1;
    protected Vector3f m_kV2;
    protected Vector3f m_kCentroid;
    protected HashMap<Vertex, Integer> m_kVMap;

    public ExtractSurfaceTetra(int iXBound, int iYBound, int iZBound, int[] aiData) {
        this.m_iXBound = iXBound;
        this.m_iYBound = iYBound;
        this.m_iZBound = iZBound;
        this.m_iXYProduct = this.m_iXBound * this.m_iYBound;
        this.m_iXYZProduct = this.m_iXYProduct * this.m_iZBound;
        this.m_aiData = aiData;
        this.m_kV0 = new Vector3f();
        this.m_kV1 = new Vector3f();
        this.m_kV2 = new Vector3f();
        this.m_kE0 = new Vector3f();
        this.m_kE1 = new Vector3f();
        this.m_kN = new Vector3f();
        this.m_kCentroid = new Vector3f();
        this.m_kGradient = new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public void ExtractContour(int iLevel, HashMap<Vertex, Integer> kVMap, HashSet<Triangle> kTSet) {
        this.m_kVMap = kVMap;
        this.m_kTSet = kTSet;
        this.m_kVMap.clear();
        this.m_kTSet.clear();
        this.m_iNextIndex = 0;
        int iIndex = 0;
        while (iIndex < this.m_iXYZProduct) {
            int n = iIndex++;
            this.m_aiData[n] = this.m_aiData[n] - iLevel;
        }
        int iZ = 0;
        int iZP = 1;
        while (iZ < this.m_iZBound - 1) {
            int iZParity = iZ & 1;
            int iY = 0;
            int iYP = 1;
            while (iY < this.m_iYBound - 1) {
                int iYParity = iY & 1;
                int iX = 0;
                int iXP = 1;
                while (iX < this.m_iXBound - 1) {
                    int iXParity = iX & 1;
                    int iI000 = iX + this.m_iXBound * (iY + this.m_iYBound * iZ);
                    int iI100 = iI000 + 1;
                    int iI010 = iI000 + this.m_iXBound;
                    int iI110 = iI100 + this.m_iXBound;
                    int iI001 = iI000 + this.m_iXYProduct;
                    int iI101 = iI100 + this.m_iXYProduct;
                    int iI011 = iI010 + this.m_iXYProduct;
                    int iI111 = iI110 + this.m_iXYProduct;
                    int iF000 = this.m_aiData[iI000];
                    int iF100 = this.m_aiData[iI100];
                    int iF010 = this.m_aiData[iI010];
                    int iF110 = this.m_aiData[iI110];
                    int iF001 = this.m_aiData[iI001];
                    int iF101 = this.m_aiData[iI101];
                    int iF011 = this.m_aiData[iI011];
                    int iF111 = this.m_aiData[iI111];
                    if ((iXParity ^ iYParity ^ iZParity) != 0) {
                        this.processTetrahedron(iLevel, iXP, iY, iZ, iF100, iXP, iYP, iZ, iF110, iX, iY, iZ, iF000, iXP, iY, iZP, iF101);
                        this.processTetrahedron(iLevel, iX, iYP, iZ, iF010, iX, iY, iZ, iF000, iXP, iYP, iZ, iF110, iX, iYP, iZP, iF011);
                        this.processTetrahedron(iLevel, iX, iY, iZP, iF001, iX, iYP, iZP, iF011, iXP, iY, iZP, iF101, iX, iY, iZ, iF000);
                        this.processTetrahedron(iLevel, iXP, iYP, iZP, iF111, iXP, iY, iZP, iF101, iX, iYP, iZP, iF011, iXP, iYP, iZ, iF110);
                        this.processTetrahedron(iLevel, iX, iY, iZ, iF000, iX, iYP, iZP, iF011, iXP, iY, iZP, iF101, iXP, iYP, iZ, iF110);
                    } else {
                        this.processTetrahedron(iLevel, iX, iY, iZ, iF000, iXP, iY, iZ, iF100, iX, iYP, iZ, iF010, iX, iY, iZP, iF001);
                        this.processTetrahedron(iLevel, iXP, iYP, iZ, iF110, iX, iYP, iZ, iF010, iXP, iY, iZ, iF100, iXP, iYP, iZP, iF111);
                        this.processTetrahedron(iLevel, iXP, iY, iZP, iF101, iX, iY, iZP, iF001, iXP, iYP, iZP, iF111, iXP, iY, iZ, iF100);
                        this.processTetrahedron(iLevel, iX, iYP, iZP, iF011, iXP, iYP, iZP, iF111, iX, iY, iZP, iF001, iX, iYP, iZ, iF010);
                        this.processTetrahedron(iLevel, iXP, iYP, iZP, iF111, iX, iYP, iZ, iF010, iXP, iY, iZ, iF100, iX, iY, iZP, iF001);
                    }
                    ++iX;
                    ++iXP;
                }
                ++iY;
                ++iYP;
            }
            ++iZ;
            ++iZP;
        }
        iIndex = 0;
        while (iIndex < this.m_iXYZProduct) {
            int n = iIndex++;
            this.m_aiData[n] = this.m_aiData[n] + iLevel;
        }
    }

    public void ExtractContour(int iLevel, Vector<int[]> kTriTable, HashMap<Vertex, Integer> kVMap, HashSet<Triangle> kTSet) {
        this.m_kVMap = kVMap;
        this.m_kTSet = kTSet;
        this.m_kVMap.clear();
        this.m_kTSet.clear();
        this.m_iNextIndex = 0;
        int iIndex = 0;
        while (iIndex < this.m_iXYZProduct) {
            int n = iIndex++;
            this.m_aiData[n] = this.m_aiData[n] - iLevel;
        }
        int iSize = kTriTable.size();
        for (int i = 0; i < iSize; ++i) {
            int[] iCube = kTriTable.get(i);
            int iX = iCube[0];
            int iY = iCube[1];
            int iZ = iCube[2];
            if (iX < 0 || iY < 0 || iZ < 0 || iX >= this.m_iXBound - 1 || iY >= this.m_iYBound - 1 || iZ >= this.m_iZBound - 1) continue;
            int iXP = iX + 1;
            int iYP = iY + 1;
            int iZP = iZ + 1;
            int iZParity = iZ & 1;
            int iYParity = iY & 1;
            int iXParity = iX & 1;
            int iI000 = iX + this.m_iXBound * (iY + this.m_iYBound * iZ);
            int iI100 = iI000 + 1;
            int iI010 = iI000 + this.m_iXBound;
            int iI110 = iI100 + this.m_iXBound;
            int iI001 = iI000 + this.m_iXYProduct;
            int iI101 = iI100 + this.m_iXYProduct;
            int iI011 = iI010 + this.m_iXYProduct;
            int iI111 = iI110 + this.m_iXYProduct;
            int iF000 = this.m_aiData[iI000];
            int iF100 = this.m_aiData[iI100];
            int iF010 = this.m_aiData[iI010];
            int iF110 = this.m_aiData[iI110];
            int iF001 = this.m_aiData[iI001];
            int iF101 = this.m_aiData[iI101];
            int iF011 = this.m_aiData[iI011];
            int iF111 = this.m_aiData[iI111];
            if ((iXParity ^ iYParity ^ iZParity) != 0) {
                this.processTetrahedron(iLevel, iXP, iY, iZ, iF100, iXP, iYP, iZ, iF110, iX, iY, iZ, iF000, iXP, iY, iZP, iF101);
                this.processTetrahedron(iLevel, iX, iYP, iZ, iF010, iX, iY, iZ, iF000, iXP, iYP, iZ, iF110, iX, iYP, iZP, iF011);
                this.processTetrahedron(iLevel, iX, iY, iZP, iF001, iX, iYP, iZP, iF011, iXP, iY, iZP, iF101, iX, iY, iZ, iF000);
                this.processTetrahedron(iLevel, iXP, iYP, iZP, iF111, iXP, iY, iZP, iF101, iX, iYP, iZP, iF011, iXP, iYP, iZ, iF110);
                this.processTetrahedron(iLevel, iX, iY, iZ, iF000, iX, iYP, iZP, iF011, iXP, iY, iZP, iF101, iXP, iYP, iZ, iF110);
                continue;
            }
            this.processTetrahedron(iLevel, iX, iY, iZ, iF000, iXP, iY, iZ, iF100, iX, iYP, iZ, iF010, iX, iY, iZP, iF001);
            this.processTetrahedron(iLevel, iXP, iYP, iZ, iF110, iX, iYP, iZ, iF010, iXP, iY, iZ, iF100, iXP, iYP, iZP, iF111);
            this.processTetrahedron(iLevel, iXP, iY, iZP, iF101, iX, iY, iZP, iF001, iXP, iYP, iZP, iF111, iXP, iY, iZ, iF100);
            this.processTetrahedron(iLevel, iX, iYP, iZP, iF011, iXP, iYP, iZP, iF111, iX, iY, iZP, iF001, iX, iYP, iZ, iF010);
            this.processTetrahedron(iLevel, iXP, iYP, iZP, iF111, iX, iYP, iZ, iF010, iXP, iY, iZ, iF100, iX, iY, iZP, iF001);
        }
        iIndex = 0;
        while (iIndex < this.m_iXYZProduct) {
            int n = iIndex++;
            this.m_aiData[n] = this.m_aiData[n] + iLevel;
        }
    }

    public float getFunction(Vector3f kP) {
        float fInterp;
        int iX = (int)kP.X;
        if (iX < 0 || iX >= this.m_iXBound - 1) {
            return 0.0f;
        }
        int iY = (int)kP.Y;
        if (iY < 0 || iY >= this.m_iYBound - 1) {
            return 0.0f;
        }
        int iZ = (int)kP.Z;
        if (iZ < 0 || iZ >= this.m_iZBound - 1) {
            return 0.0f;
        }
        float fDX = kP.X - (float)iX;
        float fDY = kP.Y - (float)iY;
        float fDZ = kP.Z - (float)iZ;
        int i000 = iX + this.m_iXBound * (iY + this.m_iYBound * iZ);
        int i100 = i000 + 1;
        int i010 = i000 + this.m_iXBound;
        int i110 = i100 + this.m_iXBound;
        int i001 = i000 + this.m_iXYProduct;
        int i101 = i100 + this.m_iXYProduct;
        int i011 = i010 + this.m_iXYProduct;
        int i111 = i110 + this.m_iXYProduct;
        float fF000 = this.m_aiData[i000];
        float fF100 = this.m_aiData[i100];
        float fF010 = this.m_aiData[i010];
        float fF110 = this.m_aiData[i110];
        float fF001 = this.m_aiData[i001];
        float fF101 = this.m_aiData[i101];
        float fF011 = this.m_aiData[i011];
        float fF111 = this.m_aiData[i111];
        if ((iX & 1 ^ iY & 1 ^ iZ & 1) != 0) {
            if (fDX - fDY - fDZ >= 0.0f) {
                fInterp = (1.0f - (1.0f - fDX) - fDY - fDZ) * fF100 + (1.0f - fDX) * fF000 + fDY * fF110 + fDZ * fF101;
            } else if (fDX - fDY + fDZ <= 0.0f) {
                fInterp = (1.0f - fDX - (1.0f - fDY) - fDZ) * fF010 + fDX * fF110 + (1.0f - fDY) * fF000 + fDZ * fF011;
            } else if (fDX + fDY - fDZ <= 0.0f) {
                fInterp = (1.0f - fDX - fDY - (1.0f - fDZ)) * fF001 + fDX * fF101 + fDY * fF011 + (1.0f - fDZ) * fF000;
            } else if (fDX + fDY + fDZ >= 2.0f) {
                fInterp = (1.0f - (1.0f - fDX) - (1.0f - fDY) - (1.0f - fDZ)) * fF111 + (1.0f - fDX) * fF011 + (1.0f - fDY) * fF101 + (1.0f - fDZ) * fF110;
            } else {
                float fC0 = 0.5f * (-fDX + fDY + fDZ);
                float fC1 = 0.5f * (fDX - fDY + fDZ);
                float fC2 = 0.5f * (fDX + fDY - fDZ);
                fInterp = (1.0f - fC0 - fC1 - fC2) * fF000 + fC0 * fF011 + fC1 * fF101 + fC2 * fF110;
            }
        } else if (fDX + fDY + fDZ <= 1.0f) {
            fInterp = (1.0f - fDX - fDY - fDZ) * fF000 + fDX * fF100 + fDY * fF010 + fDZ * fF001;
        } else if (fDX + fDY - fDZ >= 1.0f) {
            fInterp = (1.0f - (1.0f - fDX) - (1.0f - fDY) - fDZ) * fF110 + (1.0f - fDX) * fF010 + (1.0f - fDY) * fF100 + fDZ * fF111;
        } else if (fDX - fDY + fDZ >= 1.0f) {
            fInterp = (1.0f - (1.0f - fDX) - fDY - (1.0f - fDZ)) * fF101 + (1.0f - fDX) * fF001 + fDY * fF111 + (1.0f - fDZ) * fF100;
        } else if (-fDX + fDY + fDZ >= 1.0f) {
            fInterp = (1.0f - fDX - (1.0f - fDY) - (1.0f - fDZ)) * fF011 + fDX * fF111 + (1.0f - fDY) * fF001 + (1.0f - fDZ) * fF010;
        } else {
            float fC0 = 0.5f * (1.0f - fDX - (1.0f - fDY) + (1.0f - fDZ));
            float fC1 = 0.5f * (-(1.0f - fDX) + (1.0f - fDY) + (1.0f - fDZ));
            float fC2 = 0.5f * (1.0f - fDX + (1.0f - fDY) - (1.0f - fDZ));
            fInterp = (1.0f - fC0 - fC1 - fC2) * fF111 + fC0 * fF010 + fC1 * fF100 + fC2 * fF001;
        }
        return fInterp;
    }

    public Vector3f getGradient(Vector3f kP) {
        int iX = (int)kP.X;
        if (iX < 0 || iX >= this.m_iXBound - 1) {
            this.m_kGradient.X = 0.0f;
            this.m_kGradient.Y = 0.0f;
            this.m_kGradient.Z = 0.0f;
            return this.m_kGradient;
        }
        int iY = (int)kP.Y;
        if (iY < 0 || iY >= this.m_iYBound - 1) {
            this.m_kGradient.X = 0.0f;
            this.m_kGradient.Y = 0.0f;
            this.m_kGradient.Z = 0.0f;
            return this.m_kGradient;
        }
        int iZ = (int)kP.Z;
        if (iZ < 0 || iZ >= this.m_iZBound - 1) {
            this.m_kGradient.X = 0.0f;
            this.m_kGradient.Y = 0.0f;
            this.m_kGradient.Z = 0.0f;
            return this.m_kGradient;
        }
        float fDX = kP.X - (float)iX;
        float fDY = kP.Y - (float)iY;
        float fDZ = kP.Z - (float)iZ;
        int i000 = iX + this.m_iXBound * (iY + this.m_iYBound * iZ);
        int i100 = i000 + 1;
        int i010 = i000 + this.m_iXBound;
        int i110 = i100 + this.m_iXBound;
        int i001 = i000 + this.m_iXYProduct;
        int i101 = i100 + this.m_iXYProduct;
        int i011 = i010 + this.m_iXYProduct;
        int i111 = i110 + this.m_iXYProduct;
        float fF000 = this.m_aiData[i000];
        float fF100 = this.m_aiData[i100];
        float fF010 = this.m_aiData[i010];
        float fF110 = this.m_aiData[i110];
        float fF001 = this.m_aiData[i001];
        float fF101 = this.m_aiData[i101];
        float fF011 = this.m_aiData[i011];
        float fF111 = this.m_aiData[i111];
        if ((iX & 1 ^ iY & 1 ^ iZ & 1) != 0) {
            if (fDX - fDY - fDZ >= 0.0f) {
                this.m_kGradient.X = fF100 - fF000;
                this.m_kGradient.Y = -fF100 + fF110;
                this.m_kGradient.Z = -fF100 + fF101;
            } else if (fDX - fDY + fDZ <= 0.0f) {
                this.m_kGradient.X = -fF010 + fF110;
                this.m_kGradient.Y = fF010 - fF000;
                this.m_kGradient.Z = -fF010 + fF011;
            } else if (fDX + fDY - fDZ <= 0.0f) {
                this.m_kGradient.X = -fF001 + fF101;
                this.m_kGradient.Y = -fF001 + fF011;
                this.m_kGradient.Z = fF001 - fF000;
            } else if (fDX + fDY + fDZ >= 2.0f) {
                this.m_kGradient.X = fF111 - fF011;
                this.m_kGradient.Y = fF111 - fF101;
                this.m_kGradient.Z = fF111 - fF110;
            } else {
                this.m_kGradient.X = 0.5f * (-fF000 - fF011 + fF101 + fF110);
                this.m_kGradient.Y = 0.5f * (-fF000 + fF011 - fF101 + fF110);
                this.m_kGradient.Z = 0.5f * (-fF000 + fF011 + fF101 - fF110);
            }
        } else if (fDX + fDY + fDZ <= 1.0f) {
            this.m_kGradient.X = -fF000 + fF100;
            this.m_kGradient.Y = -fF000 + fF010;
            this.m_kGradient.Z = -fF000 + fF001;
        } else if (fDX + fDY - fDZ >= 1.0f) {
            this.m_kGradient.X = fF110 - fF010;
            this.m_kGradient.Y = fF110 - fF100;
            this.m_kGradient.Z = -fF110 + fF111;
        } else if (fDX - fDY + fDZ >= 1.0f) {
            this.m_kGradient.X = fF101 - fF001;
            this.m_kGradient.Y = -fF101 + fF111;
            this.m_kGradient.Z = fF101 - fF100;
        } else if (-fDX + fDY + fDZ >= 1.0f) {
            this.m_kGradient.X = -fF011 + fF111;
            this.m_kGradient.Y = fF011 - fF001;
            this.m_kGradient.Z = fF011 - fF010;
        } else {
            this.m_kGradient.X = 0.5f * (fF111 - fF010 + fF100 - fF001);
            this.m_kGradient.Y = 0.5f * (fF111 + fF010 - fF100 - fF001);
            this.m_kGradient.Z = 0.5f * (fF111 - fF010 - fF100 + fF001);
        }
        return this.m_kGradient;
    }

    protected void addTriangle(int iXN0, int iXD0, int iYN0, int iYD0, int iZN0, int iZD0, int iXN1, int iXD1, int iYN1, int iYD1, int iZN1, int iZD1, int iXN2, int iXD2, int iYN2, int iYD2, int iZN2, int iZD2) {
        int iV0 = this.addVertex(iXN0, iXD0, iYN0, iYD0, iZN0, iZD0);
        int iV1 = this.addVertex(iXN1, iXD1, iYN1, iYD1, iZN1, iZD1);
        int iV2 = this.addVertex(iXN2, iXD2, iYN2, iYD2, iZN2, iZD2);
        this.m_kV0.X = (float)iXN0 / (float)iXD0;
        this.m_kV0.Y = (float)iYN0 / (float)iYD0;
        this.m_kV0.Z = (float)iZN0 / (float)iZD0;
        this.m_kV1.X = (float)iXN1 / (float)iXD1;
        this.m_kV1.Y = (float)iYN1 / (float)iYD1;
        this.m_kV1.Z = (float)iZN1 / (float)iZD1;
        this.m_kV2.X = (float)iXN2 / (float)iXD2;
        this.m_kV2.Y = (float)iYN2 / (float)iYD2;
        this.m_kV2.Z = (float)iZN2 / (float)iZD2;
        this.m_kE0.Sub(this.m_kV1, this.m_kV0);
        this.m_kE1.Sub(this.m_kV2, this.m_kV0);
        this.m_kN.Cross(this.m_kE0, this.m_kE1);
        this.m_kCentroid.Add(this.m_kV0, this.m_kV1);
        this.m_kCentroid.Add(this.m_kV2);
        this.m_kCentroid.Scale(0.33333334f);
        Vector3f kGradient = this.getGradient(this.m_kCentroid);
        if (kGradient.Dot(this.m_kN) <= 0.0f) {
            this.m_kTSet.add(new Triangle(iV0, iV1, iV2));
        } else {
            this.m_kTSet.add(new Triangle(iV0, iV2, iV1));
        }
    }

    protected int addVertex(int iXN, int iXD, int iYN, int iYD, int iZN, int iZD) {
        Vertex kV = new Vertex(iXN, iXD, iYN, iYD, iZN, iZD);
        if (this.m_kVMap.containsKey(kV)) {
            Integer kInt = this.m_kVMap.get(kV);
            return kInt;
        }
        int i = this.m_iNextIndex++;
        this.m_kVMap.put(kV, new Integer(i));
        return i;
    }

    protected void processTetrahedron(float iLevel, int iX0, int iY0, int iZ0, int iF0, int iX1, int iY1, int iZ1, int iF1, int iX2, int iY2, int iZ2, int iF2, int iX3, int iY3, int iZ3, int iF3) {
        if (iF0 != 0) {
            if (iF0 < 0) {
                iF0 = -iF0;
                iF1 = -iF1;
                iF2 = -iF2;
                iF3 = -iF3;
            }
            if (iF1 > 0) {
                if (iF2 > 0) {
                    if (iF3 > 0) {
                        return;
                    }
                    if (iF3 < 0) {
                        int iD0 = iF0 - iF3;
                        int iXN0 = iF0 * iX3 - iF3 * iX0;
                        int iYN0 = iF0 * iY3 - iF3 * iY0;
                        int iZN0 = iF0 * iZ3 - iF3 * iZ0;
                        int iD1 = iF1 - iF3;
                        int iXN1 = iF1 * iX3 - iF3 * iX1;
                        int iYN1 = iF1 * iY3 - iF3 * iY1;
                        int iZN1 = iF1 * iZ3 - iF3 * iZ1;
                        int iD2 = iF2 - iF3;
                        int iXN2 = iF2 * iX3 - iF3 * iX2;
                        int iYN2 = iF2 * iY3 - iF3 * iY2;
                        int iZN2 = iF2 * iZ3 - iF3 * iZ2;
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iXN2, iD2, iYN2, iD2, iZN2, iD2);
                    }
                } else if (iF2 < 0) {
                    int iD0 = iF0 - iF2;
                    int iXN0 = iF0 * iX2 - iF2 * iX0;
                    int iYN0 = iF0 * iY2 - iF2 * iY0;
                    int iZN0 = iF0 * iZ2 - iF2 * iZ0;
                    int iD1 = iF1 - iF2;
                    int iXN1 = iF1 * iX2 - iF2 * iX1;
                    int iYN1 = iF1 * iY2 - iF2 * iY1;
                    int iZN1 = iF1 * iZ2 - iF2 * iZ1;
                    if (iF3 > 0) {
                        int iD2 = iF3 - iF2;
                        int iXN2 = iF3 * iX2 - iF2 * iX3;
                        int iYN2 = iF3 * iY2 - iF2 * iY3;
                        int iZN2 = iF3 * iZ2 - iF2 * iZ3;
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iXN2, iD2, iYN2, iD2, iZN2, iD2);
                    } else if (iF3 < 0) {
                        int iD2 = iF0 - iF3;
                        int iXN2 = iF0 * iX3 - iF3 * iX0;
                        int iYN2 = iF0 * iY3 - iF3 * iY0;
                        int iZN2 = iF0 * iZ3 - iF3 * iZ0;
                        int iD3 = iF1 - iF3;
                        int iXN3 = iF1 * iX3 - iF3 * iX1;
                        int iYN3 = iF1 * iY3 - iF3 * iY1;
                        int iZN3 = iF1 * iZ3 - iF3 * iZ1;
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iXN2, iD2, iYN2, iD2, iZN2, iD2);
                        this.addTriangle(iXN1, iD1, iYN1, iD1, iZN1, iD1, iXN3, iD3, iYN3, iD3, iZN3, iD3, iXN2, iD2, iYN2, iD2, iZN2, iD2);
                    } else {
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iX3, 1, iY3, 1, iZ3, 1);
                    }
                } else if (iF3 <= 0 && iF3 < 0) {
                    int iD0 = iF0 - iF3;
                    int iXN0 = iF0 * iX3 - iF3 * iX0;
                    int iYN0 = iF0 * iY3 - iF3 * iY0;
                    int iZN0 = iF0 * iZ3 - iF3 * iZ0;
                    int iD1 = iF1 - iF3;
                    int iXN1 = iF1 * iX3 - iF3 * iX1;
                    int iYN1 = iF1 * iY3 - iF3 * iY1;
                    int iZN1 = iF1 * iZ3 - iF3 * iZ1;
                    this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iX2, 1, iY2, 1, iZ2, 1);
                }
            } else if (iF1 < 0) {
                if (iF2 > 0) {
                    int iD0 = iF0 - iF1;
                    int iXN0 = iF0 * iX1 - iF1 * iX0;
                    int iYN0 = iF0 * iY1 - iF1 * iY0;
                    int iZN0 = iF0 * iZ1 - iF1 * iZ0;
                    int iD1 = iF2 - iF1;
                    int iXN1 = iF2 * iX1 - iF1 * iX2;
                    int iYN1 = iF2 * iY1 - iF1 * iY2;
                    int iZN1 = iF2 * iZ1 - iF1 * iZ2;
                    if (iF3 > 0) {
                        int iD2 = iF3 - iF1;
                        int iXN2 = iF3 * iX1 - iF1 * iX3;
                        int iYN2 = iF3 * iY1 - iF1 * iY3;
                        int iZN2 = iF3 * iZ1 - iF1 * iZ3;
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iXN2, iD2, iYN2, iD2, iZN2, iD2);
                    } else if (iF3 < 0) {
                        int iD2 = iF0 - iF3;
                        int iXN2 = iF0 * iX3 - iF3 * iX0;
                        int iYN2 = iF0 * iY3 - iF3 * iY0;
                        int iZN2 = iF0 * iZ3 - iF3 * iZ0;
                        int iD3 = iF2 - iF3;
                        int iXN3 = iF2 * iX3 - iF3 * iX2;
                        int iYN3 = iF2 * iY3 - iF3 * iY2;
                        int iZN3 = iF2 * iZ3 - iF3 * iZ2;
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iXN2, iD2, iYN2, iD2, iZN2, iD2);
                        this.addTriangle(iXN1, iD1, iYN1, iD1, iZN1, iD1, iXN3, iD3, iYN3, iD3, iZN3, iD3, iXN2, iD2, iYN2, iD2, iZN2, iD2);
                    } else {
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iX3, 1, iY3, 1, iZ3, 1);
                    }
                } else if (iF2 < 0) {
                    int iD0 = iF1 - iF0;
                    int iXN0 = iF1 * iX0 - iF0 * iX1;
                    int iYN0 = iF1 * iY0 - iF0 * iY1;
                    int iZN0 = iF1 * iZ0 - iF0 * iZ1;
                    int iD1 = iF2 - iF0;
                    int iXN1 = iF2 * iX0 - iF0 * iX2;
                    int iYN1 = iF2 * iY0 - iF0 * iY2;
                    int iZN1 = iF2 * iZ0 - iF0 * iZ2;
                    if (iF3 > 0) {
                        int iD2 = iF1 - iF3;
                        int iXN2 = iF1 * iX3 - iF3 * iX1;
                        int iYN2 = iF1 * iY3 - iF3 * iY1;
                        int iZN2 = iF1 * iZ3 - iF3 * iZ1;
                        int iD3 = iF2 - iF3;
                        int iXN3 = iF2 * iX3 - iF3 * iX2;
                        int iYN3 = iF2 * iY3 - iF3 * iY2;
                        int iZN3 = iF2 * iZ3 - iF3 * iZ2;
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iXN2, iD2, iYN2, iD2, iZN2, iD2);
                        this.addTriangle(iXN1, iD1, iYN1, iD1, iZN1, iD1, iXN3, iD3, iYN3, iD3, iZN3, iD3, iXN2, iD2, iYN2, iD2, iZN2, iD2);
                    } else if (iF3 < 0) {
                        int iD2 = iF3 - iF0;
                        int iXN2 = iF3 * iX0 - iF0 * iX3;
                        int iYN2 = iF3 * iY0 - iF0 * iY3;
                        int iZN2 = iF3 * iZ0 - iF0 * iZ3;
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iXN2, iD2, iYN2, iD2, iZN2, iD2);
                    } else {
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iX3, 1, iY3, 1, iZ3, 1);
                    }
                } else {
                    int iD0 = iF1 - iF0;
                    int iXN0 = iF1 * iX0 - iF0 * iX1;
                    int iYN0 = iF1 * iY0 - iF0 * iY1;
                    int iZN0 = iF1 * iZ0 - iF0 * iZ1;
                    if (iF3 > 0) {
                        int iD1 = iF1 - iF3;
                        int iXN1 = iF1 * iX3 - iF3 * iX1;
                        int iYN1 = iF1 * iY3 - iF3 * iY1;
                        int iZN1 = iF1 * iZ3 - iF3 * iZ1;
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iX2, 1, iY2, 1, iZ2, 1);
                    } else if (iF3 < 0) {
                        int iD1 = iF3 - iF0;
                        int iXN1 = iF3 * iX0 - iF0 * iX3;
                        int iYN1 = iF3 * iY0 - iF0 * iY3;
                        int iZN1 = iF3 * iZ0 - iF0 * iZ3;
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iX2, 1, iY2, 1, iZ2, 1);
                    } else {
                        this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iX2, 1, iY2, 1, iZ2, 1, iX3, 1, iY3, 1, iZ3, 1);
                    }
                }
            } else if (iF2 > 0) {
                if (iF3 <= 0 && iF3 < 0) {
                    int iD0 = iF0 - iF3;
                    int iXN0 = iF0 * iX3 - iF3 * iX0;
                    int iYN0 = iF0 * iY3 - iF3 * iY0;
                    int iZN0 = iF0 * iZ3 - iF3 * iZ0;
                    int iD1 = iF2 - iF3;
                    int iXN1 = iF2 * iX3 - iF3 * iX2;
                    int iYN1 = iF2 * iY3 - iF3 * iY2;
                    int iZN1 = iF2 * iZ3 - iF3 * iZ2;
                    this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iX1, 1, iY1, 1, iZ1, 1);
                }
            } else if (iF2 < 0) {
                int iD0 = iF2 - iF0;
                int iXN0 = iF2 * iX0 - iF0 * iX2;
                int iYN0 = iF2 * iY0 - iF0 * iY2;
                int iZN0 = iF2 * iZ0 - iF0 * iZ2;
                if (iF3 > 0) {
                    int iD1 = iF2 - iF3;
                    int iXN1 = iF2 * iX3 - iF3 * iX2;
                    int iYN1 = iF2 * iY3 - iF3 * iY2;
                    int iZN1 = iF2 * iZ3 - iF3 * iZ2;
                    this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iX1, 1, iY1, 1, iZ1, 1);
                } else if (iF3 < 0) {
                    int iD1 = iF0 - iF3;
                    int iXN1 = iF0 * iX3 - iF3 * iX0;
                    int iYN1 = iF0 * iY3 - iF3 * iY0;
                    int iZN1 = iF0 * iZ3 - iF3 * iZ0;
                    this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iX1, 1, iY1, 1, iZ1, 1);
                } else {
                    this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iX1, 1, iY1, 1, iZ1, 1, iX3, 1, iY3, 1, iZ3, 1);
                }
            } else if (iF3 <= 0) {
                if (iF3 < 0) {
                    int iD0 = iF0 - iF3;
                    int iXN0 = iF0 * iX3 - iF3 * iX0;
                    int iYN0 = iF0 * iY3 - iF3 * iY0;
                    int iZN0 = iF0 * iZ3 - iF3 * iZ0;
                    this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iX1, 1, iY1, 1, iZ1, 1, iX2, 1, iY2, 1, iZ2, 1);
                } else {
                    this.addTriangle(iX1, 1, iY1, 1, iZ1, 1, iX2, 1, iY2, 1, iZ2, 1, iX3, 1, iY3, 1, iZ3, 1);
                }
            }
        } else if (iF1 != 0) {
            if (iF1 < 0) {
                iF1 = -iF1;
                iF2 = -iF2;
                iF3 = -iF3;
            }
            if (iF2 > 0) {
                if (iF3 <= 0 && iF3 < 0) {
                    int iD0 = iF2 - iF3;
                    int iXN0 = iF2 * iX3 - iF3 * iX2;
                    int iYN0 = iF2 * iY3 - iF3 * iY2;
                    int iZN0 = iF2 * iZ3 - iF3 * iZ2;
                    int iD1 = iF1 - iF3;
                    int iXN1 = iF1 * iX3 - iF3 * iX1;
                    int iYN1 = iF1 * iY3 - iF3 * iY1;
                    int iZN1 = iF1 * iZ3 - iF3 * iZ1;
                    this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iX0, 1, iY0, 1, iZ0, 1);
                }
            } else if (iF2 < 0) {
                int iD0 = iF2 - iF1;
                int iXN0 = iF2 * iX1 - iF1 * iX2;
                int iYN0 = iF2 * iY1 - iF1 * iY2;
                int iZN0 = iF2 * iZ1 - iF1 * iZ2;
                if (iF3 > 0) {
                    int iD1 = iF2 - iF3;
                    int iXN1 = iF2 * iX3 - iF3 * iX2;
                    int iYN1 = iF2 * iY3 - iF3 * iY2;
                    int iZN1 = iF2 * iZ3 - iF3 * iZ2;
                    this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iX0, 1, iY0, 1, iZ0, 1);
                } else if (iF3 < 0) {
                    int iD1 = iF1 - iF3;
                    int iXN1 = iF1 * iX3 - iF3 * iX1;
                    int iYN1 = iF1 * iY3 - iF3 * iY1;
                    int iZN1 = iF1 * iZ3 - iF3 * iZ1;
                    this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iXN1, iD1, iYN1, iD1, iZN1, iD1, iX0, 1, iY0, 1, iZ0, 1);
                } else {
                    this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iX0, 1, iY0, 1, iZ0, 1, iX3, 1, iY3, 1, iZ3, 1);
                }
            } else if (iF3 <= 0) {
                if (iF3 < 0) {
                    int iD0 = iF1 - iF3;
                    int iXN0 = iF1 * iX3 - iF3 * iX1;
                    int iYN0 = iF1 * iY3 - iF3 * iY1;
                    int iZN0 = iF1 * iZ3 - iF3 * iZ1;
                    this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iX0, 1, iY0, 1, iZ0, 1, iX2, 1, iY2, 1, iZ2, 1);
                } else {
                    this.addTriangle(iX0, 1, iY0, 1, iZ0, 1, iX2, 1, iY2, 1, iZ2, 1, iX3, 1, iY3, 1, iZ3, 1);
                }
            }
        } else if (iF2 != 0) {
            if (iF2 < 0) {
                iF2 = -iF2;
                iF3 = -iF3;
            }
            if (iF3 <= 0) {
                if (iF3 < 0) {
                    int iD0 = iF2 - iF3;
                    int iXN0 = iF2 * iX3 - iF3 * iX2;
                    int iYN0 = iF2 * iY3 - iF3 * iY2;
                    int iZN0 = iF2 * iZ3 - iF3 * iZ2;
                    this.addTriangle(iXN0, iD0, iYN0, iD0, iZN0, iD0, iX0, 1, iY0, 1, iZ0, 1, iX1, 1, iY1, 1, iZ1, 1);
                } else {
                    this.addTriangle(iX0, 1, iY0, 1, iZ0, 1, iX1, 1, iY1, 1, iZ1, 1, iX3, 1, iY3, 1, iZ3, 1);
                }
            }
        } else if (iF3 != 0) {
            this.addTriangle(iX0, 1, iY0, 1, iZ0, 1, iX1, 1, iY1, 1, iZ1, 1, iX2, 1, iY2, 1, iZ2, 1);
        } else {
            this.addTriangle(iX0, 1, iY0, 1, iZ0, 1, iX1, 1, iY1, 1, iZ1, 1, iX2, 1, iY2, 1, iZ2, 1);
            this.addTriangle(iX0, 1, iY0, 1, iZ0, 1, iX1, 1, iY1, 1, iZ1, 1, iX3, 1, iY3, 1, iZ3, 1);
            this.addTriangle(iX0, 1, iY0, 1, iZ0, 1, iX2, 1, iY2, 1, iZ2, 1, iX3, 1, iY3, 1, iZ3, 1);
            this.addTriangle(iX1, 1, iY1, 1, iZ1, 1, iX2, 1, iY2, 1, iZ2, 1, iX3, 1, iY3, 1, iZ3, 1);
        }
    }

    protected class Vertex {
        public int m_iXNumer;
        public int m_iXDenom;
        public int m_iYNumer;
        public int m_iYDenom;
        public int m_iZNumer;
        public int m_iZDenom;

        public Vertex() {
            this.m_iXNumer = 0;
            this.m_iXDenom = 0;
            this.m_iYNumer = 0;
            this.m_iYDenom = 0;
            this.m_iZNumer = 0;
            this.m_iZDenom = 0;
        }

        public Vertex(int iXNumer, int iXDenom, int iYNumer, int iYDenom, int iZNumer, int iZDenom) {
            if (iXDenom > 0) {
                this.m_iXNumer = iXNumer;
                this.m_iXDenom = iXDenom;
            } else {
                this.m_iXNumer = -iXNumer;
                this.m_iXDenom = -iXDenom;
            }
            if (iYDenom > 0) {
                this.m_iYNumer = iYNumer;
                this.m_iYDenom = iYDenom;
            } else {
                this.m_iYNumer = -iYNumer;
                this.m_iYDenom = -iYDenom;
            }
            if (iZDenom > 0) {
                this.m_iZNumer = iZNumer;
                this.m_iZDenom = iZDenom;
            } else {
                this.m_iZNumer = -iZNumer;
                this.m_iZDenom = -iZDenom;
            }
        }

        public boolean equals(Object kObject) {
            Vertex kV = (Vertex)kObject;
            return this.m_iXNumer * kV.m_iXDenom == this.m_iXDenom * kV.m_iXNumer && this.m_iYNumer * kV.m_iYDenom == this.m_iYDenom * kV.m_iYNumer && this.m_iZNumer * kV.m_iZDenom == this.m_iZDenom * kV.m_iZNumer;
        }

        public int hashCode() {
            int iXPair = this.m_iXNumer << 16 | this.m_iXDenom;
            int iYPair = this.m_iYNumer << 16 | this.m_iYDenom;
            int iZPair = this.m_iZNumer << 16 | this.m_iZDenom;
            return iXPair ^ iYPair ^ iZPair;
        }
    }

    protected class Triangle {
        public int m_iV0;
        public int m_iV1;
        public int m_iV2;

        public Triangle() {
            this.m_iV0 = -1;
            this.m_iV1 = -1;
            this.m_iV2 = -1;
        }

        public Triangle(int iV0, int iV1, int iV2) {
            if (iV0 < iV1) {
                if (iV0 < iV2) {
                    this.m_iV0 = iV0;
                    this.m_iV1 = iV1;
                    this.m_iV2 = iV2;
                } else {
                    this.m_iV0 = iV2;
                    this.m_iV1 = iV0;
                    this.m_iV2 = iV1;
                }
            } else if (iV1 < iV2) {
                this.m_iV0 = iV1;
                this.m_iV1 = iV2;
                this.m_iV2 = iV0;
            } else {
                this.m_iV0 = iV2;
                this.m_iV1 = iV0;
                this.m_iV2 = iV1;
            }
        }

        public boolean equals(Object kObject) {
            Triangle kT = (Triangle)kObject;
            return this.m_iV0 == kT.m_iV0 && (this.m_iV1 == kT.m_iV1 && this.m_iV2 == kT.m_iV2 || this.m_iV1 == kT.m_iV2 && this.m_iV2 == kT.m_iV1);
        }

        public int hashCode() {
            int iCmp = this.m_iV1 < this.m_iV2 ? this.m_iV2 << 8 ^ (this.m_iV0 << 16 | this.m_iV1) : this.m_iV1 << 8 ^ (this.m_iV0 << 16 | this.m_iV2);
            return iCmp;
        }
    }
}

