/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibRenderers.OpenGLRenderer;

import WildMagic.LibGraphics.Rendering.FrameBuffer;
import WildMagic.LibGraphics.Rendering.GraphicsImage;
import WildMagic.LibGraphics.Rendering.Renderer;
import WildMagic.LibGraphics.Rendering.ResourceIdentifier;
import WildMagic.LibGraphics.Rendering.Texture;
import WildMagic.LibRenderers.OpenGLRenderer.OpenGLRenderer;
import WildMagic.LibRenderers.OpenGLRenderer.TextureID;
import javax.media.opengl.GL3bc;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLException;

public class OpenGLFrameBuffer
extends FrameBuffer {
    private static final long serialVersionUID = 4607482103901610301L;
    protected int m_uiFrameBufferID;
    protected int m_uiDepthBufferID;
    protected int[] m_auiTargetID;
    private GL3bc m_kGL = null;
    private static int[] ms_aDrawBuffers = new int[]{36064, 36065, 36066, 36067, 36068, 36069, 36070};

    public OpenGLFrameBuffer(FrameBuffer.FormatType eFormat, FrameBuffer.DepthType eDepth, FrameBuffer.StencilType eStencil, FrameBuffer.BufferingType eBuffering, FrameBuffer.MultisamplingType eMultisampling, Renderer pkRenderer, GLAutoDrawable drawable) {
        super(eFormat, eDepth, eStencil, eBuffering, eMultisampling, pkRenderer, null);
        this.SetDrawable(drawable);
    }

    public void ClearDrawable() {
        this.m_kGL = null;
    }

    @Override
    public void Disable() {
        OpenGLRenderer pkRenderer = (OpenGLRenderer)this.m_pkRenderer;
        this.m_kGL.glBindFramebuffer(36160, 0);
        this.m_kGL.glBindRenderbuffer(36161, 0);
        this.m_kGL.glDrawBuffer(pkRenderer.GetDrawBuffer());
        for (int i = 0; i < this.m_apkTarget.length; ++i) {
            Texture.Type eSType = this.m_apkTarget[i].GetType();
            int eTarget = OpenGLRenderer.ms_aeSamplerTypes[eSType.Value()];
            this.m_kGL.glBindTexture(eTarget, this.m_auiTargetID[i]);
        }
    }

    @Override
    public void dispose() {
        this.m_kGL = null;
        super.dispose();
    }

    @Override
    public void DrawBuffers(int[] aiSet) {
        int[] aiBuffers = new int[aiSet.length];
        for (int i = 0; i < aiSet.length; ++i) {
            aiBuffers[i] = ms_aDrawBuffers[aiSet[i]];
        }
        this.m_kGL.glDrawBuffers(aiSet.length, aiBuffers, 0);
    }

    @Override
    public void Enable() {
        GraphicsImage[] apkImage = new GraphicsImage[this.m_apkTarget.length];
        int[] aeTarget = new int[this.m_apkTarget.length];
        for (int i = 0; i < this.m_apkTarget.length; ++i) {
            apkImage[i] = this.m_apkTarget[i].GetImage();
            ResourceIdentifier pkID = this.m_apkTarget[i].GetIdentifier(this.m_pkRenderer);
            assert (pkID != null);
            TextureID pkResource = (TextureID)pkID;
            this.m_auiTargetID[i] = pkResource.ID;
            Texture.Type eSType = this.m_apkTarget[i].GetType();
            aeTarget[i] = OpenGLRenderer.ms_aeSamplerTypes[eSType.Value()];
            this.m_kGL.glBindTexture(aeTarget[i], this.m_auiTargetID[i]);
        }
        this.m_kGL.glBindFramebuffer(36160, this.m_uiFrameBufferID);
        this.m_kGL.glBindRenderbuffer(36161, this.m_uiDepthBufferID);
        this.m_kGL.glDrawBuffers(this.m_apkTarget.length, ms_aDrawBuffers, 0);
    }

    public boolean InitializeBuffer() {
        GraphicsImage[] apkImage = new GraphicsImage[this.m_apkTarget.length];
        int[] aeTarget = new int[this.m_apkTarget.length];
        this.m_auiTargetID = new int[this.m_apkTarget.length];
        for (int i = 0; i < this.m_apkTarget.length; ++i) {
            apkImage[i] = this.m_apkTarget[i].GetImage();
            if (apkImage[i].IsCubeImage()) {
                return false;
            }
            ResourceIdentifier pkID = this.m_apkTarget[i].GetIdentifier(this.m_pkRenderer);
            assert (pkID != null);
            TextureID pkResource = (TextureID)pkID;
            this.m_auiTargetID[i] = pkResource.ID;
            Texture.Type eSType = this.m_apkTarget[i].GetType();
            aeTarget[i] = OpenGLRenderer.ms_aeSamplerTypes[eSType.Value()];
            this.m_kGL.glBindTexture(aeTarget[i], this.m_auiTargetID[i]);
        }
        int[] aiParams = new int[1];
        this.m_kGL.glGenFramebuffers(1, aiParams, 0);
        this.m_uiFrameBufferID = aiParams[0];
        this.m_kGL.glBindFramebuffer(36160, this.m_uiFrameBufferID);
        this.m_kGL.glGenRenderbuffers(1, aiParams, 0);
        this.m_uiDepthBufferID = aiParams[0];
        this.m_kGL.glBindRenderbuffer(36161, this.m_uiDepthBufferID);
        this.m_kGL.glRenderbufferStorage(36161, 6402, apkImage[0].GetBound(0), apkImage[0].GetBound(1));
        this.m_kGL.glFramebufferRenderbuffer(36160, 36096, 36161, this.m_uiDepthBufferID);
        for (int i = 0; i < this.m_apkTarget.length; ++i) {
            if (!this.m_apkTarget[i].IsDepthTexture()) {
                if (apkImage[i].GetDimension() == 2) {
                    this.m_kGL.glFramebufferTexture2D(36160, 36064 + i, 3553, this.m_auiTargetID[i], 0);
                    continue;
                }
                if (apkImage[i].GetDimension() != 3) continue;
                this.m_kGL.glFramebufferTexture3D(36160, 36064 + i, 32879, this.m_auiTargetID[i], 0, 0);
                continue;
            }
            this.m_kGL.glFramebufferTexture2D(36160, 36096, 3553, this.m_auiTargetID[i], 0);
            this.m_kGL.glDrawBuffer(0);
            this.m_kGL.glReadBuffer(0);
        }
        int uiStatus = this.m_kGL.glCheckFramebufferStatus(36160);
        switch (uiStatus) {
            case 36053: {
                for (int i = 0; i < this.m_apkTarget.length; ++i) {
                    this.m_kGL.glBindTexture(aeTarget[i], 0);
                }
                this.m_kGL.glBindFramebuffer(36160, 0);
                this.m_kGL.glBindRenderbuffer(36161, 0);
                return true;
            }
            case 36054: {
                System.err.println("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
                break;
            }
            case 36055: {
                System.err.println("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT");
                break;
            }
            case 36057: {
                System.err.println("GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT");
                break;
            }
            case 36058: {
                System.err.println("GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT");
                break;
            }
            case 36059: {
                System.err.println("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT");
                break;
            }
            case 36060: {
                System.err.println("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT");
                break;
            }
            case 36061: {
                System.err.println("GL_FRAMEBUFFER_UNSUPPORTED_EXT");
                break;
            }
            default: {
                System.err.println("FBO not OK");
            }
        }
        assert (false);
        return false;
    }

    public boolean InitializeBuffer(Texture[] apkTarget) {
        int[] aiParams = new int[1];
        this.m_apkTarget = apkTarget;
        GraphicsImage[] apkImage = new GraphicsImage[this.m_apkTarget.length];
        int[] aeTarget = new int[this.m_apkTarget.length];
        this.m_auiTargetID = new int[this.m_apkTarget.length];
        for (int i = 0; i < this.m_apkTarget.length; ++i) {
            apkImage[i] = this.m_apkTarget[i].GetImage();
            ResourceIdentifier pkID = this.m_apkTarget[i].GetIdentifier(this.m_pkRenderer);
            assert (pkID != null);
            TextureID pkResource = (TextureID)pkID;
            this.m_auiTargetID[i] = pkResource.ID;
            Texture.Type eSType = this.m_apkTarget[i].GetType();
            aeTarget[i] = OpenGLRenderer.ms_aeSamplerTypes[eSType.Value()];
            this.m_kGL.glBindTexture(aeTarget[i], this.m_auiTargetID[i]);
        }
        this.m_kGL.glGenFramebuffers(1, aiParams, 0);
        this.m_uiFrameBufferID = aiParams[0];
        try {
            this.m_kGL.glBindFramebuffer(36160, this.m_uiFrameBufferID);
        }
        catch (GLException e) {
            this.m_kGL.glGenFramebuffers(1, aiParams, 0);
            this.m_uiFrameBufferID = aiParams[0];
            this.m_kGL.glBindFramebuffer(36160, this.m_uiFrameBufferID);
        }
        this.m_kGL.glGenRenderbuffers(1, aiParams, 0);
        this.m_uiDepthBufferID = aiParams[0];
        this.m_kGL.glBindRenderbuffer(36161, this.m_uiDepthBufferID);
        this.m_kGL.glRenderbufferStorage(36161, 6402, apkImage[0].GetBound(0), apkImage[0].GetBound(1));
        this.m_kGL.glFramebufferRenderbuffer(36160, 36096, 36161, this.m_uiDepthBufferID);
        for (int i = 0; i < this.m_apkTarget.length; ++i) {
            if (!this.m_apkTarget[i].IsDepthTexture()) {
                if (apkImage[i].GetDimension() == 2) {
                    this.m_kGL.glFramebufferTexture2D(36160, ms_aDrawBuffers[i], 3553, this.m_auiTargetID[i], 0);
                    continue;
                }
                if (apkImage[i].GetDimension() != 3) continue;
                this.m_kGL.glFramebufferTexture3D(36160, ms_aDrawBuffers[i], 32879, this.m_auiTargetID[i], 0, 0);
                continue;
            }
            this.m_kGL.glFramebufferTexture2D(36160, 36096, 3553, this.m_auiTargetID[i], 0);
            this.m_kGL.glDrawBuffer(0);
            this.m_kGL.glReadBuffer(0);
        }
        int uiStatus = this.m_kGL.glCheckFramebufferStatus(36160);
        switch (uiStatus) {
            case 36053: {
                this.m_kGL.glBindFramebuffer(36160, 0);
                for (int i = 0; i < this.m_apkTarget.length; ++i) {
                    this.m_kGL.glBindTexture(aeTarget[i], 0);
                }
                this.m_kGL.glBindRenderbuffer(36161, 0);
                return true;
            }
            case 36054: {
                System.err.println("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
                break;
            }
            case 36055: {
                System.err.println("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT");
                break;
            }
            case 36057: {
                System.err.println("GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT");
                break;
            }
            case 36058: {
                System.err.println("GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT");
                break;
            }
            case 36059: {
                System.err.println("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT");
                break;
            }
            case 36060: {
                System.err.println("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT");
                break;
            }
            case 36061: {
                System.err.println("GL_FRAMEBUFFER_UNSUPPORTED_EXT");
                break;
            }
            default: {
                System.err.println("FBO not OK");
            }
        }
        assert (false);
        return false;
    }

    public void SetDrawable(GLAutoDrawable drawable) {
        this.m_kGL = drawable.getGL().getGL3bc();
    }

    public void SetZOffset(int iZOffset) {
        for (int i = 0; i < this.m_apkTarget.length; ++i) {
            if (this.m_apkTarget[i].IsDepthTexture() || this.m_apkTarget[i].GetImage().GetDimension() != 3) continue;
            this.m_kGL.glFramebufferTexture3D(36160, 36064 + i, 32879, this.m_auiTargetID[i], 0, iZOffset);
        }
    }

    public void TerminateBuffer() {
        int[] aiParams = new int[]{this.m_uiDepthBufferID};
        this.m_kGL.glDeleteRenderbuffers(1, aiParams, 0);
        aiParams[0] = this.m_uiFrameBufferID;
        this.m_kGL.glDeleteFramebuffers(1, aiParams, 0);
        for (int i = 0; i < this.m_apkTarget.length; ++i) {
            if (!this.m_apkTarget[i].IsDepthTexture()) continue;
            aiParams[0] = this.m_auiTargetID[i];
            this.m_kGL.glDeleteRenderbuffers(1, aiParams, 0);
        }
    }
}

