/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.transparency;

import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleStripArray;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.utils.scenegraph.transparency.TransparencyOrderController;
import org.jdesktop.j3d.utils.scenegraph.transparency.TransparencyOrderedGroup;

public class TransparencyOrderedGroupTest
extends JFrame {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private JPanel drawingPanel;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JSlider jSlider1;
    private JSlider jSlider2;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        objRoot.addChild((Node)this.createTest2());
        return objRoot;
    }

    private Group createTest3() {
        BranchGroup bg = new BranchGroup();
        TransparencyOrderedGroup tog = new TransparencyOrderedGroup();
        tog.setCapability(14);
        tog.setCapability(13);
        bg.addChild((Node)tog);
        tog.addChild(this.createShape(0.0f, 0.0f, 0.0f, 1.0f, null, "c1"));
        tog.addChild(this.createShape(0.0f, 0.0f, 0.0f, 1.0f, null, "c2"));
        tog.addChild(this.createShape(0.0f, 0.0f, 0.0f, 1.0f, null, "c3"));
        tog.addChild(this.createShape(0.0f, 0.0f, 0.0f, 1.0f, null, "c4"));
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[2] = 1;
        tog.setChildIndexOrder(nArray);
        this.univ.addBranchGraph(bg);
        tog.addChild(this.createShape(0.0f, 0.0f, 0.0f, 1.0f, null, "i1"));
        int[] io = tog.getChildIndexOrder();
        int i = 0;
        while (i < io.length) {
            System.out.println(String.valueOf(io[i]) + " " + tog.getChild(i).getName());
            ++i;
        }
        return null;
    }

    private Group createTest2() {
        BranchGroup bg = new BranchGroup();
        BranchGroup bg2 = new BranchGroup();
        Appearance app = new Appearance();
        final TransparencyAttributes transparencyAttr = new TransparencyAttributes();
        transparencyAttr.setTransparency((float)this.jSlider1.getValue() / 100.0f);
        transparencyAttr.setTransparencyMode(0);
        transparencyAttr.setCapability(3);
        app.setTransparencyAttributes(transparencyAttr);
        this.jSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                transparencyAttr.setTransparency((float)TransparencyOrderedGroupTest.this.jSlider1.getValue() / 100.0f);
            }
        });
        Appearance app2 = new Appearance();
        final TransparencyAttributes transparencyAttr2 = new TransparencyAttributes();
        transparencyAttr2.setTransparency(0.5f);
        transparencyAttr2.setTransparencyMode(0);
        transparencyAttr2.setCapability(3);
        app2.setTransparencyAttributes(transparencyAttr2);
        ColoringAttributes colorAttr = new ColoringAttributes();
        colorAttr.setColor(1.0f, 0.0f, 0.0f);
        app2.setColoringAttributes(colorAttr);
        this.jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                transparencyAttr2.setTransparency((float)TransparencyOrderedGroupTest.this.jSlider2.getValue() / 100.0f);
            }
        });
        Appearance app3 = new Appearance();
        ColoringAttributes colorAttr2 = new ColoringAttributes();
        colorAttr2.setColor(0.0f, 1.0f, 0.0f);
        app3.setColoringAttributes(colorAttr2);
        Appearance app4 = new Appearance();
        TransparencyAttributes transparencyAttr3 = new TransparencyAttributes();
        transparencyAttr3.setTransparency(0.5f);
        transparencyAttr3.setTransparencyMode(0);
        transparencyAttr3.setCapability(3);
        app4.setTransparencyAttributes(transparencyAttr3);
        ColoringAttributes colorAttr3 = new ColoringAttributes();
        colorAttr3.setColor(1.0f, 1.0f, 0.0f);
        app4.setColoringAttributes(colorAttr3);
        bg2.addChild(this.createShape(0.3f, 0.3f, 0.5f, 0.1f, app2, "right"));
        bg2.addChild(this.createShape(-0.3f, 0.3f, 0.5f, 0.1f, app2, "left"));
        bg2.addChild(this.createShape(0.3f, -0.3f, 0.5f, 0.1f, app3, "solid"));
        TransparencyOrderedGroup tog2 = new TransparencyOrderedGroup();
        tog2.addChild(this.createShape(0.39f, 0.3f, 0.55f, 0.05f, app4, null));
        tog2.addChild((Node)bg2);
        final TransparencyOrderedGroup tog = new TransparencyOrderedGroup();
        tog.addChild((Node)tog2);
        tog.addChild(this.createShape(0.0f, 0.0f, 0.0f, 0.6f, app, "BigBox"));
        int[] nArray = new int[2];
        nArray[1] = 1;
        tog.setChildIndexOrder(nArray);
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] order = tog.getChildIndexOrder();
                int tmp = order[0];
                order[0] = order[1];
                order[1] = tmp;
                tog.setChildIndexOrder(order);
            }
        });
        bg.addChild((Node)tog);
        Appearance bApp = new Appearance();
        ColoringAttributes bClr = new ColoringAttributes();
        bClr.setColor(0.0f, 0.0f, 1.0f);
        bApp.setColoringAttributes(bClr);
        bg.addChild(this.createShape(0.0f, 0.0f, -1.0f, 0.6f, bApp, "background"));
        return bg;
    }

    private Node createShape(float x, float y, float z, float size, Appearance app, String name) {
        BranchGroup bg = new BranchGroup();
        bg.setName("bg-" + name);
        bg.setCapability(17);
        Transform3D t3d = new Transform3D();
        t3d.setTranslation(new Vector3f(x, y, z));
        TransformGroup tg = new TransformGroup(t3d);
        tg.setName("tg-" + name);
        TriangleStripArray geom = new TriangleStripArray(4, 1, new int[]{4});
        float s = size;
        geom.setCoordinates(0, new float[]{-s, -s, 0.0f, s, -s, 0.0f, -s, s, 0.0f, s, s, 0.0f});
        Shape3D shape = new Shape3D((Geometry)geom, app);
        shape.setName(name);
        tg.addChild((Node)shape);
        bg.addChild((Node)tg);
        return bg;
    }

    private Group createTest1() {
        TransparencyOrderedGroup tog1 = new TransparencyOrderedGroup();
        tog1.setName("tog1");
        TransparencyOrderedGroup tog2 = new TransparencyOrderedGroup();
        tog2.setName("tog2");
        BranchGroup bg = new BranchGroup();
        Shape3D s1 = new Shape3D();
        s1.setName("s1");
        Shape3D s2 = new Shape3D();
        s2.setName("s2");
        Shape3D s3 = new Shape3D();
        s3.setName("s3");
        Shape3D s4 = new Shape3D();
        s4.setName("s4");
        BranchGroup bg2 = new BranchGroup();
        bg2.addChild((Node)s1);
        tog2.addChild((Node)bg2);
        tog2.addChild((Node)s2);
        tog1.addChild((Node)s3);
        tog1.addChild((Node)bg);
        tog1.addChild((Node)tog2);
        bg.addChild((Node)s4);
        return tog1;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        this.univ.addBranchGraph((BranchGroup)new TransparencyOrderController(this.univ.getViewer().getView()));
        return c;
    }

    public TransparencyOrderedGroupTest() {
        this.initComponents();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jLabel2 = new JLabel();
        this.jSlider2 = new JSlider();
        this.jCheckBox1 = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("HelloUniverse");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(500, 500));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("White Transparency");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jSlider1.setValue(20);
        this.jPanel1.add((Component)this.jSlider1, new GridBagConstraints());
        this.jLabel2.setText("Red Transparency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jSlider2, gridBagConstraints);
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("White Quad In Front");
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jCheckBox1, gridBagConstraints);
        this.drawingPanel.add((Component)this.jPanel1, "South");
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TransparencyOrderedGroupTest().setVisible(true);
            }
        });
    }
}

