/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.collada;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.collada.colladaschema.Asset;
import org.collada.colladaschema.COLLADA;
import org.collada.colladaschema.UpAxisType;
import org.jdesktop.j3d.loaders.collada.xml_walker.ElementCache;
import org.jdesktop.j3d.loaders.collada.xml_walker.Processor;
import org.jdesktop.j3d.loaders.collada.xml_walker.ProcessorFactory;

public class Collada14Loader
extends LoaderBase {
    public static final String COLLADA_LOADER = "collada.loader";
    private float scale = 1.0f;
    private boolean zUp = false;
    private JAXBContext jaxbContext;

    public Collada14Loader() {
        if (Logger.getLogger(COLLADA_LOADER).getLevel() == null) {
            Logger.getLogger(COLLADA_LOADER).setLevel(Level.WARNING);
        }
    }

    public boolean isZUp() {
        return this.zUp;
    }

    public float getScale() {
        return this.scale;
    }

    public Scene load(String filename) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        try {
            Unmarshaller unmarshaller = this.getJaxbContext().createUnmarshaller();
            File file = new File(filename);
            COLLADA collada = (COLLADA)unmarshaller.unmarshal(file);
            ElementCache.cache().setLoadingURL(file.toURI().toURL());
            return this.doLoad(collada);
        }
        catch (JAXBException ex) {
            Logger.getLogger(COLLADA_LOADER).log(Level.SEVERE, null, ex);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext != null) {
            return this.jaxbContext;
        }
        this.jaxbContext = JAXBContext.newInstance((String)"org.collada.colladaschema");
        return this.jaxbContext;
    }

    public Scene load(URL url) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        try {
            ElementCache.cache().setLoadingURL(url);
            Unmarshaller unmarshaller = this.getJaxbContext().createUnmarshaller();
            COLLADA collada = (COLLADA)unmarshaller.unmarshal(url);
            return this.doLoad(collada);
        }
        catch (JAXBException ex) {
            Logger.getLogger(COLLADA_LOADER).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Scene load(Reader arg0) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        throw new UnsupportedOperationException("Not supported.");
    }

    private Scene doLoad(COLLADA collada) {
        Logger.getLogger(COLLADA_LOADER).log(Level.WARNING, "Collada Schema Version " + collada.getVersion());
        Asset asset = collada.getAsset();
        Asset.Unit unit = asset.getUnit();
        UpAxisType upAxis = asset.getUpAxis();
        if (unit != null) {
            this.scale = (float)unit.getMeter();
            Logger.getLogger(COLLADA_LOADER).log(Level.WARNING, "Units: " + unit.getName() + "; Java3D scale factor is " + unit.getMeter());
        }
        if (upAxis != null) {
            if (upAxis == UpAxisType.Z_UP) {
                this.zUp = true;
            }
            Logger.getLogger(COLLADA_LOADER).log(Level.WARNING, "Up Axis is " + (Object)((Object)upAxis));
        }
        ElementCache.cache().setAsset(asset);
        List<Object> lib = collada.getLibraryLightsAndLibraryGeometriesAndLibraryAnimationClips();
        BranchGroup root = new BranchGroup();
        Processor lgtp = null;
        for (Object o : lib) {
            Processor processor = ProcessorFactory.createProcessor(o, null);
        }
        lgtp = ProcessorFactory.createProcessor(collada.getScene(), null);
        lgtp.create((Node)root);
        if (asset.getUnit() != null) {
            this.scale = (float)asset.getUnit().getMeter();
        }
        SceneBase ret = new SceneBase();
        ret.setSceneGroup(root);
        return ret;
    }
}

