/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.collada.test;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ToolTipManager;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.loaders.collada.Collada14Loader;
import org.jdesktop.j3d.utils.scenegraph.traverser.ChangePolygonAttributes;
import org.jdesktop.j3d.utils.view.ViewUtils;

public class Viewer
extends JFrame {
    private String filename = null;
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private BranchGroup root = null;
    private JMenu View;
    private JPanel drawingPanel;
    private JMenuItem exitMI;
    private JMenu fileMenu;
    private JMenuBar jMenuBar1;
    private JMenuItem loadMI;
    private JRadioButtonMenuItem polygonFillMI;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.7);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objTrans.setCapability(17);
        objScale.addChild((Node)objTrans);
        Collada14Loader collada = new Collada14Loader();
        Scene s = null;
        try {
            s = collada.load(this.filename);
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            System.exit(1);
        }
        objTrans.addChild((Node)s.getSceneGroup());
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 500.0);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.5f);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds((Bounds)bounds);
        objRoot.addChild((Node)bgNode);
        return objRoot;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas3d = new Canvas3D(config);
        this.univ = new SimpleUniverse(canvas3d);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
        ViewingPlatform viewingPlatform = this.univ.getViewingPlatform();
        PlatformGeometry pg = new PlatformGeometry();
        Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds((Bounds)bounds);
        pg.addChild((Node)ambientLightNode);
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(1.0f, 1.0f, 1.0f);
        Color3f light2Color = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3f light2Direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)bounds);
        pg.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)bounds);
        pg.addChild((Node)light2);
        viewingPlatform.setPlatformGeometry(pg);
        double fov = viewingPlatform.getViewers()[0].getView().getFieldOfView();
        TransformGroup viewTG = viewingPlatform.getViewPlatformTransform();
        double distance = ViewUtils.setViewpoint(viewTG, this.scene.getBounds(), fov, ViewUtils.Axis.POSITIVE_Z_AXIS);
        viewingPlatform.getViewers()[0].getView().setBackClipDistance(distance * 1.25);
        Transform3D t3d = new Transform3D();
        viewTG.getTransform(t3d);
        System.out.println("Set tg " + t3d);
        OrbitBehavior orbit = new OrbitBehavior(canvas3d, 112);
        orbit.setSchedulingBounds((Bounds)bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        return canvas3d;
    }

    private void usage() {
    }

    public Viewer(String[] args) {
        if (args.length != 0) {
            int i = 0;
            while (i < args.length) {
                args[i].startsWith("-");
                ++i;
            }
        }
        if (this.filename == null) {
            this.filename = "collada/samples/basic_samples/Cube/cube_triangulate.dae";
            this.filename = "collada/samples/basic_samples/Duck/duck_triangulate.dae";
            if (this.filename == null) {
                System.err.println("Must provide a file to load");
                System.exit(1);
            }
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.initComponents();
        this.scene = this.createSceneGraph();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.root = new BranchGroup();
        this.root.setCapability(14);
        this.root.setCapability(12);
        this.root.setCapability(13);
        this.root.addChild((Node)this.scene);
        this.scene.setCapability(17);
        this.univ.addBranchGraph(this.root);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.loadMI = new JMenuItem();
        this.exitMI = new JMenuItem();
        this.View = new JMenu();
        this.polygonFillMI = new JRadioButtonMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("ObjLoad");
        this.drawingPanel.setPreferredSize(new Dimension(700, 700));
        this.drawingPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.fileMenu.setText("File");
        this.loadMI.setText("Load...");
        this.loadMI.setEnabled(false);
        this.loadMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Viewer.this.loadMIActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadMI);
        this.exitMI.setText("Exit");
        this.exitMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Viewer.this.exitMIActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMI);
        this.jMenuBar1.add(this.fileMenu);
        this.View.setText("View");
        this.polygonFillMI.setSelected(true);
        this.polygonFillMI.setText("Polygon Fill");
        this.polygonFillMI.setToolTipText("Select Filled or edge only rendering");
        this.polygonFillMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Viewer.this.polygonFillMIActionPerformed(evt);
            }
        });
        this.View.add(this.polygonFillMI);
        this.jMenuBar1.add(this.View);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void loadMIActionPerformed(ActionEvent evt) {
    }

    private void polygonFillMIActionPerformed(ActionEvent evt) {
        int mode = this.polygonFillMI.isSelected() ? 2 : 1;
        this.root.removeChild((Node)this.scene);
        ChangePolygonAttributes.setPolygonMode((Node)this.scene, mode, true);
        this.root.addChild((Node)this.scene);
    }

    private void exitMIActionPerformed(ActionEvent evt) {
        System.exit(1);
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Viewer viewer = new Viewer(args);
                viewer.setVisible(true);
            }
        });
    }
}

