/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.collada.xml_walker;

import java.util.ArrayList;
import java.util.List;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import org.collada.colladaschema.Mesh;
import org.collada.colladaschema.Source;
import org.jdesktop.j3d.loaders.collada.xml_walker.Primitive;
import org.jdesktop.j3d.loaders.collada.xml_walker.Processor;
import org.jdesktop.j3d.loaders.collada.xml_walker.ProcessorFactory;

public class MeshProcessor
extends Processor {
    private ArrayList<Primitive> primProcessors = new ArrayList();

    public MeshProcessor(Mesh mesh, Processor parent) {
        super(mesh, parent);
        this.logger.info("Processing Mesh");
        List<Source> sources = mesh.getSources();
        for (Source s : sources) {
            ProcessorFactory.createProcessor(s, this);
        }
        ProcessorFactory.createProcessor(mesh.getVertices(), this);
        List<Object> primitives = mesh.getTrianglesAndLinestripsAndPolygons();
        for (Object prim : primitives) {
            Primitive p = (Primitive)((Object)ProcessorFactory.createProcessor(prim, this));
            if (p == null) continue;
            this.primProcessors.add(p);
        }
    }

    public void create(Node parent) {
        Group parentGroup = (Group)parent;
        for (Primitive p : this.primProcessors) {
            parentGroup.addChild((Node)p.getShape3D());
        }
    }
}

