/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.collada.xml_walker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import org.collada.colladaschema.InstanceController;
import org.collada.colladaschema.InstanceGeometry;
import org.collada.colladaschema.InstanceWithExtra;
import org.collada.colladaschema.Matrix;
import org.jdesktop.j3d.loaders.collada.xml_walker.ElementCache;
import org.jdesktop.j3d.loaders.collada.xml_walker.Processor;
import org.jdesktop.j3d.loaders.collada.xml_walker.ProcessorFactory;

public class NodeProcessor
extends Processor {
    private ArrayList<Processor> children = new ArrayList();
    private TransformGroup tg = null;

    public NodeProcessor(org.collada.colladaschema.Node node, Processor parent) {
        super(node, parent);
        Object da;
        String id = node.getId();
        if (id != null) {
            ElementCache.cache().put(id, this);
        }
        List<Object> list = node.getTranslatesAndMatrixesAndLookats();
        for (Object object : list) {
            if (!(object instanceof Matrix)) continue;
            Matrix mt = (Matrix)object;
            List<Double> m = mt.getValues();
            da = new double[m.size()];
            int i = 0;
            Iterator<Object> iterator = m.iterator();
            while (iterator.hasNext()) {
                Double d = (Double)iterator.next();
                da[i++] = d;
            }
            Matrix4d m4d = new Matrix4d((double[])da);
            Transform3D t3d = new Transform3D(m4d);
            this.tg = new TransformGroup(t3d);
        }
        List<org.collada.colladaschema.Node> nodes = node.getNodes();
        for (org.collada.colladaschema.Node nodeType : nodes) {
            this.children.add(ProcessorFactory.createProcessor(nodeType, this));
        }
        List<InstanceWithExtra> instanceNodes = node.getInstanceNodes();
        for (InstanceWithExtra nodeType : instanceNodes) {
            this.children.add(ProcessorFactory.createProcessor(nodeType, this));
        }
        List<InstanceGeometry> geometries = node.getInstanceGeometries();
        da = geometries.iterator();
        while (da.hasNext()) {
            InstanceGeometry nodeType = (InstanceGeometry)da.next();
            this.children.add(ProcessorFactory.createProcessor(nodeType, this));
        }
        List<InstanceController> controllers = node.getInstanceControllers();
        for (InstanceController nodeType : controllers) {
            this.children.add(ProcessorFactory.createProcessor(nodeType, this));
        }
        List<InstanceWithExtra> lights = node.getInstanceLights();
        for (InstanceWithExtra nodeType : lights) {
            this.children.add(ProcessorFactory.createProcessor(nodeType, this));
        }
        List<InstanceWithExtra> cameras = node.getInstanceCameras();
        for (InstanceWithExtra nodeType : cameras) {
            this.children.add(ProcessorFactory.createProcessor(nodeType, this));
        }
    }

    public void create(Node parent) {
        Group group;
        if (this.tg != null) {
            if (this.tg.getParent() == null) {
                ((Group)parent).addChild((Node)this.tg);
            }
            parent = this.tg;
        }
        for (Processor p : this.children) {
            p.create(parent);
        }
        if (parent instanceof Group && (group = (Group)parent).numChildren() == 0 && (Group)group.getParent() != null) {
            ((Group)group.getParent()).removeChild((Node)group);
        }
    }
}

