/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.collada.xml_walker;

import java.util.List;
import java.util.logging.Logger;
import javax.vecmath.Tuple3f;
import org.collada.colladaschema.Accessor;
import org.collada.colladaschema.BoolArray;
import org.collada.colladaschema.FloatArray;
import org.collada.colladaschema.IDREFArray;
import org.collada.colladaschema.IntArray;
import org.collada.colladaschema.Mesh;
import org.collada.colladaschema.NameArray;
import org.collada.colladaschema.Source;
import org.jdesktop.j3d.loaders.collada.xml_walker.ElementCache;
import org.jdesktop.j3d.loaders.collada.xml_walker.Processor;
import org.jdesktop.j3d.loaders.collada.xml_walker.ProcessorFactory;

public class SourceProcessor
extends Processor {
    private Logger logger = Logger.getLogger("collada.loader");
    private Source source = null;
    private SourceTypeEnum sourceType = null;
    private float[] processedFloatArray = null;

    public SourceProcessor(Mesh mesh, Processor parent) {
        super(mesh, parent);
        this.logger.info("Processing Mesh ");
        List<Source> sources = mesh.getSources();
        for (Source s : sources) {
            ProcessorFactory.createProcessor(s, this);
        }
        ProcessorFactory.createProcessor(mesh.getVertices(), this);
    }

    public SourceProcessor(Source source, Processor parent) {
        super(source, parent);
        this.logger.info("Processing Source id=" + source.getId() + " name=" + source.getName());
        this.source = source;
        ElementCache.cache().putSource(source.getId(), this);
        BoolArray boolArray = source.getBoolArray();
        FloatArray floatArray = source.getFloatArray();
        IntArray intArray = source.getIntArray();
        NameArray nameArray = source.getNameArray();
        IDREFArray idRefArray = source.getIDREFArray();
        if (boolArray != null) {
            this.logger.info("BoolArray");
        } else if (floatArray != null) {
            List<Double> data = floatArray.getValues();
            this.logger.info("FloatArray " + data.size());
            float[] floatData = new float[data.size()];
            int i = 0;
            for (Double d : data) {
                floatData[i++] = d.floatValue();
            }
            ElementCache.cache().putFloatArray(floatArray.getId(), floatData);
            this.sourceType = SourceTypeEnum.FLOAT_ARRAY;
        } else if (intArray != null) {
            this.logger.info("IntArray ");
        } else if (nameArray != null) {
            this.logger.info("NameArray ");
        } else if (idRefArray != null) {
            this.logger.info("IdRefArray ");
        }
        Source.TechniqueCommon techCommon = source.getTechniqueCommon();
        Accessor accessor = techCommon.getAccessor();
        switch (this.sourceType) {
            case FLOAT_ARRAY: {
                break;
            }
            default: {
                this.logger.warning("Unimplemented SourceType " + (Object)((Object)this.sourceType));
            }
        }
    }

    Tuple3f getTuple3f(Tuple3f result, int index) {
        Source.TechniqueCommon techCommon = this.source.getTechniqueCommon();
        Accessor accessor = techCommon.getAccessor();
        int size = accessor.getCount().intValue();
        int stride = accessor.getStride().intValue();
        int offset = accessor.getOffset().intValue();
        float[] data = ElementCache.cache().getFloatArray(accessor.getSource());
        result.x = data[index += offset];
        result.y = data[index + 1];
        result.z = data[index + 2];
        return result;
    }

    float[] getFloatArray() {
        Source.TechniqueCommon techCommon = this.source.getTechniqueCommon();
        Accessor accessor = techCommon.getAccessor();
        return ElementCache.cache().getFloatArray(accessor.getSource());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SourceTypeEnum {
        BOOL_ARRAY,
        FLOAT_ARRAY,
        INT_ARRAY,
        NAME_ARRAY,
        ID_REF_ARRAY;

    }
}

