/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class GeometryClipper {
    private BoundingBox boundingBox;
    private Point3d upperCorner = new Point3d();
    private Point3d lowerCorner = new Point3d();
    private Vector newTriangles = new Vector();
    private NormalGenerator normalGenerator = new NormalGenerator();
    private Stripifier stripifier = new Stripifier();

    public void clip(GeometryInfo geom, BoundingBox boundingBox) {
        boundingBox.getUpper(this.upperCorner);
        boundingBox.getLower(this.lowerCorner);
        this.newTriangles.clear();
        this.boundingBox = boundingBox;
        geom.convertToIndexedTriangles();
        this.processTriangleArray(geom);
    }

    public BoundingBox createBounds(Shape3D shape) {
        if (!(shape.getGeometry() instanceof GeometryArray)) {
            throw new RuntimeException("Geomtery type not supported " + shape.getGeometry().getClass().getName());
        }
        GeometryArray geom = (GeometryArray)shape.getGeometry();
        double[] coords = new double[geom.getVertexCount() * 3];
        geom.getCoordinates(0, coords);
        if (coords.length < 4) {
            return new BoundingBox(new Point3d(coords[0], coords[1], coords[2]), new Point3d(coords[0], coords[1], coords[2]));
        }
        double lowerX = coords[0];
        double upperX = coords[0];
        double lowerY = coords[1];
        double upperY = coords[1];
        double lowerZ = coords[2];
        double upperZ = coords[2];
        int i = 3;
        while (i < coords.length) {
            lowerX = Math.min(lowerX, coords[i]);
            upperX = Math.max(upperX, coords[i]);
            lowerY = Math.min(lowerY, coords[i + 1]);
            upperY = Math.max(upperY, coords[i + 1]);
            lowerZ = Math.min(lowerZ, coords[i + 2]);
            upperZ = Math.max(upperZ, coords[i + 2]);
            i += 3;
        }
        return new BoundingBox(new Point3d(lowerX, lowerY, lowerZ), new Point3d(upperX, upperY, upperZ));
    }

    private void processTriangleArray(GeometryInfo geom) {
        geom.indexify();
        Point3f[] coords = geom.getCoordinates();
        Object[] colors = geom.getColors();
        Vector3f[] normals = geom.getNormals();
        int[] coordIndices = geom.getCoordinateIndices();
        int[] colorIndices = geom.getColorIndices();
        int numPointsDeleted = 0;
        int i = 0;
        while (i < coordIndices.length) {
            numPointsDeleted += this.clipTriangle(coords, coordIndices, colors, colorIndices, i);
            i += 3;
        }
        this.removeDeletedVertex(geom, coordIndices, colorIndices, numPointsDeleted);
        this.addNewTriangles(geom);
        geom.compact();
        geom.setNormals(null);
        geom.setNormalIndices(null);
        this.normalGenerator.generateNormals(geom);
        this.stripifier.stripify(geom);
    }

    private void printGeom(GeometryInfo geom) {
        Point3f[] coords = geom.getCoordinates();
        int[] indices = geom.getCoordinateIndices();
        int i = 0;
        while (i < indices.length) {
            System.out.println(String.valueOf(indices[i]) + "  " + coords[indices[i]]);
            ++i;
        }
    }

    private void removeDeletedVertex(GeometryInfo geom, int[] coordIndices, int[] colorIndices, int numDeleted) {
        int[] normalIndices = geom.getNormalIndices();
        int[] texCoordIndices = geom.getTextureCoordinateIndices(0);
        int indexSize = coordIndices.length - numDeleted;
        int[] newNormalIndices = null;
        int[] newColorIndices = null;
        int[] newTexCoordIndices = null;
        int[] newCoordIndices = new int[indexSize];
        if (normalIndices != null) {
            newNormalIndices = new int[indexSize];
        }
        if (colorIndices != null) {
            newColorIndices = new int[indexSize];
        }
        if (texCoordIndices != null) {
            newTexCoordIndices = new int[indexSize];
        }
        int j = 0;
        int i = 0;
        while (i < coordIndices.length) {
            if (coordIndices[i] != -1) {
                newCoordIndices[j] = coordIndices[i];
                if (newNormalIndices != null) {
                    newNormalIndices[j] = normalIndices[i];
                }
                if (newColorIndices != null) {
                    newColorIndices[j] = colorIndices[i];
                }
                if (newTexCoordIndices != null) {
                    newTexCoordIndices[j] = texCoordIndices[i];
                }
                ++j;
            }
            ++i;
        }
        geom.setCoordinateIndices(newCoordIndices);
        geom.setNormalIndices(newNormalIndices);
        geom.setColorIndices(newColorIndices);
        geom.setTextureCoordinateIndices(0, newTexCoordIndices);
    }

    private void addNewTriangles(GeometryInfo geom) {
        GeometryInfo newGeom;
        Enumeration e = this.newTriangles.elements();
        int additionalIndices = 0;
        int additionalCoords = 0;
        int additionalColors = 0;
        while (e.hasMoreElements()) {
            newGeom = (GeometryInfo)e.nextElement();
            additionalIndices += newGeom.getCoordinateIndices().length;
            additionalCoords += newGeom.getCoordinates().length;
            if (geom.getColors() == null) continue;
            additionalColors += newGeom.getColors().length;
        }
        Point3f[] newCoords = new Point3f[geom.getCoordinates().length + additionalCoords];
        System.arraycopy(geom.getCoordinates(), 0, newCoords, 0, geom.getCoordinates().length);
        int[] newCoordIndices = new int[geom.getCoordinateIndices().length + additionalIndices];
        System.arraycopy(geom.getCoordinateIndices(), 0, newCoordIndices, 0, geom.getCoordinateIndices().length);
        int[] newColorIndices = null;
        Object[] newColors = null;
        int currentColor = 0;
        int currentColorIndex = 0;
        int currentCoord = geom.getCoordinates().length;
        int currentCoordIndex = geom.getCoordinateIndices().length;
        if (geom.getColors() != null) {
            newColorIndices = new int[newCoordIndices.length];
            System.arraycopy(geom.getColorIndices(), 0, newColorIndices, 0, geom.getColorIndices().length);
            if (geom.getColors()[0] instanceof Color3f) {
                newColors = new Color3f[geom.getColors().length + additionalColors];
            } else if (geom.getColors()[0] instanceof Color4f) {
                newColors = new Color4f[geom.getColors().length + additionalColors];
            } else {
                throw new RuntimeException("Unsupported Color in Geometry ");
            }
            System.arraycopy(geom.getColors(), 0, newColors, 0, geom.getColors().length);
            currentColor = geom.getColors().length;
            currentColorIndex = geom.getColorIndices().length;
        }
        e = this.newTriangles.elements();
        int coordIndicesOffset = geom.getCoordinates().length;
        int colorIndicesOffset = 0;
        if (newColors != null) {
            colorIndicesOffset = geom.getColors().length;
        }
        while (e.hasMoreElements()) {
            newGeom = (GeometryInfo)e.nextElement();
            int length = newGeom.getCoordinates().length;
            System.arraycopy(newGeom.getCoordinates(), 0, newCoords, currentCoord, length);
            currentCoord += length;
            int[] newGeomCoordIndices = newGeom.getCoordinateIndices();
            int i = 0;
            while (i < newGeomCoordIndices.length) {
                newCoordIndices[currentCoordIndex + i] = newGeomCoordIndices[i] + coordIndicesOffset;
                ++i;
            }
            coordIndicesOffset += newGeom.getCoordinates().length;
            currentCoordIndex += newGeomCoordIndices.length;
            if (newColors == null) continue;
            length = newGeom.getColors().length;
            System.arraycopy(newGeom.getColors(), 0, newColors, currentColor, length);
            currentColor += length;
            int[] newGeomColorIndices = newGeom.getColorIndices();
            int i2 = 0;
            while (i2 < newGeomColorIndices.length) {
                newColorIndices[currentColorIndex + i2] = newGeomColorIndices[i2] + colorIndicesOffset;
                ++i2;
            }
            colorIndicesOffset += newGeom.getColors().length;
            currentColorIndex += newGeomColorIndices.length;
        }
        geom.setCoordinates(newCoords);
        geom.setCoordinateIndices(newCoordIndices);
        if (newColors != null) {
            if (newColors[0] instanceof Color3f) {
                geom.setColors((Color3f[])newColors);
            } else {
                geom.setColors((Color4f[])newColors);
            }
            geom.setColorIndices(newColorIndices);
        }
    }

    private int clipTriangle(Point3f[] coords, int[] coordIndices, Object[] colors, int[] colorIndices, int index) {
        Point3f p1 = coords[coordIndices[index]];
        Point3f p2 = coords[coordIndices[index + 1]];
        Point3f p3 = coords[coordIndices[index + 2]];
        Object n1 = null;
        Object n2 = null;
        Object n3 = null;
        Object color1 = null;
        Object color2 = null;
        Object color3 = null;
        if (colors != null) {
            color1 = colors[colorIndices[index]];
            color2 = colors[colorIndices[index + 1]];
            color3 = colors[colorIndices[index + 2]];
        }
        boolean c1 = this.contains(p1);
        boolean c2 = this.contains(p2);
        boolean c3 = this.contains(p3);
        if (c1 && c2 && c3) {
            return 0;
        }
        if (!(c1 || c2 || c3)) {
            coordIndices[index] = -1;
            coordIndices[index + 1] = -1;
            coordIndices[index + 2] = -1;
            return 3;
        }
        Point3f[] newPoints = null;
        Object[] newColors = null;
        if (!c1 && !c2 || !c2 && !c3 || !c3 && !c1) {
            coordIndices[index] = -1;
            coordIndices[index + 1] = -1;
            coordIndices[index + 2] = -1;
            newPoints = new Point3f[3];
            if (!c1 && !c2) {
                newPoints[0] = this.clipLine(p3, p1);
                newPoints[1] = this.clipLine(p3, p2);
                newPoints[2] = p3;
            } else if (!c2 && !c3) {
                newPoints[0] = p1;
                newPoints[1] = this.clipLine(p1, p2);
                newPoints[2] = this.clipLine(p1, p3);
            } else if (!c3 && !c1) {
                newPoints[0] = this.clipLine(p2, p1);
                newPoints[1] = p2;
                newPoints[2] = this.clipLine(p2, p3);
            }
            if (colors != null) {
                if (colors[0] instanceof Color3f) {
                    newColors = new Color3f[4];
                } else if (colors[0] instanceof Color4f) {
                    newColors = new Color4f[4];
                }
                newColors[0] = color1;
                newColors[1] = color2;
                newColors[2] = color3;
            }
        } else {
            coordIndices[index] = -1;
            coordIndices[index + 1] = -1;
            coordIndices[index + 2] = -1;
            newPoints = new Point3f[4];
            if (colors != null) {
                if (colors[0] instanceof Color3f) {
                    newColors = new Color3f[4];
                } else if (colors[0] instanceof Color4f) {
                    newColors = new Color4f[4];
                }
            }
            int p = 0;
            if (c1 && !c2) {
                if (colors != null) {
                    newColors[p] = color1;
                    newColors[p + 1] = color2;
                }
                newPoints[p++] = p1;
                newPoints[p++] = this.clipLine(p1, p2);
            } else if (c2 && !c1) {
                if (colors != null) {
                    newColors[p] = color1;
                    newColors[p + 1] = color2;
                }
                newPoints[p++] = this.clipLine(p2, p1);
                newPoints[p++] = p2;
            }
            if (c2 && !c3) {
                if (colors != null) {
                    newColors[p] = color2;
                    newColors[p + 1] = color3;
                }
                newPoints[p++] = p2;
                newPoints[p++] = this.clipLine(p2, p3);
            } else if (c3 && !c2) {
                if (colors != null) {
                    newColors[p] = color2;
                    newColors[p + 1] = color3;
                }
                newPoints[p++] = this.clipLine(p3, p2);
                newPoints[p++] = p3;
            }
            if (c1 && !c3) {
                if (colors != null) {
                    newColors[p] = color3;
                    newColors[p + 1] = color1;
                }
                newPoints[p++] = this.clipLine(p1, p3);
                newPoints[p++] = p1;
            } else if (c3 && !c1) {
                if (colors != null) {
                    newColors[p] = color3;
                    newColors[p + 1] = color1;
                }
                newPoints[p++] = p3;
                newPoints[p++] = this.clipLine(p3, p1);
            }
            if (p != 4) {
                throw new RuntimeException("Triangle Clip fault");
            }
        }
        GeometryInfo newGeom = null;
        newGeom = newPoints.length == 4 ? new GeometryInfo(2) : new GeometryInfo(1);
        newGeom.setCoordinates(newPoints);
        if (colors != null) {
            if (newColors[0] instanceof Color3f) {
                newGeom.setColors((Color3f[])newColors);
            } else if (newColors[0] instanceof Color4f) {
                newGeom.setColors((Color4f[])newColors);
            }
        }
        newGeom.convertToIndexedTriangles();
        this.newTriangles.add(newGeom);
        return 3;
    }

    private Point3f clipLine(Point3f p1, Point3f p2) {
        double lambda;
        Vector3f line = new Vector3f();
        line.sub((Tuple3f)p2, (Tuple3f)p1);
        Point3f ret = new Point3f();
        if ((double)line.x != 0.0) {
            if ((double)line.x < 0.0) {
                lambda = (this.lowerCorner.x - (double)p1.x) / (double)line.x;
                ret.x = (float)((double)p1.x + (double)line.x * lambda);
                ret.y = (float)((double)p1.y + (double)line.y * lambda);
                ret.z = (float)((double)p1.z + (double)line.z * lambda);
                if ((double)ret.y >= this.lowerCorner.y && (double)ret.y <= this.upperCorner.y && (double)ret.z >= this.lowerCorner.z && (double)ret.z <= this.upperCorner.z) {
                    return ret;
                }
            } else {
                lambda = (this.upperCorner.x - (double)p1.x) / (double)line.x;
                ret.x = (float)((double)p1.x + (double)line.x * lambda);
                ret.y = (float)((double)p1.y + (double)line.y * lambda);
                ret.z = (float)((double)p1.z + (double)line.z * lambda);
                if ((double)ret.y >= this.lowerCorner.y && (double)ret.y <= this.upperCorner.y && (double)ret.z >= this.lowerCorner.z && (double)ret.z <= this.upperCorner.z) {
                    return ret;
                }
            }
        }
        if ((double)line.y != 0.0) {
            if ((double)line.y < 0.0) {
                lambda = (this.lowerCorner.y - (double)p1.y) / (double)line.y;
                ret.x = (float)((double)p1.x + (double)line.x * lambda);
                ret.y = (float)((double)p1.y + (double)line.y * lambda);
                ret.z = (float)((double)p1.z + (double)line.z * lambda);
                if ((double)ret.x >= this.lowerCorner.x && (double)ret.x <= this.upperCorner.x && (double)ret.z >= this.lowerCorner.z && (double)ret.z <= this.upperCorner.z) {
                    return ret;
                }
            } else {
                lambda = (this.upperCorner.y - (double)p1.y) / (double)line.y;
                ret.x = (float)((double)p1.x + (double)line.x * lambda);
                ret.y = (float)((double)p1.y + (double)line.y * lambda);
                ret.z = (float)((double)p1.z + (double)line.z * lambda);
                if ((double)ret.x >= this.lowerCorner.x && (double)ret.x <= this.upperCorner.x && (double)ret.z >= this.lowerCorner.z && (double)ret.z <= this.upperCorner.z) {
                    return ret;
                }
            }
        }
        if ((double)line.z != 0.0) {
            if ((double)line.z < 0.0) {
                lambda = (this.lowerCorner.z - (double)p1.z) / (double)line.z;
                ret.x = (float)((double)p1.x + (double)line.x * lambda);
                ret.y = (float)((double)p1.y + (double)line.y * lambda);
                ret.z = (float)((double)p1.z + (double)line.z * lambda);
                if ((double)ret.x >= this.lowerCorner.x && (double)ret.x <= this.upperCorner.x && (double)ret.y >= this.lowerCorner.y && (double)ret.y <= this.upperCorner.y) {
                    return ret;
                }
            } else {
                lambda = (this.upperCorner.z - (double)p1.z) / (double)line.z;
                ret.x = (float)((double)p1.x + (double)line.x * lambda);
                ret.y = (float)((double)p1.y + (double)line.y * lambda);
                ret.z = (float)((double)p1.z + (double)line.z * lambda);
                if ((double)ret.x >= this.lowerCorner.x && (double)ret.x <= this.upperCorner.x && (double)ret.y >= this.lowerCorner.y && (double)ret.y <= this.upperCorner.y) {
                    return ret;
                }
            }
        }
        throw new RuntimeException("Intersection not found");
    }

    private boolean contains(Point3f point) {
        if ((double)point.x < this.lowerCorner.x || (double)point.x > this.upperCorner.x) {
            return false;
        }
        if ((double)point.y < this.lowerCorner.y || (double)point.y > this.upperCorner.y) {
            return false;
        }
        return !((double)point.z < this.lowerCorner.z) && !((double)point.z > this.upperCorner.z);
    }
}

