/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeometryInfo;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;

public class GeometryInfoGenerator {
    public static void create(GeometryInfo geomInfo, GeometryArray geomArray) {
        if (geomArray instanceof GeometryStripArray) {
            GeometryInfoGenerator.create(geomInfo, (GeometryStripArray)geomArray);
        } else if (geomArray instanceof TriangleArray) {
            geomInfo.reset(1);
            GeometryInfoGenerator.processGeometryArray(geomInfo, geomArray);
        } else if (geomArray instanceof QuadArray) {
            geomInfo.reset(2);
            GeometryInfoGenerator.processGeometryArray(geomInfo, geomArray);
        } else if (geomArray instanceof IndexedGeometryArray) {
            GeometryInfoGenerator.create(geomInfo, (IndexedGeometryArray)geomArray);
        } else {
            throw new RuntimeException("Unsupported Geometry type " + geomArray.getClass().getName());
        }
    }

    private static void create(GeometryInfo geomInfo, GeometryStripArray geomArray) {
        if (geomArray instanceof TriangleFanArray) {
            geomInfo.reset(3);
        } else if (geomArray instanceof TriangleStripArray) {
            geomInfo.reset(4);
        } else {
            throw new RuntimeException("Unsupported Geometry type " + geomArray.getClass().getName());
        }
        GeometryInfoGenerator.processGeometryArray(geomInfo, (GeometryArray)geomArray);
        GeometryInfoGenerator.processStripArray(geomInfo, geomArray);
    }

    private static void create(GeometryInfo geomInfo, IndexedGeometryArray geomArray) {
        if (geomArray instanceof IndexedQuadArray) {
            geomInfo.reset(2);
        } else if (geomArray instanceof IndexedTriangleArray) {
            geomInfo.reset(1);
        } else if (geomArray instanceof IndexedTriangleFanArray) {
            geomInfo.reset(3);
            GeometryInfoGenerator.processIndexStripArray(geomInfo, (IndexedGeometryStripArray)geomArray);
        } else if (geomArray instanceof IndexedTriangleStripArray) {
            geomInfo.reset(4);
            GeometryInfoGenerator.processIndexStripArray(geomInfo, (IndexedGeometryStripArray)geomArray);
        }
        GeometryInfoGenerator.processGeometryArray(geomInfo, (GeometryArray)geomArray);
        GeometryInfoGenerator.processIndexedArray(geomInfo, geomArray);
    }

    private static void processGeometryArray(GeometryInfo geomInfo, GeometryArray geomArray) {
        float[] tex;
        float[] colors;
        int vertexFormat = geomArray.getVertexFormat();
        int vertexCount = geomArray.getVertexCount();
        double[] coords = new double[vertexCount * 3];
        geomArray.getCoordinates(0, coords);
        geomInfo.setCoordinates(coords);
        if ((vertexFormat & 2) == 2) {
            float[] normals = new float[vertexCount * 3];
            geomArray.getNormals(0, normals);
            geomInfo.setNormals(normals);
        }
        if ((vertexFormat & 0xC) == 12) {
            colors = new float[vertexCount * 4];
            geomArray.getColors(0, colors);
            geomInfo.setColors4(colors);
        } else if ((vertexFormat & 4) != 0) {
            colors = new float[vertexCount * 3];
            geomArray.getColors(0, colors);
            geomInfo.setColors3(colors);
        }
        if ((vertexFormat & 0x40) == 64) {
            tex = new float[vertexCount * 3];
            geomArray.getTextureCoordinates(0, 0, tex);
            geomInfo.setTextureCoordinates(0, tex);
        } else if ((vertexFormat & 0x20) != 0) {
            tex = new float[vertexCount * 2];
            geomArray.getTextureCoordinates(0, 0, tex);
            geomInfo.setTextureCoordinates(0, tex);
        }
    }

    private static void processIndexedArray(GeometryInfo geomInfo, IndexedGeometryArray geomArray) {
        int indexCount = geomArray.getIndexCount();
        int vertexFormat = geomArray.getVertexFormat();
        int[] coordI = new int[indexCount];
        geomArray.getCoordinateIndices(0, coordI);
        geomInfo.setCoordinateIndices(coordI);
        if ((vertexFormat & 2) != 0) {
            int[] normalI = new int[indexCount];
            geomArray.getNormalIndices(0, normalI);
            geomInfo.setNormalIndices(normalI);
        }
        if ((vertexFormat & 4) != 0 || (vertexFormat & 0xC) != 0) {
            int[] colorI = new int[indexCount];
            geomArray.getColorIndices(0, colorI);
            geomInfo.setColorIndices(colorI);
        }
        if ((vertexFormat & 0x20) != 0 || (vertexFormat & 0x40) != 0) {
            int[] texI = new int[indexCount];
            geomArray.getTextureCoordinateIndices(0, 0, texI);
            geomInfo.setTextureCoordinateIndices(0, texI);
        }
    }

    private static void processStripArray(GeometryInfo geomInfo, GeometryStripArray geomArray) {
        int[] strips = new int[geomArray.getNumStrips()];
        geomArray.getStripVertexCounts(strips);
        geomInfo.setStripCounts(strips);
    }

    private static void processIndexStripArray(GeometryInfo geomInfo, IndexedGeometryStripArray geomArray) {
        int[] strips = new int[geomArray.getNumStrips()];
        geomArray.getStripIndexCounts(strips);
        geomInfo.setStripCounts(strips);
    }
}

