/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.scenegraph;

import com.sun.j3d.utils.scenegraph.io.SceneGraphStateProvider;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.media.j3d.ImageComponent2D;
import org.jdesktop.j3d.utils.scenegraph.io.ImageComponent2DURLState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageComponent2DURL
extends ImageComponent2D
implements SceneGraphStateProvider {
    private URL baseURL = null;
    private String imageName = null;
    private static AssetManager assetManager = new SimpleAssetManager();

    public ImageComponent2DURL(ImageComponent2D ic, URL baseURL, String imageName) {
        super(ic.getFormat(), ic.getImage(), ic.isByReference(), ic.isYUp());
        this.baseURL = baseURL;
        this.imageName = imageName;
        this.set(ic.getImage());
    }

    public ImageComponent2DURL(int format, int width, int height, boolean byReference, boolean yUp, URL baseURL, String imageName) {
        this(format, width, height, byReference, yUp, baseURL, imageName, false);
    }

    public ImageComponent2DURL(int format, int width, int height, boolean byReference, boolean yUp, URL baseURL, String imageName, boolean dontUseAssetManager) {
        super(format, width, height, byReference, yUp);
        this.baseURL = baseURL;
        this.imageName = imageName;
        if (!dontUseAssetManager) {
            this.notifyAssetManager();
        }
    }

    private void notifyAssetManager() {
        assetManager.loadImage(this);
    }

    public static void setAssetManager(AssetManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("AssetManager can not be null");
        }
        assetManager = manager;
    }

    public static AssetManager getAssetManager() {
        return assetManager;
    }

    public void setBaseURL(URL url) {
        this.baseURL = url;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImageName() {
        return new String(this.imageName);
    }

    public Class<? extends SceneGraphObjectState> getStateClass() {
        return ImageComponent2DURLState.class;
    }

    public static interface AssetManager {
        public void loadImage(ImageComponent2DURL var1);

        public ImageComponent2DURL createImageComponent2DURL(URL var1, String var2);
    }

    static class SimpleAssetManager
    implements AssetManager {
        SimpleAssetManager() {
        }

        public void loadImage(ImageComponent2DURL ic) {
            String url = ic.getBaseURL().toExternalForm();
            try {
                URL fullURL = new URL(String.valueOf(url) + "/" + ic.getImageName());
                BufferedImage bufImg = ImageIO.read(fullURL);
                ic.set(bufImg);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public ImageComponent2DURL createImageComponent2DURL(URL baseURL, String filename) {
            throw new RuntimeException("Not Implemented");
        }
    }
}

