/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.scenegraph.transparency;

import java.util.Arrays;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import org.jdesktop.j3d.utils.scenegraph.transparency.TransparencyOrderController;
import org.jdesktop.j3d.utils.scenegraph.traverser.ProcessNodeInterface;
import org.jdesktop.j3d.utils.scenegraph.traverser.TreeScan;

public class TransparencyOrderedGroup
extends TransformGroup {
    private int[] childIndexOrder = null;
    private boolean[] checkArr = null;
    private static final Transform3D t3d = new Transform3D();

    public TransparencyOrderedGroup() {
        super(new Transform3D());
        this.setCapability(12);
        this.setCapability(18);
    }

    public void setChildIndexOrder(int[] childIndexOrder) {
        this.verifyChildIndexOrderArray(childIndexOrder, 0);
        if (childIndexOrder == null) {
            this.childIndexOrder = null;
            return;
        }
        if (this.childIndexOrder == null || childIndexOrder.length != this.childIndexOrder.length) {
            this.childIndexOrder = new int[childIndexOrder.length];
        }
        System.arraycopy(childIndexOrder, 0, this.childIndexOrder, 0, childIndexOrder.length);
        super.setTransform(t3d);
    }

    public int[] getChildIndexOrder() {
        if (this.childIndexOrder == null) {
            return null;
        }
        int[] ret = new int[this.childIndexOrder.length];
        System.arraycopy(this.childIndexOrder, 0, ret, 0, ret.length);
        return ret;
    }

    int getRenderingOrderForChild(int childIndex) {
        if (this.childIndexOrder == null) {
            return childIndex;
        }
        int ret = -1;
        int i = 0;
        while (i < this.childIndexOrder.length && ret == -1) {
            if (this.childIndexOrder[i] == childIndex) {
                ret = i;
            }
            ++i;
        }
        if (ret == -1) {
            throw new RuntimeException("Child " + childIndex + " not found in childIndexOrder array");
        }
        return ret;
    }

    public void addChild(Node child) {
        super.addChild(child);
        if (this.childIndexOrder != null) {
            int[] tmp = new int[this.childIndexOrder.length + 1];
            System.arraycopy(this.childIndexOrder, 0, tmp, 0, this.childIndexOrder.length);
            tmp[tmp.length - 1] = tmp.length - 1;
            this.childIndexOrder = tmp;
        }
    }

    public void addChild(Node child, int[] childIndexOrder) {
        this.verifyChildIndexOrderArray(childIndexOrder, 1);
        this.childIndexOrder = new int[childIndexOrder.length];
        System.arraycopy(childIndexOrder, 0, this.childIndexOrder, 0, childIndexOrder.length);
        super.addChild(child);
    }

    public void insertChild(Node child, int index) {
        if (this.childIndexOrder != null) {
            throw new IllegalStateException("insertChild illegal when childIndexOrder != null");
        }
        super.insertChild(child, index);
    }

    public void setChild(Node child, int index) {
        if (this.childIndexOrder != null) {
            throw new IllegalStateException("setChild illegal when childIndexOrder != null");
        }
        super.setChild(child, index);
    }

    public void removeChild(Node child) {
        int index = this.indexOfChild(child);
        super.removeChild(child);
        this.removeChildFromIndexOrder(index);
    }

    public void removeChild(int index) {
        super.removeChild(index);
        this.removeChildFromIndexOrder(index);
    }

    public void setTransform(Transform3D t) {
        throw new RuntimeException("TransparencyOrderedGroup.setTransform should not be used.");
    }

    public void getTransform(Transform3D t) {
        throw new RuntimeException("TransparencyOrderedGroup.getTransform should not be used.");
    }

    private void removeChildFromIndexOrder(int index) {
        if (this.childIndexOrder != null) {
            int[] tmp = new int[this.childIndexOrder.length - 1];
            int newi = 0;
            int i = 0;
            while (i < this.childIndexOrder.length) {
                int cio = this.childIndexOrder[i];
                if (cio > index) {
                    tmp[newi++] = cio - 1;
                    if (this.isLive()) {
                        this.updateShapeChildIndicies(this.getChild(cio - 1), -1);
                    }
                } else if (cio != index) {
                    tmp[newi++] = cio;
                }
                ++i;
            }
            this.childIndexOrder = tmp;
        }
    }

    private void updateShapeChildIndicies(Node root, final int indexAdjustment) {
        final TransparencyOrderController controller = TransparencyOrderController.getController();
        TreeScan.findNode(root, Shape3D.class, new ProcessNodeInterface(){

            public boolean processNode(Node node) {
                controller.adjustChildIndex((Shape3D)node, indexAdjustment, TransparencyOrderedGroup.this);
                return true;
            }
        }, false, true);
    }

    void verifyChildIndexOrderArray(int[] cIOArr, int plus) {
        if (cIOArr != null) {
            if (cIOArr.length != this.numChildren() + plus) {
                throw new IllegalArgumentException("childIndexOrder.length != number of children");
            }
            if (this.checkArr == null || this.checkArr.length != cIOArr.length) {
                this.checkArr = new boolean[cIOArr.length];
            }
            Arrays.fill(this.checkArr, false);
            int i = 0;
            while (i < cIOArr.length) {
                if (cIOArr[i] < 0) {
                    throw new IllegalArgumentException("childIndexOrder[i] must be >= 0, for i in [0, numChildren-1]");
                }
                if (cIOArr[i] >= cIOArr.length) {
                    throw new IllegalArgumentException("childIndexOrder[i] must be < numChildren, for i in [0, numChildren-1]");
                }
                if (this.checkArr[cIOArr[i]]) {
                    throw new IllegalArgumentException("childIndexOrder[i] must not be equal to childIndexOrder[j], for i,j in [0,numChildren-1] and i != j");
                }
                this.checkArr[cIOArr[i]] = true;
                ++i;
            }
        }
    }
}

