/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.scenegraph.traverser;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.Stripifier;
import java.util.HashMap;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleStripArray;
import org.jdesktop.j3d.utils.capability.Capabilities;
import org.jdesktop.j3d.utils.geometry.GeometryInfoGenerator;
import org.jdesktop.j3d.utils.scenegraph.traverser.ProcessNodeInterface;
import org.jdesktop.j3d.utils.scenegraph.traverser.StripifyProcessor;
import org.jdesktop.j3d.utils.scenegraph.traverser.TreeScan;

public class GeometryArrayStripifier {
    public static void stripify(Node[] treeRoots) {
        StripifyProcessor processor = new StripifyProcessor(){
            private GeometryInfo geomInfo = new GeometryInfo(1);
            private Stripifier stripifier = new Stripifier();
            private HashMap map = new HashMap();

            public boolean stripifyGeometry(Shape3D shape) {
                int i = 0;
                while (i < shape.numGeometries()) {
                    if (shape.getGeometry(i) != null && shape.getGeometry(i) instanceof GeometryArray) {
                        GeometryArray geom = (GeometryArray)shape.getGeometry(i);
                        GeometryArray previousConvert = (GeometryArray)this.map.get(geom);
                        if (previousConvert != null) {
                            shape.setGeometry((Geometry)previousConvert, i);
                        } else if (geom instanceof TriangleArray || geom instanceof IndexedTriangleArray || geom instanceof IndexedTriangleStripArray || geom instanceof TriangleStripArray) {
                            GeometryInfoGenerator.create(this.geomInfo, geom);
                            this.stripifier.stripify(this.geomInfo);
                            GeometryArray newGeom = this.geomInfo.getGeometryArray();
                            shape.setGeometry((Geometry)newGeom, i);
                            this.map.put(geom, newGeom);
                            int[] capabilities = Capabilities.getCapabilities((SceneGraphObject)geom);
                            int c = 0;
                            while (c < capabilities.length) {
                                newGeom.setCapability(capabilities[c]);
                                ++c;
                            }
                        }
                    }
                    ++i;
                }
                return true;
            }
        };
        int i = 0;
        while (i < treeRoots.length) {
            GeometryArrayStripifier.scanTree(treeRoots[i], processor);
            ++i;
        }
    }

    public static void stripify(Node treeRoot) {
        GeometryArrayStripifier.stripify(new Node[]{treeRoot});
    }

    private static void scanTree(Node treeRoot, StripifyProcessor processor) {
        try {
            TreeScan.findNode(treeRoot, Shape3D.class, (ProcessNodeInterface)processor, false, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR GeometryArrayStripifier, SceneGraph contains Live or compiled nodes");
        }
    }
}

