/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.scenegraph.traverser;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Node;
import org.jdesktop.j3d.utils.scenegraph.traverser.GeometrySizeProcessor;
import org.jdesktop.j3d.utils.scenegraph.traverser.ProcessNodeInterface;
import org.jdesktop.j3d.utils.scenegraph.traverser.TreeScan;

public class GeometryStatistics {
    public static void printStatistics(Node[] treeRoots) {
        GeometrySizeProcessor processor = new GeometrySizeProcessor();
        TreeScan scan = new TreeScan();
        boolean triangleCount = false;
        boolean quadCount = false;
        boolean lineCount = false;
        boolean pointCount = false;
        try {
            Class<?> geometryClass = Class.forName("javax.media.j3d.Shape3D");
            int i = 0;
            while (i < treeRoots.length) {
                TreeScan.findNode(treeRoots[i], geometryClass, (ProcessNodeInterface)processor, false, false);
                ++i;
            }
            System.out.println("Triangle Count : " + processor.getTriangleCount());
            System.out.println("Quad Count     : " + processor.getQuadCount());
            System.out.println("Line Count     : " + processor.getLineCount());
            System.out.println("Point Count    : " + processor.getPointCount());
            System.out.println("Percentage of Vertex in Strips " + processor.getStripPercentage() + "%");
            System.out.println("Average Strip Length " + processor.getAverageStripLength());
            int[] dist = processor.getTriangleStripDistribution();
            System.out.println("Triangle Strip size distribution");
            System.out.println("1       " + dist[1]);
            System.out.println("2       " + dist[2]);
            System.out.println("3       " + dist[3]);
            System.out.println("4       " + dist[4]);
            System.out.println("5       " + dist[5]);
            System.out.println("6       " + dist[6]);
            System.out.println("7       " + dist[7]);
            System.out.println("8       " + dist[8]);
            System.out.println("9       " + dist[9]);
            System.out.println("10-19   " + dist[10]);
            System.out.println("20-49   " + dist[11]);
            System.out.println("50-99   " + dist[12]);
            System.out.println("100-999 " + dist[13]);
            System.out.println(">1000   " + dist[14]);
        }
        catch (CapabilityNotSetException e) {
            System.out.println("Error, SceneGraph is either live or compiled");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static void printStatistics(Node treeRoot) {
        GeometryStatistics.printStatistics(new Node[]{treeRoot});
    }
}

