/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.scenegraph.traverser;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import org.jdesktop.j3d.utils.scenegraph.traverser.ProcessNodeInterface;

public class TreeScan {
    private static HashSet visitedSharedGroups = null;

    public static void findNode(Node treeRoot, Class nodeClass, ProcessNodeInterface processor, boolean onlyEnabledSwitchChildren, boolean sharedGroupsOnce) throws CapabilityNotSetException {
        Class[] nodeClasses = new Class[]{nodeClass};
        TreeScan.findNode(treeRoot, nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
    }

    public static void findNode(Node treeRoot, Class[] nodeClasses, ProcessNodeInterface processor, boolean onlyEnabledSwitchChildren, boolean sharedGroupsOnce) throws CapabilityNotSetException {
        if (sharedGroupsOnce && visitedSharedGroups == null) {
            visitedSharedGroups = new HashSet();
        }
        TreeScan.actualFindNode(treeRoot, nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
        if (sharedGroupsOnce) {
            visitedSharedGroups.clear();
        }
    }

    public static Class getClass(String str) {
        try {
            return Class.forName(str);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("BAD CLASS " + str);
        }
    }

    private static void actualFindNode(Node treeRoot, Class[] nodeClasses, ProcessNodeInterface processor, boolean onlyEnabledSwitchChildren, boolean sharedGroupsOnce) throws CapabilityNotSetException {
        block11: {
            block9: {
                int whichChild;
                block12: {
                    block10: {
                        boolean doChildren = true;
                        if (treeRoot == null) {
                            return;
                        }
                        int i = 0;
                        while (i < nodeClasses.length) {
                            if (nodeClasses[i].isAssignableFrom(treeRoot.getClass())) {
                                doChildren = processor.processNode(treeRoot);
                                i = nodeClasses.length;
                            }
                            ++i;
                        }
                        if (!doChildren) {
                            return;
                        }
                        if (!onlyEnabledSwitchChildren || !(treeRoot instanceof Switch)) break block9;
                        whichChild = ((Switch)treeRoot).getWhichChild();
                        if (whichChild != -2) break block10;
                        Enumeration e = ((Group)treeRoot).getAllChildren();
                        while (e.hasMoreElements()) {
                            TreeScan.actualFindNode((Node)e.nextElement(), nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
                        }
                        break block11;
                    }
                    if (whichChild != -3) break block12;
                    BitSet set = ((Switch)treeRoot).getChildMask();
                    int s = 0;
                    while (s < set.length()) {
                        if (set.get(s)) {
                            TreeScan.actualFindNode(((Switch)treeRoot).getChild(s), nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
                        }
                        ++s;
                    }
                    break block11;
                }
                if (whichChild == -1) break block11;
                TreeScan.actualFindNode(((Switch)treeRoot).currentChild(), nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
                break block11;
            }
            if (treeRoot instanceof Group) {
                Enumeration e = ((Group)treeRoot).getAllChildren();
                while (e != null && e.hasMoreElements()) {
                    TreeScan.actualFindNode((Node)e.nextElement(), nodeClasses, processor, onlyEnabledSwitchChildren, sharedGroupsOnce);
                }
            }
        }
    }
}

