/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.scenegraph.visualtools;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Sphere;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Fog;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Sound;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class ShowBoundsBehavior
extends Behavior {
    public static final Integer NODE_BOUNDS = new Integer(1);
    public static final Integer SCHEDULING_BOUNDS = new Integer(2);
    public static final Integer INFLUENCING_BOUNDS = new Integer(3);
    WakeupOnElapsedFrames frameCondition;
    WakeupOnBehaviorPost waitCondition;
    WakeupCondition currentCondition;
    ArrayList nodes = new ArrayList();
    ArrayList bounds = new ArrayList();
    ArrayList transforms = new ArrayList();
    ArrayList boundsType = new ArrayList();
    Switch root = new Switch();
    boolean newNode = false;
    TransformGroup testtg;
    Sphere tests;
    Shape3D shp;
    private Transform3D tmpTransform = new Transform3D();

    public ShowBoundsBehavior(BranchGroup parent) {
        this.root.setCapability(12);
        this.root.setCapability(13);
        this.root.setCapability(14);
        this.root.setWhichChild(-2);
        parent.addChild((Node)this.root);
        parent.addChild((Node)this);
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), Double.POSITIVE_INFINITY));
        this.frameCondition = new WakeupOnElapsedFrames(0, true);
        this.waitCondition = new WakeupOnBehaviorPost((Behavior)this, 1);
        this.currentCondition = this.waitCondition;
    }

    public void showBounds(Node node) {
        node.setCapability(3);
        node.setCapability(11);
        if (node instanceof TransformGroup) {
            node.setCapability(17);
        }
        this.nodes.add(node);
        this.bounds.add(node.getBounds());
        this.boundsType.add(NODE_BOUNDS);
        this.root.addChild((Node)this.drawBounds(node, node.getBounds(), -1));
        this.newNode = true;
        this.currentCondition = this.frameCondition;
        this.postId(1);
    }

    public void showSchedulingBounds(Node node) {
        Bounds schedBounds = null;
        if (node instanceof Behavior || node instanceof Sound) {
            if (node instanceof Sound) {
                node.setCapability(24);
                schedBounds = ((Sound)node).getSchedulingBounds();
            } else if (node instanceof Behavior) {
                schedBounds = ((Behavior)node).getSchedulingBounds();
            }
        } else {
            throw new RuntimeException(node + " not supported in showSchedulingBounds");
        }
        node.setCapability(11);
        this.nodes.add(node);
        this.bounds.add(schedBounds);
        this.boundsType.add(SCHEDULING_BOUNDS);
        this.root.addChild((Node)this.drawBounds(node, schedBounds, -1));
        this.newNode = true;
        this.currentCondition = this.frameCondition;
        this.postId(1);
    }

    public void showInfluencingBounds(Node node) {
        if (node instanceof Light || node instanceof Fog) {
            throw new RuntimeException("Not Implemented");
        }
        throw new RuntimeException(node + " not supported in showInfluencingBounds");
    }

    public void hideBounds(Node node, Integer type) {
        int i = -1;
        int j = 0;
        while (j < this.nodes.size() && i == -1) {
            if (this.nodes.get(j) == node && this.boundsType.get(j) == type) {
                i = j;
            }
            ++j;
        }
        if (i == -1) {
            System.out.println("WARNING - error removing bounds");
            return;
        }
        this.nodes.remove(i);
        this.bounds.remove(i);
        this.boundsType.remove(i);
        this.root.removeChild(i);
    }

    public void removeAllBounds() {
        this.nodes.clear();
        this.bounds.clear();
        while (this.root.numChildren() > 0) {
            this.root.removeChild(0);
        }
    }

    public void initialize() {
        this.wakeupOn(this.currentCondition);
    }

    public void processStimulus(Enumeration criteria) {
        Transform3D nodeTrans = new Transform3D();
        Transform3D local2vw = new Transform3D();
        Bounds newBounds = null;
        int i = 0;
        while (i < this.nodes.size()) {
            Node node = (Node)this.nodes.get(i);
            Bounds bnds = (Bounds)this.bounds.get(i);
            Integer type = (Integer)this.boundsType.get(i);
            if (type == NODE_BOUNDS) {
                newBounds = node.getBounds();
            } else if (type == SCHEDULING_BOUNDS) {
                if (node instanceof Sound) {
                    newBounds = ((Sound)node).getSchedulingBounds();
                } else if (node instanceof Behavior) {
                    newBounds = ((Behavior)node).getSchedulingBounds();
                }
            }
            if (bnds instanceof BoundingSphere && node.isLive()) {
                if (this.boundsNotEqual(bnds, newBounds) || this.newNode) {
                    this.root.setChild((Node)this.drawBounds(node, newBounds, i), i);
                    this.bounds.set(i, newBounds);
                } else {
                    node.getLocalToVworld(local2vw);
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(nodeTrans);
                        local2vw.mul(nodeTrans);
                    }
                    this.setTransform(i, local2vw);
                }
            } else if (bnds instanceof BoundingBox && node.isLive()) {
                if (this.boundsNotEqual(bnds, newBounds)) {
                    this.root.setChild((Node)this.drawBounds(node, newBounds, i), i);
                    this.bounds.set(i, newBounds);
                } else {
                    node.getLocalToVworld(local2vw);
                    if (node instanceof TransformGroup) {
                        ((TransformGroup)node).getTransform(nodeTrans);
                        local2vw.mul(nodeTrans);
                    }
                    this.setTransform(i, local2vw);
                }
            } else if (node.isLive()) {
                throw new RuntimeException("showBounds does not handle this type of bounds" + bnds.getClass().getName());
            }
            ++i;
        }
        this.newNode = false;
        this.currentCondition = this.nodes.size() > 0 ? this.frameCondition : this.waitCondition;
        this.wakeupOn(this.currentCondition);
    }

    private void setTransform(int index, Transform3D newTransform) {
        ((TransformGroup)this.transforms.get(index)).getTransform(this.tmpTransform);
        if (!this.tmpTransform.equals(newTransform)) {
            ((TransformGroup)this.transforms.get(index)).setTransform(newTransform);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BranchGroup drawBounds(Node node, Bounds bounds, int i) {
        BranchGroup ret = new BranchGroup();
        Appearance appearance = new Appearance();
        PolygonAttributes poly = new PolygonAttributes();
        poly.setPolygonMode(1);
        appearance.setPolygonAttributes(poly);
        ret.setCapability(17);
        Transform3D nodeTrans = new Transform3D();
        Sphere primitive = null;
        Point3d c = new Point3d();
        if (bounds instanceof BoundingSphere) {
            ((BoundingSphere)bounds).getCenter(c);
            double radius = ((BoundingSphere)bounds).getRadius();
            if (!(radius > 0.0)) return ret;
            primitive = new Sphere((float)radius, 16, 10, appearance);
        } else {
            if (!(bounds instanceof BoundingBox)) throw new RuntimeException("Not implemented yet");
            Point3d upper = new Point3d();
            Point3d lower = new Point3d();
            ((BoundingBox)bounds).getUpper(upper);
            ((BoundingBox)bounds).getLower(lower);
            Vector3f size = new Vector3f();
            size.x = (float)(upper.x - lower.x);
            size.y = (float)(upper.y - lower.y);
            size.z = (float)(upper.z - lower.z);
            c.x = lower.x + (double)(size.x / 2.0f);
            c.y = lower.y + (double)(size.y / 2.0f);
            c.z = lower.z + (double)(size.z / 2.0f);
            primitive = new Box(size.x / 2.0f, size.y / 2.0f, size.z / 2.0f, appearance);
        }
        Transform3D trans = new Transform3D();
        trans.set(new Vector3d(c.x, c.y, c.z));
        Transform3D local2vw = new Transform3D();
        if (node.isLive()) {
            node.getLocalToVworld(local2vw);
        }
        if (node instanceof TransformGroup) {
            ((TransformGroup)node).getTransform(nodeTrans);
            local2vw.mul(nodeTrans);
        }
        TransformGroup tg = new TransformGroup(trans);
        TransformGroup tgvw = new TransformGroup(local2vw);
        tgvw.setCapability(18);
        tgvw.setCapability(17);
        if (i > this.transforms.size() - 1) {
            this.transforms.add(tgvw);
        } else {
            this.transforms.set(i, tgvw);
        }
        tg.addChild((Node)primitive);
        tgvw.addChild((Node)tg);
        ret.addChild((Node)tgvw);
        return ret;
    }

    private boolean boundsNotEqual(Bounds b1, Bounds b2) {
        if (b1 instanceof BoundingBox && b2 instanceof BoundingBox) {
            Point3d p1u = new Point3d();
            Point3d p1l = new Point3d();
            Point3d p2u = new Point3d();
            Point3d p2l = new Point3d();
            ((BoundingBox)b1).getUpper(p1u);
            ((BoundingBox)b1).getLower(p1l);
            ((BoundingBox)b2).getUpper(p2u);
            ((BoundingBox)b2).getLower(p2l);
            return !p1u.equals((Tuple3d)p2u) || !p1l.equals((Tuple3d)p2l);
        }
        if (b1 instanceof BoundingPolytope && b2 instanceof BoundingPolytope) {
            throw new RuntimeException("Not Implemented yet");
        }
        if (b1 instanceof BoundingSphere && b2 instanceof BoundingSphere) {
            Point3d b1Center = new Point3d();
            Point3d b2Center = new Point3d();
            ((BoundingSphere)b1).getCenter(b1Center);
            ((BoundingSphere)b2).getCenter(b2Center);
            double b1radius = ((BoundingSphere)b1).getRadius();
            double b2radius = ((BoundingSphere)b2).getRadius();
            return !b1Center.equals((Tuple3d)b2Center) || b1radius != b2radius;
        }
        return true;
    }
}

