/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.utils.view;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class ViewUtils {
    public static double setViewpoint(TransformGroup tg, Bounds sceneBounds, double fieldOfView, Axis axis) {
        if (sceneBounds instanceof BoundingSphere) {
            return ViewUtils.setViewpoint(tg, (BoundingSphere)sceneBounds, fieldOfView, axis);
        }
        return ViewUtils.setViewpoint(tg, new BoundingSphere(sceneBounds), fieldOfView, axis);
    }

    private static double setViewpoint(TransformGroup tg, BoundingSphere sceneBounds, double fieldOfView, Axis axis) {
        Transform3D viewTrans = new Transform3D();
        Transform3D eyeTrans = new Transform3D();
        Point3d center = new Point3d();
        sceneBounds.getCenter(center);
        double radius = sceneBounds.getRadius();
        Point3d eyePos = new Point3d(center);
        Vector3d up = new Vector3d();
        double eyeDist = radius / Math.tan(fieldOfView / 2.0);
        switch (axis) {
            case POSITIVE_X_AXIS: {
                eyePos.x += eyeDist;
                up.y = 1.0;
                break;
            }
            case POSITIVE_Y_AXIS: {
                eyePos.y += eyeDist;
                up.z = -1.0;
                break;
            }
            case POSITIVE_Z_AXIS: {
                eyePos.z += eyeDist;
                up.y = 1.0;
                break;
            }
            case NEGATIVE_X_AXIS: {
                eyePos.x -= eyeDist;
                up.y = 1.0;
                break;
            }
            case NEGATIVE_Y_AXIS: {
                eyePos.y -= eyeDist;
                up.z = -1.0;
                break;
            }
            case NEGATIVE_Z_AXIS: {
                eyePos.z -= eyeDist;
                up.y = 1.0;
            }
        }
        viewTrans.setIdentity();
        viewTrans.lookAt(eyePos, center, up);
        viewTrans.invert();
        tg.setTransform(viewTrans);
        return eyeDist;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Axis {
        POSITIVE_X_AXIS,
        POSITIVE_Y_AXIS,
        POSITIVE_Z_AXIS,
        NEGATIVE_X_AXIS,
        NEGATIVE_Y_AXIS,
        NEGATIVE_Z_AXIS;

    }
}

