/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.MultipleEntryHashMap;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

public class MultipartFormDataBuilder
implements Builder {
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (request == null) {
            throw new AxisFault("Cannot create DocumentElement without HttpServletRequest");
        }
        try {
            MultipleEntryHashMap parameterMap = this.getParameterMap(request);
            return BuilderUtil.buildsoapMessage(messageContext, parameterMap, OMAbstractFactory.getSOAP12Factory());
        }
        catch (FileUploadException e) {
            throw new AxisFault(e);
        }
    }

    private MultipleEntryHashMap getParameterMap(HttpServletRequest request) throws FileUploadException {
        MultipleEntryHashMap parameterMap = new MultipleEntryHashMap();
        List items = MultipartFormDataBuilder.parseRequest(new ServletRequestContext(request));
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            String[] value = new String[1];
            DiskFileItem diskFileItem = (DiskFileItem)iter.next();
            value[0] = diskFileItem.getString();
            parameterMap.put(diskFileItem.getFieldName(), value);
        }
        return parameterMap;
    }

    private static List parseRequest(ServletRequestContext requestContext) throws FileUploadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        return upload.parseRequest((RequestContext)requestContext);
    }
}

