/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.SelfManagedDataManager;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.MetaDataEntry;
import org.apache.axis2.util.ObjectStateUtils;
import org.apache.axis2.util.SelfManagedDataHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;

public class MessageContext
extends AbstractContext
implements Externalizable {
    private static final Log log = LogFactory.getLog((Class)MessageContext.class);
    private String logCorrelationID = null;
    private transient String logCorrelationIDString = null;
    private static final String myClassName = "MessageContext";
    private static final long serialVersionUID = -7753637088257391858L;
    private static final int REVISION_1 = 1;
    private static final int revisionID = 1;
    public static ThreadLocal currentMessageContext = new ThreadLocal();
    protected Options options = new Options();
    public static final int IN_FLOW = 1;
    public static final int IN_FAULT_FLOW = 3;
    public static final int OUT_FLOW = 2;
    public static final int OUT_FAULT_FLOW = 4;
    public static final String REMOTE_ADDR = "REMOTE_ADDR";
    public static final String TRANSPORT_ADDR = "TRANSPORT_ADDR";
    public static final String TRANSPORT_HEADERS = "TRANSPORT_HEADERS";
    public transient Attachments attachments;
    public static final String TRANSPORT_OUT = "TRANSPORT_OUT";
    public static final String TRANSPORT_IN = "TRANSPORT_IN";
    public static final String CHARACTER_SET_ENCODING = "CHARACTER_SET_ENCODING";
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16 = "utf-16";
    public static final String TRANSPORT_SUCCEED = "TRANSPORT_SUCCEED";
    public static final String DEFAULT_CHAR_SET_ENCODING = "UTF-8";
    public int FLOW = 1;
    public static final String TRANSPORT_NON_BLOCKING = "transportNonBlocking";
    public static final String DISABLE_ASYNC_CALLBACK_ON_TRANSPORT_ERROR = "disableTransmissionErrorCallback";
    private boolean processingFault;
    private boolean paused;
    public boolean outputWritten;
    private boolean newThreadRequired;
    private boolean isSOAP11 = true;
    private ArrayList executionChain;
    private LinkedList inboundExecutedPhases;
    private LinkedList outboundExecutedPhases;
    private boolean doingREST;
    private boolean doingMTOM;
    private boolean doingSwA;
    private transient AxisMessage axisMessage;
    private transient AxisOperation axisOperation;
    private transient AxisService axisService;
    private transient AxisServiceGroup axisServiceGroup;
    private transient ConfigurationContext configurationContext;
    private int currentHandlerIndex;
    private int currentPhaseIndex;
    private SOAPEnvelope envelope;
    private OperationContext operationContext;
    private boolean responseWritten;
    private boolean serverSide;
    private ServiceContext serviceContext;
    private String serviceContextID;
    private ServiceGroupContext serviceGroupContext;
    private String serviceGroupContextId;
    private SessionContext sessionContext;
    private transient TransportOutDescription transportOut;
    private transient TransportInDescription transportIn;
    private String incomingTransportName;
    private transient LinkedHashMap selfManagedDataMap = null;
    private transient boolean needsToBeReconciled = false;
    private transient int selfManagedDataHandlerCount = 0;
    private transient ArrayList selfManagedDataListHolder = null;
    private transient ArrayList metaExecutionChain = null;
    private transient LinkedList metaInboundExecuted = null;
    private transient LinkedList metaOutboundExecuted = null;
    private transient int metaHandlerIndex = 0;
    private transient int metaPhaseIndex = 0;
    private transient MetaDataEntry metaAxisOperation = null;
    private transient MetaDataEntry metaAxisService = null;
    private transient MetaDataEntry metaAxisServiceGroup = null;
    private transient MetaDataEntry metaTransportOut = null;
    private transient MetaDataEntry metaTransportIn = null;
    private transient MetaDataEntry metaAxisMessage = null;
    private transient boolean reconcileAxisMessage = false;
    private transient boolean inboundReset = false;
    private transient boolean outboundReset = false;
    private String selfManagedDataDelimiter = "*";
    static /* synthetic */ Class class$org$apache$axis2$context$SelfManagedDataManager;

    public static MessageContext getCurrentMessageContext() {
        return (MessageContext)currentMessageContext.get();
    }

    public static void setCurrentMessageContext(MessageContext ctx) {
        currentMessageContext.set(ctx);
    }

    public MessageContext() {
        super(null);
    }

    public String toString() {
        return this.getLogIDString();
    }

    public String getLogCorrelationID() {
        if (this.logCorrelationID == null) {
            this.logCorrelationID = UUIDGenerator.getUUID();
        }
        return this.logCorrelationID;
    }

    public String getLogIDString() {
        if (this.logCorrelationIDString == null) {
            this.logCorrelationIDString = "[MessageContext: logID=" + this.getLogCorrelationID() + "]";
        }
        return this.logCorrelationIDString;
    }

    public void pause() {
        this.paused = true;
    }

    public AxisOperation getAxisOperation() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getAxisOperation");
        }
        return this.axisOperation;
    }

    public AxisService getAxisService() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getAxisService");
        }
        return this.axisService;
    }

    public AxisServiceGroup getAxisServiceGroup() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getAxisServiceGroup");
        }
        return this.axisServiceGroup;
    }

    public ConfigurationContext getConfigurationContext() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getConfigurationContext");
        }
        return this.configurationContext;
    }

    public int getCurrentHandlerIndex() {
        return this.currentHandlerIndex;
    }

    public int getCurrentPhaseIndex() {
        return this.currentPhaseIndex;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public ArrayList getExecutionChain() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getExecutionChain");
        }
        return this.executionChain;
    }

    public void addInboundExecutedPhase(Handler phase) {
        if (this.inboundExecutedPhases == null) {
            this.inboundExecutedPhases = new LinkedList();
        }
        this.inboundExecutedPhases.addFirst(phase);
    }

    public void removeFirstInboundExecutedPhase() {
        if (this.inboundExecutedPhases != null) {
            this.inboundExecutedPhases.removeFirst();
        }
    }

    public Iterator getInboundExecutedPhases() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getInboundExecutedPhases");
        }
        if (this.inboundExecutedPhases == null) {
            this.inboundExecutedPhases = new LinkedList();
        }
        return this.inboundExecutedPhases.iterator();
    }

    public void resetInboundExecutedPhases() {
        this.inboundReset = true;
        this.inboundExecutedPhases = new LinkedList();
    }

    public void addOutboundExecutedPhase(Handler phase) {
        if (this.outboundExecutedPhases == null) {
            this.outboundExecutedPhases = new LinkedList();
        }
        this.outboundExecutedPhases.addFirst(phase);
    }

    public void removeFirstOutboundExecutedPhase() {
        if (this.outboundExecutedPhases != null) {
            this.outboundExecutedPhases.removeFirst();
        }
    }

    public Iterator getOutboundExecutedPhases() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getOutboundExecutedPhases");
        }
        if (this.outboundExecutedPhases == null) {
            this.outboundExecutedPhases = new LinkedList();
        }
        return this.outboundExecutedPhases.iterator();
    }

    public void resetOutboundExecutedPhases() {
        this.outboundReset = true;
        this.outboundExecutedPhases = new LinkedList();
    }

    public EndpointReference getFaultTo() {
        return this.options.getFaultTo();
    }

    public EndpointReference getFrom() {
        return this.options.getFrom();
    }

    public String getMessageID() {
        return this.options.getMessageId();
    }

    public Parameter getModuleParameter(String key, String moduleName, HandlerDescription handler) {
        AxisModule module;
        AxisConfiguration baseConfig;
        AxisServiceGroup axisServiceDesc;
        AxisService axisService;
        Parameter param;
        ModuleConfiguration moduleConfig;
        AxisOperation opDesc = this.getAxisOperation();
        if (opDesc != null && (moduleConfig = opDesc.getModuleConfig(moduleName)) != null) {
            param = moduleConfig.getParameter(key);
            if (param != null) {
                return param;
            }
            param = opDesc.getParameter(key);
            if (param != null) {
                return param;
            }
        }
        if ((axisService = this.getAxisService()) != null && (moduleConfig = axisService.getModuleConfig(moduleName)) != null) {
            param = moduleConfig.getParameter(key);
            if (param != null) {
                return param;
            }
            param = axisService.getParameter(key);
            if (param != null) {
                return param;
            }
        }
        if ((axisServiceDesc = this.getAxisServiceGroup()) != null && (moduleConfig = axisServiceDesc.getModuleConfig(moduleName)) != null) {
            param = moduleConfig.getParameter(key);
            if (param != null) {
                return param;
            }
            param = axisServiceDesc.getParameter(key);
            if (param != null) {
                return param;
            }
        }
        if ((moduleConfig = (baseConfig = this.configurationContext.getAxisConfiguration()).getModuleConfig(moduleName)) != null) {
            param = moduleConfig.getParameter(key);
            if (param != null) {
                return param;
            }
            param = baseConfig.getParameter(key);
            if (param != null) {
                return param;
            }
        }
        if ((module = baseConfig.getModule(moduleName)) != null && (param = module.getParameter(key)) != null) {
            return param;
        }
        param = handler.getParameter(key);
        return param;
    }

    public OperationContext getOperationContext() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getOperationContext");
        }
        return this.operationContext;
    }

    public Parameter getParameter(String key) {
        if (this.axisOperation != null) {
            return this.axisOperation.getParameter(key);
        }
        if (this.axisService != null) {
            return this.axisService.getParameter(key);
        }
        if (this.axisServiceGroup != null) {
            return this.axisServiceGroup.getParameter(key);
        }
        if (this.configurationContext != null) {
            AxisConfiguration baseConfig = this.configurationContext.getAxisConfiguration();
            return baseConfig.getParameter(key);
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        this.options.setProperty(name, value);
    }

    public Object getProperty(String name) {
        Object obj;
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getProperty");
        }
        if ((obj = this.options.getProperty(name)) != null) {
            return obj;
        }
        if (this.operationContext != null) {
            return this.operationContext.getProperty(name);
        }
        if (this.serviceContext != null) {
            return this.serviceContext.getProperty(name);
        }
        if (this.serviceGroupContext != null) {
            return this.serviceGroupContext.getProperty(name);
        }
        if (this.configurationContext != null) {
            return this.configurationContext.getProperty(name);
        }
        return null;
    }

    public Map getProperties() {
        HashMap resultMap = new HashMap();
        if (this.configurationContext != null) {
            resultMap.putAll(this.configurationContext.getProperties());
        }
        if (this.serviceGroupContext != null) {
            resultMap.putAll(this.serviceGroupContext.getProperties());
        }
        if (this.serviceContext != null) {
            resultMap.putAll(this.serviceContext.getProperties());
        }
        if (this.operationContext != null) {
            resultMap.putAll(this.operationContext.getProperties());
        }
        resultMap.putAll(this.options.getProperties());
        return Collections.unmodifiableMap(resultMap);
    }

    public RelatesTo[] getRelationships() {
        return this.options.getRelationships();
    }

    public RelatesTo getRelatesTo(String type) {
        return this.options.getRelatesTo(type);
    }

    public RelatesTo getRelatesTo() {
        return this.options.getRelatesTo();
    }

    public EndpointReference getReplyTo() {
        return this.options.getReplyTo();
    }

    public ServiceContext getServiceContext() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getServiceContext");
        }
        return this.serviceContext;
    }

    public String getServiceContextID() {
        return this.serviceContextID;
    }

    public ServiceGroupContext getServiceGroupContext() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getServiceGroupContext");
        }
        return this.serviceGroupContext;
    }

    public String getServiceGroupContextId() {
        return this.serviceGroupContextId;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public String getSoapAction() {
        return this.options.getAction();
    }

    public EndpointReference getTo() {
        return this.options.getTo();
    }

    public TransportInDescription getTransportIn() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getTransportIn");
        }
        return this.transportIn;
    }

    public TransportOutDescription getTransportOut() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getTransportOut");
        }
        return this.transportOut;
    }

    public String getWSAAction() {
        return this.options.getAction();
    }

    public boolean isDoingMTOM() {
        return this.doingMTOM;
    }

    public boolean isDoingREST() {
        return this.doingREST;
    }

    public boolean isDoingSwA() {
        return this.doingSwA;
    }

    public boolean isNewThreadRequired() {
        return this.newThreadRequired;
    }

    public boolean isOutputWritten() {
        return this.outputWritten;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isProcessingFault() {
        return this.processingFault;
    }

    public boolean isResponseWritten() {
        return this.responseWritten;
    }

    public boolean isSOAP11() {
        return this.isSOAP11;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public AxisMessage getAxisMessage() {
        if (this.reconcileAxisMessage) {
            log.warn((Object)(this.getLogIDString() + ":getAxisMessage(): ****WARNING**** MessageContext.activate(configurationContext) needs to be invoked."));
        }
        return this.axisMessage;
    }

    public void setAxisMessage(AxisMessage axisMessage) {
        this.axisMessage = axisMessage;
    }

    public void setAxisOperation(AxisOperation axisOperation) {
        this.axisOperation = axisOperation;
    }

    public void setAxisService(AxisService axisService) {
        this.axisService = axisService;
        this.axisServiceGroup = this.axisService != null ? (AxisServiceGroup)this.axisService.getParent() : null;
    }

    public void setAxisServiceGroup(AxisServiceGroup axisServiceGroup) {
        this.axisServiceGroup = axisServiceGroup;
    }

    public void setConfigurationContext(ConfigurationContext context) {
        this.configurationContext = context;
    }

    public void setCurrentHandlerIndex(int currentHandlerIndex) {
        this.currentHandlerIndex = currentHandlerIndex;
    }

    public void setCurrentPhaseIndex(int currentPhaseIndex) {
        this.currentPhaseIndex = currentPhaseIndex;
    }

    public void setDoingMTOM(boolean b) {
        this.doingMTOM = b;
    }

    public void setDoingREST(boolean b) {
        this.doingREST = b;
    }

    public void setDoingSwA(boolean b) {
        this.doingSwA = b;
    }

    public void setEnvelope(SOAPEnvelope envelope) throws AxisFault {
        this.envelope = envelope;
        if (this.envelope != null) {
            String soapNamespaceURI = envelope.getNamespace().getNamespaceURI();
            if ("http://www.w3.org/2003/05/soap-envelope".equals(soapNamespaceURI)) {
                this.isSOAP11 = false;
            } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapNamespaceURI)) {
                this.isSOAP11 = true;
            } else {
                throw new AxisFault("Unknown SOAP Version. Current Axis handles only SOAP 1.1 and SOAP 1.2 messages");
            }
        }
    }

    public void setExecutionChain(ArrayList executionChain) {
        this.executionChain = executionChain;
        this.currentHandlerIndex = -1;
        this.currentPhaseIndex = 0;
    }

    public void setFaultTo(EndpointReference reference) {
        this.options.setFaultTo(reference);
    }

    public void setFrom(EndpointReference reference) {
        this.options.setFrom(reference);
    }

    public void setMessageID(String messageId) {
        this.options.setMessageId(messageId);
    }

    public void setNewThreadRequired(boolean b) {
        this.newThreadRequired = b;
    }

    public void setOperationContext(OperationContext context) {
        this.operationContext = context;
        this.setParent(this.operationContext);
        if (this.operationContext != null) {
            if (this.serviceContext != null && this.operationContext.getParent() == null) {
                this.operationContext.setParent(this.serviceContext);
            }
            this.setAxisOperation(this.operationContext.getAxisOperation());
        }
    }

    public void setOutputWritten(boolean b) {
        this.outputWritten = b;
    }

    public void setProcessingFault(boolean b) {
        this.processingFault = b;
    }

    public void addRelatesTo(RelatesTo reference) {
        this.options.addRelatesTo(reference);
    }

    public void setReplyTo(EndpointReference referance) {
        this.options.setReplyTo(referance);
    }

    public void setResponseWritten(boolean b) {
        this.responseWritten = b;
    }

    public void setServerSide(boolean b) {
        this.serverSide = b;
    }

    public void setServiceContext(ServiceContext context) {
        this.serviceContext = context;
        if (this.serviceContext != null) {
            if (this.operationContext != null && this.operationContext.getParent() != null) {
                this.operationContext.setParent(context);
            }
            if (this.configurationContext == null) {
                this.configurationContext = context.getConfigurationContext();
            }
            if (this.serviceGroupContext == null) {
                this.serviceGroupContext = context.getServiceGroupContext();
            }
            this.setAxisService(context.getAxisService());
        }
    }

    public void setServiceContextID(String serviceContextID) {
        this.serviceContextID = serviceContextID;
    }

    public void setServiceGroupContext(ServiceGroupContext serviceGroupContext) {
        this.serviceGroupContext = serviceGroupContext;
        if (this.serviceGroupContext != null) {
            this.axisServiceGroup = serviceGroupContext.getDescription();
        }
    }

    public void setServiceGroupContextId(String serviceGroupContextId) {
        this.serviceGroupContextId = serviceGroupContextId;
    }

    public void setSoapAction(String soapAction) {
        this.options.setAction(soapAction);
    }

    public void setTo(EndpointReference to) {
        this.options.setTo(to);
    }

    public void setTransportIn(TransportInDescription in) {
        this.transportIn = in;
    }

    public void setTransportOut(TransportOutDescription out) {
        this.transportOut = out;
    }

    public void setWSAAction(String actionURI) {
        this.options.setAction(actionURI);
    }

    public void setWSAMessageId(String messageID) {
        this.options.setMessageId(messageID);
    }

    public int getFLOW() {
        return this.FLOW;
    }

    public void setFLOW(int FLOW) {
        this.FLOW = FLOW;
    }

    public Options getOptions() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getOptions");
        }
        return this.options;
    }

    public void setOptions(Options options) {
        this.options.setParent(options);
    }

    public String getIncomingTransportName() {
        return this.incomingTransportName;
    }

    public void setIncomingTransportName(String incomingTransportName) {
        this.incomingTransportName = incomingTransportName;
    }

    public void setRelationships(RelatesTo[] list) {
        this.options.setRelationships(list);
    }

    public Policy getEffectivePolicy() {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("getEffectivePolicy");
        }
        if (this.axisMessage != null) {
            return this.axisMessage.getPolicyInclude().getEffectivePolicy();
        }
        if (this.axisOperation != null) {
            return this.axisOperation.getPolicyInclude().getEffectivePolicy();
        }
        if (this.axisService != null) {
            return this.axisService.getPolicyInclude().getEffectivePolicy();
        }
        return this.configurationContext.getAxisConfiguration().getPolicyInclude().getEffectivePolicy();
    }

    public boolean isEngaged(String moduleName) {
        if (LoggingControl.debugLoggingAllowed) {
            this.checkActivateWarning("isEngaged");
        }
        if (this.configurationContext != null) {
            AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
            AxisModule module = axisConfig.getModule(moduleName);
            if (module == null) {
                return false;
            }
            boolean enegage = axisConfig.isEngaged(moduleName);
            if (enegage) {
                return true;
            }
            if (this.axisServiceGroup != null && (enegage = this.axisServiceGroup.isEngaged(moduleName))) {
                return true;
            }
            if (this.axisService != null && (enegage = this.axisService.isEngaged(moduleName))) {
                return true;
            }
            if (this.axisOperation != null && (enegage = this.axisOperation.isEngaged(module.getName()))) {
                return true;
            }
        }
        return false;
    }

    public boolean isHeaderPresent() {
        if (this.envelope == null) {
            return false;
        }
        return this.envelope.getHeader() != null;
    }

    public void setAttachmentMap(Attachments attachments) {
        this.attachments = attachments;
    }

    public Attachments getAttachmentMap() {
        if (this.attachments == null) {
            this.attachments = new Attachments();
        }
        return this.attachments;
    }

    public void addAttachment(String contentID, DataHandler dataHandler) {
        if (this.attachments == null) {
            this.attachments = new Attachments();
        }
        this.attachments.addDataHandler(contentID, dataHandler);
    }

    public String addAttachment(DataHandler dataHandler) {
        String contentID = UUIDGenerator.getUUID();
        this.addAttachment(contentID, dataHandler);
        return contentID;
    }

    public DataHandler getAttachment(String contentID) {
        if (this.attachments == null) {
            this.attachments = new Attachments();
        }
        return this.attachments.getDataHandler(contentID);
    }

    public void removeAttachment(String contentID) {
        if (this.attachments != null) {
            this.attachments.removeDataHandler(contentID);
        }
    }

    private String generateSelfManagedDataKey(Class clazz, Object key) {
        return clazz.getName() + this.selfManagedDataDelimiter + key.toString() + this.selfManagedDataDelimiter + Integer.toString(key.hashCode());
    }

    public void setSelfManagedData(Class clazz, Object key, Object value) {
        if (this.selfManagedDataMap == null) {
            this.selfManagedDataMap = new LinkedHashMap();
        }
        this.selfManagedDataMap.put(this.generateSelfManagedDataKey(clazz, key), value);
    }

    public Object getSelfManagedData(Class clazz, Object key) {
        if (this.selfManagedDataMap != null) {
            return this.selfManagedDataMap.get(this.generateSelfManagedDataKey(clazz, key));
        }
        return null;
    }

    public boolean containsSelfManagedDataKey(Class clazz, Object key) {
        if (this.selfManagedDataMap != null) {
            return this.selfManagedDataMap.containsKey(this.generateSelfManagedDataKey(clazz, key));
        }
        return false;
    }

    public void removeSelfManagedData(Class clazz, Object key) {
        if (this.selfManagedDataMap != null) {
            this.selfManagedDataMap.remove(this.generateSelfManagedDataKey(clazz, key));
        }
    }

    private ArrayList flattenPhaseListToHandlers(ArrayList list, LinkedHashMap map) {
        String key;
        if (map == null) {
            map = new LinkedHashMap<String, Handler>();
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Handler handler = (Handler)it.next();
            key = null;
            if (handler != null) {
                key = handler.getClass().getName() + "@" + handler.hashCode();
            }
            if (handler instanceof Phase) {
                this.flattenHandlerList(((Phase)handler).getHandlers(), map);
                continue;
            }
            map.put(key, handler);
        }
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            Iterator it2 = map.keySet().iterator();
            while (it2.hasNext()) {
                key = (String)it2.next();
                Handler value = (Handler)map.get(key);
                String name = value.getName();
                log.trace((Object)(this.getLogIDString() + ":flattenPhaseListToHandlers():  key [" + key + "]    handler name [" + name + "]"));
            }
        }
        return new ArrayList(map.values());
    }

    private ArrayList flattenHandlerList(ArrayList list, LinkedHashMap map) {
        if (map == null) {
            map = new LinkedHashMap<String, Handler>();
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Handler handler = (Handler)it.next();
            String key = null;
            if (handler != null) {
                key = handler.getClass().getName() + "@" + handler.hashCode();
            }
            if (handler instanceof Phase) {
                map.put(key, handler);
                this.flattenHandlerList(((Phase)handler).getHandlers(), map);
                continue;
            }
            map.put(key, handler);
        }
        return new ArrayList(map.values());
    }

    private void serializeSelfManagedData(ObjectOutput out) {
        this.selfManagedDataHandlerCount = 0;
        try {
            if (this.selfManagedDataMap == null || this.executionChain == null || this.selfManagedDataMap.size() == 0 || this.executionChain.size() == 0) {
                out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(this.getLogIDString() + ":serializeSelfManagedData(): No data : END"));
                }
                return;
            }
            ArrayList flatExecChain = this.flattenPhaseListToHandlers(this.executionChain, null);
            ArrayList selfManagedDataHolderList = this.serializeSelfManagedDataHelper(flatExecChain);
            if (selfManagedDataHolderList.size() == 0) {
                out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(this.getLogIDString() + ":serializeSelfManagedData(): No data : END"));
                }
                return;
            }
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            out.writeInt(selfManagedDataHolderList.size());
            for (int i = 0; i < selfManagedDataHolderList.size(); ++i) {
                out.writeObject(selfManagedDataHolderList.get(i));
            }
        }
        catch (IOException e) {
            log.trace((Object)("MessageContext:serializeSelfManagedData(): Exception [" + e.getClass().getName() + "]  description [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private ArrayList serializeSelfManagedDataHelper(ArrayList handlers) {
        ArrayList<SelfManagedDataHolder> selfManagedDataHolderList = new ArrayList<SelfManagedDataHolder>();
        Iterator it = handlers.iterator();
        try {
            while (it.hasNext()) {
                ByteArrayOutputStream baos_fromHandler;
                Handler handler;
                if (!(class$org$apache$axis2$context$SelfManagedDataManager == null ? MessageContext.class$("org.apache.axis2.context.SelfManagedDataManager") : class$org$apache$axis2$context$SelfManagedDataManager).isAssignableFrom((handler = (Handler)it.next()).getClass())) continue;
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)("MessageContext:serializeSelfManagedDataHelper(): calling handler  [" + handler.getClass().getName() + "]  name [" + handler.getName() + "]   serializeSelfManagedData method"));
                }
                if ((baos_fromHandler = ((SelfManagedDataManager)((Object)handler)).serializeSelfManagedData(this)) == null) continue;
                baos_fromHandler.close();
                try {
                    SelfManagedDataHolder selfManagedDataHolder = new SelfManagedDataHolder(handler.getClass().getName(), handler.getName(), baos_fromHandler.toByteArray());
                    selfManagedDataHolderList.add(selfManagedDataHolder);
                    ++this.selfManagedDataHandlerCount;
                }
                catch (Exception exc) {
                    log.trace((Object)("MessageContext:serializeSelfManagedData(): exception [" + exc.getClass().getName() + "][" + exc.getMessage() + "]  in setting up SelfManagedDataHolder object for [" + handler.getClass().getName() + " / " + handler.getName() + "] "), (Throwable)exc);
                }
            }
            return selfManagedDataHolderList;
        }
        catch (Exception ex) {
            log.trace((Object)("MessageContext:serializeSelfManagedData(): exception [" + ex.getClass().getName() + "][" + ex.getMessage() + "]"), (Throwable)ex);
            return null;
        }
    }

    private SelfManagedDataManager deserialize_getHandlerFromExecutionChain(Iterator it, String classname, String qNameAsString) {
        SelfManagedDataManager handler_toreturn = null;
        try {
            while (it.hasNext() && handler_toreturn == null) {
                Handler handler = (Handler)it.next();
                if (handler instanceof Phase) {
                    handler_toreturn = this.deserialize_getHandlerFromExecutionChain(((Phase)handler).getHandlers().iterator(), classname, qNameAsString);
                    continue;
                }
                if (!handler.getClass().getName().equals(classname) || !handler.getName().equals(qNameAsString)) continue;
                handler_toreturn = (SelfManagedDataManager)((Object)handler);
            }
            return handler_toreturn;
        }
        catch (ClassCastException e) {
            log.trace((Object)("MessageContext:deserialize_getHandlerFromExecutionChain(): ClassCastException thrown: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private void deserializeSelfManagedData() throws IOException {
        try {
            for (int i = 0; this.selfManagedDataListHolder != null && i < this.selfManagedDataListHolder.size(); ++i) {
                SelfManagedDataHolder selfManagedDataHolder = (SelfManagedDataHolder)this.selfManagedDataListHolder.get(i);
                String classname = selfManagedDataHolder.getClassname();
                String qNameAsString = selfManagedDataHolder.getId();
                SelfManagedDataManager handler = this.deserialize_getHandlerFromExecutionChain(this.executionChain.iterator(), classname, qNameAsString);
                if (handler == null) {
                    if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                        log.trace((Object)(this.getLogIDString() + ":deserializeSelfManagedData():  [" + classname + "]  was not found in the executionChain associated with the message context."));
                    }
                    throw new IOException("The class [" + classname + "] was not found in the executionChain associated with the message context.");
                }
                ByteArrayInputStream handlerData = new ByteArrayInputStream(selfManagedDataHolder.getData());
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(this.getLogIDString() + ":deserializeSelfManagedData(): calling handler [" + classname + "] [" + qNameAsString + "]  deserializeSelfManagedData method"));
                }
                handler.deserializeSelfManagedData(handlerData, this);
                handler.restoreTransientData(this);
            }
        }
        catch (IOException ioe) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.getLogIDString() + ":deserializeSelfManagedData(): IOException thrown: " + ioe.getMessage()), (Throwable)ioe);
            }
            throw ioe;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        String logCorrelationIDString = this.getLogIDString();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(logCorrelationIDString + ":writeExternal(): writing to output stream"));
        }
        out.writeLong(-7753637088257391858L);
        out.writeInt(1);
        out.writeInt(this.FLOW);
        out.writeBoolean(this.processingFault);
        out.writeBoolean(this.paused);
        out.writeBoolean(this.outputWritten);
        out.writeBoolean(this.newThreadRequired);
        out.writeBoolean(this.isSOAP11);
        out.writeBoolean(this.doingREST);
        out.writeBoolean(this.doingMTOM);
        out.writeBoolean(this.doingSwA);
        out.writeBoolean(this.responseWritten);
        out.writeBoolean(this.serverSide);
        out.writeLong(this.getLastTouchedTime());
        ObjectStateUtils.writeString(out, this.getLogCorrelationID(), "logCorrelationID");
        boolean persistWithOptimizedMTOM = this.getProperty("Attachments") != null;
        out.writeBoolean(persistWithOptimizedMTOM);
        if (this.envelope != null) {
            OperationContext opContext;
            String msgClass = this.envelope.getClass().getName();
            ByteArrayOutputStream msgBuffer = new ByteArrayOutputStream();
            try {
                ByteArrayOutputStream msgData = new ByteArrayOutputStream();
                OMOutputFormat outputFormat = new OMOutputFormat();
                outputFormat.setSOAP11(this.isSOAP11);
                if (persistWithOptimizedMTOM) {
                    outputFormat.setDoOptimize(true);
                    out.writeUTF(outputFormat.getContentType());
                }
                this.envelope.serialize((OutputStream)msgData, outputFormat);
                msgBuffer.write(msgData.toByteArray(), 0, msgData.size());
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(logCorrelationIDString + ":writeExternal(): msg data [" + msgData + "]"));
                }
            }
            catch (Exception e) {
                log.trace((Object)(logCorrelationIDString + ":writeExternal(): can not serialize the SOAP message ***Exception***  [" + e.getClass().getName() + " : " + e.getMessage() + "]"));
            }
            String charSetEnc = (String)this.getProperty(CHARACTER_SET_ENCODING);
            if (charSetEnc == null && (opContext = this.getOperationContext()) != null) {
                charSetEnc = (String)opContext.getProperty(CHARACTER_SET_ENCODING);
            }
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            String namespaceURI = this.envelope.getNamespace().getNamespaceURI();
            out.writeUTF(msgClass);
            int msgSize = msgBuffer.size();
            if (msgSize != 0) {
                out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
                out.writeUTF(charSetEnc);
                out.writeUTF(namespaceURI);
                out.writeInt(msgSize);
                out.write(msgBuffer.toByteArray());
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(logCorrelationIDString + ":writeExternal(): msg  charSetEnc=[" + charSetEnc + "]  namespaceURI=[" + namespaceURI + "]  msgSize=[" + msgSize + "]"));
                }
            } else {
                out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(logCorrelationIDString + ":writeExternal(): msg  is Empty"));
                }
            }
            msgBuffer.close();
        } else {
            out.writeUTF("MessageContext.envelope");
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":writeExternal(): msg  is Empty"));
            }
        }
        String execChainDesc = logCorrelationIDString + ".executionChain";
        int listSize = 0;
        if (this.executionChain != null) {
            listSize = this.executionChain.size();
        }
        if (listSize > 0) {
            out.writeUTF(execChainDesc);
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            out.writeInt(this.currentHandlerIndex);
            out.writeInt(this.currentPhaseIndex);
            out.writeInt(listSize);
            int nextIndex = 0;
            Iterator i = this.executionChain.iterator();
            while (i.hasNext()) {
                String qnameAsString;
                Object obj = i.next();
                String objClass = obj.getClass().getName();
                MetaDataEntry mdEntry = new MetaDataEntry();
                mdEntry.setClassName(objClass);
                if (obj instanceof Phase) {
                    Phase phaseObj = (Phase)obj;
                    qnameAsString = phaseObj.getName();
                    this.setupPhaseList(phaseObj, mdEntry);
                } else if (obj instanceof Handler) {
                    Handler handlerObj = (Handler)obj;
                    qnameAsString = handlerObj.getName();
                } else {
                    qnameAsString = "NULL";
                }
                mdEntry.setQName(qnameAsString);
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(logCorrelationIDString + ":writeExternal(): ***BEFORE OBJ WRITE*** executionChain entry class [" + objClass + "] qname [" + qnameAsString + "]"));
                }
                ObjectStateUtils.writeObject(out, mdEntry, logCorrelationIDString + ".executionChain:entry class [" + objClass + "] qname [" + qnameAsString + "]");
                ++nextIndex;
                if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                log.trace((Object)(logCorrelationIDString + ":writeExternal(): ***AFTER OBJ WRITE*** executionChain entry class [" + objClass + "] qname [" + qnameAsString + "]"));
            }
            MetaDataEntry lastEntry = new MetaDataEntry();
            lastEntry.setClassName(MetaDataEntry.END_OF_LIST);
            ObjectStateUtils.writeObject(out, lastEntry, logCorrelationIDString + ".executionChain:  last entry ");
            out.writeInt(++nextIndex);
        } else {
            out.writeUTF(execChainDesc);
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":writeExternal(): executionChain is NULL"));
            }
        }
        String inExecListDesc = logCorrelationIDString + ".inboundExecutedPhases";
        int inExecListSize = 0;
        if (this.inboundExecutedPhases != null) {
            inExecListSize = this.inboundExecutedPhases.size();
        }
        if (inExecListSize > 0) {
            out.writeUTF(inExecListDesc);
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            out.writeInt(inExecListSize);
            int inExecNextIndex = 0;
            Iterator inIterator = this.inboundExecutedPhases.iterator();
            while (inIterator.hasNext()) {
                String inQnameAsString;
                Object inObj = inIterator.next();
                String inObjClass = inObj.getClass().getName();
                MetaDataEntry inMdEntry = new MetaDataEntry();
                inMdEntry.setClassName(inObjClass);
                if (inObj instanceof Phase) {
                    Phase inPhaseObj = (Phase)inObj;
                    inQnameAsString = inPhaseObj.getName();
                    this.setupPhaseList(inPhaseObj, inMdEntry);
                } else if (inObj instanceof Handler) {
                    Handler inHandlerObj = (Handler)inObj;
                    inQnameAsString = inHandlerObj.getName();
                } else {
                    inQnameAsString = "NULL";
                }
                inMdEntry.setQName(inQnameAsString);
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(logCorrelationIDString + ":writeExternal(): ***BEFORE Inbound Executed List OBJ WRITE*** inboundExecutedPhases entry class [" + inObjClass + "] qname [" + inQnameAsString + "]"));
                }
                ObjectStateUtils.writeObject(out, inMdEntry, logCorrelationIDString + ".inboundExecutedPhases:entry class [" + inObjClass + "] qname [" + inQnameAsString + "]");
                ++inExecNextIndex;
                if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                log.trace((Object)(logCorrelationIDString + ":writeExternal(): " + "***AFTER Inbound Executed List OBJ WRITE*** " + "inboundExecutedPhases entry class [" + inObjClass + "] " + "qname [" + inQnameAsString + "]"));
            }
            MetaDataEntry inLastEntry = new MetaDataEntry();
            inLastEntry.setClassName(MetaDataEntry.END_OF_LIST);
            ObjectStateUtils.writeObject(out, inLastEntry, logCorrelationIDString + ".inboundExecutedPhases:  last entry ");
            out.writeInt(++inExecNextIndex);
        } else {
            out.writeUTF(inExecListDesc);
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":writeExternal(): inboundExecutedPhases is NULL"));
            }
        }
        String outExecListDesc = logCorrelationIDString + ".outboundExecutedPhases";
        int outExecListSize = 0;
        if (this.outboundExecutedPhases != null) {
            outExecListSize = this.outboundExecutedPhases.size();
        }
        if (outExecListSize > 0) {
            out.writeUTF(outExecListDesc);
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            out.writeInt(outExecListSize);
            int outExecNextIndex = 0;
            Iterator outIterator = this.outboundExecutedPhases.iterator();
            while (outIterator.hasNext()) {
                String outQnameAsString;
                Object outObj = outIterator.next();
                String outObjClass = outObj.getClass().getName();
                MetaDataEntry outMdEntry = new MetaDataEntry();
                outMdEntry.setClassName(outObjClass);
                if (outObj instanceof Phase) {
                    Phase outPhaseObj = (Phase)outObj;
                    outQnameAsString = outPhaseObj.getName();
                    this.setupPhaseList(outPhaseObj, outMdEntry);
                } else if (outObj instanceof Handler) {
                    Handler outHandlerObj = (Handler)outObj;
                    outQnameAsString = outHandlerObj.getName();
                } else {
                    outQnameAsString = "NULL";
                }
                outMdEntry.setQName(outQnameAsString);
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(logCorrelationIDString + ":writeExternal(): ***BEFORE Outbound Executed List OBJ WRITE*** outboundExecutedPhases entry class [" + outObjClass + "] qname [" + outQnameAsString + "]"));
                }
                ObjectStateUtils.writeObject(out, outMdEntry, logCorrelationIDString + ".outboundExecutedPhases:entry class [" + outObjClass + "] qname [" + outQnameAsString + "]");
                ++outExecNextIndex;
                if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                log.trace((Object)(logCorrelationIDString + ":writeExternal(): ***AFTER Outbound Executed List OBJ WRITE*** outboundExecutedPhases entry class [" + outObjClass + "] qname [" + outQnameAsString + "]"));
            }
            MetaDataEntry outLastEntry = new MetaDataEntry();
            outLastEntry.setClassName(MetaDataEntry.END_OF_LIST);
            ObjectStateUtils.writeObject(out, outLastEntry, logCorrelationIDString + ".outboundExecutedPhases:  last entry ");
            out.writeInt(++outExecNextIndex);
        } else {
            out.writeUTF(outExecListDesc);
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":writeExternal(): outboundExecutedPhases is NULL"));
            }
        }
        String tmpID = this.getMessageID();
        if (tmpID == null) {
            tmpID = UUIDGenerator.getUUID();
            this.setMessageID(tmpID);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(logCorrelationIDString + ":writeExternal():   message ID [" + tmpID + "]"));
        }
        ObjectStateUtils.writeObject(out, this.options, logCorrelationIDString + ".options   for  [" + this.options.getLogCorrelationIDString() + "]");
        String axisOpMarker = logCorrelationIDString + ".axisOperation";
        ObjectStateUtils.writeString(out, axisOpMarker, axisOpMarker);
        if (this.axisOperation == null) {
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
        } else {
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            QName aoTmpQName = this.axisOperation.getName();
            if (aoTmpQName == null) {
                aoTmpQName = new QName(ObjectStateUtils.EMPTY_MARKER);
                this.axisOperation.setName(aoTmpQName);
            }
            this.metaAxisOperation = new MetaDataEntry(this.axisOperation.getClass().getName(), this.axisOperation.getName().toString());
            ObjectStateUtils.writeObject(out, this.metaAxisOperation, logCorrelationIDString + ".metaAxisOperation");
        }
        String oc_desc = logCorrelationIDString + ".operationContext";
        if (this.operationContext != null) {
            this.operationContext.isolateMessageContext(this);
            oc_desc = oc_desc + "  for  [" + this.operationContext.getLogCorrelationIDString() + "]";
        }
        ObjectStateUtils.writeObject(out, this.operationContext, oc_desc);
        String axisServMarker = logCorrelationIDString + ".axisService";
        ObjectStateUtils.writeString(out, axisServMarker, axisServMarker);
        if (this.axisService == null) {
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
        } else {
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            this.metaAxisService = new MetaDataEntry(this.axisService.getClass().getName(), this.axisService.getName());
            ObjectStateUtils.writeObject(out, this.metaAxisService, logCorrelationIDString + ".metaAxisService");
        }
        ObjectStateUtils.writeString(out, this.serviceContextID, logCorrelationIDString + ".serviceContextID");
        boolean isParent = false;
        if (this.operationContext != null) {
            ServiceContext opctxParent = this.operationContext.getServiceContext();
            if (this.serviceContext != null && this.serviceContext.equals(opctxParent)) {
                isParent = true;
            }
        }
        String servCtxMarker = logCorrelationIDString + ".serviceContext";
        ObjectStateUtils.writeString(out, servCtxMarker, servCtxMarker);
        if (this.serviceContext == null) {
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
        } else {
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            out.writeBoolean(isParent);
            if (!isParent) {
                ObjectStateUtils.writeObject(out, this.serviceContext, logCorrelationIDString + ".serviceContext");
            }
        }
        String axisServGrpMarker = logCorrelationIDString + ".axisServiceGroup";
        ObjectStateUtils.writeString(out, axisServGrpMarker, axisServGrpMarker);
        if (this.axisServiceGroup == null) {
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
        } else {
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            this.metaAxisServiceGroup = new MetaDataEntry(this.axisServiceGroup.getClass().getName(), this.axisServiceGroup.getServiceGroupName());
            ObjectStateUtils.writeObject(out, this.metaAxisServiceGroup, logCorrelationIDString + ".metaAxisServiceGroup");
        }
        ObjectStateUtils.writeString(out, this.serviceGroupContextId, logCorrelationIDString + ".serviceGroupContextId");
        isParent = false;
        if (this.serviceContext != null) {
            ServiceGroupContext srvgrpctxParent = (ServiceGroupContext)this.serviceContext.getParent();
            if (this.serviceGroupContext != null && this.serviceGroupContext.equals(srvgrpctxParent)) {
                isParent = true;
            }
        }
        String servGrpCtxMarker = logCorrelationIDString + ".serviceGroupContext";
        ObjectStateUtils.writeString(out, servGrpCtxMarker, servGrpCtxMarker);
        if (this.serviceGroupContext == null) {
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
        } else {
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            out.writeBoolean(isParent);
            if (!isParent) {
                ObjectStateUtils.writeObject(out, this.serviceGroupContext, logCorrelationIDString + ".serviceGroupContext");
            }
        }
        String axisMsgMarker = logCorrelationIDString + ".axisMessage";
        ObjectStateUtils.writeString(out, axisMsgMarker, axisMsgMarker);
        if (this.axisMessage == null) {
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
        } else {
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            String amTmpName = this.axisMessage.getName();
            if (amTmpName == null) {
                amTmpName = ObjectStateUtils.EMPTY_MARKER;
                this.axisMessage.setName(amTmpName);
            }
            QName amTmpElementQName = this.axisMessage.getElementQName();
            String amTmpElemQNameString = null;
            if (amTmpElementQName != null) {
                amTmpElemQNameString = amTmpElementQName.toString();
            }
            this.metaAxisMessage = new MetaDataEntry(this.axisMessage.getClass().getName(), this.axisMessage.getName(), amTmpElemQNameString);
            ObjectStateUtils.writeObject(out, this.metaAxisMessage, logCorrelationIDString + ".metaAxisMessage");
        }
        ObjectStateUtils.writeObject(out, this.sessionContext, logCorrelationIDString + ".sessionContext");
        ObjectStateUtils.writeString(out, this.incomingTransportName, logCorrelationIDString + ".incomingTransportName");
        this.metaTransportIn = this.transportIn != null ? new MetaDataEntry(null, this.transportIn.getName().toString()) : null;
        ObjectStateUtils.writeObject(out, this.metaTransportIn, logCorrelationIDString + ".transportIn");
        this.metaTransportOut = this.transportOut != null ? new MetaDataEntry(null, this.transportOut.getName().toString()) : null;
        ObjectStateUtils.writeObject(out, this.metaTransportOut, logCorrelationIDString + ".transportOut");
        Map tmpMap = this.getProperties();
        HashMap tmpHashMap = null;
        if (tmpMap != null && !tmpMap.isEmpty()) {
            tmpHashMap = new HashMap(tmpMap);
        }
        ObjectStateUtils.writeHashMap(out, tmpHashMap, logCorrelationIDString + ".properties");
        String selfManagedDataMarker = logCorrelationIDString + ".selfManagedData";
        ObjectStateUtils.writeString(out, selfManagedDataMarker, selfManagedDataMarker);
        this.serializeSelfManagedData(out);
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(logCorrelationIDString + ":writeExternal(): completed writing to output stream for " + logCorrelationIDString));
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean isParentSGC;
        boolean isParent;
        this.needsToBeReconciled = true;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("MessageContext:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  "));
        }
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != -7753637088257391858L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 1) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        this.FLOW = in.readInt();
        this.processingFault = in.readBoolean();
        this.paused = in.readBoolean();
        this.outputWritten = in.readBoolean();
        this.newThreadRequired = in.readBoolean();
        this.isSOAP11 = in.readBoolean();
        this.doingREST = in.readBoolean();
        this.doingMTOM = in.readBoolean();
        this.doingSwA = in.readBoolean();
        this.responseWritten = in.readBoolean();
        this.serverSide = in.readBoolean();
        long time = in.readLong();
        this.setLastTouchedTime(time);
        this.logCorrelationID = ObjectStateUtils.readString(in, "logCorrelationID");
        this.logCorrelationIDString = "[MessageContext: logID=" + this.logCorrelationID + "]";
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("MessageContext:readExternal():  reading the input stream for  " + this.logCorrelationIDString));
        }
        boolean persistedWithOptimizedMTOM = in.readBoolean();
        String contentType = null;
        if (persistedWithOptimizedMTOM) {
            contentType = in.readUTF();
        }
        in.readUTF();
        boolean gotMsg = in.readBoolean();
        if (gotMsg == ObjectStateUtils.ACTIVE_OBJECT) {
            int bytesRead;
            int numberOfBytesLastRead;
            String charSetEnc = in.readUTF();
            String namespaceURI = in.readUTF();
            int msgSize = in.readInt();
            byte[] buffer = new byte[msgSize];
            for (bytesRead = 0; bytesRead < msgSize; bytesRead += numberOfBytesLastRead) {
                numberOfBytesLastRead = in.read(buffer, bytesRead, msgSize - bytesRead);
                if (numberOfBytesLastRead != -1) continue;
                if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) break;
                log.trace((Object)(this.logCorrelationIDString + ":readExternal(): ***WARNING*** unexpected end to message   bytesRead [" + bytesRead + "]    msgSize [" + msgSize + "]"));
                break;
            }
            String tmpMsg = new String(buffer);
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.logCorrelationIDString + ":readExternal(): msg  charSetEnc=[" + charSetEnc + "]  namespaceURI=[" + namespaceURI + "]  msgSize=[" + msgSize + "]   bytesRead [" + bytesRead + "]"));
                log.trace((Object)(this.logCorrelationIDString + ":readExternal(): msg  [" + tmpMsg + "]"));
            }
            if (bytesRead > 0) {
                ByteArrayInputStream msgBuffer = new ByteArrayInputStream(buffer);
                try {
                    if (persistedWithOptimizedMTOM) {
                        boolean isSOAP = true;
                        StAXBuilder builder = BuilderUtil.getAttachmentsBuilder(this, msgBuffer, contentType, isSOAP);
                        this.envelope = (SOAPEnvelope)builder.getDocumentElement();
                    } else {
                        XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((InputStream)msgBuffer, (String)charSetEnc);
                        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlreader, namespaceURI);
                        this.envelope = (SOAPEnvelope)builder.getDocumentElement();
                    }
                }
                catch (Exception ex) {
                    log.error((Object)(this.logCorrelationIDString + ":readExternal(): Error when deserializing persisted envelope: [" + ex.getClass().getName() + " : " + ex.getLocalizedMessage() + "]"), (Throwable)ex);
                    this.envelope = null;
                }
                msgBuffer.close();
            } else {
                this.envelope = null;
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(this.logCorrelationIDString + ":readExternal(): no message from the input stream"));
                }
            }
        } else {
            this.envelope = null;
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.logCorrelationIDString + ":readExternal(): no message present"));
            }
        }
        this.executionChain = null;
        this.currentHandlerIndex = -1;
        this.currentPhaseIndex = 0;
        this.metaExecutionChain = null;
        in.readUTF();
        boolean gotChain = in.readBoolean();
        if (gotChain == ObjectStateUtils.ACTIVE_OBJECT) {
            this.metaHandlerIndex = in.readInt();
            this.metaPhaseIndex = in.readInt();
            int expectedNumberEntries = in.readInt();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.logCorrelationIDString + ":readExternal(): execution chain:  expected number of entries [" + expectedNumberEntries + "]"));
            }
            this.metaExecutionChain = new ArrayList();
            boolean keepGoing = true;
            int count = 0;
            while (keepGoing) {
                Object tmpObj = ObjectStateUtils.readObject(in, "MessageContext.metaExecutionChain MetaDataEntry");
                ++count;
                MetaDataEntry mdObj = (MetaDataEntry)tmpObj;
                String tmpHasList = "no list";
                if (mdObj != null) {
                    String tmpClassNameStr = mdObj.getClassName();
                    if (tmpClassNameStr.equalsIgnoreCase(MetaDataEntry.END_OF_LIST)) {
                        keepGoing = false;
                        continue;
                    }
                    this.metaExecutionChain.add(mdObj);
                    String tmpQNameAsStr = mdObj.getQNameAsString();
                    if (!mdObj.isListEmpty()) {
                        tmpHasList = "has list";
                    }
                    if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                    log.trace((Object)(this.logCorrelationIDString + ":readExternal(): meta data class [" + tmpClassNameStr + "] qname [" + tmpQNameAsStr + "]  index [" + count + "]   [" + tmpHasList + "]"));
                    continue;
                }
                keepGoing = false;
            }
            int adjustedNumberEntries = in.readInt();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.logCorrelationIDString + ":readExternal(): adjusted number of entries ExecutionChain [" + adjustedNumberEntries + "]    "));
            }
        }
        if ((this.metaExecutionChain == null || this.metaExecutionChain.isEmpty()) && LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.logCorrelationIDString + ":readExternal(): meta data for Execution Chain is NULL"));
        }
        this.inboundExecutedPhases = null;
        this.metaInboundExecuted = null;
        in.readUTF();
        boolean gotInExecList = in.readBoolean();
        if (gotInExecList == ObjectStateUtils.ACTIVE_OBJECT) {
            int expectedNumberInExecList = in.readInt();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.logCorrelationIDString + ":readExternal(): inbound executed phases:  expected number of entries [" + expectedNumberInExecList + "]"));
            }
            this.metaInboundExecuted = new LinkedList();
            boolean keepGoing = true;
            int count = 0;
            while (keepGoing) {
                Object tmpObj = ObjectStateUtils.readObject(in, "MessageContext.metaInboundExecuted MetaDataEntry");
                ++count;
                MetaDataEntry mdObj = (MetaDataEntry)tmpObj;
                String tmpHasList = "no list";
                if (mdObj != null) {
                    String tmpClassNameStr = mdObj.getClassName();
                    if (tmpClassNameStr.equalsIgnoreCase(MetaDataEntry.END_OF_LIST)) {
                        keepGoing = false;
                        continue;
                    }
                    this.metaInboundExecuted.add(mdObj);
                    String tmpQNameAsStr = mdObj.getQNameAsString();
                    if (!mdObj.isListEmpty()) {
                        tmpHasList = "has list";
                    }
                    if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                    log.trace((Object)(this.logCorrelationIDString + ":readExternal(): meta data class [" + tmpClassNameStr + "] qname [" + tmpQNameAsStr + "]  index [" + count + "]   [" + tmpHasList + "]"));
                    continue;
                }
                keepGoing = false;
            }
            int adjustedNumberInExecList = in.readInt();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.logCorrelationIDString + ":readExternal(): adjusted number of entries InboundExecutedPhases [" + adjustedNumberInExecList + "]    "));
            }
        }
        if ((this.metaInboundExecuted == null || this.metaInboundExecuted.isEmpty()) && LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.logCorrelationIDString + ":readExternal(): meta data for InboundExecutedPhases list is NULL"));
        }
        this.outboundExecutedPhases = null;
        this.metaOutboundExecuted = null;
        in.readUTF();
        boolean gotOutExecList = in.readBoolean();
        if (gotOutExecList == ObjectStateUtils.ACTIVE_OBJECT) {
            int expectedNumberOutExecList = in.readInt();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.logCorrelationIDString + ":readExternal(): outbound executed phases:  expected number of entries [" + expectedNumberOutExecList + "]"));
            }
            this.metaOutboundExecuted = new LinkedList();
            boolean keepGoing = true;
            int count = 0;
            while (keepGoing) {
                Object tmpObj = ObjectStateUtils.readObject(in, "MessageContext.metaOutboundExecuted MetaDataEntry");
                ++count;
                MetaDataEntry mdObj = (MetaDataEntry)tmpObj;
                String tmpHasList = "no list";
                if (mdObj != null) {
                    String tmpClassNameStr = mdObj.getClassName();
                    if (tmpClassNameStr.equalsIgnoreCase(MetaDataEntry.END_OF_LIST)) {
                        keepGoing = false;
                        continue;
                    }
                    this.metaOutboundExecuted.add(mdObj);
                    String tmpQNameAsStr = mdObj.getQNameAsString();
                    if (!mdObj.isListEmpty()) {
                        tmpHasList = "has list";
                    }
                    if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                    log.trace((Object)(this.logCorrelationIDString + ":readExternal(): OutboundExecutedPhases: meta data class [" + tmpClassNameStr + "] qname [" + tmpQNameAsStr + "]  index [" + count + "]   [" + tmpHasList + "]"));
                    continue;
                }
                keepGoing = false;
            }
            int adjustedNumberOutExecList = in.readInt();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.logCorrelationIDString + ":readExternal(): adjusted number of entries OutboundExecutedPhases [" + adjustedNumberOutExecList + "]    "));
            }
        }
        if ((this.metaOutboundExecuted == null || this.metaOutboundExecuted.isEmpty()) && LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.logCorrelationIDString + ":readExternal(): meta data for OutboundExecutedPhases list is NULL"));
        }
        this.options = (Options)ObjectStateUtils.readObject(in, "MessageContext.options");
        if (this.options != null && LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.logCorrelationIDString + ":readExternal(): restored Options [" + this.options.getLogCorrelationIDString() + "]"));
        }
        this.axisOperation = null;
        ObjectStateUtils.readString(in, "MessageContext.axisOperation");
        boolean metaAxisOperationIsActive = in.readBoolean();
        this.metaAxisOperation = metaAxisOperationIsActive == ObjectStateUtils.ACTIVE_OBJECT ? (MetaDataEntry)ObjectStateUtils.readObject(in, "MessageContext.metaAxisOperation") : null;
        this.operationContext = (OperationContext)ObjectStateUtils.readObject(in, "MessageContext.operationContext");
        if (this.operationContext != null && LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.logCorrelationIDString + ":readExternal(): restored OperationContext [" + this.operationContext.getLogCorrelationIDString() + "]"));
        }
        this.axisService = null;
        ObjectStateUtils.readString(in, "MessageContext.axisService");
        boolean metaAxisServiceIsActive = in.readBoolean();
        this.metaAxisService = metaAxisServiceIsActive == ObjectStateUtils.ACTIVE_OBJECT ? (MetaDataEntry)ObjectStateUtils.readObject(in, "MessageContext.metaAxisService") : null;
        this.serviceContextID = ObjectStateUtils.readString(in, "MessageContext.serviceContextID");
        ObjectStateUtils.readString(in, "MessageContext.serviceContext");
        boolean servCtxActive = in.readBoolean();
        this.serviceContext = servCtxActive == ObjectStateUtils.EMPTY_OBJECT ? null : (!(isParent = in.readBoolean()) ? (ServiceContext)ObjectStateUtils.readObject(in, "MessageContext.serviceContext") : null);
        this.axisServiceGroup = null;
        ObjectStateUtils.readString(in, "MessageContext.axisServiceGroup");
        boolean metaAxisServiceGrpIsActive = in.readBoolean();
        this.metaAxisServiceGroup = metaAxisServiceGrpIsActive == ObjectStateUtils.ACTIVE_OBJECT ? (MetaDataEntry)ObjectStateUtils.readObject(in, "MessageContext.metaAxisServiceGroup") : null;
        this.serviceGroupContextId = ObjectStateUtils.readString(in, "MessageContext.serviceGroupContextId");
        ObjectStateUtils.readString(in, "MessageContext.serviceGroupContext");
        boolean servGrpCtxActive = in.readBoolean();
        this.serviceGroupContext = servGrpCtxActive == ObjectStateUtils.EMPTY_OBJECT ? null : (!(isParentSGC = in.readBoolean()) ? (ServiceGroupContext)ObjectStateUtils.readObject(in, "MessageContext.serviceGroupContext") : null);
        this.axisMessage = null;
        ObjectStateUtils.readString(in, "MessageContext.axisMessage");
        boolean metaAxisMessageIsActive = in.readBoolean();
        if (metaAxisMessageIsActive == ObjectStateUtils.ACTIVE_OBJECT) {
            this.metaAxisMessage = (MetaDataEntry)ObjectStateUtils.readObject(in, "MessageContext.metaAxisMessage");
            this.reconcileAxisMessage = true;
        } else {
            this.metaAxisMessage = null;
            this.reconcileAxisMessage = false;
        }
        this.sessionContext = (SessionContext)ObjectStateUtils.readObject(in, "MessageContext.sessionContext");
        this.incomingTransportName = ObjectStateUtils.readString(in, "MessageContext.incomingTransportName");
        this.transportIn = null;
        this.metaTransportIn = (MetaDataEntry)ObjectStateUtils.readObject(in, "MessageContext.metaTransportIn");
        this.transportOut = null;
        this.metaTransportOut = (MetaDataEntry)ObjectStateUtils.readObject(in, "MessageContext.metaTransportOut");
        HashMap tmpHashMap = ObjectStateUtils.readHashMap(in, "MessageContext.properties");
        this.properties = new HashMap();
        if (tmpHashMap != null) {
            this.setProperties(tmpHashMap);
        }
        ObjectStateUtils.readString(in, "MessageContext.selfManagedData");
        boolean gotSelfManagedData = in.readBoolean();
        if (gotSelfManagedData == ObjectStateUtils.ACTIVE_OBJECT) {
            this.selfManagedDataHandlerCount = in.readInt();
            if (this.selfManagedDataListHolder == null) {
                this.selfManagedDataListHolder = new ArrayList();
            } else {
                this.selfManagedDataListHolder.clear();
            }
            for (int i = 0; i < this.selfManagedDataHandlerCount; ++i) {
                this.selfManagedDataListHolder.add(in.readObject());
            }
        }
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(this.logCorrelationIDString + ":readExternal():  message context object created for  " + this.logCorrelationIDString));
        }
    }

    public void activate(ConfigurationContext cc) {
        AxisOperation op;
        if (!this.needsToBeReconciled) {
            return;
        }
        this.setConfigurationContext(cc);
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        if (this.metaAxisService != null) {
            this.setAxisService(ObjectStateUtils.findService(axisConfig, this.metaAxisService.getClassName(), this.metaAxisService.getQNameAsString()));
        }
        if (this.metaAxisServiceGroup != null) {
            this.setAxisServiceGroup(ObjectStateUtils.findServiceGroup(axisConfig, this.metaAxisServiceGroup.getClassName(), this.metaAxisServiceGroup.getQNameAsString()));
        }
        if (this.metaAxisOperation != null) {
            AxisService serv = this.axisService;
            if (serv != null) {
                this.setAxisOperation(ObjectStateUtils.findOperation(serv, this.metaAxisOperation.getClassName(), this.metaAxisOperation.getQName()));
            } else {
                this.setAxisOperation(ObjectStateUtils.findOperation(axisConfig, this.metaAxisOperation.getClassName(), this.metaAxisOperation.getQName()));
            }
        }
        if (this.metaAxisMessage != null && (op = this.axisOperation) != null) {
            this.setAxisMessage(ObjectStateUtils.findMessage(op, this.metaAxisMessage.getQNameAsString(), this.metaAxisMessage.getExtraName()));
        }
        if (this.operationContext != null) {
            this.operationContext.activate(cc);
        }
        if (this.serviceContext == null && this.operationContext != null) {
            this.serviceContext = this.operationContext.getServiceContext();
        }
        if (this.serviceContext != null) {
            this.serviceContext.activate(cc);
        }
        if (this.serviceGroupContext == null && this.serviceContext != null) {
            this.serviceGroupContext = (ServiceGroupContext)this.serviceContext.getParent();
        }
        if (this.serviceGroupContext != null) {
            this.serviceGroupContext.activate(cc);
        }
        this.setParent(this.operationContext);
        if (this.options != null) {
            this.options.activate(cc);
        }
        String tmpID = this.getMessageID();
        String logCorrelationIDString = this.getLogIDString();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(logCorrelationIDString + ":activate():   message ID [" + tmpID + "] for " + logCorrelationIDString));
        }
        if (this.metaTransportIn != null) {
            QName qin = this.metaTransportIn.getQName();
            TransportInDescription tmpIn = null;
            try {
                tmpIn = axisConfig.getTransportIn(qin.getLocalPart());
            }
            catch (Exception exin) {
                log.trace((Object)(logCorrelationIDString + "activate():  exception caught when getting the TransportInDescription [" + qin.toString() + "]  from the AxisConfiguration [" + exin.getClass().getName() + " : " + exin.getMessage() + "]"));
            }
            this.transportIn = tmpIn != null ? tmpIn : null;
        } else {
            this.transportIn = null;
        }
        if (this.metaTransportOut != null) {
            QName qout = this.metaTransportOut.getQName();
            TransportOutDescription tmpOut = null;
            try {
                tmpOut = axisConfig.getTransportOut(qout.getLocalPart());
            }
            catch (Exception exout) {
                log.info((Object)(logCorrelationIDString + "activate():  exception caught when getting the TransportOutDescription [" + qout.toString() + "]  from the AxisConfiguration [" + exout.getClass().getName() + " : " + exout.getMessage() + "]"));
            }
            this.transportOut = tmpOut != null ? tmpOut : null;
        } else {
            this.transportOut = null;
        }
        if (this.metaExecutionChain != null) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":activate(): reconciling the execution chain..."));
            }
            this.currentHandlerIndex = this.metaHandlerIndex;
            this.currentPhaseIndex = this.metaPhaseIndex;
            this.executionChain = this.restoreHandlerList(this.metaExecutionChain);
            try {
                this.deserializeSelfManagedData();
            }
            catch (Exception ex) {
                log.trace((Object)(logCorrelationIDString + ":activate(): *** WARNING *** deserializing the self managed data encountered Exception [" + ex.getClass().getName() + " : " + ex.getMessage() + "]"), (Throwable)ex);
            }
        }
        if (this.metaInboundExecuted != null) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":activate(): reconciling the inbound executed chain..."));
            }
            if (!this.inboundReset) {
                this.inboundExecutedPhases = this.restoreExecutedList(this.inboundExecutedPhases, this.metaInboundExecuted);
            }
        }
        if (this.inboundExecutedPhases == null) {
            this.inboundExecutedPhases = new LinkedList();
        }
        if (this.metaOutboundExecuted != null) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":activate(): reconciling the outbound executed chain..."));
            }
            if (!this.outboundReset) {
                this.outboundExecutedPhases = this.restoreExecutedList(this.outboundExecutedPhases, this.metaOutboundExecuted);
            }
        }
        if (this.outboundExecutedPhases == null) {
            this.outboundExecutedPhases = new LinkedList();
        }
        if (this.operationContext != null) {
            this.operationContext.restoreMessageContext(this);
        }
        this.needsToBeReconciled = false;
    }

    public void activateWithOperationContext(OperationContext operationCtx) {
        if (!this.needsToBeReconciled) {
            return;
        }
        String logCorrelationIDString = this.getLogIDString();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext():  BEGIN"));
        }
        if (operationCtx == null) {
            log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext():  *** WARNING ***  No active OperationContext object is available."));
            return;
        }
        ConfigurationContext configCtx = operationCtx.getConfigurationContext();
        if (configCtx == null) {
            log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext():  *** WARNING ***  No active ConfigurationContext object is available."));
            return;
        }
        AxisConfiguration axisCfg = configCtx.getAxisConfiguration();
        AxisOperation axisOp = operationCtx.getAxisOperation();
        ServiceContext serviceCtx = operationCtx.getServiceContext();
        ServiceGroupContext serviceGroupCtx = null;
        AxisService axisSrv = null;
        AxisServiceGroup axisSG = null;
        if (serviceCtx != null) {
            serviceGroupCtx = serviceCtx.getServiceGroupContext();
            axisSrv = serviceCtx.getAxisService();
        }
        if (serviceGroupCtx != null) {
            axisSG = serviceGroupCtx.getDescription();
        }
        this.setConfigurationContext(configCtx);
        this.setAxisOperation(axisOp);
        this.setAxisService(axisSrv);
        this.setAxisServiceGroup(axisSG);
        this.setServiceGroupContext(serviceGroupCtx);
        this.setServiceContext(serviceCtx);
        this.setOperationContext(operationCtx);
        if (this.metaAxisMessage != null && axisOp != null) {
            this.setAxisMessage(ObjectStateUtils.findMessage(axisOp, this.metaAxisMessage.getQNameAsString(), this.metaAxisMessage.getExtraName()));
        }
        if (this.options != null) {
            this.options.activate(configCtx);
        }
        String tmpID = this.getMessageID();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext():   message ID [" + tmpID + "]"));
        }
        if (this.metaTransportIn != null) {
            QName qin = this.metaTransportIn.getQName();
            TransportInDescription tmpIn = null;
            try {
                tmpIn = axisCfg.getTransportIn(qin.getLocalPart());
            }
            catch (Exception exin) {
                log.info((Object)(logCorrelationIDString + "activateWithOperationContext():  exception caught when getting the TransportInDescription [" + qin.toString() + "]  from the AxisConfiguration [" + exin.getClass().getName() + " : " + exin.getMessage() + "]"));
            }
            this.transportIn = tmpIn != null ? tmpIn : null;
        } else {
            this.transportIn = null;
        }
        if (this.metaTransportOut != null) {
            QName qout = this.metaTransportOut.getQName();
            TransportOutDescription tmpOut = null;
            try {
                tmpOut = axisCfg.getTransportOut(qout.getLocalPart());
            }
            catch (Exception exout) {
                log.info((Object)(logCorrelationIDString + "activateWithOperationContext():  exception caught when getting the TransportOutDescription [" + qout.toString() + "]  from the AxisConfiguration [" + exout.getClass().getName() + " : " + exout.getMessage() + "]"));
            }
            this.transportOut = tmpOut != null ? tmpOut : null;
        } else {
            this.transportOut = null;
        }
        if (this.metaExecutionChain != null) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext(): reconciling the execution chain..."));
            }
            this.currentHandlerIndex = this.metaHandlerIndex;
            this.currentPhaseIndex = this.metaPhaseIndex;
            this.executionChain = this.restoreHandlerList(this.metaExecutionChain);
            try {
                this.deserializeSelfManagedData();
            }
            catch (Exception ex) {
                log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext(): *** WARNING *** deserializing the self managed data encountered Exception [" + ex.getClass().getName() + " : " + ex.getMessage() + "]"), (Throwable)ex);
            }
        }
        if (this.metaInboundExecuted != null) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext(): reconciling the inbound executed chain..."));
            }
            if (!this.inboundReset) {
                this.inboundExecutedPhases = this.restoreExecutedList(this.inboundExecutedPhases, this.metaInboundExecuted);
            }
        }
        if (this.inboundExecutedPhases == null) {
            this.inboundExecutedPhases = new LinkedList();
        }
        if (this.metaOutboundExecuted != null) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext(): reconciling the outbound executed chain..."));
            }
            if (!this.outboundReset) {
                this.outboundExecutedPhases = this.restoreExecutedList(this.outboundExecutedPhases, this.metaOutboundExecuted);
            }
        }
        if (this.outboundExecutedPhases == null) {
            this.outboundExecutedPhases = new LinkedList();
        }
        this.needsToBeReconciled = false;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(logCorrelationIDString + ":activateWithOperationContext():  END"));
        }
    }

    private ArrayList restoreHandlerList(ArrayList metaDataEntries) {
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        ArrayList existingHandlers = null;
        switch (this.FLOW) {
            case 1: {
                existingHandlers = (ArrayList)axisConfig.getGlobalInFlow().clone();
                break;
            }
            case 2: {
                existingHandlers = (ArrayList)axisConfig.getGlobalOutPhases().clone();
                break;
            }
            case 3: {
                existingHandlers = (ArrayList)axisConfig.getInFaultFlow().clone();
                break;
            }
            case 4: {
                existingHandlers = (ArrayList)axisConfig.getOutFaultFlow().clone();
            }
        }
        existingHandlers = this.flattenHandlerList(existingHandlers, null);
        ArrayList<Handler> handlerListToReturn = new ArrayList<Handler>();
        for (int i = 0; i < metaDataEntries.size(); ++i) {
            Handler handler = (Handler)ObjectStateUtils.findHandler(existingHandlers, (MetaDataEntry)metaDataEntries.get(i));
            if (handler == null) continue;
            handlerListToReturn.add(handler);
        }
        return handlerListToReturn;
    }

    private LinkedList restoreExecutedList(LinkedList base, LinkedList metaDataEntries) {
        if (metaDataEntries == null) {
            return base;
        }
        ArrayList tmpMetaDataList = new ArrayList(metaDataEntries);
        ArrayList existingList = this.restoreHandlerList(tmpMetaDataList);
        if (existingList == null || existingList.isEmpty()) {
            return base;
        }
        LinkedList returnedList = new LinkedList();
        if (base != null) {
            returnedList.addAll(base);
        }
        returnedList.addAll(existingList);
        return returnedList;
    }

    private void setupPhaseList(Phase phase, MetaDataEntry mdPhase) {
        ArrayList handlers = phase.getHandlers();
        if (handlers.isEmpty()) {
            mdPhase.removeList();
            return;
        }
        int listSize = handlers.size();
        if (listSize > 0) {
            Iterator i = handlers.iterator();
            while (i.hasNext()) {
                String qnameAsString;
                Object obj = i.next();
                String objClass = obj.getClass().getName();
                MetaDataEntry mdEntry = new MetaDataEntry();
                mdEntry.setClassName(objClass);
                if (obj instanceof Phase) {
                    Phase phaseObj = (Phase)obj;
                    qnameAsString = phaseObj.getName();
                    this.setupPhaseList(phaseObj, mdEntry);
                } else if (obj instanceof Handler) {
                    Handler handlerObj = (Handler)obj;
                    qnameAsString = handlerObj.getName();
                } else {
                    qnameAsString = "NULL";
                }
                mdEntry.setQName(qnameAsString);
                mdPhase.addToList(mdEntry);
                if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                log.trace((Object)(this.getLogIDString() + ":setupPhaseList(): list entry class [" + objClass + "] qname [" + qnameAsString + "]"));
            }
        } else {
            mdPhase.removeList();
        }
    }

    public MessageContext extractCopyMessageContext() {
        MessageContext copy = new MessageContext();
        String logCorrelationIDString = this.getLogIDString();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(logCorrelationIDString + ":extractCopyMessageContext():  based on " + logCorrelationIDString + "   into copy " + copy.getLogIDString()));
        }
        copy.setFLOW(this.FLOW);
        copy.setProcessingFault(this.processingFault);
        copy.setPaused(this.paused);
        copy.setOutputWritten(this.outputWritten);
        copy.setNewThreadRequired(this.newThreadRequired);
        copy.setDoingREST(this.doingREST);
        copy.setDoingMTOM(this.doingMTOM);
        copy.setDoingSwA(this.doingSwA);
        copy.setResponseWritten(this.responseWritten);
        copy.setServerSide(this.serverSide);
        copy.setLastTouchedTime(this.getLastTouchedTime());
        try {
            copy.setEnvelope(this.envelope);
        }
        catch (Exception ex) {
            log.trace((Object)(logCorrelationIDString + ":extractCopyMessageContext():  Exception caught when setting the copy with the envelope"), (Throwable)ex);
        }
        copy.setAttachmentMap(this.attachments);
        copy.setIsSOAP11Explicit(this.isSOAP11);
        copy.setExecutionChain(this.executionChain);
        copy.setCurrentHandlerIndex(this.currentHandlerIndex);
        copy.setCurrentPhaseIndex(this.currentPhaseIndex);
        copy.setInboundExecutedPhasesExplicit(this.inboundExecutedPhases);
        copy.setOutboundExecutedPhasesExplicit(this.outboundExecutedPhases);
        copy.setOptionsExplicit(this.options);
        copy.setAxisOperation(null);
        copy.setOperationContext(null);
        copy.setAxisService(null);
        copy.setServiceContextID(this.serviceContextID);
        copy.setServiceContext(null);
        copy.setServiceGroupContext(null);
        copy.setServiceGroupContextId(this.serviceGroupContextId);
        copy.setAxisMessage(this.axisMessage);
        copy.setConfigurationContext(this.configurationContext);
        copy.setSessionContext(this.sessionContext);
        copy.setIncomingTransportName(this.incomingTransportName);
        copy.setTransportIn(this.transportIn);
        copy.setTransportOut(this.transportOut);
        copy.setProperties(this.getProperties());
        copy.setSelfManagedDataMapExplicit(this.selfManagedDataMap);
        return copy;
    }

    public void setIsSOAP11Explicit(boolean t) {
        this.isSOAP11 = t;
    }

    public void setInboundExecutedPhasesExplicit(LinkedList inb) {
        this.inboundExecutedPhases = inb;
    }

    public void setOutboundExecutedPhasesExplicit(LinkedList outb) {
        this.outboundExecutedPhases = outb;
    }

    public void setSelfManagedDataMapExplicit(LinkedHashMap map) {
        this.selfManagedDataMap = map;
    }

    public void setOptionsExplicit(Options op) {
        this.options = op;
    }

    private void checkActivateWarning(String methodname) {
        if (this.needsToBeReconciled) {
            log.warn((Object)(this.getLogIDString() + ":" + methodname + "(): ****WARNING**** " + myClassName + ".activate(configurationContext) needs to be invoked."));
        }
    }

    public ConfigurationContext getRootContext() {
        return this.configurationContext;
    }
}

