/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.repository.util.WSInfoList;
import org.apache.axis2.util.Loader;

public class RepositoryListener
implements DeploymentConstants {
    static String defaultEncoding = new OutputStreamWriter(System.out).getEncoding();
    protected DeploymentEngine deploymentEngine;
    private HashMap directoryToExtensionMappingMap;
    protected WSInfoList wsInfoList;

    public RepositoryListener(DeploymentEngine deploymentEngine, boolean isClasspath) {
        this.deploymentEngine = deploymentEngine;
        this.wsInfoList = new WSInfoList(deploymentEngine);
        this.init2(isClasspath);
    }

    public void init2(boolean isClasspath) {
        if (!isClasspath) {
            this.init();
        }
        this.loadClassPathModules();
    }

    public void checkModules() {
        File root = this.deploymentEngine.getModulesDir();
        File[] files = root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (this.isSourceControlDir(file)) continue;
                if (!file.isDirectory()) {
                    if (!DeploymentFileData.isModuleArchiveFile(file.getName())) continue;
                    this.wsInfoList.addWSInfoItem(file, "module");
                    continue;
                }
                if ("lib".equalsIgnoreCase(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, "module");
            }
        }
    }

    protected boolean isSourceControlDir(File file) {
        String name;
        return file.isDirectory() && ((name = file.getName()).equalsIgnoreCase("CVS") || name.equalsIgnoreCase(".svn"));
    }

    protected void loadClassPathModules() {
        String classPath = this.getLocation();
        if (classPath == null) {
            return;
        }
        int lstindex = classPath.lastIndexOf(File.separatorChar);
        File root = new File(classPath = lstindex > 0 ? classPath.substring(0, lstindex) : ".");
        File[] files = root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory() || !DeploymentFileData.isModuleArchiveFile(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, "module");
            }
        }
        for (ClassLoader cl = this.deploymentEngine.getAxisConfig().getModuleClassLoader(); cl != null; cl = cl.getParent()) {
            if (!(cl instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)cl).getURLs();
            for (int i = 0; urls != null && i < urls.length; ++i) {
                String path = urls[i].getPath();
                if (path.length() >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':') {
                    path = path.substring(1);
                }
                try {
                    path = URLDecoder.decode(path, defaultEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                File file = new File(path.replace('/', File.separatorChar).replace('|', ':'));
                if (!file.isFile() || !DeploymentFileData.isModuleArchiveFile(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, "module");
            }
        }
        this.deploymentEngine.doDeploy();
    }

    protected String getLocation() {
        try {
            Class clazz = Loader.loadClass("org.apache.axis2.engine.AxisEngine");
            URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
            String location = url.toString();
            if (location.startsWith("jar")) {
                url = ((JarURLConnection)url.openConnection()).getJarFileURL();
                location = url.toString();
            }
            if (location.startsWith("file")) {
                String path = URLDecoder.decode(url.getPath(), defaultEncoding);
                File file = new File(path.replace('/', File.separatorChar).replace('|', ':'));
                return file.getAbsolutePath();
            }
            return url.toString();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void checkServices() {
        this.findServicesInDirectory();
        this.loadOtherDirectories();
        this.update();
    }

    public void init() {
        this.wsInfoList.init();
        this.checkModules();
        this.directoryToExtensionMappingMap = this.deploymentEngine.getDirectoryToExtensionMappingMap();
        this.deploymentEngine.doDeploy();
    }

    private void loadOtherDirectories() {
        if (this.directoryToExtensionMappingMap.size() > 0) {
            Iterator keys = this.directoryToExtensionMappingMap.keySet().iterator();
            while (keys.hasNext()) {
                String s = (String)keys.next();
                this.findFileForGivenDirectory(s, (String)this.directoryToExtensionMappingMap.get(s));
            }
        }
    }

    private void findFileForGivenDirectory(String dir, String extension) {
        try {
            File[] files;
            File fileTobeSearch = new File(this.deploymentEngine.getRepositoryDir(), dir);
            if (fileTobeSearch.exists() && (files = fileTobeSearch.listFiles()) != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (this.isSourceControlDir(file) || file.isDirectory() || !DeploymentFileData.getFileExtension(file.getName()).equals(extension)) continue;
                    this.wsInfoList.addWSInfoItem(file, extension);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void findServicesInDirectory() {
        File root = this.deploymentEngine.getServicesDir();
        File[] files = root.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (this.isSourceControlDir(file)) continue;
                if (!file.isDirectory()) {
                    if (!DeploymentFileData.isServiceArchiveFile(file.getName())) continue;
                    this.wsInfoList.addWSInfoItem(file, "service");
                    continue;
                }
                if ("lib".equalsIgnoreCase(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, "service");
            }
        }
        this.wsInfoList.addWSInfoItem(null, "none");
    }

    public void startListener() {
        this.checkServices();
        this.update();
    }

    public void update() {
        this.wsInfoList.update();
    }

    public void updateRemote() throws Exception {
        this.findServicesInDirectory();
        this.update();
    }
}

