/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.repository.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.repository.util.WSInfo;

public class WSInfoList
implements DeploymentConstants {
    private List jarList = new ArrayList();
    public List currentJars = new ArrayList();
    private DeploymentEngine deployer;
    private boolean check;

    public WSInfoList(DeploymentEngine deploy_engine) {
        this.deployer = deploy_engine;
    }

    public synchronized void addWSInfoItem(File file, String type) {
        WSInfo wsInfo;
        if ("service".equals(type)) {
            WSInfo tempWSInfo;
            if (!this.isFileExist(file.getName())) {
                wsInfo = new WSInfo(file.getName(), file.lastModified(), "service");
                this.jarList.add(wsInfo);
                DeploymentFileData deploymentFileData = new DeploymentFileData(file, "service");
                this.deployer.addWSToDeploy(deploymentFileData);
            } else if (this.deployer.isHotUpdate() && this.isModified(file, tempWSInfo = this.getFileItem(file.getName()))) {
                tempWSInfo.setLastModifiedDate(file.lastModified());
                WSInfo wsInfo2 = new WSInfo(tempWSInfo.getFileName(), tempWSInfo.getLastModifiedDate(), "service");
                this.deployer.addWSToUndeploy(wsInfo2);
                DeploymentFileData deploymentFileData = new DeploymentFileData(file, "service");
                this.deployer.addWSToDeploy(deploymentFileData);
            }
        } else if ("module".equals(type)) {
            if (!this.isFileExist(file.getName())) {
                wsInfo = new WSInfo(file.getName(), file.lastModified(), "module");
                this.jarList.add(wsInfo);
                DeploymentFileData deploymentFileData = new DeploymentFileData(file, "module");
                this.deployer.addWSToDeploy(deploymentFileData);
            }
        } else if (file != null) {
            WSInfo tempWSInfo;
            String extension = DeploymentFileData.getFileExtension(file.getName());
            if (!this.isFileExist(file.getName())) {
                WSInfo wsInfo3 = new WSInfo(file.getName(), file.lastModified(), extension);
                this.jarList.add(wsInfo3);
                DeploymentFileData deploymentFileData = new DeploymentFileData(file, extension);
                this.deployer.addWSToDeploy(deploymentFileData);
            } else if (this.deployer.isHotUpdate() && this.isModified(file, tempWSInfo = this.getFileItem(file.getName()))) {
                tempWSInfo.setLastModifiedDate(file.lastModified());
                WSInfo wsInfo4 = new WSInfo(tempWSInfo.getFileName(), tempWSInfo.getLastModifiedDate(), extension);
                this.deployer.addWSToUndeploy(wsInfo4);
                DeploymentFileData deploymentFileData = new DeploymentFileData(file, extension);
                this.deployer.addWSToDeploy(deploymentFileData);
            }
        } else {
            this.check = true;
        }
        if (file != null) {
            String jarname = file.getName();
            this.currentJars.add(jarname);
        }
        this.check = true;
    }

    private synchronized void checkForUndeployedServices() {
        if (!this.check) {
            return;
        }
        this.check = false;
        ListIterator iter = this.jarList.listIterator();
        int size = this.currentJars.size();
        ArrayList<WSInfo> tempvector = new ArrayList<WSInfo>();
        tempvector.clear();
        while (iter.hasNext()) {
            WSInfo fileitem = (WSInfo)iter.next();
            if ("module".equals(fileitem.getType())) continue;
            boolean exist = false;
            for (int i = 0; i < size; ++i) {
                String filename = (String)this.currentJars.get(i);
                if (!filename.equals(fileitem.getFileName())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            tempvector.add(fileitem);
            WSInfo wsInfo = new WSInfo(fileitem.getFileName(), fileitem.getLastModifiedDate(), fileitem.getType());
            this.deployer.addWSToUndeploy(wsInfo);
        }
        for (int i = 0; i < tempvector.size(); ++i) {
            WSInfo fileItem = (WSInfo)tempvector.get(i);
            this.jarList.remove(fileItem);
        }
        tempvector.clear();
        this.currentJars.clear();
    }

    public void init() {
        this.jarList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        DeploymentEngine deploymentEngine = this.deployer;
        synchronized (deploymentEngine) {
            this.checkForUndeployedServices();
            this.deployer.unDeploy();
            this.deployer.doDeploy();
        }
    }

    private WSInfo getFileItem(String filename) {
        int sise = this.jarList.size();
        for (int i = 0; i < sise; ++i) {
            WSInfo wsInfo = (WSInfo)this.jarList.get(i);
            if (!wsInfo.getFileName().equals(filename)) continue;
            return wsInfo;
        }
        return null;
    }

    private boolean isFileExist(String filename) {
        return this.getFileItem(filename) != null;
    }

    private boolean isModified(File file, WSInfo wsInfo) {
        if (file.isDirectory()) {
            if (this.isChanged(file, wsInfo.getLastModifiedDate(), wsInfo)) {
                this.setLastModifiedDate(file, wsInfo);
                return true;
            }
            return false;
        }
        return wsInfo.getLastModifiedDate() != file.lastModified();
    }

    private void setLastModifiedDate(File file, WSInfo wsInfo) {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File fileItem = files[i];
            if (fileItem.isDirectory()) {
                this.setLastModifiedDate(fileItem, wsInfo);
                continue;
            }
            fileItem.setLastModified(wsInfo.getLastModifiedDate());
        }
    }

    private boolean isChanged(File file, long lastModifedData, WSInfo wsInfo) {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File fileItem = files[i];
            if (fileItem.isDirectory()) {
                if (!this.isChanged(fileItem, lastModifedData, wsInfo)) continue;
                wsInfo.setLastModifiedDate(fileItem.lastModified());
                return true;
            }
            if (lastModifedData == fileItem.lastModified()) continue;
            wsInfo.setLastModifiedDate(fileItem.lastModified());
            return true;
        }
        return false;
    }
}

