/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.AxisDataLocator;
import org.apache.axis2.dataretrieval.AxisDataLocatorImpl;
import org.apache.axis2.dataretrieval.Data;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.axis2.dataretrieval.DataRetrievalRequest;
import org.apache.axis2.dataretrieval.LocatorType;
import org.apache.axis2.dataretrieval.OutputForm;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService2WSDL2;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DefaultObjectSupplier;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.ObjectSupplier;
import org.apache.axis2.engine.ServiceLifeCycle;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.modules.Module;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.server.HttpUtils;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.apache.ws.java2wsdl.SchemaGenerator;
import org.apache.ws.java2wsdl.utils.TypeTable;
import org.codehaus.jam.JAnnotation;
import org.codehaus.jam.JMethod;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AxisService
extends AxisDescription {
    private Map endpointMap = new HashMap();
    private Map messageElementQNameToOperationMap = new HashMap();
    private int nsCount = 0;
    private static final Log log = LogFactory.getLog((Class)AxisService.class);
    private URL fileName;
    private HashMap httpLocationDispatcherMap = null;
    private HashMap operationsAliasesMap = null;
    private List invalidOperationsAliases = null;
    private ArrayList moduleRefs = null;
    private ArrayList engagedModules = null;
    private String serviceDescription;
    private long lastupdate;
    private HashMap moduleConfigmap;
    private String name;
    private ClassLoader serviceClassLoader;
    private ArrayList schemaList;
    private boolean wsdlFound = false;
    private String scope = "request";
    private HashMap messageReceivers;
    private boolean useDefaultChains = true;
    private boolean active = true;
    private boolean elementFormDefault = true;
    private String targetNamespace = "http://ws.apache.org/axis2";
    private String targetNamespacePrefix = "tns";
    private String schematargetNamespace;
    private String schematargetNamespacePrefix = "ns";
    private boolean enableAllTransports = true;
    private List exposedTransports = new ArrayList();
    private ServiceLifeCycle serviceLifeCycle;
    private boolean schemaLocationsAdjusted = false;
    private Map schemaMappingTable = null;
    private int count = 0;
    private String customSchemaNamePrefix = null;
    private String customSchemaNameSuffix = null;
    private NamespaceMap nameSpacesMap;
    private String soapNsUri;
    private String endpointName;
    private String endpointURL;
    private String wsaddressingFlag = "unspecified";
    private boolean clientSide = false;
    private ObjectSupplier objectSupplier;
    private Map p2nMap;
    private TypeTable typeTable;
    private HashMap dataLocators;
    private HashMap dataLocatorClassNames;
    private AxisDataLocatorImpl defaultDataLocator;
    LocatorType[] availableDataLocatorTypes = new LocatorType[]{LocatorType.SERVICE_DIALECT, LocatorType.SERVICE_LEVEL, LocatorType.GLOBAL_DIALECT, LocatorType.GLOBAL_LEVEL, LocatorType.DEFAULT_AXIS};
    private String bindingName;
    private List operationsNameList;
    private boolean customWsdl = false;

    public AxisEndpoint getEndpoint(String key) {
        return (AxisEndpoint)this.endpointMap.get(key);
    }

    public void addEndpoint(String key, AxisEndpoint axisEndpoint) {
        this.endpointMap.put(key, axisEndpoint);
    }

    public String getWSAddressingFlag() {
        return this.wsaddressingFlag;
    }

    public void setWSAddressingFlag(String ar) {
        this.wsaddressingFlag = ar;
        if (this.wsaddressingFlag == null) {
            this.wsaddressingFlag = "unspecified";
        }
    }

    public boolean isSchemaLocationsAdjusted() {
        return this.schemaLocationsAdjusted;
    }

    public void setSchemaLocationsAdjusted(boolean schemaLocationsAdjusted) {
        this.schemaLocationsAdjusted = schemaLocationsAdjusted;
    }

    public Map getSchemaMappingTable() {
        return this.schemaMappingTable;
    }

    public void setSchemaMappingTable(Map schemaMappingTable) {
        this.schemaMappingTable = schemaMappingTable;
    }

    public String getCustomSchemaNamePrefix() {
        return this.customSchemaNamePrefix;
    }

    public void setCustomSchemaNamePrefix(String customSchemaNamePrefix) {
        this.customSchemaNamePrefix = customSchemaNamePrefix;
    }

    public String getCustomSchemaNameSuffix() {
        return this.customSchemaNameSuffix;
    }

    public void setCustomSchemaNameSuffix(String customSchemaNameSuffix) {
        this.customSchemaNameSuffix = customSchemaNameSuffix;
    }

    public AxisService() {
        this.operationsAliasesMap = new HashMap();
        this.invalidOperationsAliases = new ArrayList();
        this.moduleConfigmap = new HashMap();
        this.httpLocationDispatcherMap = new HashMap();
        this.messageReceivers = new HashMap();
        this.moduleRefs = new ArrayList();
        this.engagedModules = new ArrayList();
        this.schemaList = new ArrayList();
        this.serviceClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        this.objectSupplier = new DefaultObjectSupplier();
        this.dataLocators = new HashMap();
        this.dataLocatorClassNames = new HashMap();
    }

    public String getPortTypeName() {
        return this.endpointName;
    }

    public void setPortTypeName(String portTypeName) {
        this.endpointName = portTypeName;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public String getSoapNsUri() {
        return this.soapNsUri;
    }

    public void setSoapNsUri(String soapNsUri) {
        this.soapNsUri = soapNsUri;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(String endpoint) {
        this.endpointName = endpoint;
    }

    public AxisService(String name) {
        this();
        this.name = name;
    }

    public void addMessageReceiver(String mepURI, MessageReceiver messageReceiver) {
        if ("http://www.w3.org/ns/wsdl/in-only".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/in-only".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/in-only".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/in-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/in-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/in-only", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/out-only".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/out-only".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/out-only".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/out-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/out-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/out-only", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/in-out".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/in-out".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/in-out".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/in-out", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/in-out", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/in-out", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/in-opt-out".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/in-opt-out", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/in-opt-out", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/in-opt-out", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/out-in".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/out-in".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/out-in".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/out-in", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/out-in", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/out-in", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/out-opt-in".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/out-opt-in", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/out-opt-in", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/out-opt-in", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/robust-out-only".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/robust-out-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/robust-out-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/robust-out-only", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/robust-in-only".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/robust-in-only".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/robust-in-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/robust-in-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/robust-in-only", messageReceiver);
        } else {
            this.messageReceivers.put(mepURI, messageReceiver);
        }
    }

    public MessageReceiver getMessageReceiver(String mepURL) {
        return (MessageReceiver)this.messageReceivers.get(mepURL);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addModuleOperations(AxisModule module, AxisConfiguration axisConfig) throws AxisFault {
        HashMap map = module.getOperations();
        Collection col = map.values();
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = this.copyOperation((AxisOperation)iterator.next());
            if (this.getOperation(axisOperation.getName()) != null) continue;
            ArrayList wsamappings = axisOperation.getWsamappingList();
            if (wsamappings != null) {
                int size = wsamappings.size();
                for (int j = 0; j < size; ++j) {
                    String mapping = (String)wsamappings.get(j);
                    this.mapActionToOperation(mapping, axisOperation);
                }
            }
            axisOperation.setControlOperation(true);
            this.addOperation(axisOperation);
        }
    }

    public void addModuleref(String moduleref) {
        this.moduleRefs.add(moduleref);
    }

    public void addOperation(AxisOperation axisOperation) {
        ArrayList wsamappings;
        axisOperation.setParent(this);
        Iterator modules = this.getEngagedModules().iterator();
        while (modules.hasNext()) {
            AxisModule module = (AxisModule)modules.next();
            AxisServiceGroup parent = (AxisServiceGroup)this.getParent();
            AxisConfiguration axisConfig = null;
            if (parent != null) {
                axisConfig = (AxisConfiguration)parent.getParent();
            }
            try {
                Module moduleImpl = module.getModule();
                if (moduleImpl != null) {
                    moduleImpl.engageNotify(axisOperation);
                }
                axisOperation.engageModule(module, axisConfig);
            }
            catch (AxisFault axisFault) {
                log.info((Object)Messages.getMessage("modulealredyengagetoservice", module.getName()));
            }
        }
        if (axisOperation.getMessageReceiver() == null) {
            axisOperation.setMessageReceiver(this.loadDefaultMessageReceiver(axisOperation.getMessageExchangePattern(), this));
        }
        if (axisOperation.getInputAction() == null) {
            axisOperation.setSoapAction("urn:" + axisOperation.getName().getLocalPart());
        }
        this.addChild(axisOperation);
        String operationName = axisOperation.getName().getLocalPart();
        Iterator axisMessageIter = axisOperation.getChildren();
        while (axisMessageIter.hasNext()) {
            AxisMessage axisMessage = (AxisMessage)axisMessageIter.next();
            String messageName = axisMessage.getName();
            if (messageName == null || messageName.equals(operationName)) continue;
            this.mapActionToOperation(messageName, axisOperation);
        }
        this.mapActionToOperation(operationName, axisOperation);
        String action = axisOperation.getInputAction();
        if (action.length() > 0) {
            this.mapActionToOperation(action, axisOperation);
        }
        if ((wsamappings = axisOperation.getWsamappingList()) != null) {
            int size = wsamappings.size();
            for (int j = 0; j < size; ++j) {
                String mapping = (String)wsamappings.get(j);
                this.mapActionToOperation(mapping, axisOperation);
            }
        }
        if (axisOperation.getMessageReceiver() == null) {
            axisOperation.setMessageReceiver(this.loadDefaultMessageReceiver(axisOperation.getMessageExchangePattern(), this));
        }
    }

    private MessageReceiver loadDefaultMessageReceiver(String mepURL, AxisService service) {
        MessageReceiver messageReceiver;
        if (mepURL == null) {
            mepURL = "http://www.w3.org/ns/wsdl/in-out";
        }
        if (service != null && (messageReceiver = service.getMessageReceiver(mepURL)) != null) {
            return messageReceiver;
        }
        if (this.getParent() != null && this.getParent().getParent() != null) {
            return ((AxisConfiguration)this.getParent().getParent()).getMessageReceiver(mepURL);
        }
        return null;
    }

    private AxisOperation copyOperation(AxisOperation axisOperation) throws AxisFault {
        Policy policy;
        AxisOperation operation = AxisOperationFactory.getOperationDescription(axisOperation.getMessageExchangePattern());
        operation.setMessageReceiver(axisOperation.getMessageReceiver());
        operation.setName(axisOperation.getName());
        Iterator parameters = axisOperation.getParameters().iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            operation.addParameter(parameter);
        }
        PolicyInclude policyInclude = new PolicyInclude(operation);
        PolicyInclude axisOperationPolicyInclude = axisOperation.getPolicyInclude();
        if (axisOperationPolicyInclude != null && (policy = axisOperationPolicyInclude.getPolicy()) != null) {
            policyInclude.setPolicy(axisOperationPolicyInclude.getPolicy());
        }
        operation.setPolicyInclude(policyInclude);
        operation.setWsamappingList(axisOperation.getWsamappingList());
        operation.setRemainingPhasesInFlow(axisOperation.getRemainingPhasesInFlow());
        operation.setPhasesInFaultFlow(axisOperation.getPhasesInFaultFlow());
        operation.setPhasesOutFaultFlow(axisOperation.getPhasesOutFaultFlow());
        operation.setPhasesOutFlow(axisOperation.getPhasesOutFlow());
        operation.setOutputAction(axisOperation.getOutputAction());
        String[] faultActionNames = axisOperation.getFaultActionNames();
        for (int i = 0; i < faultActionNames.length; ++i) {
            operation.addFaultAction(faultActionNames[i], axisOperation.getFaultAction(faultActionNames[i]));
        }
        return operation;
    }

    public void engageModule(AxisModule axisModule, AxisConfiguration axisConfig) throws AxisFault {
        if (axisModule == null) {
            throw new AxisFault(Messages.getMessage("modulenf"));
        }
        Iterator itr_engageModules = this.engagedModules.iterator();
        String moduleName = axisModule.getName();
        while (itr_engageModules.hasNext()) {
            AxisModule module = (AxisModule)itr_engageModules.next();
            String modu = module.getName();
            boolean isEngagable = Utils.checkVersion(moduleName, modu);
            if (isEngagable) continue;
            return;
        }
        Module moduleImpl = axisModule.getModule();
        if (moduleImpl != null) {
            moduleImpl.engageNotify(this);
        }
        this.addModuleOperations(axisModule, axisConfig);
        Iterator operations = this.getOperations();
        while (operations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operations.next();
            axisOperation.engageModule(axisModule, axisConfig);
        }
        this.engagedModules.add(axisModule);
    }

    public void mapActionToOperation(String action, AxisOperation axisOperation) {
        if (action == null || "".equals(action)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"mapActionToOperation: A null or empty action cannot be used to map to an operation.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("mapActionToOperation: Mapping Action to Operation: action: " + action + "; operation: " + axisOperation));
        }
        if (this.invalidOperationsAliases.contains(action)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("mapActionToOperation: The action: " + action + " can not be used for operation: " + axisOperation + " with operation name: " + axisOperation.getName() + " because that SOAPAction is not unique for this service."));
            }
            return;
        }
        AxisOperation currentlyMappedOperation = this.getOperationByAction(action);
        if (currentlyMappedOperation != null) {
            if (currentlyMappedOperation == axisOperation) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("mapActionToOperation: This operation is already mapped to this action: " + action + "; AxisOperation: " + currentlyMappedOperation + " named: " + currentlyMappedOperation.getName()));
                }
            } else {
                this.operationsAliasesMap.remove(action);
                this.invalidOperationsAliases.add(action);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("mapActionToOperation: The action is already mapped to a different operation.  The mapping of the action to any operations will be removed.  Action: " + action + "; original operation: " + currentlyMappedOperation + " named " + currentlyMappedOperation.getName() + "; new operation: " + axisOperation + " named " + axisOperation.getName()));
                }
            }
            return;
        }
        this.operationsAliasesMap.put(action, axisOperation);
    }

    public void addHttpLocationDispatcherString(String string, AxisOperation axisOperation) {
        this.httpLocationDispatcherMap.put(string, axisOperation);
    }

    public void printSchema(OutputStream out) throws AxisFault {
        for (int i = 0; i < this.schemaList.size(); ++i) {
            XmlSchema schema = this.addNameSpaces(i);
            schema.write(out);
        }
    }

    public XmlSchema getSchema(int index) {
        return this.addNameSpaces(index);
    }

    public void releaseSchemaList() {
        if (this.schemaList != null) {
            this.schemaList.clear();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"releaseSchemaList: schema list has been released.");
        }
    }

    private XmlSchema addNameSpaces(int i) {
        XmlSchema schema = (XmlSchema)this.schemaList.get(i);
        NamespaceMap map = (NamespaceMap)this.nameSpacesMap.clone();
        NamespacePrefixList namespaceContext = schema.getNamespaceContext();
        String[] prefixes = namespaceContext.getDeclaredPrefixes();
        for (int j = 0; j < prefixes.length; ++j) {
            String prefix = prefixes[j];
            map.add(prefix, namespaceContext.getNamespaceURI(prefix));
        }
        schema.setNamespaceContext((NamespacePrefixList)map);
        return schema;
    }

    public AxisConfiguration getAxisConfiguration() {
        if (this.getParent() != null) {
            return (AxisConfiguration)this.getParent().getParent();
        }
        return null;
    }

    public void printWSDL(OutputStream out, String requestIP, String servicePath) throws AxisFault {
        if (this.isUseUserWSDL()) {
            Parameter wsld4jdefinition = this.getParameter("wsdl4jDefinition");
            if (wsld4jdefinition != null) {
                try {
                    Definition definition = (Definition)wsld4jdefinition.getValue();
                    if (this.isModifyUserWSDLPortAddress()) {
                        this.setPortAddress(definition);
                    }
                    WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
                    writer.writeWSDL(definition, out);
                }
                catch (WSDLException e) {
                    throw new AxisFault(e);
                }
            } else {
                this.printWSDLError(out);
            }
        } else {
            String[] eprArray = this.getEPRs(requestIP);
            this.getWSDL(out, eprArray, servicePath);
        }
    }

    public String[] getEPRs() throws AxisFault {
        String requestIP;
        try {
            requestIP = HttpUtils.getIpAddress();
        }
        catch (SocketException e) {
            throw new AxisFault("Cannot get local IP address", e);
        }
        return this.getEPRs(requestIP);
    }

    private String[] getEPRs(String requestIP) {
        AxisConfiguration axisConfig = this.getAxisConfiguration();
        if (axisConfig == null) {
            return null;
        }
        ArrayList<String> eprList = new ArrayList<String>();
        if (this.enableAllTransports) {
            Iterator transports = axisConfig.getTransportsIn().values().iterator();
            while (transports.hasNext()) {
                TransportInDescription transportIn = (TransportInDescription)transports.next();
                TransportListener listener = transportIn.getReceiver();
                if (listener == null) continue;
                try {
                    EndpointReference[] eprsForService = listener.getEPRsForService(this.name, requestIP);
                    if (eprsForService == null) continue;
                    for (int i = 0; i < eprsForService.length; ++i) {
                        EndpointReference endpointReference = eprsForService[i];
                        String address = endpointReference.getAddress();
                        if (address == null) continue;
                        eprList.add(address);
                    }
                }
                catch (AxisFault axisFault) {
                    log.warn((Object)axisFault.getMessage());
                }
            }
        } else {
            List trs = this.exposedTransports;
            for (int i = 0; i < trs.size(); ++i) {
                TransportListener listener;
                String trsName = (String)trs.get(i);
                TransportInDescription transportIn = axisConfig.getTransportIn(trsName);
                if (transportIn == null || (listener = transportIn.getReceiver()) == null) continue;
                try {
                    EndpointReference[] eprsForService = listener.getEPRsForService(this.name, requestIP);
                    if (eprsForService == null) continue;
                    for (int j = 0; j < eprsForService.length; ++j) {
                        EndpointReference endpointReference = eprsForService[j];
                        String address = endpointReference.getAddress();
                        if (address == null) continue;
                        eprList.add(address);
                    }
                    continue;
                }
                catch (AxisFault axisFault) {
                    log.warn((Object)axisFault.getMessage());
                }
            }
        }
        return eprList.toArray(new String[eprList.size()]);
    }

    public void printWSDL(OutputStream out, String requestIP) throws AxisFault {
        this.printWSDL(out, requestIP, "services");
    }

    public void printWSDL(OutputStream out) throws AxisFault {
        if (this.isUseUserWSDL()) {
            Parameter wsld4jdefinition = this.getParameter("wsdl4jDefinition");
            if (wsld4jdefinition != null) {
                try {
                    Definition definition = (Definition)wsld4jdefinition.getValue();
                    if (this.isModifyUserWSDLPortAddress()) {
                        this.setPortAddress(definition);
                    }
                    WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
                    writer.writeWSDL(definition, out);
                }
                catch (WSDLException e) {
                    throw new AxisFault(e);
                }
            } else {
                this.printWSDLError(out);
            }
        } else {
            this.setWsdlFound(true);
            this.getWSDL(out, new String[]{this.endpointName}, "services");
        }
    }

    private void setPortAddress(Definition definition) throws AxisFault {
        this.setPortAddress(definition, null);
    }

    private void setPortAddress(Definition definition, String requestIP) throws AxisFault {
        Iterator serviceItr = definition.getServices().values().iterator();
        while (serviceItr.hasNext()) {
            Service serviceElement = (Service)serviceItr.next();
            Iterator portItr = serviceElement.getPorts().values().iterator();
            while (portItr.hasNext()) {
                Port port = (Port)portItr.next();
                List list = port.getExtensibilityElements();
                for (int i = 0; i < list.size(); ++i) {
                    Object extensibilityEle = list.get(i);
                    if (!(extensibilityEle instanceof SOAPAddress)) continue;
                    if (requestIP == null) {
                        ((SOAPAddress)extensibilityEle).setLocationURI(this.getEPRs()[0]);
                        continue;
                    }
                    ((SOAPAddress)extensibilityEle).setLocationURI(this.getEPRs(requestIP)[0]);
                }
            }
        }
    }

    private void getWSDL(OutputStream out, String[] serviceURL, String servicePath) throws AxisFault {
        DataRetrievalRequest request = new DataRetrievalRequest();
        request.putDialect("http://schemas.xmlsoap.org/wsdl/");
        request.putOutputForm(OutputForm.INLINE_FORM);
        MessageContext context = new MessageContext();
        context.setAxisService(this);
        context.setTo(new EndpointReference(serviceURL[0]));
        Data[] result = this.getData(request, context);
        if (result != null && result.length > 0) {
            OMElement wsdlElement = (OMElement)result[0].getData();
            try {
                wsdlElement.serialize(out);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                throw new AxisFault(e);
            }
        }
    }

    private void printWSDLError(OutputStream out) throws AxisFault {
        try {
            String wsdlntfound = "<error><description>Unable to generate WSDL 1.1 for this service</description><reason>If you wish Axis2 to automatically generate the WSDL 1.1, then please +set useOriginalwsdl as false in your services.xml</reason></error>";
            out.write(wsdlntfound.getBytes());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    public void printWSDL2(OutputStream out) throws AxisFault {
        this.getWSDL2(out, new String[]{this.endpointName});
    }

    public void printWSDL2(OutputStream out, String requestIP, String servicePath) throws AxisFault {
        this.getWSDL2(out, this.getEPRs());
    }

    private void getWSDL2(OutputStream out, String[] serviceURL) throws AxisFault {
        AxisService2WSDL2 axisService2WSDL2 = new AxisService2WSDL2(this, serviceURL);
        try {
            OMElement wsdlElement = axisService2WSDL2.toWSDL20();
            wsdlElement.serialize(out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public ClassLoader getClassLoader() {
        return this.serviceClassLoader;
    }

    public ArrayList getControlOperations() {
        Iterator op_itr = this.getOperations();
        ArrayList<AxisOperation> operationList = new ArrayList<AxisOperation>();
        while (op_itr.hasNext()) {
            AxisOperation operation = (AxisOperation)op_itr.next();
            if (!operation.isControlOperation()) continue;
            operationList.add(operation);
        }
        return operationList;
    }

    public Collection getEngagedModules() {
        return this.engagedModules;
    }

    public URL getFileName() {
        return this.fileName;
    }

    public long getLastupdate() {
        return this.lastupdate;
    }

    public ModuleConfiguration getModuleConfig(String moduleName) {
        return (ModuleConfiguration)this.moduleConfigmap.get(moduleName);
    }

    public ArrayList getModules() {
        return this.moduleRefs;
    }

    public String getName() {
        return this.name;
    }

    public AxisOperation getOperation(QName operationName) {
        AxisOperation axisOperation = (AxisOperation)this.getChild(operationName);
        if (axisOperation == null) {
            axisOperation = (AxisOperation)this.operationsAliasesMap.get(operationName.getLocalPart());
        }
        return axisOperation;
    }

    public AxisOperation getOperationByAction(String action) {
        return (AxisOperation)this.operationsAliasesMap.get(action);
    }

    public AxisOperation getOperationBySOAPAction(String soapAction) {
        if (soapAction == null || soapAction.length() == 0) {
            return null;
        }
        AxisOperation operation = (AxisOperation)this.getChild(new QName(soapAction));
        if (operation != null) {
            return operation;
        }
        operation = (AxisOperation)this.operationsAliasesMap.get(soapAction);
        return operation;
    }

    public Iterator getOperations() {
        return this.getChildren();
    }

    public ArrayList getPublishedOperations() {
        Iterator op_itr = this.getOperations();
        ArrayList<AxisOperation> operationList = new ArrayList<AxisOperation>();
        while (op_itr.hasNext()) {
            AxisOperation operation = (AxisOperation)op_itr.next();
            if (operation.isControlOperation()) continue;
            operationList.add(operation);
        }
        return operationList;
    }

    public void setServiceDescription(String serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.serviceClassLoader = classLoader;
    }

    public void setFileName(URL fileName) {
        this.fileName = fileName;
    }

    public void setLastupdate() {
        this.lastupdate = new Date().getTime();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList getSchema() {
        return this.schemaList;
    }

    public void addSchema(XmlSchema schema) {
        if (schema != null) {
            this.schemaList.add(schema);
            if (schema.getTargetNamespace() != null) {
                this.addSchemaNameSpace(schema);
            }
        }
    }

    public void addSchema(Collection schemas) {
        Iterator iterator = schemas.iterator();
        while (iterator.hasNext()) {
            XmlSchema schema = (XmlSchema)iterator.next();
            this.schemaList.add(schema);
            this.addSchemaNameSpace(schema);
        }
    }

    public boolean isWsdlFound() {
        return this.wsdlFound;
    }

    public void setWsdlFound(boolean wsdlFound) {
        this.wsdlFound = wsdlFound;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if ("application".equals(scope) || "transportsession".equals(scope) || "soapsession".equals(scope) || "request".equals(scope)) {
            this.scope = scope;
        }
    }

    public boolean isUseDefaultChains() {
        return this.useDefaultChains;
    }

    public void setUseDefaultChains(boolean useDefaultChains) {
        this.useDefaultChains = useDefaultChains;
    }

    public Object getKey() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getSchematargetNamespace() {
        return this.schematargetNamespace;
    }

    public void setSchematargetNamespace(String schematargetNamespace) {
        this.schematargetNamespace = schematargetNamespace;
    }

    public String getSchematargetNamespacePrefix() {
        return this.schematargetNamespacePrefix;
    }

    public void setSchematargetNamespacePrefix(String schematargetNamespacePrefix) {
        this.schematargetNamespacePrefix = schematargetNamespacePrefix;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getTargetNamespacePrefix() {
        return this.targetNamespacePrefix;
    }

    public void setTargetNamespacePrefix(String targetNamespacePrefix) {
        this.targetNamespacePrefix = targetNamespacePrefix;
    }

    public XmlSchemaElement getSchemaElement(QName elementQName) {
        for (int i = 0; i < this.schemaList.size(); ++i) {
            XmlSchemaElement element;
            XmlSchema schema = (XmlSchema)this.schemaList.get(i);
            if (schema == null || (element = schema.getElementByName(elementQName)) == null) continue;
            return element;
        }
        return null;
    }

    public boolean isEnableAllTransports() {
        return this.enableAllTransports;
    }

    public void setEnableAllTransports(boolean enableAllTransports) {
        this.enableAllTransports = enableAllTransports;
    }

    public List getExposedTransports() {
        return this.exposedTransports;
    }

    public void setExposedTransports(List transports) {
        this.enableAllTransports = false;
        this.exposedTransports = transports;
    }

    public void addExposedTransport(String transport) {
        this.enableAllTransports = false;
        if (!this.exposedTransports.contains(transport)) {
            this.exposedTransports.add(transport);
        }
    }

    public void removeExposedTransport(String transport) {
        this.enableAllTransports = false;
        this.exposedTransports.remove(transport);
    }

    public boolean isExposedTransport(String transport) {
        return this.exposedTransports.contains(transport);
    }

    public void disengageModule(AxisModule module) {
        AxisConfiguration axisConfig = this.getAxisConfiguration();
        if (axisConfig != null) {
            PhaseResolver phaseResolver = new PhaseResolver(axisConfig);
            if (axisConfig.isEngaged(module.getName())) {
                this.removeModuleOperations(module);
                Iterator operations = this.getChildren();
                while (operations.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)operations.next();
                    phaseResolver.disengageModuleFromOperationChain(module, axisOperation);
                    axisOperation.removeFromEngagedModuleList(module);
                }
            } else if (this.isEngaged(module.getName())) {
                phaseResolver.disengageModuleFromGlobalChains(module);
                this.removeModuleOperations(module);
                Iterator operations = this.getChildren();
                while (operations.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)operations.next();
                    phaseResolver.disengageModuleFromOperationChain(module, axisOperation);
                    axisOperation.removeFromEngagedModuleList(module);
                }
            }
        }
        this.engagedModules.remove(module);
    }

    private void removeModuleOperations(AxisModule module) {
        HashMap moduleOerations = module.getOperations();
        if (moduleOerations != null) {
            Iterator moduleOperations_itr = moduleOerations.values().iterator();
            while (moduleOperations_itr.hasNext()) {
                AxisOperation operation = (AxisOperation)moduleOperations_itr.next();
                this.removeOperation(operation.getName());
            }
        }
    }

    public boolean isEngaged(String moduleName) {
        AxisModule module = this.getAxisConfiguration().getModule(moduleName);
        if (module == null) {
            return false;
        }
        Iterator engagedModuleItr = this.engagedModules.iterator();
        while (engagedModuleItr.hasNext()) {
            AxisModule axisModule = (AxisModule)engagedModuleItr.next();
            if (!axisModule.getName().equals(module.getName())) continue;
            return true;
        }
        return false;
    }

    public static AxisService createClientSideAxisService(URL wsdlURL, QName wsdlServiceName, String portName, Options options) throws AxisFault {
        try {
            InputStream in = wsdlURL.openConnection().getInputStream();
            Document doc = XMLUtils.newDocument(in);
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.importDocuments", true);
            Definition wsdlDefinition = reader.readWSDL(null, doc);
            return AxisService.createClientSideAxisService(wsdlDefinition, wsdlServiceName, portName, options);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new AxisFault("IOException : " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e);
            throw new AxisFault("ParserConfigurationException : " + e.getMessage());
        }
        catch (SAXException e) {
            log.error((Object)e);
            throw new AxisFault("SAXException : " + e.getMessage());
        }
        catch (WSDLException e) {
            log.error((Object)e);
            throw new AxisFault("WSDLException : " + e.getMessage());
        }
    }

    public static AxisService createClientSideAxisService(Definition wsdlDefinition, QName wsdlServiceName, String portName, Options options) throws AxisFault {
        WSDL11ToAxisServiceBuilder serviceBuilder = new WSDL11ToAxisServiceBuilder(wsdlDefinition, wsdlServiceName, portName);
        serviceBuilder.setServerSide(false);
        AxisService axisService = serviceBuilder.populateService();
        AxisEndpoint axisEndpoint = (AxisEndpoint)axisService.getEndpoints().get(axisService.getEndpointName());
        options.setTo(new EndpointReference(axisEndpoint.getEndpointURL()));
        if (axisEndpoint != null) {
            options.setSoapVersionURI((String)axisEndpoint.getBinding().getProperty("wsoap:version"));
        }
        return axisService;
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfig, Class messageReceiverClass) throws AxisFault {
        return AxisService.createService(implClass, axisConfig, messageReceiverClass, null, null);
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfiguration, Map messageReceiverClassMap, String targetNamespace, String schemaNamespace, ClassLoader loader) throws AxisFault {
        SchemaGenerator schemaGenerator;
        int index;
        Parameter parameter = new Parameter("ServiceClass", implClass);
        OMElement paraElement = org.apache.axis2.deployment.util.Utils.getParameter("ServiceClass", implClass, false);
        parameter.setParameterElement(paraElement);
        AxisService axisService = new AxisService();
        axisService.setUseDefaultChains(false);
        axisService.addParameter(parameter);
        if (schemaNamespace == null) {
            schemaNamespace = axisService.getSchematargetNamespace();
        }
        String serviceName = (index = implClass.lastIndexOf(".")) > 0 ? implClass.substring(index + 1, implClass.length()) : implClass;
        axisService.setName(serviceName);
        axisService.setClassLoader(loader);
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        ArrayList excludeOpeartion = new ArrayList();
        NamespaceMap map = new NamespaceMap();
        map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
        map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
        axisService.setNameSpacesMap(map);
        try {
            schemaGenerator = new SchemaGenerator(serviceClassLoader, implClass, schemaNamespace, axisService.getSchematargetNamespacePrefix());
            schemaGenerator.setElementFormDefault("unqualified");
            axisService.setElementFormDefault(false);
            org.apache.axis2.deployment.util.Utils.addExclueMethods(excludeOpeartion);
            schemaGenerator.setExcludeMethods(excludeOpeartion);
            axisService.addSchema(schemaGenerator.generateSchema());
            axisService.setSchematargetNamespace(schemaGenerator.getSchemaTargetNameSpace());
            axisService.setTypeTable(schemaGenerator.getTypeTable());
            if (targetNamespace == null) {
                targetNamespace = schemaGenerator.getSchemaTargetNameSpace();
            }
            if (targetNamespace != null && !"".equals(targetNamespace)) {
                axisService.setTargetNamespace(targetNamespace);
            }
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
        JMethod[] method = schemaGenerator.getMethods();
        TypeTable table = schemaGenerator.getTypeTable();
        PhasesInfo pinfo = axisConfiguration.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            MessageReceiver mr;
            JMethod jmethod = method[i];
            JAnnotation methodAnnon = jmethod.getAnnotation("javax.jws.WebMethod");
            if (methodAnnon != null && methodAnnon.getValue("exclude").asBoolean() || !jmethod.isPublic() || excludeOpeartion.contains(jmethod.getSimpleName())) continue;
            AxisOperation operation = org.apache.axis2.deployment.util.Utils.getAxisOperationforJmethod(jmethod, table);
            String mep = operation.getMessageExchangePattern();
            if (messageReceiverClassMap != null) {
                if (messageReceiverClassMap.get(mep) != null) {
                    Object obj = messageReceiverClassMap.get(mep);
                    if (obj instanceof MessageReceiver) {
                        mr = (MessageReceiver)obj;
                        operation.setMessageReceiver(mr);
                    } else {
                        log.error((Object)"Object is not an instance of MessageReceiver, thus, default MessageReceiver has been set");
                        mr = axisConfiguration.getMessageReceiver(operation.getMessageExchangePattern());
                        operation.setMessageReceiver(mr);
                    }
                } else {
                    log.error((Object)"Required MessageReceiver couldn't be found, thus, default MessageReceiver has been used");
                    mr = axisConfiguration.getMessageReceiver(operation.getMessageExchangePattern());
                    operation.setMessageReceiver(mr);
                }
            } else {
                log.error((Object)"MessageRecevierClassMap couldn't be found, thus, default MessageReceiver has been used");
                mr = axisConfiguration.getMessageReceiver(operation.getMessageExchangePattern());
                operation.setMessageReceiver(mr);
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
        }
        return axisService;
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfiguration, Map messageReceiverClassMap, String targetNamespace, String schemaNamespace) throws AxisFault {
        return AxisService.createService(implClass, axisConfiguration, messageReceiverClassMap, targetNamespace, schemaNamespace, axisConfiguration.getServiceClassLoader());
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfig, Class messageReceiverClass, String targetNameSpace, String schemaNameSpace) throws AxisFault {
        SchemaGenerator schemaGenerator;
        int index;
        Parameter parameter = new Parameter("ServiceClass", implClass);
        OMElement paraElement = org.apache.axis2.deployment.util.Utils.getParameter("ServiceClass", implClass, false);
        parameter.setParameterElement(paraElement);
        AxisService axisService = new AxisService();
        axisService.setUseDefaultChains(false);
        axisService.addParameter(parameter);
        if (schemaNameSpace == null) {
            schemaNameSpace = axisService.getSchematargetNamespace();
        }
        String serviceName = (index = implClass.lastIndexOf(".")) > 0 ? implClass.substring(index + 1, implClass.length()) : implClass;
        axisService.setName(serviceName);
        axisService.setClassLoader(axisConfig.getServiceClassLoader());
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        ArrayList excludeOpeartion = new ArrayList();
        NamespaceMap map = new NamespaceMap();
        map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
        map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
        axisService.setNameSpacesMap(map);
        try {
            schemaGenerator = new SchemaGenerator(serviceClassLoader, implClass, schemaNameSpace, axisService.getSchematargetNamespacePrefix());
            schemaGenerator.setElementFormDefault("unqualified");
            axisService.setElementFormDefault(false);
            org.apache.axis2.deployment.util.Utils.addExclueMethods(excludeOpeartion);
            schemaGenerator.setExcludeMethods(excludeOpeartion);
            axisService.addSchema(schemaGenerator.generateSchema());
            axisService.setSchematargetNamespace(schemaGenerator.getSchemaTargetNameSpace());
            axisService.setTypeTable(schemaGenerator.getTypeTable());
            if (targetNameSpace == null) {
                targetNameSpace = schemaGenerator.getSchemaTargetNameSpace();
            }
            if (targetNameSpace != null && !"".equals(targetNameSpace)) {
                axisService.setTargetNamespace(targetNameSpace);
            }
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
        JMethod[] method = schemaGenerator.getMethods();
        TypeTable table = schemaGenerator.getTypeTable();
        PhasesInfo pinfo = axisConfig.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            JMethod jmethod = method[i];
            JAnnotation methodAnnon = jmethod.getAnnotation("javax.jws.WebMethod");
            if (methodAnnon != null && methodAnnon.getValue("exclude").asBoolean() || !jmethod.isPublic() || excludeOpeartion.contains(jmethod.getSimpleName())) continue;
            AxisOperation operation = org.apache.axis2.deployment.util.Utils.getAxisOperationforJmethod(jmethod, table);
            try {
                MessageReceiver messageReceiver = (MessageReceiver)messageReceiverClass.newInstance();
                operation.setMessageReceiver(messageReceiver);
            }
            catch (IllegalAccessException e) {
                throw new AxisFault("IllegalAccessException occurred during message receiver loading" + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new AxisFault("InstantiationException occurred during message receiver loading" + e.getMessage());
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
        }
        return axisService;
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfig) throws AxisFault {
        Class clazz;
        try {
            clazz = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
        }
        catch (ClassNotFoundException e) {
            throw new AxisFault("ClassNotFoundException occured during message receiver loading" + e.getMessage());
        }
        return AxisService.createService(implClass, axisConfig, clazz);
    }

    public void removeOperation(QName opName) {
        AxisOperation operation = this.getOperation(opName);
        if (operation != null) {
            this.removeChild(opName);
            ArrayList mappingList = operation.getWsamappingList();
            if (mappingList != null) {
                for (int i = 0; i < mappingList.size(); ++i) {
                    String actionMapping = (String)mappingList.get(i);
                    this.operationsAliasesMap.remove(actionMapping);
                }
            }
            this.operationsAliasesMap.remove(operation.getName().getLocalPart());
        }
    }

    public Map getNameSpacesMap() {
        return this.nameSpacesMap;
    }

    public void setNameSpacesMap(NamespaceMap nameSpacesMap) {
        this.nameSpacesMap = nameSpacesMap;
    }

    private void addSchemaNameSpace(XmlSchema schema) {
        String targetNameSpace = schema.getTargetNamespace();
        String prefix = schema.getNamespaceContext().getPrefix(targetNameSpace);
        boolean found = false;
        if (this.nameSpacesMap != null && this.nameSpacesMap.size() > 0) {
            Iterator itr = this.nameSpacesMap.values().iterator();
            Set keys = this.nameSpacesMap.keySet();
            while (itr.hasNext()) {
                String value = (String)itr.next();
                if (!value.equals(targetNameSpace) || !keys.contains(prefix)) continue;
                found = true;
            }
        }
        if (this.nameSpacesMap == null) {
            this.nameSpacesMap = new NamespaceMap();
        }
        if (!found) {
            this.nameSpacesMap.put((Object)("ns" + this.nsCount), (Object)targetNameSpace);
            ++this.nsCount;
        }
    }

    public Map populateSchemaMappings() {
        ArrayList schema = this.schemaList;
        Map changedScheamLocations = null;
        if (!this.schemaLocationsAdjusted) {
            Hashtable nameTable = new Hashtable();
            this.calcualteSchemaNames(schema, nameTable);
            changedScheamLocations = this.adjustSchemaNames(schema, nameTable);
            this.setSchemaMappingTable(this.swapMappingTable(nameTable));
            this.setSchemaLocationsAdjusted(true);
        }
        return changedScheamLocations;
    }

    private void calcualteSchemaNames(List schemas, Hashtable nameTable) {
        for (int i = 0; i < schemas.size(); ++i) {
            XmlSchema schema = (XmlSchema)schemas.get(i);
            XmlSchemaObjectCollection includes = schema.getIncludes();
            for (int j = 0; j < includes.getCount(); ++j) {
                XmlSchemaExternal externalSchema;
                XmlSchema s;
                XmlSchemaObject item = includes.getItem(j);
                if (!(item instanceof XmlSchemaExternal) || (s = (externalSchema = (XmlSchemaExternal)item).getSchema()) == null || nameTable.get(s) != null) continue;
                this.insertIntoNameTable(nameTable, s);
                this.calcualteSchemaNames(Arrays.asList(s), nameTable);
            }
        }
    }

    private void insertIntoNameTable(Hashtable nameTable, XmlSchema s) {
        nameTable.put(s, "xsd" + this.count++ + (this.customSchemaNameSuffix != null ? this.customSchemaNameSuffix : ""));
    }

    private Map adjustSchemaNames(List schemas, Hashtable nameTable) {
        Hashtable importedSchemas = new Hashtable();
        for (int i = 0; i < schemas.size(); ++i) {
            this.adjustSchemaName((XmlSchema)schemas.get(i), nameTable, importedSchemas);
        }
        Enumeration nameTableKeys = nameTable.keys();
        while (nameTableKeys.hasMoreElements()) {
            this.adjustSchemaName((XmlSchema)nameTableKeys.nextElement(), nameTable, importedSchemas);
        }
        return importedSchemas;
    }

    private void adjustSchemaName(XmlSchema parentSchema, Hashtable nameTable, Hashtable importedScheams) {
        XmlSchemaObjectCollection includes = parentSchema.getIncludes();
        for (int j = 0; j < includes.getCount(); ++j) {
            XmlSchemaObject item = includes.getItem(j);
            if (!(item instanceof XmlSchemaExternal)) continue;
            XmlSchemaExternal xmlSchemaExternal = (XmlSchemaExternal)item;
            XmlSchema s = xmlSchemaExternal.getSchema();
            this.adjustSchemaLocation(s, xmlSchemaExternal, nameTable, importedScheams);
        }
    }

    private void adjustSchemaLocation(XmlSchema s, XmlSchemaExternal xmlSchemaExternal, Hashtable nameTable, Hashtable importedScheams) {
        if (s != null) {
            String schemaLocation = xmlSchemaExternal.getSchemaLocation();
            if (importedScheams.get(schemaLocation) != null) {
                xmlSchemaExternal.setSchemaLocation((String)importedScheams.get(xmlSchemaExternal.getSchemaLocation()));
            } else {
                String newscheamlocation = this.customSchemaNamePrefix == null ? this.getName() + "?xsd=" + nameTable.get(s) : this.customSchemaNamePrefix + nameTable.get(s);
                xmlSchemaExternal.setSchemaLocation(newscheamlocation);
                importedScheams.put(schemaLocation, newscheamlocation);
            }
        }
    }

    private Map swapMappingTable(Map originalTable) {
        HashMap swappedTable = new HashMap(originalTable.size());
        Iterator keys = originalTable.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            swappedTable.put(originalTable.get(key), key);
        }
        return swappedTable;
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public void setClientSide(boolean clientSide) {
        this.clientSide = clientSide;
    }

    public boolean isElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(boolean elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    public boolean isUseUserWSDL() {
        String value;
        Parameter parameter = this.getParameter("useOriginalwsdl");
        return parameter != null && "true".equals(value = (String)parameter.getValue());
    }

    public boolean isModifyUserWSDLPortAddress() {
        String value;
        Parameter parameter = this.getParameter("modifyUserWSDLPortAddress");
        return parameter == null || !"false".equals(value = (String)parameter.getValue());
    }

    public ServiceLifeCycle getServiceLifeCycle() {
        return this.serviceLifeCycle;
    }

    public void setServiceLifeCycle(ServiceLifeCycle serviceLifeCycle) {
        this.serviceLifeCycle = serviceLifeCycle;
    }

    public Map getP2nMap() {
        return this.p2nMap;
    }

    public void setP2nMap(Map p2nMap) {
        this.p2nMap = p2nMap;
    }

    public ObjectSupplier getObjectSupplier() {
        return this.objectSupplier;
    }

    public void setObjectSupplier(ObjectSupplier objectSupplier) {
        this.objectSupplier = objectSupplier;
    }

    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    public void setTypeTable(TypeTable typeTable) {
        this.typeTable = typeTable;
    }

    public Data[] getData(DataRetrievalRequest request, MessageContext msgContext) throws AxisFault {
        Data[] data = null;
        String dialect = request.getDialect();
        AxisDataLocator dataLocator = null;
        int nextDataLocatorIndex = 0;
        int totalLocators = this.availableDataLocatorTypes.length;
        for (int i = 0; i < totalLocators; ++i) {
            dataLocator = this.getDataLocator(this.availableDataLocatorTypes[i], dialect);
            if (dataLocator == null) continue;
            nextDataLocatorIndex = i + 1;
            break;
        }
        if ((data = dataLocator.getData(request, msgContext)) == null && nextDataLocatorIndex < totalLocators) {
            data = this.bubbleupDataLocators(nextDataLocatorIndex, request, msgContext);
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Data[] bubbleupDataLocators(int nextIndex, DataRetrievalRequest request, MessageContext msgContext) throws AxisFault {
        Data[] data = null;
        if (nextIndex >= this.availableDataLocatorTypes.length) return data;
        AxisDataLocator dataLocator = this.getDataLocator(this.availableDataLocatorTypes[nextIndex], request.getDialect());
        if (dataLocator == null) return this.bubbleupDataLocators(nextIndex, request, msgContext);
        data = dataLocator.getData(request, msgContext);
        if (data != null) return data;
        return this.bubbleupDataLocators(++nextIndex, request, msgContext);
    }

    public void addDataLocatorClassNames(String dialect, String dataLocatorClassName) {
        this.dataLocatorClassNames.put(dialect, dataLocatorClassName);
    }

    private AxisDataLocator getDataLocator(LocatorType locatorType, String dialect) throws AxisFault {
        AxisDataLocator locator = null;
        locator = locatorType == LocatorType.SERVICE_DIALECT ? this.getServiceDataLocator(dialect) : (locatorType == LocatorType.SERVICE_LEVEL ? this.getServiceDataLocator("ServiceLevel") : (locatorType == LocatorType.GLOBAL_DIALECT ? this.getGlobalDataLocator(dialect) : (locatorType == LocatorType.GLOBAL_LEVEL ? this.getGlobalDataLocator("GlobalLevel") : (locatorType == LocatorType.DEFAULT_AXIS ? this.getDefaultDataLocator() : this.getDefaultDataLocator()))));
        return locator;
    }

    private AxisDataLocator getDefaultDataLocator() throws DataRetrievalException {
        if (this.defaultDataLocator == null) {
            this.defaultDataLocator = new AxisDataLocatorImpl(this);
        }
        this.defaultDataLocator.loadServiceData();
        return this.defaultDataLocator;
    }

    private AxisDataLocator getServiceDataLocator(String dialect) throws AxisFault {
        String className;
        AxisDataLocator locator = null;
        locator = (AxisDataLocator)this.dataLocators.get(dialect);
        if (locator == null && (className = (String)this.dataLocatorClassNames.get(dialect)) != null) {
            locator = this.loadDataLocator(className);
            this.dataLocators.put(dialect, locator);
        }
        return locator;
    }

    public AxisDataLocator getGlobalDataLocator(String dialect) throws AxisFault {
        String className;
        AxisConfiguration axisConfig = this.getAxisConfiguration();
        AxisDataLocator locator = null;
        if (axisConfig != null && (locator = axisConfig.getDataLocator(dialect)) == null && (className = axisConfig.getDataLocatorClassName(dialect)) != null) {
            locator = this.loadDataLocator(className);
            axisConfig.addDataLocator(dialect, locator);
        }
        return locator;
    }

    protected AxisDataLocator loadDataLocator(String className) throws AxisFault {
        AxisDataLocator locator = null;
        try {
            Class<?> dataLocator = Class.forName(className, true, this.serviceClassLoader);
            locator = (AxisDataLocator)dataLocator.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AxisFault(e);
        }
        catch (IllegalAccessException e) {
            throw new AxisFault(e);
        }
        catch (InstantiationException e) {
            throw new AxisFault(e);
        }
        return locator;
    }

    public void setMessageElementQNameToOperationMap(Map messageElementQNameToOperationMap) {
        this.messageElementQNameToOperationMap = messageElementQNameToOperationMap;
    }

    public AxisOperation getOperationByMessageElementQName(QName messageElementQName) {
        return (AxisOperation)this.messageElementQNameToOperationMap.get(messageElementQName);
    }

    public void addMessageElementQNameToOperationMapping(QName messageElementQName, AxisOperation operation) {
        if (this.messageElementQNameToOperationMap.containsKey(messageElementQName)) {
            this.messageElementQNameToOperationMap.put(messageElementQName, null);
        } else {
            this.messageElementQNameToOperationMap.put(messageElementQName, operation);
        }
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public void setEndpointURL(String endpointURL) {
        this.endpointURL = endpointURL;
    }

    public Map getEndpoints() {
        return this.endpointMap;
    }

    public boolean isCustomWsdl() {
        return this.customWsdl;
    }

    public void setCustomWsdl(boolean customWsdl) {
        this.customWsdl = customWsdl;
    }

    public List getOperationsNameList() {
        return this.operationsNameList;
    }

    public void setOperationsNameList(List operationsNameList) {
        this.operationsNameList = operationsNameList;
    }
}

