/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportListener;

public class InstanceDispatcher
extends AbstractHandler {
    private static final QName SERVICE_GROUP_QNAME = new QName("http://ws.apache.org/namespaces/axis2", "ServiceGroupId", "axis2");

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        AxisService service = msgContext.getAxisService();
        String scope = service == null ? null : service.getScope();
        ServiceContext serviceContext = msgContext.getServiceContext();
        if (msgContext.getOperationContext() != null && serviceContext != null) {
            msgContext.setServiceGroupContextId(((ServiceGroupContext)serviceContext.getParent()).getId());
            return Handler.InvocationResponse.CONTINUE;
        }
        if ("transportsession".equals(scope)) {
            this.fillContextsFromSessionContext(msgContext);
        } else if ("soapsession".equals(scope)) {
            this.extractServiceGroupContextId(msgContext);
        }
        AxisOperation axisOperation = msgContext.getAxisOperation();
        if (axisOperation == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        OperationContext operationContext = axisOperation.findForExistingOperationContext(msgContext);
        if (operationContext != null) {
            axisOperation.registerMessageContext(msgContext, operationContext);
            serviceContext = (ServiceContext)operationContext.getParent();
            ServiceGroupContext serviceGroupContext = (ServiceGroupContext)serviceContext.getParent();
            msgContext.setServiceContext(serviceContext);
            msgContext.setServiceGroupContext(serviceGroupContext);
            msgContext.setServiceGroupContextId(serviceGroupContext.getId());
        } else {
            operationContext = ContextFactory.createOperationContext(axisOperation, serviceContext);
            axisOperation.registerMessageContext(msgContext, operationContext);
            if (serviceContext != null) {
                operationContext.setParent(serviceContext);
            } else {
                msgContext.getConfigurationContext().fillServiceContextAndServiceGroupContext(msgContext);
            }
        }
        serviceContext = msgContext.getServiceContext();
        if (serviceContext != null) {
            serviceContext.setMyEPR(msgContext.getTo());
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void fillContextsFromSessionContext(MessageContext msgContext) throws AxisFault {
        TransportListener listener;
        AxisService service = msgContext.getAxisService();
        if (service == null) {
            throw new AxisFault(Messages.getMessage("unabletofindservice"));
        }
        SessionContext sessionContext = msgContext.getSessionContext();
        if (sessionContext == null && (sessionContext = (listener = msgContext.getTransportIn().getReceiver()).getSessionContext(msgContext)) == null) {
            this.createAndFillContexts(service, msgContext, sessionContext);
            return;
        }
        String serviceGroupName = msgContext.getAxisServiceGroup().getServiceGroupName();
        ServiceGroupContext serviceGroupContext = sessionContext.getServiceGroupContext(serviceGroupName);
        if (serviceGroupContext != null) {
            msgContext.setServiceGroupContext(serviceGroupContext);
            msgContext.setServiceContext(ContextFactory.createServiceContext(serviceGroupContext, service));
        } else {
            this.createAndFillContexts(service, msgContext, sessionContext);
        }
        ServiceContext serviceContext = sessionContext.getServiceContext(service);
        if (serviceContext != null) {
            msgContext.setServiceContext(serviceContext);
            serviceContext.setProperty("Cookie", sessionContext.getCookieID());
        }
    }

    private void createAndFillContexts(AxisService service, MessageContext msgContext, SessionContext sessionContext) throws AxisFault {
        AxisServiceGroup axisServiceGroup = (AxisServiceGroup)service.getParent();
        ServiceGroupContext serviceGroupContext = ContextFactory.createServiceGroupContext(msgContext.getConfigurationContext(), axisServiceGroup);
        msgContext.setServiceGroupContext(serviceGroupContext);
        ServiceContext serviceContext = ContextFactory.createServiceContext(serviceGroupContext, service);
        msgContext.setServiceContext(serviceContext);
        if (sessionContext != null) {
            sessionContext.addServiceContext(serviceContext);
            sessionContext.addServiceGroupContext(serviceGroupContext);
        }
    }

    private void extractServiceGroupContextId(MessageContext msgContext) throws AxisFault {
        OMElement serviceGroupId;
        SOAPHeader soapHeader = msgContext.getEnvelope().getHeader();
        if (soapHeader != null && (serviceGroupId = soapHeader.getFirstChildWithName(SERVICE_GROUP_QNAME)) != null) {
            String groupId = serviceGroupId.getText();
            ServiceGroupContext serviceGroupContext = msgContext.getConfigurationContext().getServiceGroupContextFromSoapSessionTable(groupId, msgContext);
            if (serviceGroupContext == null) {
                throw new AxisFault(Messages.getMessage("invalidservicegrouoid", groupId));
            }
            msgContext.setServiceGroupContextId(serviceGroupId.getText());
        }
    }
}

