/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.ServiceLifeCycle;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListenerManager {
    private static final Log log = LogFactory.getLog((Class)ListenerManager.class);
    public static ConfigurationContext defaultConfigurationContext;
    private ConfigurationContext configctx;
    private HashMap startedTransports = new HashMap();
    private boolean stopped = true;

    public void init(ConfigurationContext configCtx) {
        configCtx.setTransportManager(this);
        this.configctx = configCtx;
    }

    public ConfigurationContext getConfigctx() {
        return this.configctx;
    }

    public synchronized EndpointReference getEPRforService(String serviceName, String opName, String transportName) throws AxisFault {
        if (transportName == null || "".equals(transportName)) {
            AxisService service = this.configctx.getAxisConfiguration().getService(serviceName);
            if (service == null) {
                throw new AxisFault(Messages.getMessage("servicenotfoundinthesystem", serviceName));
            }
            if (service.isEnableAllTransports()) {
                Iterator itr_st = this.startedTransports.values().iterator();
                while (itr_st.hasNext()) {
                    TransportListener transportListener = (TransportListener)itr_st.next();
                    EndpointReference[] epRsForService = transportListener.getEPRsForService(serviceName, null);
                    if (epRsForService == null) continue;
                    return epRsForService[0];
                }
                return null;
            }
            List exposeTransport = service.getExposedTransports();
            TransportListener listener = (TransportListener)this.startedTransports.get(exposeTransport.get(0));
            EndpointReference[] eprsForService = opName == null ? listener.getEPRsForService(serviceName, null) : listener.getEPRsForService(serviceName + "/" + opName, null);
            return eprsForService != null ? eprsForService[0] : null;
        }
        TransportInDescription trsIN = this.configctx.getAxisConfiguration().getTransportIn(transportName);
        TransportListener listener = trsIN.getReceiver();
        EndpointReference[] eprsForService = opName == null ? listener.getEPRsForService(serviceName, null) : listener.getEPRsForService(serviceName + "/" + opName, null);
        return eprsForService != null ? eprsForService[0] : null;
    }

    public synchronized void start() {
        Iterator transportNames = this.configctx.getAxisConfiguration().getTransportsIn().values().iterator();
        while (transportNames.hasNext()) {
            try {
                TransportInDescription transportIn = (TransportInDescription)transportNames.next();
                TransportListener listener = transportIn.getReceiver();
                if (listener == null || this.startedTransports.get(transportIn.getName()) != null) continue;
                listener.init(this.configctx, transportIn);
                listener.start();
                if (this.startedTransports.get(transportIn.getName()) != null) continue;
                this.startedTransports.put(transportIn.getName(), listener);
            }
            catch (Exception e) {
                log.info((Object)e.getMessage());
            }
        }
        this.stopped = false;
        Runtime.getRuntime().addShutdownHook(new ListenerManagerShutdownThread(this));
    }

    public synchronized void startSystem(ConfigurationContext configurationContext) {
        this.init(configurationContext);
        this.start();
    }

    public synchronized void stop() throws AxisFault {
        HashMap modules;
        if (this.stopped) {
            return;
        }
        Iterator iter = this.startedTransports.values().iterator();
        while (iter.hasNext()) {
            TransportListener transportListener = (TransportListener)iter.next();
            transportListener.stop();
        }
        HashMap transportOut = this.configctx.getAxisConfiguration().getTransportsOut();
        if (transportOut.size() > 0) {
            Iterator trsItr = transportOut.values().iterator();
            while (trsItr.hasNext()) {
                TransportOutDescription outDescription = (TransportOutDescription)trsItr.next();
                TransportSender trsSededer = outDescription.getSender();
                if (trsSededer == null) continue;
                trsSededer.stop();
            }
        }
        if ((modules = this.configctx.getAxisConfiguration().getModules()) != null) {
            Iterator moduleitr = modules.values().iterator();
            while (moduleitr.hasNext()) {
                AxisModule axisModule = (AxisModule)moduleitr.next();
                Module module = axisModule.getModule();
                if (module == null) continue;
                module.shutdown(this.configctx);
            }
        }
        this.configctx.cleanupContexts();
        Iterator services = this.configctx.getAxisConfiguration().getServices().values().iterator();
        while (services.hasNext()) {
            AxisService axisService = (AxisService)services.next();
            ServiceLifeCycle serviceLifeCycle = axisService.getServiceLifeCycle();
            if (serviceLifeCycle == null) continue;
            serviceLifeCycle.shutDown(this.configctx, axisService);
        }
        this.stopped = true;
    }

    public synchronized void addListener(TransportInDescription trsIn, boolean started) throws AxisFault {
        this.configctx.getAxisConfiguration().addTransportIn(trsIn);
        TransportListener transportListener = trsIn.getReceiver();
        if (transportListener != null) {
            if (!started) {
                transportListener.init(this.configctx, trsIn);
                transportListener.start();
            }
            this.stopped = false;
            this.startedTransports.put(trsIn.getName(), transportListener);
        }
    }

    public synchronized boolean isListenerRunning(String transportName) {
        return this.startedTransports.get(transportName) != null;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void destroy() throws AxisFault {
        this.stop();
        this.configctx.setTransportManager(null);
        Iterator iter = this.startedTransports.values().iterator();
        while (iter.hasNext()) {
            TransportListener transportListener = (TransportListener)iter.next();
            transportListener.destroy();
        }
        this.startedTransports.clear();
        this.configctx = null;
        defaultConfigurationContext = null;
    }

    static class ListenerManagerShutdownThread
    extends Thread {
        ListenerManager listenerManager;

        public ListenerManagerShutdownThread(ListenerManager listenerManager) {
            this.listenerManager = listenerManager;
        }

        public void run() {
            try {
                if (!this.listenerManager.stopped) {
                    this.listenerManager.stop();
                }
            }
            catch (AxisFault axisFault) {
                log.error((Object)axisFault);
            }
        }
    }
}

