/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestURIBasedDispatcher
extends AbstractDispatcher {
    public static final String NAME = "RequestURIBasedDispatcher";
    private static final Log log = LogFactory.getLog((Class)RequestURIBasedDispatcher.class);

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR != null) {
            ConfigurationContext configurationContext;
            String filePart;
            String[] values;
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " Checking for Service using target endpoint address : " + toEPR.getAddress()));
            }
            if ((values = Utils.parseRequestURLForServiceAndOperation(filePart = toEPR.getAddress(), (configurationContext = messageContext.getConfigurationContext()).getServiceContextPath())).length >= 1 && values[0] != null) {
                Map endpoints;
                AxisConfiguration registry = configurationContext.getAxisConfiguration();
                AxisService axisService = registry.getService(values[0]);
                if (axisService != null && (endpoints = axisService.getEndpoints()) != null) {
                    if (endpoints.size() == 1) {
                        messageContext.setProperty("endpoint", endpoints.get(axisService.getEndpointName()));
                    } else {
                        String endpointName = values[0].substring(values[0].indexOf(".") + 1);
                        messageContext.setProperty("endpoint", endpoints.get(endpointName));
                    }
                }
                return axisService;
            }
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " Attempted to check for Service using target endpoint URI, but the service fragment was missing"));
            }
            return null;
        }
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)(messageContext.getLogIDString() + " Attempted to check for Service using null target endpoint URI"));
        }
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

