/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.WSDL20DefaultValueHolder;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;
import org.apache.woden.wsdl20.extensions.http.HTTPLocation;
import org.apache.woden.wsdl20.extensions.http.HTTPLocationTemplate;

public class URLTemplatingUtil {
    private static String applyURITemplating(MessageContext messageContext, String rawURLString, boolean detach) throws AxisFault {
        OMElement firstElement = detach ? messageContext.getEnvelope().getBody().getFirstElement() : messageContext.getEnvelope().getBody().getFirstElement().cloneOMElement();
        String queryParameterSeparator = (String)messageContext.getProperty("whttp:queryParameterSeparator");
        if (queryParameterSeparator == null) {
            queryParameterSeparator = "&";
        }
        HTTPLocation httpLocation = new HTTPLocation(rawURLString);
        HTTPLocationTemplate[] templates = httpLocation.getTemplates();
        for (int i = 0; i < templates.length; ++i) {
            HTTPLocationTemplate template = templates[i];
            String localName = template.getName();
            String elementValue = URLTemplatingUtil.getOMElementValue(localName, firstElement);
            if (template.isEncoded()) {
                try {
                    if (template.isQuery()) {
                        template.setValue(URIEncoderDecoder.quoteIllegal(elementValue, "-._~!$'()*+,;=:@/?".replaceAll(queryParameterSeparator, "")));
                        continue;
                    }
                    template.setValue(URIEncoderDecoder.quoteIllegal(elementValue, "-._~!$'()*+,;=:@"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new AxisFault("Unable to encode Query String");
                }
            }
            template.setValue(elementValue);
        }
        return httpLocation.getFormattedLocation();
    }

    public static URL appendQueryParameters(MessageContext messageContext, URL url) throws AxisFault {
        String urlString = url.toString();
        String queryParameterSeparator = (String)messageContext.getProperty("whttp:queryParameterSeparator");
        if (queryParameterSeparator == null) {
            queryParameterSeparator = WSDL20DefaultValueHolder.getDefaultValue("whttp:queryParameterSeparator");
        }
        OMElement firstElement = messageContext.getEnvelope().getBody().getFirstElement();
        String params = "";
        if (firstElement != null) {
            Iterator iter = firstElement.getChildElements();
            String legalCharacters = "-._~!$'()*+,;=:@/?".replaceAll(queryParameterSeparator, "");
            while (iter.hasNext()) {
                OMElement element = (OMElement)iter.next();
                try {
                    params = params + URIEncoderDecoder.quoteIllegal(element.getLocalName(), legalCharacters) + "=" + URIEncoderDecoder.quoteIllegal(element.getText(), legalCharacters) + queryParameterSeparator;
                }
                catch (UnsupportedEncodingException e) {
                    throw new AxisFault(e);
                }
            }
        }
        if (!"".equals(params)) {
            int index = urlString.indexOf("?");
            urlString = index == -1 ? urlString + "?" + params.substring(0, params.length() - 1) : (index == urlString.length() - 1 ? urlString + params.substring(0, params.length() - 1) : urlString + queryParameterSeparator + params.substring(0, params.length() - 1));
            try {
                return new URL(urlString);
            }
            catch (MalformedURLException e) {
                throw new AxisFault(e);
            }
        }
        return url;
    }

    private static String getOMElementValue(String elementName, OMElement parentElement) {
        OMElement httpURLParam = null;
        Iterator children = parentElement.getChildElements();
        while (children.hasNext()) {
            OMElement child = (OMElement)children.next();
            QName qName = child.getQName();
            if (!elementName.equals(qName.getLocalPart())) continue;
            httpURLParam = child;
            break;
        }
        if (httpURLParam != null) {
            httpURLParam.detach();
            if (parentElement.getFirstOMChild() == null) {
                parentElement.detach();
            }
            return httpURLParam.getText();
        }
        return "";
    }

    public static URL getTemplatedURL(URL targetURL, MessageContext messageContext, boolean detach) throws AxisFault {
        String httpLocation = (String)messageContext.getProperty("whttp:location");
        if (httpLocation != null) {
            String replacedQuery = httpLocation;
            int separator = httpLocation.indexOf(123);
            try {
                URI appendedURI;
                if (separator > -1) {
                    replacedQuery = URIEncoderDecoder.quoteIllegal(URLTemplatingUtil.applyURITemplating(messageContext, httpLocation, detach), "-._~!$&()*+,;=:@?/%");
                }
                if (replacedQuery.charAt(0) == '?') {
                    appendedURI = new URI(targetURL.toString() + replacedQuery);
                } else {
                    URI targetURI = new URI(targetURL.toString() + "/");
                    appendedURI = targetURI.resolve(replacedQuery);
                }
                targetURL = appendedURI.toURL();
            }
            catch (MalformedURLException e) {
                throw new AxisFault("An error occured while trying to create request URL");
            }
            catch (URISyntaxException e) {
                throw new AxisFault("An error occured while trying to create request URL");
            }
            catch (UnsupportedEncodingException e) {
                throw new AxisFault("An error occured while trying to create request URL");
            }
        }
        return targetURL;
    }
}

