/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.local;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.local.LocalTransportReceiver;

public class LocalTransportSender
extends AbstractHandler
implements TransportSender {
    private ByteArrayOutputStream out;
    private ByteArrayOutputStream response;

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void stop() {
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    protected OutputStream getResponse() {
        return this.response;
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
        msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(msgContext));
        EndpointReference epr = null;
        if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            epr = msgContext.getTo();
        }
        if (epr != null) {
            if (!epr.hasNoneAddress()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                TransportUtils.writeMessage(msgContext, out);
                this.finalizeSendWithToAddress(msgContext, out);
            }
        } else {
            OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
            if (out != null) {
                TransportUtils.writeMessage(msgContext, out);
            } else {
                throw new AxisFault("Both the TO and Property MessageContext.TRANSPORT_OUT is Null, No where to send");
            }
        }
        if (msgContext.getOperationContext() != null) {
            msgContext.getOperationContext().setProperty("CONTENT_WRITTEN", "true");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public void finalizeSendWithToAddress(MessageContext msgContext, OutputStream out) throws AxisFault {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(this.out.toByteArray());
            this.response = new ByteArrayOutputStream();
            LocalTransportReceiver localTransportReceiver = new LocalTransportReceiver(this);
            localTransportReceiver.processMessage(in, msgContext.getTo());
            ((InputStream)in).close();
            out.close();
            in = new ByteArrayInputStream(this.response.toByteArray());
            msgContext.setProperty("TRANSPORT_IN", in);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }
}

