/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.mail.EmailReceiver;
import org.apache.axis2.transport.mail.MailBasedOutTransportInfo;
import org.apache.axis2.transport.mail.MailWorkerManager;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.threadpool.DefaultThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleMailListener
implements Runnable,
TransportListener {
    private static final Log log = LogFactory.getLog((Class)SimpleMailListener.class);
    private ConfigurationContext configurationContext = null;
    private boolean running = true;
    private String user = "";
    private String replyTo = "";
    private Properties pop3Properties = new Properties();
    private EmailReceiver receiver = null;
    private int listenerWaitInterval = 180000;
    private ExecutorService workerPool;
    private static final int WORKERS_MAX_THREADS = 5;
    private static final long WORKER_KEEP_ALIVE = 60L;
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private LinkedBlockingQueue messageQueue;

    public SimpleMailListener() {
    }

    public SimpleMailListener(LinkedBlockingQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    public void init(ConfigurationContext configurationContext, TransportInDescription transportIn) throws AxisFault {
        this.configurationContext = configurationContext;
        ArrayList mailParameters = transportIn.getParameters();
        String password = "";
        String host = "";
        String protocol = "";
        String port = "";
        Iterator iterator = mailParameters.iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            String paramKey = param.getName();
            String paramValue = Utils.getParameterValue(param);
            if (paramKey == null || paramValue == null) {
                String error = Messages.getMessage("canNotBeNull", "Parameter name and value");
                log.error((Object)error);
                throw new AxisFault(error);
            }
            this.pop3Properties.setProperty(paramKey, paramValue);
            if (paramKey.equals("mail.pop3.user")) {
                this.user = paramValue;
            }
            if (paramKey.equals("transport.mail.pop3.password")) {
                password = paramValue;
            }
            if (paramKey.equals("mail.pop3.host")) {
                host = paramValue;
            }
            if (paramKey.equals("mail.store.protocol")) {
                protocol = paramValue;
            }
            if (paramKey.equals("mail.pop3.port")) {
                port = paramValue;
            }
            if (paramKey.equals("transport.mail.replyToAddress")) {
                this.replyTo = paramValue;
            }
            if (!paramKey.equals("transport.listener.interval")) continue;
            this.listenerWaitInterval = Integer.parseInt(paramValue);
        }
        if (password.length() == 0 || this.user.length() == 0 || host.length() == 0 || protocol.length() == 0) {
            String error = SimpleMailListener.class.getName() + " one or more of Password, User, Host and Protocol are null or empty";
            log.error((Object)error);
            throw new AxisFault(error);
        }
        URLName urlName = port.length() == 0 ? new URLName(protocol, host, -1, "", this.user, password) : new URLName(protocol, host, Integer.parseInt(port), "", this.user, password);
        this.receiver = new EmailReceiver();
        this.receiver.setPop3Properties(this.pop3Properties);
        this.receiver.setUrlName(urlName);
    }

    public void initFromRuntime(Properties properties, MessageContext msgContext) throws AxisFault {
        this.configurationContext = msgContext.getConfigurationContext();
        String password = "";
        String host = "";
        String protocol = "";
        String port = "";
        this.pop3Properties.clear();
        this.pop3Properties.putAll((Map<?, ?>)properties);
        this.user = properties.getProperty("mail.pop3.user");
        password = properties.getProperty("transport.mail.pop3.password");
        host = properties.getProperty("mail.pop3.host");
        protocol = properties.getProperty("mail.store.protocol");
        port = properties.getProperty("mail.pop3.port");
        this.replyTo = properties.getProperty("transport.mail.replyToAddress");
        String value = properties.getProperty("transport.listener.interval");
        if (value != null) {
            this.listenerWaitInterval = Integer.parseInt(value);
        }
        if (password.length() == 0 || this.user.length() == 0 || host.length() == 0 || protocol.length() == 0) {
            String error = SimpleMailListener.class.getName() + " one or more of Password, User," + " Host and Protocol are null or empty" + "in runtime settings";
            log.error((Object)error);
            throw new AxisFault(error);
        }
        URLName urlName = port == null ? new URLName(protocol, host, -1, "", this.user, password) : new URLName(protocol, host, Integer.parseInt(port), "", this.user, password);
        this.receiver = new EmailReceiver();
        this.receiver.setPop3Properties(this.pop3Properties);
        this.receiver.setUrlName(urlName);
    }

    public static void main(String[] args) throws AxisFault {
        if (args.length < 2) {
            log.info((Object)"java SimpleMailListener <repository>");
            SimpleMailListener.printUsage();
        } else {
            String path = args[0];
            String axis2xml = args[1];
            File repo = new File(path);
            if (!repo.exists()) {
                SimpleMailListener.printUsage();
                throw new AxisFault("repository not found");
            }
            ConfigurationContext configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(path, axis2xml);
            SimpleMailListener sas = new SimpleMailListener();
            TransportInDescription transportIn = configurationContext.getAxisConfiguration().getTransportIn("mailto");
            if (transportIn != null) {
                sas.init(configurationContext, transportIn);
                log.info((Object)("Starting the SimpleMailListener with repository " + new File(args[0]).getAbsolutePath()));
                sas.start();
            } else {
                log.info((Object)"Startup failed, mail transport not configured, Configure the mail trnasport in the axis2.xml file");
            }
        }
    }

    private static void printUsage() {
        System.out.println("Please provide the repository location and axis2.xml location ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.running) {
            log.info((Object)("Mail listner strated to listen to the address " + this.user));
        }
        while (this.running) {
            try {
                this.receiver.connect();
                Message[] msgs = this.receiver.receiveMessages();
                if (msgs != null && msgs.length > 0) {
                    log.info((Object)(msgs.length + " Message Found"));
                    for (int i = 0; i < msgs.length; ++i) {
                        MimeMessage msg = (MimeMessage)msgs[i];
                        try {
                            MessageContext mc = this.createMessageContextToMailWorker(msg);
                            if (mc == null) continue;
                            this.messageQueue.add((Object)mc);
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)("Error in SimpleMailListener - processing mail " + e));
                            continue;
                        }
                        finally {
                            msg.setFlag(Flags.Flag.DELETED, true);
                        }
                    }
                }
                this.receiver.disconnect();
            }
            catch (Exception e) {
                log.error((Object)("Error in SimpleMailListener" + e));
            }
            finally {
                try {
                    Thread.sleep(this.listenerWaitInterval);
                }
                catch (InterruptedException e) {
                    log.warn((Object)("Error Encountered " + e));
                }
            }
        }
    }

    private MessageContext createMessageContextToMailWorker(MimeMessage msg) throws Exception {
        MessageContext msgContext = null;
        TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn("mailto");
        TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut("mailto");
        if (transportIn != null && transportOut != null) {
            String inReplyTo;
            String smtpMessageId;
            msgContext = ContextFactory.createMessageContext(this.configurationContext);
            msgContext.setTransportIn(transportIn);
            msgContext.setTransportOut(transportOut);
            msgContext.setServerSide(true);
            msgContext.setProperty("mail.contenttype", msg.getContentType());
            msgContext.setIncomingTransportName("mailto");
            MailBasedOutTransportInfo transportInfo = new MailBasedOutTransportInfo();
            Address[] mimefroms = msg.getFrom();
            if (mimefroms != null && mimefroms.length > 0) {
                EndpointReference fromEPR = new EndpointReference("mailto:" + msg.getFrom()[0].toString());
                transportInfo.setFrom(fromEPR);
            }
            if ((smtpMessageId = msg.getMessageID()) != null) {
                transportInfo.setInReplyTo(smtpMessageId);
            }
            if ((inReplyTo = this.getMailHeader(msg, "In-Reply-To")) != null) {
                transportInfo.setInReplyTo(inReplyTo);
            }
            msgContext.setProperty("OutTransportInfo", transportInfo);
            this.buildSOAPEnvelope(msg, msgContext);
        }
        return msgContext;
    }

    private void buildSOAPEnvelope(MimeMessage msg, MessageContext msgContext) throws AxisFault {
        try {
            Multipart mp = (Multipart)msg.getContent();
            if (mp != null) {
                int n = mp.getCount();
                for (int i = 0; i < n; ++i) {
                    BodyPart part = mp.getBodyPart(i);
                    String disposition = part.getDisposition();
                    if (disposition == null || !disposition.equalsIgnoreCase("attachment")) continue;
                    if (BuilderUtil.getCharSetEncoding(part.getContentType()) != null) {
                        msgContext.setProperty("CHARACTER_SET_ENCODING", BuilderUtil.getCharSetEncoding(part.getContentType()));
                    } else {
                        msgContext.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
                    }
                    String soapAction = this.getMailHeaderFromPart((Part)part, "mail.soapaction");
                    msgContext.setSoapAction(soapAction);
                    String contentDescription = this.getMailHeaderFromPart((Part)part, "Content-Description");
                    if (contentDescription != null) {
                        msgContext.setTo(new EndpointReference(contentDescription));
                    }
                    if (part.getContentType().indexOf("application/soap+xml") > -1) {
                        TransportUtils.processContentTypeForAction(part.getContentType(), msgContext);
                    }
                    InputStream inputStream = part.getInputStream();
                    SOAPEnvelope envelope = TransportUtils.createSOAPMessage(msgContext, inputStream, part.getContentType());
                    msgContext.setEnvelope(envelope);
                }
            }
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
        catch (MessagingException e) {
            throw new AxisFault(e);
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
    }

    private String getMailHeader(MimeMessage msg, String headerName) throws AxisFault {
        try {
            String[] values = msg.getHeader(headerName);
            if (values != null) {
                return values[0];
            }
            return null;
        }
        catch (MessagingException e) {
            throw new AxisFault(e);
        }
    }

    private String getMailHeaderFromPart(Part part, String headerName) throws AxisFault {
        try {
            String[] values = part.getHeader(headerName);
            if (values != null) {
                return values[0];
            }
            return null;
        }
        catch (MessagingException e) {
            throw new AxisFault(e);
        }
    }

    public void start() throws AxisFault {
        this.workerPool = new ThreadPoolExecutor(1, 5, 60L, TIME_UNIT, (BlockingQueue)new LinkedBlockingQueue(), (ThreadFactory)new DefaultThreadFactory(new ThreadGroup("Mail Worker thread group"), "MailWorker"));
        this.messageQueue = new LinkedBlockingQueue();
        this.configurationContext.getThreadPool().execute(this);
        MailWorkerManager mailWorkerManager = new MailWorkerManager(this.configurationContext, this.messageQueue, this.workerPool, 5);
        mailWorkerManager.start();
    }

    public void stop() {
        this.running = true;
        if (!this.workerPool.isShutdown()) {
            this.workerPool.shutdown();
        }
        log.info((Object)"Stopping the mail listner");
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        return new EndpointReference[]{new EndpointReference("mailto:" + this.replyTo + "?" + this.configurationContext.getServiceContextPath() + "/" + serviceName), new EndpointReference("mailto:" + this.replyTo + "?" + "X-Service-Path" + "=" + this.configurationContext.getServiceContextPath() + "/" + serviceName)};
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public void destroy() {
        this.configurationContext = null;
    }

    public LinkedBlockingQueue getLinkedBlockingQueue() {
        return this.messageQueue;
    }
}

