/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.mail.MailBasedOutTransportInfo;
import org.apache.axis2.transport.mail.SimpleMailListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SynchronousMailListener {
    private static Log log = LogFactory.getLog((Class)SynchronousMailListener.class);
    private long timeoutInMilliseconds = -1L;
    static /* synthetic */ Class class$org$apache$axis2$transport$mail$EMailSender;

    public SynchronousMailListener(long timeoutInMilliseconds) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public void sendReceive(final MessageContext msgContext, final String msgId) throws AxisFault {
        SimpleMailListener listener = new SimpleMailListener(new LinkedBlockingQueue()){

            public void start() throws AxisFault {
                LinkedBlockingQueue queue = this.getLinkedBlockingQueue();
                while (true) {
                    long startTime = System.currentTimeMillis();
                    try {
                        MessageContext msgCtx = (MessageContext)queue.take();
                        MailBasedOutTransportInfo transportInfo = (MailBasedOutTransportInfo)msgCtx.getProperty("OutTransportInfo");
                        if (transportInfo.getInReplyTo() == null) {
                            String error = (class$org$apache$axis2$transport$mail$EMailSender == null ? (class$org$apache$axis2$transport$mail$EMailSender = SynchronousMailListener.class$("org.apache.axis2.transport.mail.EMailSender")) : class$org$apache$axis2$transport$mail$EMailSender).getName() + " Coudn't simulate request/response without In-Reply-To Mail header";
                            log.error((Object)error);
                            throw new AxisFault(error);
                        }
                        if (transportInfo.getInReplyTo().equals(msgId)) {
                            msgContext.getOperationContext().getMessageContext("In").setEnvelope(msgCtx.getEnvelope());
                            log.info((Object)((class$org$apache$axis2$transport$mail$SynchronousMailListener == null ? (class$org$apache$axis2$transport$mail$SynchronousMailListener = SynchronousMailListener.class$("org.apache.axis2.transport.mail.SynchronousMailListener")) : class$org$apache$axis2$transport$mail$SynchronousMailListener).getName() + " found the required message."));
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)e);
                        throw new AxisFault(e);
                    }
                    long endTime = System.currentTimeMillis();
                    long timeStatus = endTime - startTime;
                    if (SynchronousMailListener.this.timeoutInMilliseconds != -1L && timeStatus <= SynchronousMailListener.this.timeoutInMilliseconds) continue;
                }
            }
        };
        TransportInDescription transportIn = msgContext.getConfigurationContext().getAxisConfiguration().getTransportIn("mailto");
        Object obj = msgContext.getProperty("_MAIL_POP3_");
        if (obj != null) {
            listener.initFromRuntime((Properties)obj, msgContext);
        } else {
            listener.init(msgContext.getConfigurationContext(), transportIn);
        }
        msgContext.getConfigurationContext().getThreadPool().execute(listener);
        listener.start();
    }

    public long getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    public void setTimeoutInMilliseconds(long timeoutInMilliseconds) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }
}

