/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TCPWorker
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)TCPWorker.class);
    private ConfigurationContext configurationContext;
    private Socket socket;

    public TCPWorker(ConfigurationContext configurationContext, Socket socket) {
        this.configurationContext = configurationContext;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block18: {
            MessageContext msgContext = null;
            try {
                AxisEngine engine = new AxisEngine(this.configurationContext);
                AxisConfiguration axisConf = this.configurationContext.getAxisConfiguration();
                TransportOutDescription transportOut = axisConf.getTransportOut("tcp");
                TransportInDescription transportIn = axisConf.getTransportIn("tcp");
                if (transportOut != null && transportIn != null) {
                    msgContext = ContextFactory.createMessageContext(this.configurationContext);
                    msgContext.setIncomingTransportName("tcp");
                    msgContext.setTransportIn(transportIn);
                    msgContext.setTransportOut(transportOut);
                    msgContext.setServerSide(true);
                    OutputStream out = this.socket.getOutputStream();
                    msgContext.setProperty("TRANSPORT_OUT", out);
                    InputStreamReader in = new InputStreamReader(this.socket.getInputStream());
                    StAXBuilder builder = BuilderUtil.getBuilder(in);
                    SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
                    msgContext.setEnvelope(envelope);
                    if (envelope.getBody().hasFault()) {
                        engine.receiveFault(msgContext);
                    } else {
                        engine.receive(msgContext);
                    }
                    break block18;
                }
                throw new AxisFault(Messages.getMessage("unknownTransport", "tcp"));
            }
            catch (Throwable e) {
                try {
                    AxisEngine engine = new AxisEngine(this.configurationContext);
                    if (msgContext != null) {
                        msgContext.setProperty("TRANSPORT_OUT", this.socket.getOutputStream());
                        MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgContext, e);
                        engine.sendFault(faultContext);
                    }
                }
                catch (Exception e1) {
                    log.error((Object)e);
                }
            }
            finally {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e1) {}
                }
            }
        }
    }
}

