/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.applications.hexplorer;

import hypergraph.applications.hexplorer.ContentHandlerFactory;
import hypergraph.applications.hexplorer.GraphPanel;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphSystem;
import hypergraph.graphApi.GraphSystemFactory;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.algorithms.GraphUtilities;
import hypergraph.graphApi.io.GraphXMLWriter;
import hypergraph.graphApi.io.SAXReader;
import hypergraph.visualnet.ArrowLineRenderer;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import org.xml.sax.SAXException;

public class HExplorerApplet
extends JApplet {
    private GraphPanel graphPanel;

    public GraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    @Override
    public void init() {
        Object object;
        Object object2;
        String string = this.getParameter("file");
        GraphSystem graphSystem = null;
        try {
            graphSystem = GraphSystemFactory.createGraphSystem("hypergraph.graph.GraphSystemImpl", null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(8);
        }
        Graph graph = null;
        URL uRL = null;
        try {
            uRL = new URL(this.getCodeBase(), string);
            object2 = new SAXReader(graphSystem, uRL);
            object = new ContentHandlerFactory();
            ((ContentHandlerFactory)object).setBaseUrl(this.getCodeBase());
            ((SAXReader)object2).setContentHandlerFactory((hypergraph.graphApi.io.ContentHandlerFactory)object);
            graph = ((SAXReader)object2).parse();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "Could not find file " + uRL.getFile() + ". \n" + "Start applet with default graph", "File not found", 0);
            System.out.println("Exception : " + fileNotFoundException);
            fileNotFoundException.printStackTrace(System.out);
        }
        catch (SAXException sAXException) {
            JOptionPane.showMessageDialog(null, "Error while parsing file" + uRL.getFile() + ". \n" + "Exception : " + sAXException + ". \n" + "Start applet with default graph", "Parsing error", 0);
            System.out.println("Exception : " + sAXException);
            sAXException.getException().printStackTrace();
            sAXException.printStackTrace(System.out);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "General error while reading file " + uRL + ". \n" + "Exception : " + exception + ". \n" + "Start applet with default graph", "General error", 0);
            System.out.println(uRL);
            System.out.println("Exception : " + exception);
            exception.printStackTrace(System.out);
        }
        if (graph == null) {
            graph = GraphUtilities.createTree(graphSystem, 2, 3);
        }
        this.graphPanel = new GraphPanel(graph, this);
        string = this.getParameter("properties");
        if (string != null) {
            try {
                uRL = new URL(this.getCodeBase(), string);
                this.graphPanel.loadProperties(uRL.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(null, "Could not find propertyfile " + uRL.getFile() + ". \n" + "Start applet with default properties", "File not found", 0);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "General error while reading file " + uRL.getFile() + ". \n" + "Exception : " + exception + ". \n" + "Start applet with default properties", "General error", 0);
                System.out.println(uRL);
                System.out.println("Exception : " + exception);
                exception.printStackTrace(System.out);
            }
        }
        if ((object2 = this.getParameter("center")) != null && (object = (Node)graph.getElement((String)object2)) != null) {
            this.graphPanel.centerNode((Node)object);
        }
        this.graphPanel.setLineRenderer(new ArrowLineRenderer());
        this.getContentPane().add(this.graphPanel);
    }

    public String getGraphXML() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GraphXMLWriter graphXMLWriter = new GraphXMLWriter(new OutputStreamWriter(byteArrayOutputStream));
            graphXMLWriter.write(this.getGraphPanel().getGraph());
            return ((Object)byteArrayOutputStream).toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return iOException.toString();
        }
    }
}

