/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graph;

import hypergraph.graph.ElementImpl;
import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Node;

public class EdgeImpl
extends ElementImpl
implements Edge {
    private Node source;
    private Node target;
    private String label;
    private boolean isDirected;

    protected EdgeImpl(String string, Node node, Node node2) {
        super(string);
        this.source = node;
        this.target = node2;
        this.label = null;
        this.isDirected = false;
    }

    @Override
    public Node getSource() {
        return this.source;
    }

    @Override
    public Node getTarget() {
        return this.target;
    }

    @Override
    public void setLabel(String string) {
        this.label = string;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Node getOtherNode(Node node) {
        if (node.equals(this.source)) {
            return this.target;
        }
        if (node.equals(this.target)) {
            return this.source;
        }
        return null;
    }

    @Override
    public void reverse() {
        Node node = this.target;
        this.target = this.source;
        this.source = node;
    }

    @Override
    public void setDirected(boolean bl) {
        this.isDirected = bl;
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public int getElementType() {
        return 2;
    }

    public String toString() {
        return "[ Edge : \n  name   : " + this.getName() + "\n" + "  source : " + this.source + "\n" + "  target : " + this.target + " ]\n";
    }
}

