/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graph;

import hypergraph.graph.AttributeManagerImpl;
import hypergraph.graph.EdgeImpl;
import hypergraph.graph.ElementImpl;
import hypergraph.graph.GraphEventImpl;
import hypergraph.graph.GraphSystemImpl;
import hypergraph.graph.GroupImpl;
import hypergraph.graph.Map2D;
import hypergraph.graph.NodeImpl;
import hypergraph.graph.NodeMap2D;
import hypergraph.graphApi.AttributeManager;
import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphEvent;
import hypergraph.graphApi.GraphException;
import hypergraph.graphApi.GraphListener;
import hypergraph.graphApi.GraphSystem;
import hypergraph.graphApi.Group;
import hypergraph.graphApi.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;

public class GraphImpl
extends ElementImpl
implements Graph,
GraphListener {
    protected Map groups;
    protected Map nodes;
    protected Map edges;
    protected Map2D adjacencyList;
    private AttributeManager attributeManager;
    private GraphImpl spanningTree;
    private EventListenerList listenerList;
    private GraphSystem graphSystem;

    protected GraphImpl(GraphSystemImpl graphSystemImpl) {
        super(GraphSystemImpl.createId());
        this.graphSystem = graphSystemImpl;
        this.nodes = new HashMap();
        this.adjacencyList = new NodeMap2D();
        this.edges = new HashMap();
        this.groups = new HashMap();
        this.spanningTree = null;
        this.attributeManager = new AttributeManagerImpl(this);
        this.listenerList = new EventListenerList();
        this.addGraphListener(this);
    }

    @Override
    public void elementsAdded(GraphEvent graphEvent) {
        this.spanningTree = null;
    }

    @Override
    public void elementsRemoved(GraphEvent graphEvent) {
        this.spanningTree = null;
    }

    @Override
    public void structureChanged(GraphEvent graphEvent) {
        this.spanningTree = null;
    }

    @Override
    public void addGraphListener(GraphListener graphListener) {
        this.listenerList.add(GraphListener.class, graphListener);
    }

    @Override
    public void removeGraphListener(GraphListener graphListener) {
        this.listenerList.remove(GraphListener.class, graphListener);
    }

    void fireElementsAdded(GraphEvent graphEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GraphListener.class) continue;
            ((GraphListener)objectArray[i + 1]).elementsAdded(graphEvent);
        }
    }

    void fireElementsRemoved(GraphEvent graphEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GraphListener.class) continue;
            ((GraphListener)objectArray[i + 1]).elementsRemoved(graphEvent);
        }
    }

    @Override
    public GraphSystem getGraphSystem() {
        return this.graphSystem;
    }

    @Override
    public synchronized void addElement(Element element) {
        if (element == null) {
            return;
        }
        if (element.getElementType() == 1) {
            boolean bl;
            boolean bl2 = bl = this.nodes.put(element.getName(), element) == null;
            if (bl) {
                this.fireElementsAdded(new GraphEventImpl(this, element));
            }
            return;
        }
        if (element.getElementType() == 2) {
            Edge edge = (Edge)element;
            if (this.isConnected(edge.getSource(), edge.getTarget())) {
                return;
            }
            this.addElement(edge.getSource());
            this.addElement(edge.getTarget());
            this.adjacencyList.put(edge.getSource(), edge.getTarget(), edge);
            this.edges.put(edge.getName(), edge);
            this.fireElementsAdded(new GraphEventImpl(this, edge));
            return;
        }
        if (element.getElementType() == 3) {
            this.groups.put(element.getName(), (Group)element);
            return;
        }
    }

    @Override
    public synchronized void removeElement(Element element) {
        if (element == null) {
            return;
        }
        if (element.getElementType() == 1) {
            Collection collection = this.getEdges((Node)element);
            Object[] objectArray = collection.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                this.removeElement((Edge)objectArray[i]);
            }
            this.nodes.remove(element.getName());
            this.fireElementsRemoved(new GraphEventImpl(this, element));
            return;
        }
        if (element.getElementType() == 2) {
            this.adjacencyList.remove(((Edge)element).getSource(), ((Edge)element).getTarget());
            this.edges.remove(((Edge)element).getName());
            this.fireElementsRemoved(new GraphEventImpl(this, element));
            return;
        }
    }

    @Override
    public synchronized void removeAll() {
        Object[] objectArray = this.nodes.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.removeElement((Node)objectArray[i]);
        }
    }

    @Override
    public int getElementType() {
        return 0;
    }

    @Override
    public Collection getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public Collection getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    @Override
    public Collection getEdges() {
        return Collections.unmodifiableCollection(this.edges.values());
    }

    @Override
    public Collection getEdges(Node node) {
        Map map = this.adjacencyList.get(node);
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.adjacencyList.get(node).values());
    }

    public void insertGraph(Graph graph) {
        if (graph == null) {
            return;
        }
        this.addEdges(graph.getEdges());
    }

    @Override
    public Node createNode() {
        NodeImpl nodeImpl = new NodeImpl(GraphSystemImpl.createId());
        this.addElement(nodeImpl);
        return nodeImpl;
    }

    @Override
    public Node createNode(String string) throws GraphException {
        if (string == null) {
            return this.createNode();
        }
        Element element = this.getElement(string);
        if (element != null) {
            throw new GraphException("Duplicate name \"" + string + "\"for element.");
        }
        NodeImpl nodeImpl = new NodeImpl(string);
        this.addElement(nodeImpl);
        return nodeImpl;
    }

    @Override
    public Edge createEdge(Node node, Node node2) {
        if (node == null || node2 == null || node.equals(node2)) {
            return null;
        }
        EdgeImpl edgeImpl = new EdgeImpl(GraphSystemImpl.createId(), node, node2);
        this.addElement(edgeImpl);
        return edgeImpl;
    }

    @Override
    public Edge createEdge(String string, Node node, Node node2) throws GraphException {
        if (string == null) {
            return this.createEdge(node, node2);
        }
        Element element = this.getElement(string);
        if (element != null) {
            throw new GraphException("Duplicate name \"" + string + "\"for element.");
        }
        EdgeImpl edgeImpl = new EdgeImpl(string, node, node2);
        this.addElement(edgeImpl);
        return edgeImpl;
    }

    @Override
    public Group createGroup() {
        try {
            return this.createGroup(GraphSystemImpl.createId());
        }
        catch (GraphException graphException) {
            return null;
        }
    }

    @Override
    public Group createGroup(String string) throws GraphException {
        if (string == null) {
            return this.createGroup();
        }
        Element element = this.getElement(string);
        if (element != null) {
            throw new GraphException("Duplicate name \"" + string + "\"for element.");
        }
        GroupImpl groupImpl = new GroupImpl(string);
        this.addElement(groupImpl);
        return groupImpl;
    }

    @Override
    public Element getElement(String string) {
        Element element = (Element)this.nodes.get(string);
        if (element != null) {
            return element;
        }
        element = (Element)this.edges.get(string);
        if (element != null) {
            return element;
        }
        element = (Element)this.groups.get(string);
        if (element != null) {
            return element;
        }
        return null;
    }

    public void addNodes(Collection collection) {
        collection.addAll(collection);
    }

    public void addEdges(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addElement((Edge)iterator.next());
        }
    }

    @Override
    public boolean isConnected(Node node, Node node2) {
        return this.adjacencyList.containsKey(node, node2);
    }

    @Override
    public synchronized Graph getSpanningTree() {
        if (this.spanningTree == null) {
            Node node = this.getMinInDegree();
            this.getSpanningTree(node);
        }
        return this.spanningTree;
    }

    @Override
    public synchronized Graph getSpanningTree(Node node) {
        AttributeManager attributeManager;
        Object object;
        if (this.spanningTree != null && node == (object = (Node)(attributeManager = this.spanningTree.getAttributeManager()).getAttribute("GRAPH_ROOT", this.spanningTree))) {
            return this.spanningTree;
        }
        this.spanningTree = new GraphImpl((GraphSystemImpl)this.getGraphSystem());
        this.spanningTree.addElement(node);
        attributeManager = this.spanningTree.getAttributeManager();
        attributeManager.setAttribute("GRAPH_ROOT", this.spanningTree, node);
        object = new HashSet();
        object.add(node);
        while (!object.isEmpty()) {
            Node node2 = (Node)object.iterator().next();
            object.remove(node2);
            for (Edge edge : this.getEdges(node2)) {
                Node node3 = edge.getOtherNode(node2);
                if (this.spanningTree.getElement(node3.getName()) != null) continue;
                if (node3 == edge.getSource()) {
                    edge = new ReverseEdge("reverse" + edge.getName(), edge);
                }
                this.spanningTree.addElement(node3);
                this.spanningTree.addElement(edge);
                object.add(node3);
            }
        }
        return this.spanningTree;
    }

    public Node getMinInDegree() {
        Iterator iterator = this.getNodes().iterator();
        Node node = null;
        Node node2 = null;
        int n = -1;
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            int n2 = 0;
            for (Edge edge : this.getEdges(node2)) {
                if (!edge.getTarget().equals(node2)) continue;
                ++n2;
            }
            if (n < 0 || n > n2) {
                node = node2;
                n = n2;
            }
            if (n != 0) continue;
            break;
        }
        return node;
    }

    public Node getMaxOutDegree() {
        Iterator iterator = this.getNodes().iterator();
        Node node = null;
        Node node2 = null;
        int n = -1;
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            int n2 = 0;
            for (Edge edge : this.getEdges(node2)) {
                if (!edge.getSource().equals(node2)) continue;
                ++n2;
            }
            if (n >= n2) continue;
            node = node2;
            n = n2;
        }
        return node;
    }

    protected void createSpanningTreeDFS(Node node) {
        for (Edge edge : this.getEdges(node)) {
            Node node2 = edge.getOtherNode(node);
            if (this.spanningTree.getElement(node2.getName()) == null) continue;
            if (node2 == edge.getSource()) {
                edge = new ReverseEdge("reverse" + edge.getName(), edge);
            }
            this.spanningTree.addElement(node2);
            this.spanningTree.addElement(edge);
            this.createSpanningTreeDFS(node2);
        }
    }

    protected void processBFS(Set set) {
        Node node = (Node)set.iterator().next();
        set.remove(node);
        for (Edge edge : this.getEdges(node)) {
            Node node2 = edge.getOtherNode(node);
            if (this.spanningTree.getElement(node2.getName()) == null) continue;
            if (node2 == edge.getSource()) {
                edge = new ReverseEdge("reverse" + edge.getName(), edge);
            }
            this.spanningTree.addElement(node2);
            this.spanningTree.addElement(edge);
            set.add(node2);
        }
    }

    public void setAttributeManager(AttributeManager attributeManager) {
        this.attributeManager = attributeManager;
    }

    @Override
    public AttributeManager getAttributeManager() {
        return this.attributeManager;
    }

    public Object clone() {
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "\n";
        stringBuffer.append("hypergraph.graph.GraphImpl" + string);
        stringBuffer.append("nodes : " + string);
        Iterator iterator = this.getNodes().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString() + string);
        }
        stringBuffer.append("edges : " + string);
        iterator = this.getEdges().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString() + string);
        }
        return stringBuffer.toString();
    }

    public String getLabel() {
        return null;
    }

    public class ReverseEdge
    extends ElementImpl
    implements Edge {
        private Edge underlying;

        public ReverseEdge(String string, Edge edge) {
            super(string);
            this.underlying = edge;
        }

        @Override
        public String getName() {
            return this.underlying.getName();
        }

        @Override
        public Group getGroup() {
            return this.underlying.getGroup();
        }

        @Override
        public void setGroup(Group group) {
            this.underlying.setGroup(group);
        }

        @Override
        public Node getSource() {
            return this.underlying.getTarget();
        }

        @Override
        public Node getTarget() {
            return this.underlying.getSource();
        }

        @Override
        public Node getOtherNode(Node node) {
            return this.underlying.getOtherNode(node);
        }

        @Override
        public void reverse() {
            this.underlying.reverse();
        }

        @Override
        public void setDirected(boolean bl) {
            this.underlying.setDirected(bl);
        }

        @Override
        public boolean isDirected() {
            return this.underlying.isDirected();
        }

        @Override
        public String getLabel() {
            return this.underlying.getLabel();
        }

        @Override
        public void setLabel(String string) {
            this.underlying.setLabel(string);
        }

        @Override
        public int getElementType() {
            return 2;
        }

        public String toString() {
            return "[ ReverseEdge : \n  underlying Edge : " + this.underlying + " ]\n";
        }
    }
}

